/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.tabcontrol.plaf;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import org.netbeans.swing.tabcontrol.TabDisplayer;
import org.netbeans.swing.tabcontrol.TabListPopupAction;
import org.netbeans.swing.tabcontrol.plaf.BasicScrollingTabDisplayerUI;
import org.netbeans.swing.tabcontrol.plaf.TabCellRenderer;
import org.netbeans.swing.tabcontrol.plaf.WinVistaEditorTabCellRenderer;
import org.openide.util.Utilities;

public final class WinVistaEditorTabDisplayerUI
extends BasicScrollingTabDisplayerUI {
    private static final Rectangle scratch5 = new Rectangle();
    private static final String[] iconNames = new String[]{"org/netbeans/swing/tabcontrol/resources/vista_left_enabled.png", "org/netbeans/swing/tabcontrol/resources/vista_left_disabled.png", "org/netbeans/swing/tabcontrol/resources/vista_left_over.png", "org/netbeans/swing/tabcontrol/resources/vista_left_pressed.png", "org/netbeans/swing/tabcontrol/resources/vista_right_enabled.png", "org/netbeans/swing/tabcontrol/resources/vista_right_disabled.png", "org/netbeans/swing/tabcontrol/resources/vista_right_over.png", "org/netbeans/swing/tabcontrol/resources/vista_right_pressed.png", "org/netbeans/swing/tabcontrol/resources/vista_popup_enabled.png", "org/netbeans/swing/tabcontrol/resources/vista_popup_enabled.png", "org/netbeans/swing/tabcontrol/resources/vista_popup_over.png", "org/netbeans/swing/tabcontrol/resources/vista_popup_pressed.png"};

    public WinVistaEditorTabDisplayerUI(TabDisplayer tabDisplayer) {
        super(tabDisplayer);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new WinVistaEditorTabDisplayerUI((TabDisplayer)jComponent);
    }

    protected AbstractButton[] createControlButtons() {
        AbstractButton[] abstractButtonArray = new JButton[]{new BasicScrollingTabDisplayerUI.TimerButton(this.scroll().getBackwardAction(), false), new BasicScrollingTabDisplayerUI.TimerButton(this.scroll().getForwardAction(), false), new BasicScrollingTabDisplayerUI.OnPressButton(new TabListPopupAction(this.displayer))};
        WinVistaEditorTabDisplayerUI.configureButton(abstractButtonArray[0], 0);
        WinVistaEditorTabDisplayerUI.configureButton(abstractButtonArray[1], 1);
        WinVistaEditorTabDisplayerUI.configureButton(abstractButtonArray[2], 2);
        abstractButtonArray[0].setPreferredSize(new Dimension(15, 15));
        abstractButtonArray[2].setPreferredSize(new Dimension(16, 15));
        abstractButtonArray[1].setPreferredSize(new Dimension(15, 15));
        this.scroll().getBackwardAction().putValue("control", this.displayer);
        this.scroll().getForwardAction().putValue("control", this.displayer);
        return abstractButtonArray;
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        int n = 22;
        Graphics2D graphics2D = BasicScrollingTabDisplayerUI.getOffscreenGraphics();
        if (graphics2D != null) {
            FontMetrics fontMetrics = graphics2D.getFontMetrics(this.displayer.getFont());
            Insets insets = this.getTabAreaInsets();
            n = fontMetrics.getHeight() + insets.top + insets.bottom + 6;
        }
        return new Dimension(this.displayer.getWidth(), n);
    }

    private static final Icon createIcon(int n) {
        return new ImageIcon(Utilities.loadImage((String)iconNames[n]));
    }

    private static void configureButton(JButton jButton, int n) {
        jButton.setFocusPainted(false);
        jButton.setBorderPainted(false);
        jButton.setContentAreaFilled(false);
        jButton.setBorder(BorderFactory.createEmptyBorder());
        Icon icon = WinVistaEditorTabDisplayerUI.createIcon(n * 4);
        Icon icon2 = WinVistaEditorTabDisplayerUI.createIcon(n * 4 + 1);
        Icon icon3 = WinVistaEditorTabDisplayerUI.createIcon(n * 4 + 2);
        Icon icon4 = WinVistaEditorTabDisplayerUI.createIcon(n * 4 + 3);
        jButton.setIcon(icon);
        jButton.setRolloverEnabled(true);
        jButton.setRolloverIcon(icon3);
        jButton.setDisabledIcon(icon2);
        jButton.setPressedIcon(icon4);
        jButton.setMargin(null);
        jButton.setText(null);
        jButton.putClientProperty("hideActionText", Boolean.TRUE);
        jButton.setFocusable(false);
    }

    public void paintBackground(Graphics graphics) {
        graphics.setColor(this.displayer.getBackground());
        graphics.fillRect(0, 0, this.displayer.getWidth(), this.displayer.getHeight());
    }

    protected void paintAfterTabs(Graphics graphics) {
        Rectangle rectangle = new Rectangle();
        this.getTabsVisibleArea(rectangle);
        rectangle.width = this.displayer.getWidth();
        Insets insets = this.getTabAreaInsets();
        int n = this.displayer.getHeight() - 0;
        int n2 = this.getTabsAreaWidth();
        graphics.setColor(WinVistaEditorTabCellRenderer.getBorderColor());
        int n3 = this.scroll().getLastVisibleTab(n2);
        boolean bl = false;
        if (n3 >= 0) {
            this.getTabRect(n3, scratch5);
            n3 = WinVistaEditorTabDisplayerUI.scratch5.x + WinVistaEditorTabDisplayerUI.scratch5.width;
        }
        graphics.drawLine(n3, n - 1, this.displayer.getWidth(), n - 1);
    }

    protected TabCellRenderer createDefaultRenderer() {
        return new WinVistaEditorTabCellRenderer();
    }

    protected LayoutManager createLayout() {
        return new WCLayout();
    }

    public Insets getTabAreaInsets() {
        return new Insets(0, 0, 0, 57);
    }

    protected Rectangle getTabRectForRepaint(int n, Rectangle rectangle) {
        Rectangle rectangle2 = super.getTabRectForRepaint(n, rectangle);
        --rectangle2.x;
        rectangle2.width += 2;
        return rectangle2;
    }

    private class WCLayout
    implements LayoutManager {
        private WCLayout() {
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void layoutContainer(Container container) {
            Insets insets = WinVistaEditorTabDisplayerUI.this.getTabAreaInsets();
            Component[] componentArray = container.getComponents();
            int n = container.getWidth() - 49;
            int n2 = 0;
            for (int i = 0; i < componentArray.length; ++i) {
                n2 = insets.top;
                if (!(componentArray[i] instanceof JButton)) continue;
                int n3 = Math.min(((JButton)componentArray[i]).getIcon().getIconWidth(), container.getWidth() - n);
                componentArray[i].setBounds(n, n2, n3, Math.min(((JButton)componentArray[i]).getIcon().getIconHeight(), container.getHeight()));
                n += ((JButton)componentArray[i]).getIcon().getIconWidth();
                if (i != 1) continue;
                n += 3;
            }
        }

        public Dimension minimumLayoutSize(Container container) {
            return WinVistaEditorTabDisplayerUI.this.getPreferredSize((JComponent)container);
        }

        public Dimension preferredLayoutSize(Container container) {
            return WinVistaEditorTabDisplayerUI.this.getPreferredSize((JComponent)container);
        }

        public void removeLayoutComponent(Component component) {
        }
    }
}

