/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.tabcontrol.plaf;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import org.netbeans.swing.tabcontrol.TabDisplayer;
import org.netbeans.swing.tabcontrol.plaf.AbstractViewTabDisplayerUI;
import org.netbeans.swing.tabcontrol.plaf.ChicletWrapper;
import org.netbeans.swing.tabcontrol.plaf.ColorUtil;
import org.openide.awt.HtmlRenderer;
import org.openide.windows.TopComponent;

public final class AquaViewTabDisplayerUI
extends AbstractViewTabDisplayerUI {
    private static final int TXT_X_PAD = 5;
    private static final int ICON_X_LEFT_PAD = 5;
    private static final int ICON_X_RIGHT_PAD = 2;
    private static final int BUMP_X_PAD = 5;
    private static final int BUMP_Y_PAD = 4;
    private Dimension prefSize;
    private Rectangle tempRect = new Rectangle();
    private Rectangle pinButtonRect = new Rectangle();
    private static final ChicletWrapper chiclet = new ChicletWrapper();
    private boolean containsMouse = false;

    private AquaViewTabDisplayerUI(TabDisplayer tabDisplayer) {
        super(tabDisplayer);
        this.prefSize = new Dimension(100, 19);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new AquaViewTabDisplayerUI((TabDisplayer)jComponent);
    }

    protected AbstractViewTabDisplayerUI.Controller createController() {
        return new OwnController();
    }

    protected void installPinButton() {
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        FontMetrics fontMetrics = this.getTxtFontMetrics();
        int n = fontMetrics == null ? 21 : fontMetrics.getAscent() + 2 * fontMetrics.getDescent() + 3;
        Insets insets = jComponent.getInsets();
        this.prefSize.height = n + insets.bottom + insets.top;
        return this.prefSize;
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        ColorUtil.setupAntialiasing(graphics);
        super.paint(graphics, jComponent);
        this.paintBottomBorder(graphics, jComponent);
    }

    protected Font getTxtFont() {
        return this.getDisplayer().getFont();
    }

    private void paintBottomBorder(Graphics graphics, JComponent jComponent) {
    }

    protected void paintTabContent(Graphics graphics, int n, String string, int n2, int n3, int n4, int n5) {
        int n6;
        int n7;
        int n8;
        FontMetrics fontMetrics = this.getTxtFontMetrics();
        graphics.setFont(this.getTxtFont());
        int n9 = n4;
        if (this.isContainsMouse()) {
            int n10;
            int n11;
            n8 = 5;
            n7 = 5;
            AbstractViewTabDisplayerUI.PinButton pinButton = this.configurePinButton(n);
            int n12 = 2;
            if (this.displayer.isShowCloseButton()) {
                n6 = n7 > n5 ? -1 * ((n7 - n5) / 2) : n5 / 2 - n7 / 2;
                n11 = n2 + n4 - (n8 + n12);
                if (n == this.getDataModel().size() - 1) {
                    n11 -= 3;
                    n9 -= 3;
                }
                graphics.setColor(this.isSelected(n) && this.isActive() ? new Color(80, 80, 123) : new Color(110, 120, 120));
                graphics.drawLine(n11 -= 2, --n6, n11 + n8, n6 + n7);
                graphics.drawLine(n11, n6 + n7, n11 + n8, n6);
                graphics.drawLine(n11, ++n6, n11 + n8, n6 + n7);
                graphics.drawLine(n11, n6 + n7, n11 + n8, n6);
            } else {
                n8 = 0;
                n11 = n2 + n4 - n12;
                n6 = n7 > n5 ? -1 * ((n7 - n5) / 2) : n5 / 2 - n7 / 2 - 1;
                this.tempRect.x = n11;
            }
            int n13 = n10 = pinButton != null ? pinButton.getWidth() + 1 : 0;
            if (pinButton != null && this.isSelected(n)) {
                if (this.tempRect.x - n10 <= n2) {
                    this.pinButtonRect.setBounds(0, 0, 0, 0);
                } else {
                    Icon icon = pinButton.getIcon();
                    if (icon != null) {
                        this.pinButtonRect.setBounds(n11 - n10, n6 - 4, icon.getIconWidth(), icon.getIconHeight());
                        icon.paintIcon(this.displayer, graphics, this.pinButtonRect.x, this.pinButtonRect.y);
                    } else {
                        this.pinButtonRect.setBounds(0, 0, 0, 0);
                    }
                }
            }
            n9 -= n8 + 7 + n10;
        }
        if (string.length() == 0) {
            return;
        }
        n8 = fontMetrics.getHeight();
        n6 = n == 0 ? n2 + 10 : n2 + 5;
        n7 = n8 > n5 ? -1 * ((n8 - n5) / 2) + fontMetrics.getAscent() - 1 : n5 / 2 - n8 / 2 + fontMetrics.getAscent();
        HtmlRenderer.renderString((String)string, (Graphics)graphics, (int)n6, (int)n7, (int)(n9 -= 5), (int)n5, (Font)this.getTxtFont(), (Color)UIManager.getColor("textText"), (int)1, (boolean)true);
    }

    protected void paintTabBorder(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
    }

    protected void paintTabBackground(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        boolean bl = n == 0;
        boolean bl2 = n == this.getDataModel().size() - 1;
        int n6 = 0;
        if (this.isActive()) {
            n6 |= 4;
        }
        if (this.isSelected(n)) {
            n6 |= 2;
        }
        if (this.isAttention(n)) {
            n6 |= 0x10;
        }
        chiclet.setState(n6);
        chiclet.setBounds(n2, ++n3, n4, n5);
        chiclet.setArcs(bl ? 0.5f : 0.0f, bl2 ? 0.5f : 0.0f, bl ? 0.0f : 0.0f, bl2 ? 0.0f : 0.0f);
        chiclet.setNotch(false, false);
        graphics.translate(n2, n3);
        chiclet.draw((Graphics2D)graphics);
        graphics.translate(-n2, -n3);
    }

    private Rectangle getCloseIconRect(Rectangle rectangle, int n) {
        if (!this.displayer.isShowCloseButton()) {
            rectangle.x = -2;
            rectangle.y = -2;
            rectangle.width = 0;
            rectangle.height = 0;
            return rectangle;
        }
        FontMetrics fontMetrics = this.getTxtFontMetrics();
        Object var4_4 = null;
        int n2 = this.getLayoutModel().getW(n);
        int n3 = this.getLayoutModel().getX(n);
        int n4 = this.getLayoutModel().getH(n);
        int n5 = 5;
        int n6 = 5;
        int n7 = n6 > n4 ? -1 * ((n6 - n4) / 2) : n4 / 2 - n6 / 2 - 1;
        int n8 = 2;
        int n9 = n3 + n2 - (n5 + n8);
        if (n == this.getDataModel().size() - 1) {
            n9 -= 3;
        }
        rectangle.x = n9;
        rectangle.y = n7;
        rectangle.width = 5;
        rectangle.height = 5;
        return rectangle;
    }

    private void setContainsMouse(boolean bl) {
        if (bl != this.containsMouse) {
            this.containsMouse = bl;
            this.getDisplayer().repaint();
        }
    }

    private boolean isContainsMouse() {
        return this.containsMouse;
    }

    protected AbstractViewTabDisplayerUI.PinButton createPinButton() {
        return super.createPinButton();
    }

    private class OwnController
    extends AbstractViewTabDisplayerUI.Controller {
        private OwnController() {
        }

        protected int inCloseIconRect(Point point) {
            if (!AquaViewTabDisplayerUI.this.displayer.isShowCloseButton()) {
                return -1;
            }
            int n = AquaViewTabDisplayerUI.this.getLayoutModel().indexOfPoint(point.x, point.y);
            if (n < 0) {
                return -1;
            }
            Rectangle rectangle = AquaViewTabDisplayerUI.this.getCloseIconRect(AquaViewTabDisplayerUI.this.tempRect, n);
            rectangle.width += 6;
            rectangle.height += 6;
            rectangle.x -= 3;
            rectangle.y -= 3;
            int n2 = rectangle.contains(point) ? n : -1;
            return n2;
        }

        protected boolean inPinButtonRect(Point point) {
            return AquaViewTabDisplayerUI.this.pinButtonRect.contains(point);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
            int n = AquaViewTabDisplayerUI.this.getLayoutModel().indexOfPoint(point.x, point.y);
            int n2 = this.inCloseIconRect(point);
            AquaViewTabDisplayerUI.this.tabState.setPressed(n);
            AquaViewTabDisplayerUI.this.tabState.setCloseButtonContainsMouse(n2);
            AquaViewTabDisplayerUI.this.tabState.setMousePressedInCloseButton(n2);
            if (n != -1 && n2 == -1 && AquaViewTabDisplayerUI.this.shouldPerformAction("select", n, mouseEvent)) {
                AquaViewTabDisplayerUI.this.getSelectionModel().setSelectedIndex(n);
                AquaViewTabDisplayerUI.this.tabState.setSelected(n);
                Component component = AquaViewTabDisplayerUI.this.getDataModel().getTab(n).getComponent();
                if (null != component && component instanceof TopComponent && !((TopComponent)component).isAncestorOf(KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner())) {
                    ((TopComponent)component).requestActive();
                }
            }
            if (this.shouldReact(mouseEvent) && n2 != -1) {
                this.setClosePressed(n2);
                return;
            }
            if (AquaViewTabDisplayerUI.this.pinButton != null && this.inPinButtonRect(point)) {
                AquaViewTabDisplayerUI.this.performPinAction();
            }
            if (n != -1 && mouseEvent.isPopupTrigger()) {
                AquaViewTabDisplayerUI.this.shouldPerformAction("popup", n, mouseEvent);
                mouseEvent.consume();
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            AquaViewTabDisplayerUI.this.tabState.setMousePressedInCloseButton(-1);
            AquaViewTabDisplayerUI.this.tabState.setPressed(-1);
            if (this.shouldReact(mouseEvent)) {
                int n = this.isClosePressed();
                this.setClosePressed(-1);
                Point point = mouseEvent.getPoint();
                if (this.inCloseIconRect(point) >= 0) {
                    int n2 = AquaViewTabDisplayerUI.this.getLayoutModel().indexOfPoint(point.x, point.y);
                    if (n2 == n) {
                        this.performAction(mouseEvent);
                    }
                    this.setMouseInCloseButton(point);
                }
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            AquaViewTabDisplayerUI.this.setContainsMouse(true);
            AquaViewTabDisplayerUI.this.tabState.setMouseInTabsArea(true);
        }

        public void mouseExited(MouseEvent mouseEvent) {
            AquaViewTabDisplayerUI.this.setContainsMouse(false);
            AquaViewTabDisplayerUI.this.tabState.setMouseInTabsArea(false);
        }
    }
}

