/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.netbeans.Events;
import org.netbeans.InvalidException;
import org.netbeans.JarClassLoader;
import org.netbeans.Module;
import org.netbeans.ModuleManager;
import org.netbeans.ProxyClassLoader;
import org.netbeans.Util;
import org.openide.modules.Dependency;
import org.openide.util.NbBundle;

final class StandardModule
extends Module {
    private final File jar;
    private File physicalJar = null;
    private static final Map extensionOwners;
    private static final Set moduleJARs;
    private Set localeVariants = null;
    private Set plainExtensions = null;
    private Set localeExtensions = null;
    private Set patches = null;
    private Properties localizedProps;
    private transient boolean released;
    private transient int releaseCount = 0;
    private static PermissionCollection modulePermissions;
    static final /* synthetic */ boolean $assertionsDisabled;

    public StandardModule(ModuleManager moduleManager, Events events, File file, Object object, boolean bl, boolean bl2, boolean bl3) throws IOException {
        super(moduleManager, events, object, bl, bl2, bl3);
        this.jar = file;
        this.loadManifest();
        this.parseManifest();
        this.findExtensionsAndVariants(this.manifest);
        Set set = (Set)extensionOwners.get(file);
        if (set != null) {
            Util.err.log(16, "WARNING - module " + file + " was incorrectly placed in the Class-Path of other JARs " + set + "; please use OpenIDE-Module-Module-Dependencies instead");
        }
        moduleJARs.add(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getLocalizedAttribute(String string) {
        int n;
        Object object;
        String string2 = this.getManifest().getMainAttributes().getValue("OpenIDE-Module-Localizing-Bundle");
        boolean bl = false;
        if (string2 != null) {
            Object object2;
            if (this.classloader != null) {
                if (string2.endsWith(".properties")) {
                    bl = true;
                    object2 = string2.substring(0, string2.length() - 11).replace('/', '.');
                    try {
                        object = NbBundle.getBundle((String)object2, (Locale)Locale.getDefault(), (ClassLoader)this.classloader);
                        try {
                            return ((ResourceBundle)object).getString(string);
                        }
                        catch (MissingResourceException missingResourceException) {
                        }
                    }
                    catch (MissingResourceException missingResourceException) {
                        Util.err.notify((Throwable)missingResourceException);
                    }
                } else {
                    Util.err.log(16, "WARNING - cannot efficiently load non-*.properties OpenIDE-Module-Localizing-Bundle: " + string2);
                }
            }
            if (!bl) {
                block19: {
                    if (this.localizedProps == null) {
                        Util.err.log("Trying to get localized attr " + string + " from disabled module " + this.getCodeNameBase());
                        try {
                            if (this.jar != null) {
                                object2 = new JarFile(this.jar, false);
                                try {
                                    this.loadLocalizedProps((JarFile)object2, this.manifest);
                                    break block19;
                                }
                                finally {
                                    ((ZipFile)object2).close();
                                }
                            }
                            throw new IllegalStateException();
                        }
                        catch (IOException iOException) {
                            Util.err.annotate((Throwable)iOException, 1, this.jar.getAbsolutePath(), null, null, null);
                            Util.err.notify(1, (Throwable)iOException);
                            if (this.localizedProps != null) break block19;
                            this.localizedProps = new Properties();
                        }
                    }
                }
                if ((object2 = this.localizedProps.getProperty(string)) != null) {
                    return object2;
                }
            }
        }
        if ((n = string.lastIndexOf(47)) == -1) {
            return NbBundle.getLocalizedValue((Attributes)this.getManifest().getMainAttributes(), (Attributes.Name)new Attributes.Name(string));
        }
        object = string.substring(0, n);
        String string3 = string.substring(n + 1);
        Attributes attributes = this.getManifest().getAttributes((String)object);
        if (attributes != null) {
            return NbBundle.getLocalizedValue((Attributes)attributes, (Attributes.Name)new Attributes.Name(string3));
        }
        return null;
    }

    public boolean owns(Class clazz) {
        ClassLoader classLoader = clazz.getClassLoader();
        if (classLoader instanceof Util.ModuleProvider) {
            return ((Util.ModuleProvider)((Object)classLoader)).getModule() == this;
        }
        return false;
    }

    public boolean isFixed() {
        return false;
    }

    public File getJarFile() {
        return this.jar;
    }

    private void ensurePhysicalJar() throws IOException {
        if (this.reloadable && this.physicalJar == null) {
            this.physicalJar = Util.makeTempJar(this.jar);
        }
    }

    private void destroyPhysicalJar() {
        if (this.physicalJar != null) {
            if (this.physicalJar.isFile()) {
                if (!this.physicalJar.delete()) {
                    Util.err.log(16, "Warning: temporary JAR " + this.physicalJar + " not currently deletable.");
                } else {
                    Util.err.log("deleted: " + this.physicalJar);
                }
            }
            this.physicalJar = null;
        } else {
            Util.err.log("no physicalJar to delete for " + (Object)((Object)this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadManifest() throws IOException {
        block8: {
            Util.err.log("loading manifest of " + this.jar);
            File file = null;
            try {
                if (this.reloadable) {
                    file = this.physicalJar;
                    this.ensurePhysicalJar();
                    file = this.physicalJar;
                    JarFile jarFile = new JarFile(this.physicalJar, false);
                    try {
                        Manifest manifest = jarFile.getManifest();
                        if (manifest == null) {
                            throw new IOException("No manifest found in " + this.physicalJar);
                        }
                        this.manifest = manifest;
                        break block8;
                    }
                    finally {
                        jarFile.close();
                    }
                }
                file = this.jar;
                this.manifest = this.getManager().loadManifest(this.jar);
            }
            catch (IOException iOException) {
                if (file != null) {
                    Util.err.annotate((Throwable)iOException, 0, "While loading manifest from: " + file, null, null, null);
                }
                throw iOException;
            }
        }
    }

    private void findExtensionsAndVariants(Manifest manifest) {
        Object object;
        Iterator iterator;
        String string;
        Object object2;
        if (!$assertionsDisabled && this.jar == null) {
            throw new AssertionError((Object)("Cannot load extensions from classpath module " + this.getCodeNameBase()));
        }
        this.localeVariants = null;
        List list = Util.findLocaleVariantsOf(this.jar, false);
        if (!list.isEmpty()) {
            this.localeVariants = new HashSet(list);
        }
        this.plainExtensions = null;
        this.localeExtensions = null;
        String string2 = manifest.getMainAttributes().getValue(Attributes.Name.CLASS_PATH);
        if (string2 != null) {
            object2 = new StringTokenizer(string2);
            while (((StringTokenizer)object2).hasMoreTokens()) {
                string = ((StringTokenizer)object2).nextToken();
                if ((new File(string).isAbsolute() || string.indexOf("../") != -1) && !string.equals("../lib/updater.jar")) {
                    Util.err.log(16, "WARNING: Class-Path value " + string + " from " + this.jar + " is illegal according to the Java Extension Mechanism: must be relative and not move up directories");
                }
                if (!((File)((Object)(iterator = new File(this.jar.getParentFile(), string.replace('/', File.separatorChar))))).exists()) {
                    Util.err.log(16, "Warning: Class-Path value " + string + " from " + this.jar + " cannot be found at " + iterator);
                    continue;
                }
                object = (Set)extensionOwners.get(iterator);
                if (object == null) {
                    object = new HashSet<File>(2);
                    object.add(this.jar);
                    extensionOwners.put(iterator, object);
                } else if (!object.contains(this.jar)) {
                    object.add(this.jar);
                    this.events.log("extensionMultiplyLoaded", iterator, object);
                }
                if (moduleJARs.contains(iterator)) {
                    Util.err.log(16, "WARNING: Class-Path value " + string + " from " + this.jar + " illegally refers to another module; use OpenIDE-Module-Module-Dependencies instead");
                }
                if (this.plainExtensions == null) {
                    this.plainExtensions = new HashSet();
                }
                this.plainExtensions.add(iterator);
                list = Util.findLocaleVariantsOf((File)((Object)iterator), false);
                if (list.isEmpty()) continue;
                if (this.localeExtensions == null) {
                    this.localeExtensions = new HashSet();
                }
                this.localeExtensions.addAll(list);
            }
        }
        object2 = new File(new File(this.jar.getParentFile(), "patches"), this.getCodeNameBase().replace('.', '-'));
        this.scanForPatches((File)object2);
        string = System.getProperty("netbeans.patches." + this.getCodeNameBase());
        if (string != null) {
            iterator = new StringTokenizer(string, File.pathSeparator);
            while (((StringTokenizer)((Object)iterator)).hasMoreElements()) {
                object = (String)((StringTokenizer)((Object)iterator)).nextElement();
                File file = new File((String)object);
                if (!file.exists()) continue;
                if (this.patches == null) {
                    this.patches = new HashSet(15);
                }
                this.patches.add(file);
            }
        }
        Util.err.log("localeVariants of " + this.jar + ": " + this.localeVariants);
        Util.err.log("plainExtensions of " + this.jar + ": " + this.plainExtensions);
        Util.err.log("localeExtensions of " + this.jar + ": " + this.localeExtensions);
        Util.err.log("patches of " + this.jar + ": " + this.patches);
        if (this.patches != null) {
            iterator = this.patches.iterator();
            while (iterator.hasNext()) {
                this.events.log("patch", iterator.next());
            }
        }
    }

    private void scanForPatches(File file) {
        if (!file.isDirectory()) {
            return;
        }
        File[] fileArray = file.listFiles(Util.jarFilter());
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                if (this.patches == null) {
                    this.patches = new HashSet(5);
                }
                this.patches.add(fileArray[i]);
            }
        } else {
            Util.err.log(16, "Could not search for patches in " + file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadLocalizedProps(JarFile jarFile, Manifest manifest) throws IOException {
        String string = manifest.getMainAttributes().getValue("OpenIDE-Module-Localizing-Bundle");
        if (string != null) {
            String string2;
            int n;
            Object object;
            ZipEntry zipEntry = jarFile.getEntry(string);
            if (zipEntry != null) {
                this.localizedProps = new Properties();
                object = jarFile.getInputStream(zipEntry);
                try {
                    this.localizedProps.load((InputStream)object);
                }
                finally {
                    ((InputStream)object).close();
                }
            }
            if ((n = string.lastIndexOf(46)) == -1) {
                object = string;
                string2 = "";
            } else {
                object = string.substring(0, n);
                string2 = string.substring(n);
            }
            List list = Util.findLocaleVariantsOf(this.jar, true);
            Collections.reverse(list);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Object[] objectArray = (Object[])iterator.next();
                File file = (File)objectArray[0];
                String string3 = (String)objectArray[1];
                String string4 = (String)object + string3 + string2;
                JarFile jarFile2 = new JarFile(file, false);
                try {
                    ZipEntry zipEntry2 = jarFile2.getEntry(string4);
                    if (zipEntry2 == null) continue;
                    if (this.localizedProps == null) {
                        this.localizedProps = new Properties();
                    }
                    InputStream inputStream = jarFile2.getInputStream(zipEntry2);
                    try {
                        this.localizedProps.load(inputStream);
                    }
                    finally {
                        inputStream.close();
                    }
                }
                finally {
                    jarFile2.close();
                }
            }
            if (this.localizedProps == null) {
                throw new IOException("Could not find localizing bundle: " + string);
            }
        }
    }

    public List getAllJars() {
        ArrayList<File> arrayList = new ArrayList<File>();
        if (this.patches != null) {
            arrayList.addAll(this.patches);
        }
        if (this.physicalJar != null) {
            arrayList.add(this.physicalJar);
        } else if (this.jar != null) {
            arrayList.add(this.jar);
        }
        if (this.plainExtensions != null) {
            arrayList.addAll(this.plainExtensions);
        }
        if (this.localeVariants != null) {
            arrayList.addAll(this.localeVariants);
        }
        if (this.localeExtensions != null) {
            arrayList.addAll(this.localeExtensions);
        }
        return arrayList;
    }

    public void setReloadable(boolean bl) {
        this.getManager().assertWritable();
        if (this.reloadable != bl) {
            this.reloadable = bl;
            this.getManager().fireReloadable(this);
        }
    }

    public void reload() throws IOException {
        this.destroyPhysicalJar();
        String string = this.getCodeNameBase();
        this.localizedProps = null;
        this.loadManifest();
        this.parseManifest();
        this.findExtensionsAndVariants(this.manifest);
        String string2 = this.getCodeNameBase();
        if (!string.equals(string2)) {
            throw new InvalidException("Code name base changed during reload: " + string + " -> " + string2);
        }
    }

    protected void classLoaderUp(Set set) throws IOException {
        Object object;
        Object object2;
        Object object3;
        Util.err.log("classLoaderUp on " + (Object)((Object)this) + " with parents " + set);
        ArrayList<Object> arrayList = new ArrayList<Object>(set.size() + 1);
        arrayList.add(Module.class.getClassLoader());
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            object3 = (Module)((Object)iterator.next());
            object2 = object3.getPublicPackages();
            if (object2 != null && ((Module.PackageExport[])object2).length == 0) {
                object = this.getDependenciesArray();
                boolean bl = false;
                for (int i = 0; i < ((Dependency[])object).length; ++i) {
                    if (object[i].getType() != 1 || object[i].getComparison() != 2 || !object[i].getName().equals(object3.getCodeName())) continue;
                    bl = true;
                    break;
                }
                if (!bl) continue;
            }
            object = object3.getClassLoader();
            if (object3.isFixed() && arrayList.contains(object)) {
                Util.err.log("#24996: skipping duplicate classloader from " + (Object)object3);
                continue;
            }
            arrayList.add(object);
        }
        object3 = new ArrayList(3);
        if (this.patches != null) {
            iterator = this.patches.iterator();
            while (iterator.hasNext()) {
                object2 = (File)iterator.next();
                if (((File)object2).isDirectory()) {
                    object3.add(object2);
                    continue;
                }
                object3.add(new JarFile((File)object2, false));
            }
        }
        if (this.reloadable) {
            this.ensurePhysicalJar();
            object3.add(new JarFile(this.physicalJar, false));
        } else {
            object3.add(new JarFile(this.jar, false));
        }
        if (this.localeVariants != null) {
            iterator = this.localeVariants.iterator();
            while (iterator.hasNext()) {
                object3.add(new JarFile((File)iterator.next(), false));
            }
        }
        if (this.localeExtensions != null) {
            iterator = this.localeExtensions.iterator();
            while (iterator.hasNext()) {
                object2 = (File)iterator.next();
                object3.add(((File)object2).isDirectory() ? object2 : new JarFile((File)object2, false));
            }
        }
        if (this.plainExtensions != null) {
            iterator = this.plainExtensions.iterator();
            while (iterator.hasNext()) {
                object2 = (File)iterator.next();
                object3.add(((File)object2).isDirectory() ? object2 : new JarFile((File)object2, false));
            }
        }
        this.getManager().refineClassLoader(this, arrayList);
        try {
            this.classloader = new OneModuleClassLoader((List)object3, arrayList.toArray(new ClassLoader[arrayList.size()]));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            object = new IOException(illegalArgumentException.toString());
            Util.err.annotate((Throwable)object, (Throwable)illegalArgumentException);
            throw object;
        }
    }

    protected void classLoaderDown() {
        if (this.classloader instanceof ProxyClassLoader) {
            ((ProxyClassLoader)this.classloader).destroy();
        }
        this.classloader = null;
        Util.err.log("classLoaderDown on " + (Object)((Object)this) + ": releaseCount=" + this.releaseCount + " released=" + this.released);
        this.released = false;
    }

    protected void cleanup() {
        if (this.isEnabled()) {
            throw new IllegalStateException("cleanup on enabled module: " + (Object)((Object)this));
        }
        if (this.classloader != null) {
            throw new IllegalStateException("cleanup on module with classloader: " + (Object)((Object)this));
        }
        if (!this.released) {
            Util.err.log("Warning: not all resources associated with module " + this.jar + " were successfully released.");
            this.released = true;
        } else {
            Util.err.log("All resources associated with module " + this.jar + " were successfully released.");
        }
        this.destroyPhysicalJar();
    }

    public void destroy() {
        moduleJARs.remove(this.jar);
    }

    public String toString() {
        String string = "StandardModule:" + this.getCodeNameBase() + " jarFile: " + this.jar.getAbsolutePath();
        if (!this.isValid()) {
            string = string + "[invalid]";
        }
        return string;
    }

    private static synchronized PermissionCollection getAllPermission() {
        if (modulePermissions == null) {
            modulePermissions = new Permissions();
            modulePermissions.add(new AllPermission());
            modulePermissions.setReadOnly();
        }
        return modulePermissions;
    }

    static {
        $assertionsDisabled = !StandardModule.class.desiredAssertionStatus();
        extensionOwners = new HashMap();
        moduleJARs = new HashSet();
    }

    private class OneModuleClassLoader
    extends JarClassLoader
    implements Util.ModuleProvider,
    Util.PackageAccessibleClassLoader {
        private int rc;

        public OneModuleClassLoader(List list, ClassLoader[] classLoaderArray) throws IllegalArgumentException {
            super(list, classLoaderArray, false);
            this.rc = StandardModule.this.releaseCount++;
        }

        public Module getModule() {
            return StandardModule.this;
        }

        protected PermissionCollection getPermissions(CodeSource codeSource) {
            return StandardModule.getAllPermission();
        }

        protected String findLibrary(String string) {
            String string2 = System.mapLibraryName(string);
            File file = new File(new File(StandardModule.this.jar.getParentFile(), "lib"), string2);
            if (file.isFile()) {
                return file.getAbsolutePath();
            }
            return null;
        }

        protected boolean isSpecialResource(String string) {
            if (StandardModule.this.mgr.isSpecialResource(string)) {
                return true;
            }
            return super.isSpecialResource(string);
        }

        protected boolean shouldDelegateResource(String string, ClassLoader classLoader) {
            if (!super.shouldDelegateResource(string, classLoader)) {
                return false;
            }
            Module module = classLoader instanceof Util.ModuleProvider ? ((Util.ModuleProvider)((Object)classLoader)).getModule() : null;
            return StandardModule.this.getManager().shouldDelegateResource(StandardModule.this, module, string);
        }

        public String toString() {
            return super.toString() + "[" + StandardModule.this.getCodeNameBase() + "]";
        }

        protected void finalize() throws Throwable {
            super.finalize();
            Util.err.log("Finalize for " + this + ": rc=" + this.rc + " releaseCount=" + StandardModule.this.releaseCount + " released=" + StandardModule.this.released);
            if (this.rc == StandardModule.this.releaseCount) {
                StandardModule.this.released = true;
            } else {
                Util.err.log("Now resources for " + StandardModule.this.getCodeNameBase() + " have been released.");
            }
        }
    }
}

