/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans;

import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.netbeans.ModuleFactory;
import org.openide.util.Enumerations;
import org.openide.util.Lookup;

public class ProxyClassLoader
extends ClassLoader {
    private static final boolean DO_NOT_WARN_DEFAULT_PACKAGE = Boolean.getBoolean("org.netbeans.do_not_warn_default_package");
    private final Map domainsByPackage = new HashMap();
    private final Map packages = new HashMap();
    private ClassLoader[] parents;
    private boolean dead = false;
    private final boolean transitive;

    public ProxyClassLoader(ClassLoader[] classLoaderArray) {
        this(classLoaderArray, true);
    }

    public ProxyClassLoader(ClassLoader[] classLoaderArray, boolean bl) {
        if (classLoaderArray.length == 0) {
            throw new IllegalArgumentException("ProxyClassLoader must have a parent");
        }
        this.transitive = bl;
        HashSet<ClassLoader> hashSet = new HashSet<ClassLoader>(Arrays.asList(classLoaderArray));
        if (hashSet.size() < classLoaderArray.length) {
            throw new IllegalArgumentException("duplicate parents");
        }
        if (hashSet.contains(null)) {
            throw new IllegalArgumentException("null parent in " + hashSet);
        }
        this.parents = this.coalesceParents(classLoaderArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(ClassLoader[] classLoaderArray) throws IllegalArgumentException {
        if (classLoaderArray == null) {
            throw new IllegalArgumentException("null parents array");
        }
        for (int i = 0; i < classLoaderArray.length; ++i) {
            if (classLoaderArray[i] != null) continue;
            throw new IllegalArgumentException("null parent");
        }
        ClassLoader[] classLoaderArray2 = null;
        ModuleFactory moduleFactory = (ModuleFactory)Lookup.getDefault().lookup(ModuleFactory.class);
        classLoaderArray2 = moduleFactory != null && moduleFactory.removeBaseClassLoader() ? this.coalesceAppend(new ClassLoader[0], classLoaderArray) : this.coalesceAppend(this.parents, classLoaderArray);
        ProxyClassLoader proxyClassLoader = this;
        synchronized (proxyClassLoader) {
            this.parents = classLoaderArray2;
        }
    }

    public void destroy() {
        this.dead = true;
    }

    private void zombieCheck(String string) {
    }

    protected final synchronized Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        this.zombieCheck(string);
        String string2 = string.replace('.', '/').concat(".class");
        int n = string2.lastIndexOf(47);
        if (n == -1) {
            throw new ClassNotFoundException("Will not load classes from default package (" + string + ")");
        }
        String string3 = string2.substring(0, n + 1);
        Class clazz = this.smartLoadClass(string, string2, string3);
        if (clazz == null) {
            throw new ClassNotFoundException(string);
        }
        if (bl) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    protected Class simpleFindClass(String string, String string2, String string3) {
        return null;
    }

    public final URL getResource(String string) {
        String string2;
        this.zombieCheck(string);
        int n = string.lastIndexOf(47);
        if (n == -1) {
            ProxyClassLoader.printDefaultPackageWarning(string);
        }
        if (this.isSpecialResource(string2 = string.substring(0, n + 1))) {
            for (int i = 0; i < this.parents.length; ++i) {
                URL uRL;
                if (!this.shouldDelegateResource(string2, this.parents[i]) || (uRL = this.parents[i] instanceof ProxyClassLoader ? ((ProxyClassLoader)this.parents[i]).findResource(string) : this.parents[i].getResource(string)) == null) continue;
                return uRL;
            }
            return this.findResource(string);
        }
        ClassLoader classLoader = (ClassLoader)this.domainsByPackage.get(string2);
        if (classLoader != null) {
            if (classLoader instanceof ProxyClassLoader) {
                return ((ProxyClassLoader)classLoader).findResource(string);
            }
            return classLoader.getResource(string);
        }
        URL uRL = null;
        for (int i = 0; i < this.parents.length; ++i) {
            classLoader = this.parents[i];
            if (!this.shouldDelegateResource(string2, classLoader) || (uRL = classLoader instanceof ProxyClassLoader ? ((ProxyClassLoader)classLoader).findResource(string) : classLoader.getResource(string)) == null) continue;
            this.domainsByPackage.put(new String(string2).intern(), classLoader);
            return uRL;
        }
        uRL = this.findResource(string);
        if (uRL != null) {
            this.domainsByPackage.put(new String(string2).intern(), this);
        }
        return uRL;
    }

    protected URL findResource(String string) {
        return null;
    }

    protected final synchronized Enumeration findResources(String string) throws IOException {
        this.zombieCheck(string);
        int n = string.lastIndexOf(47);
        if (n == -1) {
            ProxyClassLoader.printDefaultPackageWarning(string);
        }
        String string2 = string.substring(0, n + 1);
        Enumeration[] enumerationArray = new Enumeration[this.parents.length + 1];
        for (int i = 0; i < this.parents.length; ++i) {
            enumerationArray[i] = !this.shouldDelegateResource(string2, this.parents[i]) ? Enumerations.empty() : (this.parents[i] instanceof ProxyClassLoader ? ((ProxyClassLoader)this.parents[i]).simpleFindResources(string) : this.parents[i].getResources(string));
        }
        enumerationArray[this.parents.length] = this.simpleFindResources(string);
        return new AAEnum(enumerationArray);
    }

    protected Enumeration simpleFindResources(String string) throws IOException {
        return super.findResources(string);
    }

    protected Package getPackage(String string) {
        this.zombieCheck(string);
        return this.getPackageFast(string, string.replace('.', '/') + '/', true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Package getPackageFast(String string, String string2, boolean bl) {
        Map map = this.packages;
        synchronized (map) {
            ClassLoader classLoader;
            Package package_ = (Package)this.packages.get(string);
            if (package_ != null) {
                return package_;
            }
            if (!bl) {
                return null;
            }
            for (int i = 0; !(i >= this.parents.length || (classLoader = this.parents[i]) instanceof ProxyClassLoader && this.shouldDelegateResource(string2, classLoader) && (package_ = ((ProxyClassLoader)classLoader).getPackageFast(string, string2, false)) != null); ++i) {
            }
            if (package_ == null && this.shouldDelegateResource(string2, this.getParent())) {
                package_ = super.getPackage(string);
            }
            if (package_ != null) {
                this.packages.put(string, package_);
            }
            return package_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Package definePackage(String string, String string2, String string3, String string4, String string5, String string6, String string7, URL uRL) throws IllegalArgumentException {
        Map map = this.packages;
        synchronized (map) {
            Package package_ = super.definePackage(string, string2, string3, string4, string5, string6, string7, uRL);
            this.packages.put(string, package_);
            return package_;
        }
    }

    protected synchronized Package[] getPackages() {
        return this.getPackages(new HashSet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Package[] getPackages(Set set) {
        this.zombieCheck(null);
        HashMap hashMap = new HashMap();
        this.addPackages(hashMap, super.getPackages());
        for (int i = 0; i < this.parents.length; ++i) {
            ClassLoader classLoader = this.parents[i];
            if (!(classLoader instanceof ProxyClassLoader) || !set.add(classLoader)) continue;
            this.addPackages(hashMap, ((ProxyClassLoader)classLoader).getPackages(set));
        }
        Map map = this.packages;
        synchronized (map) {
            hashMap.keySet().removeAll(this.packages.keySet());
            this.packages.putAll(hashMap);
        }
        return this.packages.values().toArray(new Package[this.packages.size()]);
    }

    public Package getPackageAccessibly(String string) {
        return this.getPackage(string);
    }

    public Package[] getPackagesAccessibly() {
        return this.getPackages();
    }

    private static void printDefaultPackageWarning(String string) {
        if (!DO_NOT_WARN_DEFAULT_PACKAGE && !"commons-logging.properties".equals(string)) {
            System.err.println("You are trying to access file: " + string + " from the default package.");
            System.err.println("Please see http://www.netbeans.org/download/dev/javadoc/org-openide-modules/org/openide/modules/doc-files/classpath.html#default_package");
        }
    }

    private ClassLoader[] coalesceParents(ClassLoader[] classLoaderArray) throws IllegalArgumentException {
        int n = classLoaderArray.length * 5 + 10;
        HashSet hashSet = new HashSet(n);
        ArrayList arrayList = new ArrayList(n);
        for (int i = 0; i < classLoaderArray.length; ++i) {
            this.addRec(hashSet, arrayList, classLoaderArray[i]);
        }
        ClassLoader[] classLoaderArray2 = arrayList.toArray(new ClassLoader[arrayList.size()]);
        return classLoaderArray2;
    }

    private ClassLoader[] coalesceAppend(ClassLoader[] classLoaderArray, ClassLoader[] classLoaderArray2) throws IllegalArgumentException {
        int n = classLoaderArray.length + 3;
        HashSet<ClassLoader> hashSet = new HashSet<ClassLoader>(n);
        List<ClassLoader> list = Arrays.asList(classLoaderArray);
        hashSet.addAll(list);
        if (hashSet.containsAll(Arrays.asList(classLoaderArray2))) {
            return classLoaderArray;
        }
        ArrayList<ClassLoader> arrayList = new ArrayList<ClassLoader>(n);
        arrayList.addAll(list);
        for (int i = 0; i < classLoaderArray2.length; ++i) {
            this.addRec(hashSet, arrayList, classLoaderArray2[i]);
        }
        ClassLoader[] classLoaderArray3 = arrayList.toArray(new ClassLoader[arrayList.size()]);
        return classLoaderArray3;
    }

    private void addRec(Set set, List list, ClassLoader classLoader) throws IllegalArgumentException {
        if (classLoader == this) {
            throw new IllegalArgumentException("cycle in parents");
        }
        if (set.contains(classLoader)) {
            return;
        }
        if (classLoader instanceof ProxyClassLoader && ((ProxyClassLoader)classLoader).transitive) {
            ClassLoader[] classLoaderArray = ((ProxyClassLoader)classLoader).parents;
            for (int i = 0; i < classLoaderArray.length; ++i) {
                this.addRec(set, list, classLoaderArray[i]);
            }
        }
        set.add(classLoader);
        list.add(classLoader);
    }

    private final Class smartLoadClass(String string, String string2, String string3) throws ClassNotFoundException {
        ClassLoader classLoader;
        Class clazz = this.findLoadedClass(string);
        if (clazz != null) {
            return clazz;
        }
        ClassLoader classLoader2 = classLoader = this.isSpecialResource(string3) ? null : (ClassLoader)this.domainsByPackage.get(string3);
        if (classLoader == this) {
            return this.simpleFindClass(string, string2, string3);
        }
        if (classLoader != null) {
            if (classLoader instanceof ProxyClassLoader) {
                return ((ProxyClassLoader)classLoader).fullFindClass(string, string2, string3);
            }
            return classLoader.loadClass(string);
        }
        clazz = this.loadInOrder(string, string2, string3);
        if (clazz != null) {
            ClassLoader classLoader3 = ProxyClassLoader.getClassClassLoader(clazz);
            this.domainsByPackage.put(new String(string3).intern(), classLoader3);
        }
        return clazz;
    }

    private static ClassLoader getClassClassLoader(final Class clazz) {
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return clazz.getClassLoader();
            }
        });
    }

    private final Class loadInOrder(String string, String string2, String string3) throws ClassNotFoundException {
        ClassNotFoundException classNotFoundException = null;
        for (int i = 0; i < this.parents.length; ++i) {
            ClassLoader classLoader = this.parents[i];
            if (!this.shouldDelegateResource(string3, classLoader)) continue;
            if (classLoader instanceof ProxyClassLoader && ((ProxyClassLoader)classLoader).shouldBeCheckedAsParentProxyClassLoader()) {
                ProxyClassLoader proxyClassLoader = (ProxyClassLoader)classLoader;
                Class clazz = proxyClassLoader.fullFindClass(string, string2, string3);
                if (clazz == null || !proxyClassLoader.transitive && ProxyClassLoader.getClassClassLoader(clazz) != proxyClassLoader) continue;
                return clazz;
            }
            boolean bl = false;
            if (this.optimizeNBLoading() && (string.startsWith("org.netbeans.") || string.startsWith("org.openide.") || string.endsWith(".Bundle") || string.endsWith("BeanInfo") || string.endsWith("Editor")) && classLoader.getResource(string2) == null) {
                bl = true;
            }
            if (bl) continue;
            try {
                return classLoader.loadClass(string);
            }
            catch (ClassNotFoundException classNotFoundException2) {
                classNotFoundException = classNotFoundException2;
            }
        }
        Class clazz = this.simpleFindClass(string, string2, string3);
        if (clazz != null) {
            return clazz;
        }
        if (classNotFoundException != null) {
            throw classNotFoundException;
        }
        return null;
    }

    private synchronized Class fullFindClass(String string, String string2, String string3) {
        Class clazz = this.findLoadedClass(string);
        return clazz == null ? this.simpleFindClass(string, string2, string3) : clazz;
    }

    private void addPackages(Map map, Package[] packageArray) {
        for (int i = 0; i < packageArray.length; ++i) {
            map.put(packageArray[i].getName(), packageArray[i]);
        }
    }

    protected boolean shouldBeCheckedAsParentProxyClassLoader() {
        return true;
    }

    protected boolean optimizeNBLoading() {
        return true;
    }

    protected boolean isSpecialResource(String string) {
        if (string.startsWith("META-INF/")) {
            return true;
        }
        return string.length() == 0;
    }

    protected boolean shouldDelegateResource(String string, ClassLoader classLoader) {
        return true;
    }

    private static final class AAEnum
    implements Enumeration {
        private Enumeration[] array;
        private int index = 0;

        public AAEnum(Enumeration[] enumerationArray) {
            this.array = enumerationArray;
        }

        public boolean hasMoreElements() {
            while (this.index != this.array.length) {
                if (this.array[this.index].hasMoreElements()) {
                    return true;
                }
                ++this.index;
            }
            return false;
        }

        public Object nextElement() {
            try {
                return this.array[this.index].nextElement();
            }
            catch (NoSuchElementException noSuchElementException) {
                if (this.hasMoreElements()) {
                    return this.nextElement();
                }
                throw noSuchElementException;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new NoSuchElementException();
            }
        }
    }
}

