/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.lookup;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.lookup.ALPairComparator;
import org.openide.util.lookup.ArrayStorage;
import org.openide.util.lookup.DelegatingStorage;
import org.openide.util.lookup.InheritanceTree;
import org.openide.util.lookup.WaitableResult;

public class AbstractLookup
extends Lookup
implements Serializable {
    static final long serialVersionUID = 5L;
    private static Object treeLock = new Object();
    private static Object activeQueue;
    private Object tree;
    private int count;

    public AbstractLookup(Content content) {
        content.attach(this);
    }

    AbstractLookup(Content content, Storage storage) {
        this(content);
        this.tree = storage;
        this.initialize();
    }

    AbstractLookup(Content content, Integer n) {
        this(content);
        this.tree = n;
    }

    protected AbstractLookup() {
    }

    public String toString() {
        if (this.tree instanceof Storage) {
            return "AbstractLookup" + this.lookup(new Lookup.Template(Object.class)).allItems();
        }
        return super.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Storage enterStorage() {
        while (true) {
            Object object = treeLock;
            synchronized (object) {
                if (this.tree instanceof Storage) {
                    if (this.tree instanceof DelegatingStorage) {
                        DelegatingStorage delegatingStorage = (DelegatingStorage)this.tree;
                        delegatingStorage.checkForTreeModification();
                        try {
                            treeLock.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        continue;
                    }
                    this.tree = new DelegatingStorage((Storage)this.tree);
                    return (Storage)this.tree;
                }
                this.tree = this.tree instanceof Integer ? new ArrayStorage((Integer)this.tree) : new ArrayStorage();
            }
            this.initialize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Storage exitStorage() {
        Object object = treeLock;
        synchronized (object) {
            Storage storage = ((DelegatingStorage)this.tree).exitDelegate();
            this.tree = storage;
            treeLock.notifyAll();
            return storage;
        }
    }

    protected void initialize() {
    }

    protected void beforeLookup(Lookup.Template template) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void addPair(Pair pair) {
        HashSet hashSet;
        block6: {
            hashSet = new HashSet();
            Object object = null;
            Storage storage = this.enterStorage();
            try {
                object = storage.beginTransaction(-2);
                if (storage.add(pair, object)) {
                    try {
                        pair.setIndex(storage, this.count++);
                    }
                    catch (IllegalStateException illegalStateException) {
                        storage.remove(pair, object);
                        throw illegalStateException;
                    }
                    storage.endTransaction(object, hashSet);
                    break block6;
                }
                storage.endTransaction(object, new HashSet());
            }
            finally {
                this.exitStorage();
            }
        }
        AbstractLookup.notifyListeners(hashSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void removePair(Pair pair) {
        HashSet hashSet = new HashSet();
        Object object = null;
        Storage storage = this.enterStorage();
        try {
            object = storage.beginTransaction(-1);
            storage.remove(pair, object);
            storage.endTransaction(object, hashSet);
        }
        finally {
            this.exitStorage();
        }
        AbstractLookup.notifyListeners(hashSet);
    }

    protected final void setPairs(Collection collection) {
        this.notifyCollectedListeners(this.setPairsAndCollectListeners(collection));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final LinkedHashSet getPairsAsLHS() {
        Storage storage = this.enterStorage();
        try {
            Serializable serializable;
            Enumeration enumeration = storage.lookup(Object.class);
            LinkedHashSet linkedHashSet = new LinkedHashSet();
            while (enumeration.hasMoreElements()) {
                serializable = (Pair)enumeration.nextElement();
                linkedHashSet.add(serializable);
            }
            serializable = linkedHashSet;
            return serializable;
        }
        finally {
            this.exitStorage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final HashSet setPairsAndCollectListeners(Collection collection) {
        HashSet hashSet = new HashSet(27);
        Object object = null;
        Storage storage = this.enterStorage();
        try {
            HashMap<Pair, Info> hashMap = new HashMap<Pair, Info>(collection.size() * 2);
            this.count = 0;
            Iterator iterator = collection.iterator();
            object = storage.beginTransaction(collection.size());
            while (iterator.hasNext()) {
                Pair pair = (Pair)iterator.next();
                if (storage.add(pair, object)) {
                    // empty if block
                }
                hashMap.put(pair, new Info(this.count++, object));
            }
            storage.retainAll(hashMap, object);
            storage.endTransaction(object, hashSet);
        }
        finally {
            this.exitStorage();
        }
        return hashSet;
    }

    final void notifyCollectedListeners(Object object) {
        AbstractLookup.notifyListeners((HashSet)object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        Storage storage = this.enterStorage();
        try {
            storage.beginTransaction(Integer.MAX_VALUE);
            objectOutputStream.defaultWriteObject();
        }
        finally {
            this.exitStorage();
        }
    }

    public final Object lookup(Class clazz) {
        Lookup.Item item = this.lookupItem(new Lookup.Template(clazz));
        return item == null ? null : item.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Lookup.Item lookupItem(Lookup.Template template) {
        this.beforeLookup(template);
        ArrayList arrayList = null;
        Storage storage = this.enterStorage();
        try {
            Enumeration enumeration = storage.lookup(template.getType());
            Pair pair = AbstractLookup.findSmallest(enumeration, template, false);
            return pair;
        }
        catch (ISE iSE) {
            arrayList = new ArrayList();
            Enumeration enumeration = storage.lookup(null);
            while (enumeration.hasMoreElements()) {
                arrayList.add(enumeration.nextElement());
            }
        }
        finally {
            this.exitStorage();
        }
        return AbstractLookup.findSmallest(Collections.enumeration(arrayList), template, true);
    }

    private static Pair findSmallest(Enumeration enumeration, Lookup.Template template, boolean bl) {
        int n = InheritanceTree.unsorted(enumeration) ? Integer.MAX_VALUE : Integer.MIN_VALUE;
        Pair pair = null;
        while (enumeration.hasMoreElements()) {
            Pair pair2 = (Pair)enumeration.nextElement();
            if (!AbstractLookup.matches(template, pair2, bl)) continue;
            if (n == Integer.MIN_VALUE) {
                return pair2;
            }
            if (n <= pair2.getIndex()) continue;
            n = pair2.getIndex();
            pair = pair2;
        }
        return pair;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Lookup.Result lookup(Lookup.Template template) {
        while (true) {
            ISE iSE = null;
            Storage storage = this.enterStorage();
            try {
                R r = new R();
                ReferenceToResult referenceToResult = new ReferenceToResult(r, this, template);
                referenceToResult.next = storage.registerReferenceToResult(referenceToResult);
                R r2 = r;
                return r2;
            }
            catch (ISE iSE2) {
                iSE = iSE2;
            }
            finally {
                this.exitStorage();
            }
            iSE.recover(this);
        }
    }

    private static void notifyListeners(Set set) {
        Object object;
        if (set.isEmpty()) {
            return;
        }
        ArrayList arrayList = new ArrayList();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            object = (R)iterator.next();
            ((R)object).collectFires(arrayList);
        }
        iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            object = (LookupEvent)iterator.next();
            LookupListener lookupListener = (LookupListener)iterator.next();
            lookupListener.resultChanged((LookupEvent)object);
        }
    }

    static void notifyListeners(Object[] objectArray, LookupEvent lookupEvent, Collection collection) {
        for (int i = objectArray.length - 1; i >= 0; i -= 2) {
            LookupListener lookupListener = (LookupListener)objectArray[i];
            try {
                if (collection != null) {
                    if (lookupListener instanceof WaitableResult) {
                        WaitableResult waitableResult = (WaitableResult)((Object)lookupListener);
                        waitableResult.collectFires(collection);
                        continue;
                    }
                    collection.add(lookupEvent);
                    collection.add(lookupListener);
                    continue;
                }
                lookupListener.resultChanged(lookupEvent);
                continue;
            }
            catch (RuntimeException runtimeException) {
                runtimeException.printStackTrace();
            }
        }
    }

    static boolean matches(Lookup.Template template, Pair pair, boolean bl) {
        String string = template.getId();
        if (string != null && !pair.getId().equals(string)) {
            return false;
        }
        Object object = template.getInstance();
        if (object != null && !pair.creatorOf(object)) {
            return false;
        }
        if (bl) {
            return pair.instanceOf(template.getType());
        }
        return true;
    }

    private static boolean compareArrays(Object[] objectArray, Object[] objectArray2) {
        if (objectArray == null) {
            return objectArray2 == null;
        }
        if (objectArray2 == null) {
            return false;
        }
        if (objectArray.length != objectArray2.length) {
            return false;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] == null) {
                if (objectArray2[i] == null) continue;
                return false;
            }
            if (objectArray2[i] == null) {
                return false;
            }
            if (objectArray[i].equals(objectArray2[i])) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean cleanUpResult(Lookup.Template template) {
        Storage storage = this.enterStorage();
        try {
            boolean bl = storage.cleanUpResult(template) == null;
            return bl;
        }
        finally {
            this.exitStorage();
        }
    }

    static Object modifyListenerList(boolean bl, LookupListener lookupListener, Object arrayList) {
        if (bl) {
            if (arrayList == null) {
                return lookupListener;
            }
            if (arrayList instanceof LookupListener) {
                ArrayList arrayList2 = new ArrayList();
                arrayList2.add(arrayList);
                arrayList = arrayList2;
            }
            ((ArrayList)arrayList).add(lookupListener);
            return arrayList;
        }
        if (arrayList == null) {
            return null;
        }
        if (arrayList == lookupListener) {
            return null;
        }
        ArrayList arrayList3 = arrayList;
        arrayList3.remove(lookupListener);
        if (arrayList3.size() == 1) {
            return arrayList3.iterator().next();
        }
        return arrayList3;
    }

    private static ReferenceQueue activeQueue() {
        if (activeQueue == null) {
            try {
                Class<?> clazz = Class.forName("org.openide.util.Utilities");
                Object[] objectArray = new Class[]{};
                Method method = clazz.getDeclaredMethod("activeReferenceQueue", (Class<?>[])objectArray);
                activeQueue = method.invoke(null, objectArray);
            }
            catch (Exception exception) {
                activeQueue = exception;
            }
        }
        return activeQueue instanceof ReferenceQueue ? (ReferenceQueue)activeQueue : null;
    }

    public static class Content
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private AbstractLookup al = null;
        private transient ArrayList earlyPairs;

        final synchronized void attach(AbstractLookup abstractLookup) {
            if (this.al == null) {
                this.al = abstractLookup;
                if (this.earlyPairs != null) {
                    Pair[] pairArray = this.earlyPairs.toArray(new Pair[this.earlyPairs.size()]);
                    for (int i = 0; i < pairArray.length; ++i) {
                        this.addPair(pairArray[i]);
                    }
                }
            } else {
                throw new IllegalStateException("Trying to use content for " + abstractLookup + " but it is already used for " + this.al);
            }
            this.earlyPairs = null;
        }

        public final void addPair(Pair pair) {
            AbstractLookup abstractLookup = this.al;
            if (abstractLookup != null) {
                abstractLookup.addPair(pair);
            } else {
                if (this.earlyPairs == null) {
                    this.earlyPairs = new ArrayList(3);
                }
                this.earlyPairs.add(pair);
            }
        }

        public final void removePair(Pair pair) {
            AbstractLookup abstractLookup = this.al;
            if (abstractLookup != null) {
                abstractLookup.removePair(pair);
            } else {
                if (this.earlyPairs == null) {
                    this.earlyPairs = new ArrayList(3);
                }
                this.earlyPairs.remove(pair);
            }
        }

        public final void setPairs(Collection collection) {
            AbstractLookup abstractLookup = this.al;
            if (abstractLookup != null) {
                abstractLookup.setPairs(collection);
            } else {
                this.earlyPairs = new ArrayList(collection);
            }
        }
    }

    static final class ISE
    extends IllegalStateException {
        private List jobs;

        public ISE(String string) {
            super(string);
        }

        public void registerJob(Job job) {
            if (this.jobs == null) {
                this.jobs = new ArrayList();
            }
            this.jobs.add(job);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void recover(AbstractLookup abstractLookup) {
            Object object;
            if (this.jobs == null) {
                throw this;
            }
            Object object2 = this.jobs.iterator();
            while (object2.hasNext()) {
                object = (Job)object2.next();
                object.before();
            }
            object2 = abstractLookup.enterStorage();
            try {
                object = this.jobs.iterator();
                while (object.hasNext()) {
                    Job job = (Job)object.next();
                    job.inside();
                }
            }
            finally {
                abstractLookup.exitStorage();
            }
        }

        static interface Job {
            public void before();

            public void inside();
        }
    }

    static final class Info {
        public int index;
        public Object transaction;

        public Info(int n, Object object) {
            this.index = n;
            this.transaction = object;
        }
    }

    public static abstract class Pair
    extends Lookup.Item
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private int index = -1;

        protected Pair() {
        }

        final int getIndex() {
            return this.index;
        }

        final void setIndex(Storage storage, int n) {
            if (storage == null) {
                this.index = n;
                return;
            }
            if (this.index != -1) {
                throw new IllegalStateException("You cannot use " + this + " in more than one AbstractLookup");
            }
            this.index = n;
        }

        protected abstract boolean instanceOf(Class var1);

        protected abstract boolean creatorOf(Object var1);
    }

    static final class R
    extends WaitableResult {
        public ReferenceToResult reference;
        private Object listeners;

        private boolean isSimple() {
            Storage storage = (Storage)this.reference.lookup.tree;
            return DelegatingStorage.isSimple(storage);
        }

        private Object getFromCache(int n) {
            if (this.isSimple()) {
                return null;
            }
            Object object = this.reference.caches;
            if (object instanceof Object[]) {
                return ((Object[])object)[n];
            }
            return null;
        }

        private Set getClassesCache() {
            return (Set)this.getFromCache(0);
        }

        private void setClassesCache(Set set) {
            if (this.isSimple()) {
                this.reference.caches = this.reference;
                return;
            }
            if (!(this.reference.caches instanceof Object[])) {
                this.reference.caches = new Object[3];
            }
            ((Object[])this.reference.caches)[0] = set;
        }

        private Collection getInstancesCache() {
            return (Collection)this.getFromCache(1);
        }

        private void setInstancesCache(Collection collection) {
            if (this.isSimple()) {
                this.reference.caches = this.reference;
                return;
            }
            if (!(this.reference.caches instanceof Object[])) {
                this.reference.caches = new Object[3];
            }
            ((Object[])this.reference.caches)[1] = collection;
        }

        private Object[] getItemsCache() {
            return (Object[])this.getFromCache(2);
        }

        private void setItemsCache(Collection collection) {
            if (this.isSimple()) {
                this.reference.caches = this.reference;
                return;
            }
            if (!(this.reference.caches instanceof Object[])) {
                this.reference.caches = new Object[3];
            }
            ((Object[])this.reference.caches)[2] = collection.toArray();
        }

        private void clearCaches() {
            if (this.reference.caches instanceof Object[]) {
                this.reference.caches = new Object[3];
            }
        }

        public synchronized void addLookupListener(LookupListener lookupListener) {
            this.listeners = AbstractLookup.modifyListenerList(true, lookupListener, this.listeners);
        }

        public synchronized void removeLookupListener(LookupListener lookupListener) {
            this.listeners = AbstractLookup.modifyListenerList(false, lookupListener, this.listeners);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void collectFires(Collection collection) {
            Object[] objectArray;
            Object[] objectArray2 = this.getItemsCache();
            this.clearCaches();
            if (objectArray2 != null && AbstractLookup.compareArrays(objectArray2, objectArray = this.allItemsWithoutBeforeLookup().toArray())) {
                return;
            }
            Object[] objectArray3 = this;
            synchronized (this) {
                Serializable serializable;
                if (this.listeners == null) {
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return;
                }
                if (this.listeners instanceof LookupListener) {
                    objectArray = new LookupListener[]{(LookupListener)this.listeners};
                } else {
                    serializable = (ArrayList)this.listeners;
                    objectArray = serializable.toArray(new LookupListener[serializable.size()]);
                }
                // ** MonitorExit[var4_4] (shouldn't be in output)
                objectArray3 = objectArray;
                serializable = new LookupEvent((Lookup.Result)this);
                AbstractLookup.notifyListeners(objectArray3, (LookupEvent)serializable, collection);
                return;
            }
        }

        public Collection allInstances() {
            this.reference.lookup.beforeLookup(this.reference.template);
            List<Object> list = this.getInstancesCache();
            if (list != null) {
                return list;
            }
            Collection collection = this.allItemsWithoutBeforeLookup();
            list = new ArrayList(collection.size());
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Lookup.Item item = (Lookup.Item)iterator.next();
                Object object = item.getInstance();
                if (object == null) continue;
                list.add(object);
            }
            list = Collections.unmodifiableList(list);
            this.setInstancesCache(list);
            return list;
        }

        public Set allClasses() {
            this.reference.lookup.beforeLookup(this.reference.template);
            Set<Class> set = this.getClassesCache();
            if (set != null) {
                return set;
            }
            set = new HashSet();
            Iterator iterator = this.allItemsWithoutBeforeLookup().iterator();
            while (iterator.hasNext()) {
                Lookup.Item item = (Lookup.Item)iterator.next();
                Class clazz = item.getType();
                if (clazz == null) continue;
                set.add(clazz);
            }
            set = Collections.unmodifiableSet(set);
            this.setClassesCache(set);
            return set;
        }

        public Collection allItems() {
            this.reference.lookup.beforeLookup(this.reference.template);
            return this.allItemsWithoutBeforeLookup();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Collection allItemsWithoutBeforeLookup() {
            Pair pair;
            Object object;
            Object[] objectArray = this.getItemsCache();
            if (objectArray != null) {
                return Collections.unmodifiableList(Arrays.asList(objectArray));
            }
            ArrayList<Pair> arrayList = null;
            Storage storage = this.reference.lookup.enterStorage();
            try {
                Collection collection = Collections.unmodifiableCollection(this.initItems(storage));
                return collection;
            }
            catch (ISE iSE) {
                arrayList = new ArrayList<Pair>();
                object = storage.lookup(null);
                while (object.hasMoreElements()) {
                    pair = (Pair)object.nextElement();
                    arrayList.add(pair);
                }
            }
            finally {
                this.reference.lookup.exitStorage();
            }
            Iterator iterator = arrayList.iterator();
            object = new TreeSet(ALPairComparator.DEFAULT);
            while (iterator.hasNext()) {
                pair = (Pair)iterator.next();
                if (!AbstractLookup.matches(this.reference.template, pair, false)) continue;
                ((TreeSet)object).add(pair);
            }
            return Collections.unmodifiableCollection(object);
        }

        private Collection initItems(Storage storage) {
            Enumeration enumeration = storage.lookup(this.reference.template.getType());
            TreeSet<Pair> treeSet = new TreeSet<Pair>(ALPairComparator.DEFAULT);
            while (enumeration.hasMoreElements()) {
                Pair pair = (Pair)enumeration.nextElement();
                if (!AbstractLookup.matches(this.reference.template, pair, false)) continue;
                treeSet.add(pair);
            }
            this.setItemsCache(treeSet);
            return treeSet;
        }

        protected void beforeLookup(Lookup.Template template) {
            if (template.getType() == this.reference.template.getType()) {
                this.reference.lookup.beforeLookup(template);
            }
        }

        public String toString() {
            return super.toString() + " for " + this.reference.template;
        }
    }

    static final class ReferenceIterator {
        private ReferenceToResult first;
        private ReferenceToResult current;
        private R currentResult;

        public ReferenceIterator(ReferenceToResult referenceToResult) {
            this.first = referenceToResult;
        }

        public boolean next() {
            ReferenceToResult referenceToResult;
            ReferenceToResult referenceToResult2;
            if (this.current == null) {
                referenceToResult2 = this.first;
                referenceToResult = null;
            } else {
                referenceToResult = this.current;
                referenceToResult2 = this.current.next;
            }
            while (referenceToResult2 != null) {
                R r = (R)referenceToResult2.get();
                if (r == null) {
                    if (referenceToResult == null) {
                        this.first = referenceToResult2.next;
                    } else {
                        referenceToResult.next = referenceToResult2.next;
                    }
                    referenceToResult = referenceToResult2;
                    referenceToResult2 = referenceToResult2.next;
                    continue;
                }
                this.currentResult = r;
                this.current = referenceToResult2;
                return true;
            }
            this.currentResult = null;
            this.current = null;
            return false;
        }

        public ReferenceToResult current() {
            return this.current;
        }

        public ReferenceToResult first() {
            return this.first;
        }
    }

    static final class ReferenceToResult
    extends WeakReference
    implements Runnable {
        private ReferenceToResult next;
        public final Lookup.Template template;
        public final AbstractLookup lookup;
        public Object caches;

        private ReferenceToResult(R r, AbstractLookup abstractLookup, Lookup.Template template) {
            super(r, AbstractLookup.activeQueue());
            this.template = template;
            this.lookup = abstractLookup;
            this.getResult().reference = this;
        }

        R getResult() {
            return (R)this.get();
        }

        public void run() {
            this.lookup.cleanUpResult(this.template);
        }

        public void cloneList(Storage storage) {
            ReferenceIterator referenceIterator = new ReferenceIterator(this);
            while (referenceIterator.next()) {
                ReferenceToResult referenceToResult = referenceIterator.current();
                ReferenceToResult referenceToResult2 = new ReferenceToResult(referenceToResult.getResult(), referenceToResult.lookup, referenceToResult.template);
                referenceToResult2.next = storage.registerReferenceToResult(referenceToResult2);
                referenceToResult2.caches = referenceToResult.caches;
                if (referenceToResult.caches != referenceToResult) continue;
                referenceToResult.getResult().initItems(storage);
            }
        }
    }

    static interface Storage {
        public Object beginTransaction(int var1);

        public void endTransaction(Object var1, Set var2);

        public boolean add(Pair var1, Object var2);

        public void remove(Pair var1, Object var2);

        public void retainAll(Map var1, Object var2);

        public Enumeration lookup(Class var1);

        public ReferenceToResult registerReferenceToResult(ReferenceToResult var1);

        public ReferenceToResult cleanUpResult(Lookup.Template var1);
    }
}

