/*
 * Decompiled with CFR 0.152.
 */
package org.openide.nodes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.TMUtil;

public interface Index
extends Node.Cookie {
    public int getNodesCount();

    public Node[] getNodes();

    public int indexOf(Node var1);

    public void reorder();

    public void reorder(int[] var1);

    public void move(int var1, int var2);

    public void exchange(int var1, int var2);

    public void moveUp(int var1);

    public void moveDown(int var1);

    public void addChangeListener(ChangeListener var1);

    public void removeChangeListener(ChangeListener var1);

    public static class ArrayChildren
    extends Children.Array
    implements Index {
        protected Index support = new Support(){

            public Node[] getNodes() {
                return ArrayChildren.this.getNodes();
            }

            public int getNodesCount() {
                return ArrayChildren.this.getNodesCount();
            }

            public void reorder(int[] nArray) {
                ArrayChildren.this.reorder(nArray);
                this.fireChangeEvent(new ChangeEvent(ArrayChildren.this));
            }
        };

        public ArrayChildren() {
            this(null);
        }

        private ArrayChildren(List list) {
            super(list);
        }

        protected Collection initCollection() {
            return new ArrayList();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reorder(int[] nArray) {
            try {
                PR.enterWriteAccess();
                Object[] objectArray = this.nodes.toArray();
                List list = (List)this.nodes;
                for (int i = 0; i < objectArray.length; ++i) {
                    list.set(nArray[i], objectArray[i]);
                }
                this.refresh();
            }
            finally {
                PR.exitWriteAccess();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reorder() {
            try {
                PR.enterReadAccess();
                Support.showIndexedCustomizer(this);
            }
            finally {
                PR.exitReadAccess();
            }
        }

        public void move(int n, int n2) {
            this.support.move(n, n2);
        }

        public void exchange(int n, int n2) {
            this.support.exchange(n, n2);
        }

        public void moveUp(int n) {
            this.support.exchange(n, n - 1);
        }

        public void moveDown(int n) {
            this.support.exchange(n, n + 1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int indexOf(Node node) {
            try {
                PR.enterReadAccess();
                int n = ((List)this.nodes).indexOf(node);
                return n;
            }
            finally {
                PR.exitReadAccess();
            }
        }

        public void addChangeListener(ChangeListener changeListener) {
            this.support.addChangeListener(changeListener);
        }

        public void removeChangeListener(ChangeListener changeListener) {
            this.support.removeChangeListener(changeListener);
        }
    }

    public static abstract class KeysChildren
    extends Children.Keys {
        private Index support;
        protected final List list;

        public KeysChildren(List list) {
            this.list = list;
            this.update();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Index getIndex() {
            KeysChildren keysChildren = this;
            synchronized (keysChildren) {
                if (this.support == null) {
                    this.support = this.createIndex();
                }
                return this.support;
            }
        }

        protected Index createIndex() {
            return new Support(){

                public Node[] getNodes() {
                    List<Node> list = Arrays.asList(KeysChildren.this.getNodes());
                    if (KeysChildren.this.nodes != null) {
                        list.removeAll(KeysChildren.this.nodes);
                    }
                    return list.toArray(new Node[list.size()]);
                }

                public int getNodesCount() {
                    return KeysChildren.this.list.size();
                }

                public void reorder(int[] nArray) {
                    KeysChildren.this.reorder(nArray);
                    KeysChildren.this.update();
                    this.fireChangeEvent(new ChangeEvent(this));
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void reorder(int[] nArray) {
            Object object = this.lock();
            synchronized (object) {
                Object[] objectArray = this.list.toArray();
                for (int i = 0; i < objectArray.length; ++i) {
                    this.list.set(nArray[i], objectArray[i]);
                }
            }
        }

        protected Object lock() {
            return this.list;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void update() {
            Object[] objectArray;
            Object object = this.lock();
            synchronized (object) {
                objectArray = this.list.toArray();
            }
            super.setKeys(objectArray);
        }
    }

    public static abstract class Support
    implements Index {
        private HashSet listeners;

        public void move(int n, int n2) {
            int[] nArray = new int[this.getNodesCount()];
            if (n == n2) {
                return;
            }
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = i < n && i < n2 || i > n && i > n2 ? i : (i > n && i < n2 ? i - 1 : i + 1);
            }
            nArray[n] = n2;
            nArray[n2] = n < n2 ? n2 - 1 : n2 + 1;
            this.reorder(nArray);
        }

        public void exchange(int n, int n2) {
            int[] nArray = new int[this.getNodesCount()];
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = i;
            }
            nArray[n] = n2;
            nArray[n2] = n;
            this.reorder(nArray);
        }

        public void moveUp(int n) {
            this.exchange(n, n - 1);
        }

        public void moveDown(int n) {
            this.exchange(n, n + 1);
        }

        public void addChangeListener(ChangeListener changeListener) {
            if (this.listeners == null) {
                this.listeners = new HashSet();
            }
            this.listeners.add(changeListener);
        }

        public void removeChangeListener(ChangeListener changeListener) {
            if (this.listeners == null) {
                return;
            }
            this.listeners.remove(changeListener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void fireChangeEvent(ChangeEvent changeEvent) {
            HashSet hashSet;
            if (this.listeners == null) {
                return;
            }
            Object object = this;
            synchronized (object) {
                hashSet = (HashSet)this.listeners.clone();
            }
            object = hashSet.iterator();
            while (object.hasNext()) {
                ((ChangeListener)object.next()).stateChanged(changeEvent);
            }
        }

        public abstract Node[] getNodes();

        public int indexOf(Node node) {
            Node[] nodeArray = this.getNodes();
            for (int i = 0; i < nodeArray.length; ++i) {
                if (!node.equals(nodeArray[i])) continue;
                return i;
            }
            return -1;
        }

        public void reorder() {
            Support.showIndexedCustomizer(this);
        }

        public static void showIndexedCustomizer(Index index) {
            TMUtil.showIndexedCustomizer(index);
        }

        public abstract int getNodesCount();

        public abstract void reorder(int[] var1);
    }
}

