/*
 * Decompiled with CFR 0.152.
 */
package org.openide.nodes;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.openide.nodes.Node;
import org.openide.util.lookup.AbstractLookup;

public final class CookieSet {
    private static ThreadLocal QUERY_MODE = new ThreadLocal();
    private HashMap map = new HashMap(31);
    private EventListenerList listeners = new EventListenerList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Node.Cookie cookie) {
        CookieSet cookieSet = this;
        synchronized (cookieSet) {
            this.registerCookie(cookie.getClass(), cookie);
        }
        this.fireChangeEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Node.Cookie cookie) {
        CookieSet cookieSet = this;
        synchronized (cookieSet) {
            this.unregisterCookie(cookie.getClass(), cookie);
        }
        this.fireChangeEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node.Cookie getCookie(Class clazz) {
        Node.Cookie cookie = null;
        Object t = QUERY_MODE.get();
        CookieSet cookieSet = this;
        synchronized (cookieSet) {
            R r = this.findR(clazz);
            if (r == null) {
                return null;
            }
            cookie = r.cookie();
            if (t instanceof Set) {
                ((Set)t).addAll(this.map.keySet());
            }
        }
        if (cookie instanceof CookieEntry) {
            if (clazz == t) {
                QUERY_MODE.set(cookie);
                cookie = null;
            } else {
                cookie = ((CookieEntry)cookie).getCookie(true);
            }
        }
        return cookie;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(ChangeListener.class, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(ChangeListener.class, changeListener);
    }

    static Object entryQueryMode(Class clazz) {
        Object t = QUERY_MODE.get();
        QUERY_MODE.set(clazz);
        return t;
    }

    static Object entryAllClassesMode() {
        Object t = QUERY_MODE.get();
        QUERY_MODE.set(new HashSet());
        return t;
    }

    static AbstractLookup.Pair exitQueryMode(Object object) {
        Object t = QUERY_MODE.get();
        QUERY_MODE.set(object);
        if (t instanceof CookieEntry) {
            return new CookieEntryPair((CookieEntry)t);
        }
        return null;
    }

    static Set exitAllClassesMode(Object object) {
        Object t = QUERY_MODE.get();
        QUERY_MODE.set(object);
        if (t instanceof HashSet) {
            return (Set)t;
        }
        return null;
    }

    private void fireChangeEvent() {
        Object[] objectArray = this.listeners.getListenerList();
        if (objectArray.length > 0) {
            ChangeEvent changeEvent = null;
            for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                if (objectArray[i] != (class$javax$swing$event$ChangeListener == null ? CookieSet.class$("javax.swing.event.ChangeListener") : class$javax$swing$event$ChangeListener)) continue;
                if (changeEvent == null) {
                    changeEvent = new ChangeEvent(this);
                }
                ((ChangeListener)objectArray[i + 1]).stateChanged(changeEvent);
            }
        }
    }

    private void registerCookie(Class clazz, Node.Cookie cookie) {
        if (clazz == null || !Node.Cookie.class.isAssignableFrom(clazz)) {
            return;
        }
        R r = this.findR(clazz);
        if (r == null) {
            r = new R();
            this.map.put(clazz, r);
        }
        r.add(cookie);
        this.registerCookie(clazz.getSuperclass(), cookie);
        Class<?>[] classArray = clazz.getInterfaces();
        for (int i = 0; i < classArray.length; ++i) {
            this.registerCookie(classArray[i], cookie);
        }
    }

    private void unregisterCookie(Class clazz, Node.Cookie cookie) {
        if (clazz == null || !Node.Cookie.class.isAssignableFrom(clazz)) {
            return;
        }
        R r = this.findR(clazz);
        if (r != null) {
            r.remove(cookie);
        }
        this.unregisterCookie(clazz.getSuperclass(), cookie);
        Class<?>[] classArray = clazz.getInterfaces();
        for (int i = 0; i < classArray.length; ++i) {
            this.unregisterCookie(classArray[i], cookie);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Class clazz, Factory factory) {
        if (factory == null) {
            throw new IllegalArgumentException();
        }
        CookieSet cookieSet = this;
        synchronized (cookieSet) {
            this.registerCookie(clazz, new CookieEntry(factory, clazz));
        }
        this.fireChangeEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Class[] classArray, Factory factory) {
        if (factory == null) {
            throw new IllegalArgumentException();
        }
        CookieSet cookieSet = this;
        synchronized (cookieSet) {
            for (int i = 0; i < classArray.length; ++i) {
                this.registerCookie(classArray[i], new CookieEntry(factory, classArray[i]));
            }
        }
        this.fireChangeEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Class clazz, Factory factory) {
        if (factory == null) {
            throw new IllegalArgumentException();
        }
        CookieSet cookieSet = this;
        synchronized (cookieSet) {
            Node.Cookie cookie;
            R r = this.findR(clazz);
            if (r != null && (cookie = r.cookie()) instanceof CookieEntry) {
                CookieEntry cookieEntry = (CookieEntry)cookie;
                if (cookieEntry.factory == factory) {
                    this.unregisterCookie(clazz, cookie);
                }
            }
        }
        this.fireChangeEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Class[] classArray, Factory factory) {
        if (factory == null) {
            throw new IllegalArgumentException();
        }
        CookieSet cookieSet = this;
        synchronized (cookieSet) {
            for (int i = 0; i < classArray.length; ++i) {
                Node.Cookie cookie;
                R r = this.findR(classArray[i]);
                if (r == null || !((cookie = r.cookie()) instanceof CookieEntry)) continue;
                CookieEntry cookieEntry = (CookieEntry)cookie;
                if (cookieEntry.factory != factory) continue;
                this.unregisterCookie(classArray[i], cookie);
            }
        }
        this.fireChangeEvent();
    }

    private R findR(Class clazz) {
        return (R)this.map.get(clazz);
    }

    private static Class baseForCookie(Node.Cookie cookie) {
        if (cookie instanceof CookieEntry) {
            return ((CookieEntry)cookie).klass;
        }
        return cookie.getClass();
    }

    private static class CookieEntry
    implements Node.Cookie {
        final Factory factory;
        private final Class klass;
        private Reference cookie;

        public CookieEntry(Factory factory, Class clazz) {
            this.factory = factory;
            this.klass = clazz;
        }

        public synchronized Node.Cookie getCookie(boolean bl) {
            Node.Cookie cookie;
            if (bl) {
                if (this.cookie == null || (cookie = (Node.Cookie)this.cookie.get()) == null) {
                    cookie = this.factory.createCookie(this.klass);
                    if (cookie == null) {
                        return null;
                    }
                    this.cookie = new WeakReference<Node.Cookie>(cookie);
                }
            } else {
                cookie = this.cookie == null ? null : this.cookie.get();
            }
            return cookie;
        }
    }

    private static final class CookieEntryPair
    extends AbstractLookup.Pair {
        private CookieEntry entry;

        public CookieEntryPair(CookieEntry cookieEntry) {
            this.entry = cookieEntry;
        }

        protected boolean creatorOf(Object object) {
            return object == this.entry.getCookie(false);
        }

        public String getDisplayName() {
            return this.getId();
        }

        public String getId() {
            return this.entry.klass.getName();
        }

        public Object getInstance() {
            return this.entry.getCookie(true);
        }

        public Class getType() {
            return this.entry.klass;
        }

        protected boolean instanceOf(Class clazz) {
            return clazz.isAssignableFrom(this.entry.klass);
        }

        public int hashCode() {
            return this.entry.hashCode() + 5;
        }

        public boolean equals(Object object) {
            if (object instanceof CookieEntryPair) {
                return ((CookieEntryPair)((Object)object)).entry == this.entry;
            }
            return false;
        }
    }

    public static interface Factory {
        public Node.Cookie createCookie(Class var1);
    }

    private static final class R {
        public List cookies;
        public Class base;

        R() {
        }

        public void add(Node.Cookie cookie) {
            if (this.cookies == null) {
                this.cookies = new ArrayList(1);
                this.cookies.add(cookie);
                this.base = CookieSet.baseForCookie(cookie);
                return;
            }
            Class clazz = CookieSet.baseForCookie(cookie);
            if (this.base == null || clazz.isAssignableFrom(this.base)) {
                this.cookies.set(0, cookie);
                this.base = clazz;
            } else {
                this.cookies.add(cookie);
            }
        }

        public boolean remove(Node.Cookie cookie) {
            if (this.cookies == null) {
                return true;
            }
            if (this.cookies.remove(cookie) && this.cookies.size() == 0) {
                this.base = null;
                this.cookies = null;
                return true;
            }
            this.base = CookieSet.baseForCookie((Node.Cookie)this.cookies.get(0));
            return false;
        }

        public Node.Cookie cookie() {
            return this.cookies == null || this.cookies.isEmpty() ? null : (Node.Cookie)this.cookies.get(0);
        }
    }
}

