/*
 * Decompiled with CFR 0.152.
 */
package tr.data.files;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import org.openide.util.HelpCtx;
import org.openide.windows.WindowManager;
import tr.background.activation.ActivatorTaskScheduler;
import tr.background.recurrence.RecurrenceTaskScheduler;
import tr.datastore.DataStore;
import tr.datastore.DataStoreLookup;
import tr.view.WindowUtils;

public final class RecentDataFileOpenAction
extends AbstractAction {
    private static final Logger LOG = Logger.getLogger("tr.data.files");
    private final String path;

    public RecentDataFileOpenAction(String path) {
        super(path);
        this.path = path;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        DataStore ds = (DataStore)DataStoreLookup.instance().lookup(DataStore.class);
        if (ds == null) {
            LOG.severe("Datastore was not found.");
            return;
        }
        try {
            ds.store();
        }
        catch (Exception ex) {
            LOG.severe("Datastore store exception: " + ex.getMessage());
        }
        File datafile = new File(this.path);
        if (!datafile.exists()) {
            String t = "Data File Not Found";
            String m = "The data file was not found.  \n\n";
            JOptionPane.showConfirmDialog(null, m, t, 0);
            return;
        }
        try {
            ds.setPath(this.path);
            ds.load();
            WindowManager.getDefault().getMainWindow().setTitle("ThinkingRock " + this.path);
            WindowUtils.closeWindows();
            WindowUtils.openInitialWindow();
            ActivatorTaskScheduler.instance().runTask(0, 1, 0);
            RecurrenceTaskScheduler.instance().runTask(0, 2, 0);
        }
        catch (Exception ex) {
            String e = ex.getMessage();
            String t = "Open File Error";
            String m = "Could not open data file: " + this.path + "\n\n" + (e == null ? "" : e);
            JOptionPane.showMessageDialog(null, m, t, 0);
        }
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }
}

