/*
 * Decompiled with CFR 0.152.
 */
package tr.view.project;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import tr.model.Data;
import tr.model.DataLookup;
import tr.model.project.Project;
import tr.util.Observable;
import tr.util.Observer;

public class ProjectsComboBoxModel
extends DefaultComboBoxModel
implements Observer {
    private List<ProjectItem> projectItems;
    private Lookup.Result result;

    public ProjectsComboBoxModel() {
        this.initialise();
    }

    public Object getElementAt(int index) {
        try {
            return this.projectItems.get(index);
        }
        catch (IndexOutOfBoundsException ex) {
            return null;
        }
    }

    public int getSize() {
        return this.projectItems.size();
    }

    public void update(Observable o, Object arg) {
        this.initialise();
        this.fireContentsChanged(this, 0, this.getSize());
    }

    private synchronized void initialise() {
        if (this.result == null) {
            this.result = DataLookup.instance().lookup(new Lookup.Template(Data.class));
            this.result.addLookupListener(new LookupListener(){

                public void resultChanged(LookupEvent lookupEvent) {
                    ProjectsComboBoxModel.this.update(null, null);
                }
            });
        }
        this.projectItems = new Vector<ProjectItem>();
        Data data = (Data)DataLookup.instance().lookup(Data.class);
        if (data == null) {
            return;
        }
        this.projectItems.add(new ProjectItem("None", null));
        this.addProjects(data.getRootProjects(), "");
        data.getRootProjects().addObserver((Observer)this);
    }

    private void addProjects(Project project, String indent) {
        if (project == null || project.isDone()) {
            return;
        }
        Iterator i = project.iterator(Project.class);
        while (i.hasNext()) {
            Project subProject = (Project)i.next();
            if (subProject.isDone()) continue;
            this.projectItems.add(new ProjectItem(indent + subProject.getDescription(), subProject));
            this.addProjects(subProject, indent + "   ");
        }
    }

    public final class ProjectItem {
        public final String string;
        public final Project project;

        public ProjectItem(String string, Project project) {
            this.project = project;
            this.string = this.filter(string);
        }

        private final String filter(String str) {
            str = str.replaceAll("\t", " ");
            str = str.replaceAll("\n", " ");
            str = str.replaceAll("\f", "");
            str = str.replaceAll("\r", "");
            return str;
        }

        public final String toString() {
            return this.string;
        }
    }
}

