/*
 * Decompiled with CFR 0.152.
 */
package tr.view.topic;

import java.awt.BorderLayout;
import java.io.Serializable;
import org.openide.ErrorManager;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import tr.model.Data;
import tr.model.DataLookup;
import tr.view.Window;
import tr.view.topic.Resources;
import tr.view.topic.TopicsPanel;

public final class TopicsTopComponent
extends Window {
    public static final String PREFERRED_ID = "TopicsTopComponent";
    private static TopicsTopComponent instance;
    private transient Lookup lookup;
    private transient Lookup.Result result;
    private transient TopicsPanel panel;

    private TopicsTopComponent() {
        this.initComponents();
        this.setName(NbBundle.getMessage(TopicsTopComponent.class, (String)"CTL_TopicsTopComponent"));
        this.setToolTipText(NbBundle.getMessage(TopicsTopComponent.class, (String)"HINT_TopicsTopComponent"));
        this.setIcon(Resources.ICON_TOPIC.getImage());
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    public static synchronized TopicsTopComponent getDefault() {
        if (instance == null) {
            instance = new TopicsTopComponent();
        }
        return instance;
    }

    public static synchronized TopicsTopComponent findInstance() {
        TopComponent win = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (win == null) {
            ErrorManager.getDefault().log(16, "Cannot find Topics component. It will not be located properly in the window system.");
            return TopicsTopComponent.getDefault();
        }
        if (win instanceof TopicsTopComponent) {
            return (TopicsTopComponent)win;
        }
        ErrorManager.getDefault().log(16, "There seem to be multiple components with the 'TopicsTopComponent' ID. That is a potential source of errors and unexpected behavior.");
        return TopicsTopComponent.getDefault();
    }

    public int getPersistenceType() {
        return 0;
    }

    public void componentOpened() {
        if (this.panel == null) {
            this.removeAll();
            this.panel = new TopicsPanel();
            this.add(this.panel, "Center");
            super.revalidate();
            super.repaint();
        }
        if (this.result == null) {
            this.result = DataLookup.instance().lookup(new Lookup.Template(Data.class));
            this.result.addLookupListener(new LookupListener(){

                public void resultChanged(LookupEvent lookupEvent) {
                    TopicsTopComponent.this.removeAll();
                    TopicsTopComponent.this.panel = null;
                }
            });
        }
    }

    public void componentClosed() {
        if (this.panel != null) {
            this.panel.deactivate();
        }
    }

    public Object writeReplace() {
        return new ResolvableHelper();
    }

    public String preferredID() {
        return PREFERRED_ID;
    }

    public Lookup getLookup() {
        if (this.panel == null) {
            return super.getLookup();
        }
        if (this.lookup == null) {
            this.lookup = Lookups.singleton((Object)this.panel);
        }
        return this.lookup;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("tr.view.topics");
    }

    static final class ResolvableHelper
    implements Serializable {
        private static final long serialVersionUID = 1L;

        ResolvableHelper() {
        }

        public Object readResolve() {
            return TopicsTopComponent.getDefault();
        }
    }
}

