/*
 * Decompiled with CFR 0.152.
 */
package tr.view.topic;

import java.awt.Color;
import java.util.List;
import javax.swing.Icon;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import tr.model.topic.Topic;
import tr.model.util.Manager;
import tr.swing.ColorEditor;
import tr.swing.ColorRenderer;
import tr.swing.StyledString;
import tr.swing.StyledStringEditor;
import tr.swing.StyledStringRenderer;
import tr.util.Observable;
import tr.util.Observer;
import tr.view.topic.Resources;

public class TopicsTableModel
extends AbstractTableModel
implements Observer {
    public static final String[] HEADINGS = new String[]{"", " Text Colour ", " Background ", " Name ", " Description "};
    public static final Class[] CLASSES = new Class[]{Icon.class, Color.class, Color.class, StyledString.class, StyledString.class};
    public static final TableCellRenderer[] RENDERERS = new TableCellRenderer[]{null, new ColorRenderer(), new ColorRenderer(), new StyledStringRenderer(), new StyledStringRenderer()};
    public static final TableCellEditor[] EDITORS = new TableCellEditor[]{null, new ColorEditor(), new ColorEditor(), new StyledStringEditor(), new StyledStringEditor()};
    public static final int[] MAX_WIDTHS = new int[]{17, 90, 90, 800, -1};
    public static final int[] MIN_WIDTHS = new int[]{17, 17, 17, -1, -1};
    public static final int[] PREF_WIDTHS = new int[]{17, 90, 90, 300, -1};
    private final Manager manager;
    private List topics;

    public TopicsTableModel(Manager topicManager) {
        this.manager = topicManager;
        this.manager.addObserver((Observer)this);
        this.initModel();
    }

    private void initModel() {
        this.topics = this.manager.list();
    }

    public int getColumnCount() {
        return CLASSES.length;
    }

    public Class getColumnClass(int col) {
        return CLASSES[col];
    }

    public String getColumnName(int col) {
        return HEADINGS[col];
    }

    public int getRowCount() {
        return this.topics.size();
    }

    public Topic getValueAt(int row) {
        return (Topic)this.topics.get(row);
    }

    public Object getValueAt(int row, int column) {
        if (row > this.topics.size() - 1) {
            return null;
        }
        StyledString ss = new StyledString();
        switch (column) {
            case 0: {
                return Resources.ICON_TOPIC;
            }
            case 1: {
                return ((Topic)this.topics.get(row)).getForeground();
            }
            case 2: {
                return ((Topic)this.topics.get(row)).getBackground();
            }
            case 3: {
                ss.setString(((Topic)this.topics.get(row)).getName());
                ss.setForeground(((Topic)this.topics.get(row)).getForeground());
                ss.setBackground(((Topic)this.topics.get(row)).getBackground());
                return ss;
            }
            case 4: {
                ss.setString(((Topic)this.topics.get(row)).getDescription());
                ss.setForeground(((Topic)this.topics.get(row)).getForeground());
                ss.setBackground(((Topic)this.topics.get(row)).getBackground());
                return ss;
            }
        }
        return null;
    }

    public boolean isCellEditable(int row, int column) {
        return row > 0 && column > 0;
    }

    public void setValueAt(Object value, int row, int column) {
        if (row > this.topics.size() - 1) {
            return;
        }
        switch (column) {
            case 1: {
                ((Topic)this.topics.get(row)).setForeground((Color)value);
                break;
            }
            case 2: {
                ((Topic)this.topics.get(row)).setBackground((Color)value);
                break;
            }
            case 3: {
                ((Topic)this.topics.get(row)).setName(((StyledString)value).getString());
                break;
            }
            case 4: {
                ((Topic)this.topics.get(row)).setDescription(((StyledString)value).getString());
            }
        }
    }

    public void update(Observable o, Object arg) {
        this.initModel();
        this.fireTableDataChanged();
    }
}

