/*
 * Decompiled with CFR 0.152.
 */
package tr.view.topic;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.JXTable;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import tr.global.Constants;
import tr.model.Data;
import tr.model.DataLookup;
import tr.model.topic.Topic;
import tr.model.topic.TopicUtils;
import tr.model.util.Manager;
import tr.prefs.gui.GUIPrefs;
import tr.util.Observable;
import tr.view.Add;
import tr.view.Delete;
import tr.view.Resources;
import tr.view.topic.TopicComboBox;
import tr.view.topic.TopicComboBoxModel;
import tr.view.topic.TopicsTableModel;

public class TopicsPanel
extends JPanel
implements Add,
Delete {
    private static final String HEADING = "Topics";
    private TopicsTableModel tableModel;
    private Data data = (Data)DataLookup.instance().lookup(Data.class);
    private Manager<Topic> manager = this.data.getTopicManager();
    private JPanel buttonsPanel;
    private JButton addButton;
    private JButton deleteButton;
    private JPanel bodyPanel;
    private JTable table;
    private JTableHeader tableHeader;
    private JScrollPane tableScrollPane;

    public TopicsPanel() {
        this.tableModel = new TopicsTableModel(this.manager);
        this.initComponents();
    }

    private void initComponents() {
        this.initButtonsPanel();
        this.initTable();
        this.initBodyPanel();
        this.initFrame();
    }

    private void initButtonsPanel() {
        this.addButton = new JButton(Constants.STRING_PLUS);
        this.addButton.setIcon(tr.view.topic.Resources.ICON_TOPIC);
        this.addButton.setToolTipText(Resources.ADD_TOOLTIP);
        this.addButton.putClientProperty("JButton.buttonType", "icon");
        this.addButton.setPreferredSize(Constants.BUTTON_SIZE_BIG);
        this.addButton.setEnabled(true);
        this.addButton.setFocusable(false);
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TopicsPanel.this.add();
            }
        });
        this.deleteButton = new JButton(Constants.STRING_MINUS);
        this.deleteButton.setIcon(tr.view.topic.Resources.ICON_TOPIC);
        this.deleteButton.setToolTipText(Resources.DELETE_TOOLTIP);
        this.deleteButton.putClientProperty("JButton.buttonType", "icon");
        this.deleteButton.setPreferredSize(Constants.BUTTON_SIZE_BIG);
        this.deleteButton.setEnabled(false);
        this.deleteButton.setFocusable(false);
        this.deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TopicsPanel.this.delete();
            }
        });
        this.buttonsPanel = new JPanel(new FlowLayout(0, 2, 2));
        this.buttonsPanel.setBorder(BorderFactory.createLineBorder(Color.gray));
        this.buttonsPanel.add(this.addButton);
        this.buttonsPanel.add(this.deleteButton);
    }

    private void initTable() {
        JXTable jxtable = new JXTable((TableModel)this.tableModel);
        jxtable.setColumnControlVisible(false);
        jxtable.setSortable(false);
        this.table = jxtable;
        this.table.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.table.setSurrendersFocusOnKeystroke(true);
        this.table.setEnabled(true);
        this.table.setFocusable(true);
        this.table.setShowGrid(false);
        this.table.setRowSelectionAllowed(false);
        this.table.setColumnSelectionAllowed(false);
        this.table.setCellSelectionEnabled(true);
        this.table.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 40) {
                    if (TopicsPanel.this.table.isEditing()) {
                        e.consume();
                        TopicsPanel.this.stopEditing();
                    } else if (TopicsPanel.this.isLastRowSelected()) {
                        e.consume();
                        TopicsPanel.this.add();
                    }
                } else if (e.getKeyCode() == 9) {
                    if (!e.isShiftDown() && TopicsPanel.this.isLastRowSelected() && TopicsPanel.this.isLastColumnSelected()) {
                        e.consume();
                        TopicsPanel.this.add();
                    }
                } else if (e.getKeyCode() == 10) {
                    e.consume();
                    if (TopicsPanel.this.table.isEditing()) {
                        TopicsPanel.this.stopEditing();
                    } else {
                        int row = TopicsPanel.this.table.getSelectedRow();
                        int last = TopicsPanel.this.table.getRowCount() - 1;
                        if (row > -1 && row < last) {
                            int column = TopicsPanel.this.table.getSelectedColumn();
                            TopicsPanel.this.table.changeSelection(row + 1, column, false, false);
                        } else {
                            TopicsPanel.this.add();
                        }
                    }
                } else if (e.getKeyCode() == 127) {
                    e.consume();
                    TopicsPanel.this.delete();
                }
            }
        });
        this.table.setSelectionMode(0);
        ListSelectionModel rowSM = this.table.getSelectionModel();
        rowSM.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                TopicsPanel.this.enableModifyAndDeleteButtons();
                if (TopicsPanel.this.table.getSelectedColumn() == 0) {
                    TopicsPanel.this.table.setColumnSelectionInterval(1, 1);
                }
            }
        });
        TableCellRenderer tcr = this.table.getTableHeader().getDefaultRenderer();
        if (tcr instanceof DefaultTableCellRenderer) {
            DefaultTableCellRenderer dtcr = (DefaultTableCellRenderer)tcr;
            dtcr.setHorizontalAlignment(2);
        }
        this.tableHeader = this.table.getTableHeader();
        this.tableHeader.setResizingAllowed(true);
        for (int i = 0; i < TopicsTableModel.CLASSES.length; ++i) {
            TableColumn tc = this.table.getColumnModel().getColumn(i);
            if (TopicsTableModel.RENDERERS[i] != null) {
                tc.setCellRenderer(TopicsTableModel.RENDERERS[i]);
            }
            if (TopicsTableModel.EDITORS[i] != null) {
                tc.setCellEditor(TopicsTableModel.EDITORS[i]);
            }
            if (TopicsTableModel.MAX_WIDTHS[i] > -1) {
                tc.setMaxWidth(TopicsTableModel.MAX_WIDTHS[i]);
            }
            if (TopicsTableModel.MIN_WIDTHS[i] > -1) {
                tc.setMinWidth(TopicsTableModel.MIN_WIDTHS[i]);
            }
            if (TopicsTableModel.PREF_WIDTHS[i] <= -1) continue;
            tc.setPreferredWidth(TopicsTableModel.PREF_WIDTHS[i]);
        }
        this.tableScrollPane = new JScrollPane(this.table);
    }

    private void stopEditing() {
        if (!this.table.isEditing()) {
            return;
        }
        int row = this.table.getEditingRow();
        int column = this.table.getEditingColumn();
        this.table.getCellEditor().stopCellEditing();
        if (Utilities.isWindows()) {
            this.table.changeSelection(row, column, false, false);
        }
    }

    private void enableModifyAndDeleteButtons() {
        boolean b = false;
        int selectedRow = this.table.getSelectedRow();
        if (selectedRow > -1 && !this.tableModel.getValueAt(selectedRow).equals((Object)Topic.getDefault())) {
            b = true;
        }
        this.deleteButton.setEnabled(b);
        this.addButton.setEnabled(this.canAdd());
    }

    public void focus() {
        this.table.requestFocusInWindow();
    }

    private void initBodyPanel() {
        this.bodyPanel = new JPanel();
        this.bodyPanel.setLayout(new BorderLayout());
        this.bodyPanel.add((Component)this.tableScrollPane, "Center");
        if (GUIPrefs.getButtonsPosition().equals("top")) {
            this.bodyPanel.add((Component)this.buttonsPanel, "North");
        } else {
            this.bodyPanel.add((Component)this.buttonsPanel, "South");
        }
    }

    private void initFrame() {
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(new Insets(2, 2, 2, 2)));
        this.add((Component)this.bodyPanel, "Center");
    }

    private boolean isLastRowSelected() {
        return this.table.isRowSelected(this.table.getRowCount() - 1);
    }

    private boolean isLastColumnSelected() {
        int last = this.table.getColumnCount() - 1;
        return this.table.getSelectedColumn() == last || this.table.getEditingColumn() == last;
    }

    private boolean canAdd() {
        if (this.table.getRowCount() < 1) {
            return true;
        }
        Topic topic = this.tableModel.getValueAt(this.table.getRowCount() - 1);
        return !topic.getName().trim().equals("");
    }

    public void add() {
        if (this.canAdd()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    TopicsPanel.this.table.requestFocus();
                    TopicsPanel.this.manager.add((Observable)new Topic());
                    try {
                        Thread.sleep(400L);
                    }
                    catch (InterruptedException ex) {
                        // empty catch block
                    }
                    int row = TopicsPanel.this.table.getRowCount() - 1;
                    int column = 1;
                    TopicsPanel.this.table.changeSelection(row, column, false, false);
                    TopicsPanel.this.table.requestFocus();
                    TopicsPanel.this.table.editCellAt(row, column);
                }
            });
        }
    }

    public void delete() {
        this.stopEditing();
        int selectedRow = this.table.getSelectedRow();
        if (selectedRow < 0) {
            return;
        }
        Topic topic = this.tableModel.getValueAt(selectedRow);
        if (TopicUtils.instance().isUsed(this.data, topic)) {
            TopicComboBox tcb = new TopicComboBox((ComboBoxModel)new TopicComboBoxModel(false));
            tcb.setSelectedIndex(0);
            JPanel panel = new JPanel();
            panel.add(new JLabel(NbBundle.getMessage(this.getClass(), (String)"MSG_ReplaceTopic")));
            panel.add(tcb);
            String title = "Delete Topic: " + topic.getName();
            int r = JOptionPane.showConfirmDialog(null, panel, title, 2);
            if (r == 2) {
                return;
            }
            Topic replacement = (Topic)tcb.getSelectedItem();
            if (!TopicUtils.instance().replace(this.data, topic, replacement)) {
                String msg = "Can not replace topic: " + topic.getName() + "\n" + " with topic: " + replacement.getName() + "\n\n";
                JOptionPane.showMessageDialog(this, msg);
                return;
            }
        }
        this.manager.remove((Observable)topic);
        try {
            Thread.sleep(400L);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        int rows = this.table.getRowCount();
        if (selectedRow < rows) {
            this.table.changeSelection(selectedRow, 1, false, false);
        } else if (rows > 0) {
            this.table.changeSelection(rows - 1, 1, false, false);
        }
    }

    public void deactivate() {
        this.stopEditing();
        Manager manager = this.data.getTopicManager();
        for (Topic topic : manager.list()) {
            if (topic.getName().trim().length() != 0 || TopicUtils.instance().isUsed(this.data, topic)) continue;
            manager.remove((Observable)topic);
        }
    }
}

