/*
 * Decompiled with CFR 0.152.
 */
package tr.view.topic;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import tr.global.InitialAction;
import tr.model.Data;
import tr.model.DataLookup;
import tr.view.WindowUtils;
import tr.view.topic.Resources;
import tr.view.topic.TopicsTopComponent;

public class TopicsAction
extends AbstractAction
implements InitialAction {
    public TopicsAction() {
        super(NbBundle.getMessage(TopicsAction.class, (String)"CTL_TopicsAction"));
        this.putValue("SmallIcon", Resources.ICON_TOPIC);
        this.enableDisable();
        Lookup.Result r = DataLookup.instance().lookup(new Lookup.Template(Data.class));
        r.addLookupListener(new LookupListener(){

            public void resultChanged(LookupEvent lookupEvent) {
                TopicsAction.this.enableDisable();
            }
        });
    }

    private void enableDisable() {
        Data data = (Data)DataLookup.instance().lookup(Data.class);
        this.setEnabled(data != null);
    }

    public void actionPerformed(ActionEvent evt) {
        Data data = (Data)DataLookup.instance().lookup(Data.class);
        if (data == null) {
            return;
        }
        WindowUtils.closeWindows();
        WindowManager.getDefault().getMainWindow().invalidate();
        WindowManager.getDefault().getMainWindow().repaint();
        TopicsTopComponent tc = TopicsTopComponent.findInstance();
        Mode mode = WindowManager.getDefault().findMode("topics");
        if (mode != null) {
            mode.dockInto((TopComponent)tc);
        }
        tc.open();
        tc.requestActive();
    }

    public String getID() {
        return "topics";
    }

    public String getName() {
        return (String)this.getValue("Name");
    }
}

