/*
 * Decompiled with CFR 0.152.
 */
package org.openide.actions;

import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public class RenameAction
extends NodeAction {
    protected boolean surviveFocusChange() {
        return false;
    }

    public String getName() {
        return NbBundle.getMessage((Class)RenameAction.class, (String)"Rename");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(RenameAction.class);
    }

    protected boolean enable(Node[] nodeArray) {
        if (nodeArray == null || nodeArray.length != 1) {
            return false;
        }
        return nodeArray[0].canRename();
    }

    protected void performAction(Node[] nodeArray) {
        Node node = nodeArray[0];
        NotifyDescriptor.InputLine inputLine = new NotifyDescriptor.InputLine(NbBundle.getMessage((Class)RenameAction.class, (String)"CTL_RenameLabel"), NbBundle.getMessage((Class)RenameAction.class, (String)"CTL_RenameTitle"));
        inputLine.setInputText(node.getName());
        if (NotifyDescriptor.OK_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)inputLine))) {
            String string = null;
            try {
                string = inputLine.getInputText();
                if (!string.equals("")) {
                    node.setName(inputLine.getInputText());
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                ErrorManager errorManager = ErrorManager.getDefault();
                ErrorManager.Annotation[] annotationArray = errorManager.findAnnotations((Throwable)illegalArgumentException);
                boolean bl = true;
                if (annotationArray != null && annotationArray.length > 0) {
                    for (int i = 0; i < annotationArray.length; ++i) {
                        String string2 = annotationArray[i].getLocalizedMessage();
                        if (string2 == null || string2.equals("")) continue;
                        bl = false;
                    }
                }
                if (bl) {
                    errorManager.annotate((Throwable)illegalArgumentException, NbBundle.getMessage((Class)RenameAction.class, (String)"MSG_BadFormat", (Object)node.getName(), (Object)string));
                }
                errorManager.notify((Throwable)illegalArgumentException);
            }
        }
    }

    protected boolean asynchronous() {
        return false;
    }
}

