/*
 * Decompiled with CFR 0.152.
 */
package org.openide.actions;

import java.awt.Component;
import java.awt.MenuShortcut;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventListener;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.openide.ErrorManager;
import org.openide.actions.ActionManager;
import org.openide.awt.Actions;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeMemberEvent;
import org.openide.nodes.NodeReorderEvent;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.SharedClassObject;
import org.openide.util.UserCancelException;
import org.openide.util.WeakListeners;
import org.openide.util.actions.CallbackSystemAction;
import org.openide.util.actions.Presenter;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.PasteType;
import org.openide.windows.TopComponent;

public final class PasteAction
extends CallbackSystemAction {
    private static ActSubMenuModel globalModel;
    private static PasteType[] types;
    static /* synthetic */ Class class$javax$swing$ActionMap;
    static /* synthetic */ Class class$org$openide$util$LookupListener;
    static /* synthetic */ Class class$javax$swing$event$ChangeListener;

    private static synchronized ActSubMenuModel model() {
        if (globalModel == null) {
            globalModel = new ActSubMenuModel(null);
        }
        return globalModel;
    }

    protected void initialize() {
        super.initialize();
        this.setEnabled(false);
    }

    public String getName() {
        return NbBundle.getMessage((Class)PasteAction.class, (String)"Paste");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(PasteAction.class);
    }

    protected String iconResource() {
        return "org/openide/resources/actions/paste.gif";
    }

    public JMenuItem getMenuPresenter() {
        return new Actions.SubMenu((SystemAction)this, (Actions.SubMenuModel)PasteAction.model(), false);
    }

    public JMenuItem getPopupPresenter() {
        return new Actions.SubMenu((SystemAction)this, (Actions.SubMenuModel)PasteAction.model(), true);
    }

    public Action createContextAwareInstance(Lookup lookup) {
        return new DelegateAction(this, lookup);
    }

    public Object getActionMapKey() {
        return "paste-from-clipboard";
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object;
        Object object2 = actionEvent.getSource() instanceof PasteType ? (PasteType)actionEvent.getSource() : ((object = this.getPasteTypes()) != null && ((PasteType[])object).length > 0 ? object[0] : null);
        if (object2 == null && (object = PasteAction.findActionFromActivatedTopComponentMap()) != null) {
            Object object3 = object.getValue("delegates");
            if (object3 instanceof PasteType[]) {
                PasteType[] pasteTypeArray = (PasteType[])object3;
                if (pasteTypeArray.length > 0) {
                    object2 = pasteTypeArray[0];
                }
            } else if (object3 instanceof Action[]) {
                Action[] actionArray = (Action[])object3;
                if (actionArray.length > 0) {
                    actionArray[0].actionPerformed(actionEvent);
                }
            } else {
                object.actionPerformed(actionEvent);
                return;
            }
        }
        if (object2 != null) {
            new ActionPT((PasteType)object2, actionEvent.getActionCommand());
        } else {
            ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("No paste types available when performing paste action"));
        }
    }

    protected boolean asynchronous() {
        return false;
    }

    public void setPasteTypes(PasteType[] pasteTypeArray) {
        types = pasteTypeArray;
        if (pasteTypeArray == null || pasteTypeArray.length == 0) {
            this.setEnabled(false);
        } else {
            this.setEnabled(true);
        }
        PasteAction.model().checkStateChanged(true);
    }

    public PasteType[] getPasteTypes() {
        return types;
    }

    private static Action findActionFromActivatedTopComponentMap() {
        TopComponent topComponent = TopComponent.getRegistry().getActivated();
        if (topComponent != null) {
            ActionMap actionMap = topComponent.getActionMap();
            return PasteAction.findActionFromMap(actionMap);
        }
        return null;
    }

    private static Action findActionFromMap(ActionMap actionMap) {
        if (actionMap != null) {
            return actionMap.get("paste-from-clipboard");
        }
        return null;
    }

    private static Clipboard getClipboard() {
        Clipboard clipboard = (Clipboard)Lookup.getDefault().lookup(Clipboard.class);
        if (clipboard == null) {
            clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        }
        return clipboard;
    }

    static ExplorerManager findExplorerManager() {
        Exception exception = null;
        try {
            Class<?> clazz = Class.forName("org.openide.windows.TopComponent");
            Method method = clazz.getMethod("getRegistry", new Class[0]);
            Object object = method.invoke(null, new Object[0]);
            clazz = Class.forName("org.openide.windows.TopComponent$Registry");
            method = clazz.getMethod("getActivated", new Class[0]);
            object = method.invoke(object, new Object[0]);
            if (object instanceof ExplorerManager.Provider) {
                return ((ExplorerManager.Provider)object).getExplorerManager();
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (ExceptionInInitializerError exceptionInInitializerError) {
        }
        catch (LinkageError linkageError) {
        }
        catch (SecurityException securityException) {
            exception = securityException;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            exception = noSuchMethodException;
        }
        catch (IllegalAccessException illegalAccessException) {
            exception = illegalAccessException;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exception = illegalArgumentException;
        }
        catch (InvocationTargetException invocationTargetException) {
            exception = invocationTargetException;
        }
        if (exception != null) {
            ErrorManager.getDefault().notify(1, (Throwable)exception);
        }
        return null;
    }

    private static class ActSubMenuModel
    extends EventListenerList
    implements Actions.SubMenuModel,
    LookupListener,
    PropertyChangeListener {
        private Lookup.Result result;
        private boolean enabled;
        private PropertyChangeListener actionWeakL;
        private PropertyChangeListener pasteTypeWeakL;
        private LookupListener weakLookup;

        public ActSubMenuModel(Lookup lookup) {
            this.attachListenerToChangesInMap(lookup);
        }

        private ActionMap map() {
            if (this.result == null) {
                TopComponent topComponent = TopComponent.getRegistry().getActivated();
                if (topComponent != null) {
                    return topComponent.getActionMap();
                }
            } else {
                Iterator iterator = this.result.allItems().iterator();
                while (iterator.hasNext()) {
                    Object object = ((Lookup.Item)iterator.next()).getInstance();
                    if (!(object instanceof ActionMap)) continue;
                    return (ActionMap)object;
                }
            }
            return null;
        }

        private void attachListenerToChangesInMap(Lookup lookup) {
            if (lookup == null) {
                TopComponent.getRegistry().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)TopComponent.getRegistry()));
            } else {
                this.result = lookup.lookup(new Lookup.Template(class$javax$swing$ActionMap == null ? (class$javax$swing$ActionMap = PasteAction.class$("javax.swing.ActionMap")) : class$javax$swing$ActionMap));
                this.weakLookup = (LookupListener)WeakListeners.create((Class)(class$org$openide$util$LookupListener == null ? (class$org$openide$util$LookupListener = PasteAction.class$("org.openide.util.LookupListener")) : class$org$openide$util$LookupListener), (EventListener)this, (Object)this.result);
                this.result.addLookupListener(this.weakLookup);
            }
            this.checkStateChanged(false);
        }

        private Object[] getPasteTypesOrActions(Action[] actionArray) {
            Object object;
            Action action = PasteAction.findActionFromMap(this.map());
            if (action == null) {
                Object[] objectArray;
                PasteAction pasteAction = (PasteAction)SharedClassObject.findObject((Class)(class$org$openide$actions$PasteAction == null ? (class$org$openide$actions$PasteAction = PasteAction.class$("org.openide.actions.PasteAction")) : class$org$openide$actions$PasteAction));
                if (actionArray != null) {
                    actionArray[0] = pasteAction;
                }
                if ((objectArray = pasteAction.getPasteTypes()) != null) {
                    return objectArray;
                }
                return new Object[0];
            }
            if (actionArray != null) {
                actionArray[0] = action;
            }
            if ((object = action.getValue("delegates")) instanceof Object[]) {
                return (Object[])object;
            }
            return new Object[]{action};
        }

        public boolean isEnabled() {
            Object[] objectArray = this.getPasteTypesOrActions(null);
            if (objectArray.length == 1 && objectArray[0] instanceof Action) {
                return ((Action)objectArray[0]).isEnabled();
            }
            return objectArray.length > 0;
        }

        public int getCount() {
            return this.getPasteTypesOrActions(null).length;
        }

        public String getLabel(int n) {
            Object[] objectArray = this.getPasteTypesOrActions(null);
            if (objectArray.length <= n) {
                return null;
            }
            if (objectArray[n] instanceof PasteType) {
                return ((PasteType)objectArray[n]).getName();
            }
            return (String)((Action)objectArray[n]).getValue("Name");
        }

        public HelpCtx getHelpCtx(int n) {
            Object[] objectArray = this.getPasteTypesOrActions(null);
            if (objectArray.length <= n) {
                return null;
            }
            if (objectArray[n] instanceof PasteType) {
                return ((PasteType)objectArray[n]).getHelpCtx();
            }
            Object object = ((Action)objectArray[n]).getValue("helpID");
            if (object instanceof String) {
                return new HelpCtx((String)object);
            }
            return null;
        }

        public MenuShortcut getMenuShortcut(int n) {
            return null;
        }

        public void performActionAt(int n) {
            this.performActionAt(n, null);
        }

        public void performActionAt(int n, ActionEvent actionEvent) {
            Action[] actionArray = new Action[1];
            Object[] objectArray = this.getPasteTypesOrActions(actionArray);
            if (objectArray.length <= n) {
                return;
            }
            if (objectArray[n] instanceof PasteType) {
                PasteType pasteType = (PasteType)objectArray[n];
                new ActionPT(pasteType, actionEvent == null ? null : actionEvent.getActionCommand());
                return;
            }
            Action action = (Action)objectArray[n];
            action.actionPerformed(new ActionEvent(action, 1001, "Name"));
        }

        public synchronized void addChangeListener(ChangeListener changeListener) {
            this.add(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = PasteAction.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, changeListener);
        }

        public synchronized void removeChangeListener(ChangeListener changeListener) {
            this.remove(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = PasteAction.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, changeListener);
        }

        protected void checkStateChanged(boolean bl) {
            boolean bl2;
            Action[] actionArray = new Action[1];
            Object[] objectArray = this.getPasteTypesOrActions(actionArray);
            Action action = null;
            if (objectArray.length == 1 && objectArray[0] instanceof Action) {
                action = (Action)objectArray[0];
                action.removePropertyChangeListener(this.pasteTypeWeakL);
                this.pasteTypeWeakL = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)action);
                action.addPropertyChangeListener(this.pasteTypeWeakL);
            }
            if (actionArray[0] != action) {
                actionArray[0].removePropertyChangeListener(this.actionWeakL);
                this.actionWeakL = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)actionArray[0]);
                actionArray[0].addPropertyChangeListener(this.actionWeakL);
            }
            if ((bl2 = this.isEnabled()) == this.enabled) {
                return;
            }
            this.enabled = bl2;
            if (!bl) {
                return;
            }
            Object[] objectArray2 = this.getListenerList();
            if (objectArray2.length == 0) {
                return;
            }
            ChangeEvent changeEvent = new ChangeEvent(this);
            for (int i = objectArray2.length - 1; i >= 0; i -= 2) {
                ((ChangeListener)objectArray2[i]).stateChanged(changeEvent);
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.checkStateChanged(true);
        }

        public void resultChanged(LookupEvent lookupEvent) {
            this.checkStateChanged(true);
        }
    }

    private static final class ActionPT
    extends AbstractAction
    implements Runnable {
        private PasteType t;
        private NodeSelector sel;
        private boolean secondInvocation;

        public ActionPT(PasteType pasteType, String string) {
            this.t = pasteType;
            ExplorerManager explorerManager = PasteAction.findExplorerManager();
            if (explorerManager != null) {
                this.sel = new NodeSelector(explorerManager, null);
            }
            if ("waitFinished".equals(string)) {
                this.run();
            } else {
                RequestProcessor.getDefault().post((Runnable)this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                Transferable transferable = this.t.paste();
                Clipboard clipboard = PasteAction.getClipboard();
                if (transferable != null) {
                    ClipboardOwner clipboardOwner = transferable instanceof ClipboardOwner ? (ClipboardOwner)((Object)transferable) : new StringSelection("");
                    clipboard.setContents(transferable, clipboardOwner);
                }
            }
            catch (UserCancelException userCancelException) {
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
            finally {
                SwingUtilities.invokeLater(this);
            }
        }

        public void run() {
            if (this.secondInvocation) {
                if (this.sel != null) {
                    this.sel.select();
                }
            } else {
                this.secondInvocation = true;
                ActionManager.getDefault().invokeAction(this, new ActionEvent(this.t, 1001, "Name"));
            }
        }

        public boolean isEnabled() {
            return ((PasteAction)PasteAction.get((Class)(class$org$openide$actions$PasteAction == null ? (class$org$openide$actions$PasteAction = PasteAction.class$("org.openide.actions.PasteAction")) : class$org$openide$actions$PasteAction))).isEnabled();
        }

        public Object getValue(String string) {
            return ((PasteAction)PasteAction.get((Class)(class$org$openide$actions$PasteAction == null ? (class$org$openide$actions$PasteAction = PasteAction.class$("org.openide.actions.PasteAction")) : class$org$openide$actions$PasteAction))).getValue(string);
        }
    }

    private static final class DelegateAction
    extends AbstractAction
    implements Presenter.Menu,
    Presenter.Popup,
    Presenter.Toolbar,
    ChangeListener {
        private PasteAction delegate;
        private ActSubMenuModel model;

        public DelegateAction(PasteAction pasteAction, Lookup lookup) {
            this.delegate = pasteAction;
            this.model = new ActSubMenuModel(lookup);
            this.model.addChangeListener(this);
        }

        public String toString() {
            return super.toString() + "[delegate=" + (Object)((Object)this.delegate) + "]";
        }

        public void putValue(String string, Object object) {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.model != null) {
                this.model.performActionAt(0, actionEvent);
            }
        }

        public boolean isEnabled() {
            return this.model != null && this.model.isEnabled();
        }

        public Object getValue(String string) {
            return this.delegate.getValue(string);
        }

        public void setEnabled(boolean bl) {
        }

        public JMenuItem getMenuPresenter() {
            return new Actions.SubMenu((Action)this, (Actions.SubMenuModel)this.model, false);
        }

        public JMenuItem getPopupPresenter() {
            return new Actions.SubMenu((Action)this, (Actions.SubMenuModel)this.model, true);
        }

        public Component getToolbarPresenter() {
            return new Actions.ToolbarButton((Action)this);
        }

        public void stateChanged(ChangeEvent changeEvent) {
            super.firePropertyChange("enabled", null, null);
        }
    }

    static final class NodeSelector
    implements NodeListener,
    Runnable {
        private List added;
        private Node node;
        private ExplorerManager em;
        private Node[] children;

        public NodeSelector(ExplorerManager explorerManager, Node[] nodeArray) {
            this.em = explorerManager;
            if (nodeArray != null && nodeArray.length > 0) {
                this.node = nodeArray[0];
            } else {
                Node[] nodeArray2 = explorerManager.getSelectedNodes();
                if (nodeArray2.length != 0) {
                    this.node = nodeArray2[0];
                } else {
                    return;
                }
            }
            this.children = this.node.getChildren().getNodes(true);
            this.added = new ArrayList();
            this.node.addNodeListener((NodeListener)this);
        }

        public void select() {
            if (this.added != null) {
                this.node.getChildren().getNodes(true);
                Children.MUTEX.readAccess((Runnable)this);
            }
        }

        public void run() {
            this.node.removeNodeListener((NodeListener)this);
            if (this.added.isEmpty()) {
                return;
            }
            Node[] nodeArray = this.added.toArray(new Node[this.added.size()]);
            block3: for (int i = 0; i < nodeArray.length; ++i) {
                for (Node node = nodeArray[i]; node != null; node = node.getParentNode()) {
                    if (node.equals((Object)this.em.getRootContext())) continue block3;
                }
                return;
            }
            try {
                this.em.setSelectedNodes(nodeArray);
            }
            catch (PropertyVetoException propertyVetoException) {
                ErrorManager.getDefault().notify(1, (Throwable)propertyVetoException);
            }
            catch (IllegalStateException illegalStateException) {
                ErrorManager.getDefault().notify(1, (Throwable)illegalStateException);
            }
        }

        public void childrenAdded(NodeMemberEvent nodeMemberEvent) {
            this.added.addAll(Arrays.asList(nodeMemberEvent.getDelta()));
        }

        public void childrenRemoved(NodeMemberEvent nodeMemberEvent) {
        }

        public void childrenReordered(NodeReorderEvent nodeReorderEvent) {
        }

        public void nodeDestroyed(NodeEvent nodeEvent) {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        }
    }
}

