/*
 * Decompiled with CFR 0.152.
 */
package tr.model.thought;

import java.util.Calendar;
import java.util.Date;
import tr.model.action.Action;
import tr.model.topic.Topic;
import tr.model.topic.TopicChangeCookie;
import tr.util.Observable;
import tr.util.ObservableImpl;
import tr.util.Utils;

public class Thought
extends ObservableImpl
implements TopicChangeCookie {
    private Date created = Calendar.getInstance().getTime();
    private String description = "";
    private Topic topic = Topic.getDefault();
    private boolean processed = false;
    private Action action;
    private String notes;
    public transient String key;

    public Date getCreated() {
        return this.created;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        if (Utils.equal((Object)this.description, (Object)description)) {
            return;
        }
        this.description = description;
        this.notifyObservers((Observable)this, (Object)Change.DESCRIPTION);
    }

    public Topic getTopic() {
        if (this.topic == null) {
            return Topic.getDefault();
        }
        if (this.topic.getName().equals(Topic.getDefault().getName())) {
            return Topic.getDefault();
        }
        return this.topic;
    }

    public void setTopic(Topic topic) {
        if (Utils.equal((Object)this.topic, (Object)topic)) {
            return;
        }
        this.topic = topic;
        this.notifyObservers((Observable)this, (Object)Change.TOPIC);
    }

    public String getNotes() {
        return this.notes == null ? "" : this.notes;
    }

    public void setNotes(String notes) {
        if (notes != null && notes.trim().length() == 0) {
            notes = null;
        }
        if (Utils.equal((Object)this.notes, (Object)notes)) {
            return;
        }
        this.notes = notes;
        this.notifyObservers((Observable)this, (Object)Change.NOTES);
    }

    public boolean isProcessed() {
        return this.processed;
    }

    public void setProcessed(boolean processed) {
        if (this.processed == processed) {
            return;
        }
        this.processed = processed;
        this.notifyObservers((Observable)this, (Object)Change.PROCESSED);
    }

    public void setAction(Action action) {
        if (this.action == action) {
            return;
        }
        this.action = action;
        this.notifyObservers((Observable)this);
    }

    public Action getAction() {
        return this.action;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Thought)) {
            return false;
        }
        Thought thought = (Thought)object;
        if (!Utils.equal((Object)this.created, (Object)thought.created)) {
            return false;
        }
        if (!Utils.equal((Object)this.description, (Object)thought.description)) {
            return false;
        }
        if (!Utils.equal((Object)this.topic, (Object)thought.topic)) {
            return false;
        }
        return this.processed == thought.processed;
    }

    public String toString() {
        return this.description;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Change {
        DESCRIPTION,
        TOPIC,
        NOTES,
        PROCESSED;

    }
}

