/*
 * Decompiled with CFR 0.152.
 */
package tr.model.project;

import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.Icon;
import tr.model.IDGenerator;
import tr.model.Item.Doable;
import tr.model.Item.Item;
import tr.model.Item.ItemList;
import tr.model.Item.ItemSelector;
import tr.model.Resources;
import tr.model.action.Action;
import tr.model.action.ActionStateASAP;
import tr.model.criteria.Value;
import tr.model.project.Sequencing;
import tr.model.thought.Thought;
import tr.model.topic.Topic;
import tr.model.topic.TopicChangeCookie;
import tr.prefs.projects.ProjectsPrefs;
import tr.util.DateUtils;
import tr.util.Observable;
import tr.util.ObservableImpl;
import tr.util.Observer;
import tr.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Project
extends ObservableImpl
implements TopicChangeCookie,
Doable,
ItemList,
Observer {
    private static final Logger LOG = Logger.getLogger("tr.model.project");
    protected Integer id;
    protected Date created;
    protected Thought thought;
    protected Project parent;
    protected Vector<Item> children;
    protected Topic topic;
    protected String description;
    protected String purpose;
    protected String success;
    protected String brainstorming;
    protected String organising;
    protected boolean done;
    protected Date doneDate;
    protected boolean sequence;
    protected Sequencing sequencing;
    protected Date dueDate;
    protected String notes;
    protected Value priority;
    protected Date startDate;
    private Date modified;
    private static ActiveSelector activeSelector = new ActiveSelector();
    private static NotDoneSelector notDoneSelector = new NotDoneSelector();
    private static SequencingActiveChildSelector sequencingActiveChildSelector = new SequencingActiveChildSelector();

    public Project(IDGenerator idGenerator) {
        this.id = idGenerator.getNextID();
        this.setCreated();
        this.setModified();
        this.thought = null;
        this.parent = null;
        this.children = new Vector();
        this.setTopic(Topic.getDefault());
        this.setDescription("");
        this.setPurpose("");
        this.setVision("");
        this.setBrainstorming("");
        this.setOrganising("");
        this.setSequencing(ProjectsPrefs.isSequencing());
        this.setDone(false);
        this.doneDate = null;
    }

    private void setCreated() {
        this.created = Calendar.getInstance().getTime();
    }

    private void setModified() {
        this.modified = Calendar.getInstance().getTime();
    }

    public Thought getThought() {
        return this.thought;
    }

    public void setThought(Thought thought) {
        if (Utils.equal((Object)this.thought, (Object)thought)) {
            return;
        }
        this.thought = thought;
        this.setModified();
        this.notifyObservers(this);
    }

    @Override
    public boolean isDone() {
        return this.done;
    }

    @Override
    public boolean isEditable() {
        return true;
    }

    public boolean isRoot() {
        return false;
    }

    public boolean hasActiveDecendant() {
        return this.contains(activeSelector, true);
    }

    public boolean hasNotDoneDecendant() {
        return this.contains(notDoneSelector, true);
    }

    @Override
    public void setDone(boolean done) {
        if (this.done == done) {
            return;
        }
        this.done = done;
        if (done) {
            if (this.doneDate == null) {
                this.doneDate = Calendar.getInstance().getTime();
            }
        } else {
            this.doneDate = null;
            if (this.parent != null) {
                this.parent.setDone(false);
            }
        }
        this.setModified();
        this.notifyObservers(this);
    }

    public void setSequencing(boolean b) {
        if (this.sequence == b) {
            return;
        }
        this.sequence = b;
        this.setModified();
        this.notifyObservers(this);
    }

    public boolean isSequencing() {
        return this.sequence;
    }

    public Sequencing getSequenceType() {
        if (this.sequencing == null) {
            this.sequencing = Sequencing.INTO_SUBPROJECTS;
        }
        return this.sequencing;
    }

    public void setSequenceType(Sequencing type) {
        if (this.sequencing == type) {
            return;
        }
        this.sequencing = type;
        this.setModified();
        this.notifyObservers(this);
    }

    public boolean isSequenceIntoSubProjects() {
        return this.isSequencing() && this.sequencing == Sequencing.INTO_SUBPROJECTS;
    }

    public boolean sequence() {
        if (!ProjectsPrefs.isSequencing()) {
            LOG.fine("Automatic sequencing is turned off in the user preferences");
            return false;
        }
        if (this.sequenceNextAction()) {
            return true;
        }
        if (this.parent.isRoot()) {
            return false;
        }
        return this.parent.sequence();
    }

    private boolean sequenceNextAction() {
        if (!this.isSequencing()) {
            LOG.fine("Automatic sequencing is turned off for this project.");
            return false;
        }
        if (this.contains(sequencingActiveChildSelector, false)) {
            LOG.fine("An active action already exists.");
            return false;
        }
        for (Item child : this.getChildren()) {
            Project subProject;
            LOG.fine("Processing child");
            if (child instanceof Action) {
                Action action = (Action)child;
                if (action.isDone() || !action.isStateInactive()) continue;
                LOG.fine("Setting state to Do ASAP.");
                action.setState(new ActionStateASAP());
                return true;
            }
            if (!this.isSequenceIntoSubProjects() || !(child instanceof Project) || (subProject = (Project)child).isDone() || !subProject.sequenceNextAction()) continue;
            return true;
        }
        return false;
    }

    public void setDoneDate(Date date) {
        this.doneDate = date;
        this.setDone(this.doneDate != null);
        this.setModified();
        this.notifyObservers(this);
    }

    public Date getDoneDate() {
        return this.doneDate;
    }

    public void setDueDate(Date date) {
        this.dueDate = date;
        this.setModified();
        this.notifyObservers(this);
    }

    public Date getDueDate() {
        return this.dueDate;
    }

    public String getPurpose() {
        return this.purpose;
    }

    public void setPurpose(String purpose) {
        if (Utils.equal((Object)this.purpose, (Object)purpose)) {
            return;
        }
        this.purpose = purpose;
        this.setModified();
        this.notifyObservers(this);
    }

    public String getVision() {
        return this.success;
    }

    public void setVision(String success) {
        if (Utils.equal((Object)this.success, (Object)success)) {
            return;
        }
        this.success = success;
        this.setModified();
        this.notifyObservers(this);
    }

    public String getBrainstorming() {
        return this.brainstorming;
    }

    public void setBrainstorming(String text) {
        if (Utils.equal((Object)this.brainstorming, (Object)text)) {
            return;
        }
        this.brainstorming = text;
        this.setModified();
        this.notifyObservers(this);
    }

    public String getNotes() {
        return this.notes == null ? "" : this.notes;
    }

    public void setNotes(String notes) {
        if (Utils.equal((Object)this.notes, (Object)notes)) {
            return;
        }
        this.notes = notes;
        this.setModified();
        this.notifyObservers(this);
    }

    public String getOrganising() {
        return this.organising;
    }

    public void setOrganising(String text) {
        if (Utils.equal((Object)this.organising, (Object)text)) {
            return;
        }
        this.organising = text;
        this.setModified();
        this.notifyObservers(this);
    }

    public Topic getTopic() {
        if (this.topic == null) {
            return Topic.getDefault();
        }
        if (this.topic.getName().equals(Topic.getDefault().getName())) {
            return Topic.getDefault();
        }
        return this.topic;
    }

    @Override
    public void setTopic(Topic topic) {
        if (Utils.equal((Object)this.topic, (Object)topic)) {
            return;
        }
        if (this.topic != null) {
            this.topic.removeObserver(this);
        }
        this.topic = topic;
        if (this.topic != null) {
            this.topic.addObserver(this);
        }
        this.setModified();
        this.notifyObservers(this);
    }

    public void resetObservers() {
        if (this.topic != null) {
            this.topic.addObserver(this);
        }
        for (Item item : this.getChildren()) {
            item.addObserver(this);
            item.resetObservers();
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof Project)) {
            return false;
        }
        Project project = (Project)object;
        if (!Utils.equal((Object)this.created, (Object)project.created)) {
            return false;
        }
        if (!Utils.equal((Object)this.thought, (Object)project.thought)) {
            return false;
        }
        if (!Utils.equal((Object)this.topic, (Object)project.topic)) {
            return false;
        }
        if (!Utils.equal((Object)this.description, (Object)project.description)) {
            return false;
        }
        if (!Utils.equal((Object)this.purpose, (Object)project.purpose)) {
            return false;
        }
        if (!Utils.equal((Object)this.success, (Object)project.success)) {
            return false;
        }
        if (!Utils.equal((Object)this.brainstorming, (Object)project.brainstorming)) {
            return false;
        }
        if (!Utils.equal((Object)this.organising, (Object)project.organising)) {
            return false;
        }
        if (!Utils.equal((Object)this.priority, (Object)project.priority)) {
            return false;
        }
        if (!Utils.equal((Object)this.startDate, (Object)project.startDate)) {
            return false;
        }
        if (!Utils.equal((Object)this.dueDate, (Object)project.dueDate)) {
            return false;
        }
        if (this.done != project.done) {
            return false;
        }
        if (!Utils.equal((Object)this.doneDate, (Object)project.doneDate)) {
            return false;
        }
        return Utils.equal(this.getChildren(), project.getChildren());
    }

    public String toString() {
        return this.getDescription();
    }

    public void update(Observable observable, Object arg) {
        this.notifyObservers(observable, arg);
    }

    @Override
    public boolean canSetDone(boolean value) {
        if (!value) {
            return true;
        }
        return !this.hasNotDoneDecendant();
    }

    @Override
    public int getID() {
        return this.id;
    }

    @Override
    public Date getCreated() {
        return this.created;
    }

    @Override
    public String getDescription() {
        return this.filter(this.description);
    }

    @Override
    public void setDescription(String description) {
        if (description == null) {
            return;
        }
        String newdesc = this.filter(description);
        if (Utils.equal((Object)this.description, (Object)newdesc)) {
            return;
        }
        this.description = newdesc;
        this.setModified();
        this.notifyObservers(this);
    }

    private String filter(String str) {
        str = str.replaceAll("\t", " ");
        str = str.replaceAll("\n", " ");
        str = str.replaceAll("\f", "");
        str = str.replaceAll("\r", "");
        return str;
    }

    @Override
    public Icon getIcon(boolean opened) {
        if (this.isDone() || this.hasActiveDecendant()) {
            return opened ? Resources.ICON_PROJECT_OPENED : Resources.ICON_PROJECT;
        }
        return opened ? Resources.ICON_PROJECT_RED_OPENED : Resources.ICON_PROJECT_RED;
    }

    @Override
    public ItemList getParent() {
        return this.parent;
    }

    @Override
    public void setParent(ItemList parent) {
        if (Utils.equal((Object)this.parent, (Object)parent)) {
            return;
        }
        if (parent instanceof Project) {
            this.parent = (Project)parent;
            this.setModified();
            this.notifyObservers(this);
        }
    }

    public Value getPriority() {
        return this.priority;
    }

    public void setPriority(Value priority) {
        if (Utils.equal((Object)this.priority, (Object)priority)) {
            return;
        }
        if (this.priority != null) {
            this.priority.removeObserver(this);
        }
        this.priority = priority;
        if (this.priority != null) {
            this.priority.addObserver(this);
        }
        this.setModified();
        this.notifyObservers(this);
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date date) {
        if (date != null) {
            date = DateUtils.clearTime((Date)date);
        }
        if (!Utils.equal((Object)this.startDate, (Object)date)) {
            this.startDate = date;
            this.setModified();
            this.notifyObservers(this);
        }
    }

    @Override
    public Item copy(IDGenerator idGenerator) {
        Project copy = new Project(idGenerator);
        copy.setCreated();
        copy.thought = this.thought;
        copy.parent = this.parent;
        copy.description = this.description;
        copy.topic = this.topic;
        copy.purpose = this.purpose;
        copy.success = this.success;
        copy.brainstorming = this.brainstorming;
        copy.organising = this.organising;
        copy.sequence = this.sequence;
        copy.sequencing = this.sequencing;
        copy.priority = this.priority;
        copy.startDate = this.startDate;
        copy.dueDate = this.dueDate;
        copy.done = this.done;
        copy.doneDate = this.doneDate;
        for (Item item : this.getChildren()) {
            copy.add(item.copy(idGenerator));
        }
        return copy;
    }

    @Override
    public void removeFromParent() {
        if (this.parent != null) {
            this.parent.remove(this);
        }
    }

    @Override
    public boolean isWithin(ItemList list) {
        if (list == null || this.parent == null) {
            return false;
        }
        if (list == this.parent) {
            return true;
        }
        return this.parent.isWithin(list);
    }

    @Override
    public boolean canAdd(Item item) {
        if (item.getClass() == Action.class) {
            Action action = (Action)item;
            return !this.contains(action);
        }
        if (item.getClass() == Project.class) {
            Project project = (Project)item;
            if (this.contains(project)) {
                return false;
            }
            if (this.equals(project)) {
                return false;
            }
            return !this.isWithin(project);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void reorder(Item[] srcItems, Item[] dstItems) {
        if (srcItems.length != dstItems.length) {
            return;
        }
        Project project = this;
        synchronized (project) {
            Vector<Item> reorderedChildren = new Vector<Item>(this.children);
            for (int i = 0; i < srcItems.length; ++i) {
                if (!this.contains(srcItems[i]) || !this.contains(dstItems[i])) continue;
                int dstIndex = this.children.indexOf(dstItems[i]);
                reorderedChildren.set(dstIndex, srcItems[i]);
            }
            this.children = reorderedChildren;
        }
        this.setModified();
        this.notifyObservers(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(Item item) {
        if (!this.canAdd(item)) {
            return false;
        }
        Project project = this;
        synchronized (project) {
            if (!this.children.add(item)) {
                return false;
            }
        }
        item.setParent(this);
        item.addObserver(this);
        this.setModified();
        this.notifyObservers(this, item);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(int index, Item item) {
        if (!this.canAdd(item)) {
            return;
        }
        Project project = this;
        synchronized (project) {
            this.children.add(index, item);
        }
        item.setParent(this);
        item.addObserver(this);
        this.notifyObservers(this, item);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Item remove(int index) {
        Project project = this;
        synchronized (project) {
            if (index < 0 || index >= this.children.size()) {
                return null;
            }
            Item removed = this.children.remove(index);
            if (removed != null) {
                removed.removeObserver(this);
                this.setModified();
                this.notifyObservers(this, removed);
            }
            return removed;
        }
    }

    @Override
    public boolean remove(Item item) {
        int index = this.indexOf(item);
        if (index == -1) {
            return false;
        }
        return this.remove(index) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Item item) {
        Project project = this;
        synchronized (project) {
            return this.children.contains(item);
        }
    }

    @Override
    public boolean contains(Item item, boolean recurse) {
        if (this.contains(item)) {
            return true;
        }
        if (recurse) {
            for (Item child : this.getChildren()) {
                if (!(child instanceof ItemList) || !((ItemList)child).contains(item, true)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean contains(ItemSelector selector, boolean recurse) {
        for (Item child : this.getChildren()) {
            if (selector.isSelected(child)) {
                return true;
            }
            if (!recurse || !(child instanceof ItemList) || !((ItemList)child).contains(selector, true)) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized <T extends Item> Iterator<T> iterator(Class<T> clazz) {
        Vector<T> result = new Vector<T>();
        for (Item item : this.getChildren()) {
            if (!clazz.isAssignableFrom(item.getClass())) continue;
            result.add(clazz.cast(item));
        }
        return result.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List<Item> getChildren() {
        Project project = this;
        synchronized (project) {
            return new Vector<Item>(this.children);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        Project project = this;
        synchronized (project) {
            return this.children.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int indexOf(Item item) {
        Project project = this;
        synchronized (project) {
            return this.children.indexOf(item);
        }
    }

    private static class SequencingActiveChildSelector
    implements ItemSelector {
        private SequencingActiveChildSelector() {
        }

        public boolean isSelected(Item item) {
            if (item instanceof Action) {
                return ((Action)item).isActive();
            }
            if (item instanceof Project) {
                Project p = (Project)item;
                if (p.parent.isSequencing() && p.parent.isSequenceIntoSubProjects()) {
                    for (Item subItem : p.getChildren()) {
                        if (!this.isSelected(subItem)) continue;
                        return true;
                    }
                }
            }
            return false;
        }
    }

    private static class NotDoneSelector
    implements ItemSelector {
        private NotDoneSelector() {
        }

        public boolean isSelected(Item item) {
            return item instanceof Doable && !((Doable)((Object)item)).isDone();
        }
    }

    private static class ActiveSelector
    implements ItemSelector {
        private ActiveSelector() {
        }

        public boolean isSelected(Item item) {
            return item instanceof Action && ((Action)item).isActive();
        }
    }
}

