/*
 * Decompiled with CFR 0.152.
 */
package tr.model;

import java.io.File;
import java.util.Iterator;
import tr.model.Data;
import tr.model.ICal4JWrapper;
import tr.model.Item.Item;
import tr.model.action.Action;
import tr.model.action.ActionState;
import tr.model.action.ActionStateASAP;
import tr.model.action.ActionStateDelegated;
import tr.model.action.ActionStateScheduled;
import tr.model.project.Project;
import tr.model.thought.Thought;
import tr.util.ObservableImpl;

public class ICalendar {
    private static final String UID_SUFFIX = "@thinkingrock.com.au";
    private static ICal4JWrapper ical;
    private static File outfile;

    public static void process(Data data, String path) {
        ical = new ICal4JWrapper();
        try {
            System.out.print("Generating ICalendar file ... ");
            ICalendar.initialise(path);
            ICalendar.process(data);
            ICalendar.finalise();
            System.out.println("done");
        }
        catch (Exception ex) {
            System.out.println();
            ex.printStackTrace(System.err);
        }
    }

    private static void initialise(String filename) throws Exception {
        outfile = new File(filename);
    }

    private static void finalise() throws Exception {
        ical.write(outfile);
    }

    private static void process(Data data) {
        Iterator<ObservableImpl> i = data.getRootProjects().iterator(Project.class);
        while (i.hasNext()) {
            ICalendar.process(data, i.next());
        }
        i = data.getRootActions().iterator(Action.class);
        while (i.hasNext()) {
            ICalendar.process(data, (Action)i.next());
        }
    }

    private static void process(Data data, Project project) {
        Iterator<Item> i = project.iterator(Item.class);
        while (i.hasNext()) {
            Item child = i.next();
            if (child instanceof Action) {
                ICalendar.process(data, (Action)child);
                continue;
            }
            if (!(child instanceof Project)) continue;
            ICalendar.process(data, (Project)child);
        }
    }

    private static void process(Data data, Action action) {
        if (action.isDone()) {
            return;
        }
        String context = action.getContext().getName();
        StringBuffer notes = new StringBuffer();
        notes.append(context);
        if (action.isSingleAction()) {
            Thought thought = action.getThought();
            if (thought != null) {
                notes.append(" {" + thought.getDescription() + "}");
            }
        } else {
            Project project = (Project)action.getParent();
            if (project != null) {
                notes.append(" [" + project.getDescription() + "]");
            }
        }
        notes.append("\r\n");
        notes.append(action.getNotes());
        ActionState state = action.getState();
        if (state instanceof ActionStateASAP) {
            ical.createToDo(ICalendar.getUID(action.getID()), action.getDescription(), notes.toString(), context);
        } else if (state instanceof ActionStateDelegated) {
            ActionStateDelegated asd = (ActionStateDelegated)state;
            if (asd.getDate() == null) {
                return;
            }
            String desc = action.getDescription() + " " + " Delegated to: " + asd.getTo();
            ical.createAllDayEvent(ICalendar.getUID(action.getID()), asd.getDate(), desc, notes.toString(), context);
        } else if (state instanceof ActionStateScheduled) {
            ActionStateScheduled ass = (ActionStateScheduled)state;
            if (ass.getDate() == null) {
                return;
            }
            ical.createSpecificTimeEvent(ICalendar.getUID(action.getID()), ass.getDate(), action.getDescription(), notes.toString(), context, ass.getDurationHours(), ass.getDurationMinutes());
        }
    }

    private static String getUID(int id) {
        return id + UID_SUFFIX;
    }
}

