/*
 * Decompiled with CFR 0.152.
 */
package tr.view.action;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdesktop.layout.GroupLayout;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;
import tr.global.Constants;
import tr.model.Data;
import tr.model.DataLookup;
import tr.model.action.Recurrence;
import tr.model.context.Context;
import tr.model.criteria.Criterion;
import tr.model.criteria.Value;
import tr.model.topic.Topic;
import tr.prefs.recurrence.RecurrencePrefs;
import tr.swing.time.HourSpinner;
import tr.swing.time.MinuteSpinner;
import tr.util.DateButton;
import tr.util.DateUtils;
import tr.util.Utils;
import tr.view.action.Resources;
import tr.view.context.ContextsComboBox;
import tr.view.context.ContextsComboBoxModel;
import tr.view.criteria.CriterionComboBoxModel;
import tr.view.topic.TopicComboBox;
import tr.view.topic.TopicComboBoxModel;
import tr.view.topic.TopicListCellRenderer;

public class RecurrenceDialog
extends JDialog {
    private ComboBoxModel periodComboBoxModel;
    private JPanel actionPanel;
    private JLabel advanceLabel1;
    private JLabel advanceLabel2;
    private JSpinner advanceSpinner;
    private ButtonGroup basisButtonGroup;
    private JRadioButton basisDoneRadioButton;
    private JRadioButton basisStartRadioButton;
    private JPanel buttonsPanel;
    private JButton cancelButton;
    private JLabel contextLabel;
    private JComboBox contextsCombo;
    private JButton deleteButton;
    private JLabel descriptionLabel;
    private JTextField descriptionText;
    private HourSpinner durationHourSpinner;
    private JLabel durationLabel;
    private MinuteSpinner durationMinSpinner;
    private JComboBox energyCombo;
    private JLabel energyLabel;
    private JLabel fillerLabel;
    private JLabel frequencyLabel;
    private JSpinner frequencyNbrSpinner;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JButton okButton;
    private JComboBox periodCombo;
    private JComboBox priorityCombo;
    private JLabel priorityLabel;
    private JPanel recurrencePanel;
    private HourSpinner scheduleHourSpinner;
    private MinuteSpinner scheduleMinSpinner;
    private JLabel scheduleTimeLabel;
    private DateButton startDateButton;
    private DateButton terminateDateButton;
    private JRadioButton terminateDateRadioButton;
    private JLabel terminateLabel;
    private JRadioButton terminateNeverRadioButton;
    private JLabel terminateNumberLabel;
    private JRadioButton terminateNumberRadioButton;
    private JSpinner terminateNumberSpinner;
    private ButtonGroup terminatebuttonGroup;
    private JComboBox timeCombo;
    private JLabel timeLabel;
    private JComboBox topicCombo;
    private JLabel topicLabel;
    private JLabel triggerLabel;
    private static final Logger LOG = Logger.getLogger("tr.recurrence");
    private final Data data = (Data)DataLookup.instance().lookup(Data.class);
    private final Date defaultStartDate;
    private Recurrence.Basis basis;
    private int frequency;
    private Recurrence.Period period;
    private int advance;
    private Integer endNbr;
    private Date endDate;
    public boolean scheduleChange;
    private ComboBoxModel topicsModel;
    private ComboBoxModel contextsModel;
    public boolean cancel = true;
    public boolean delete = false;

    public RecurrenceDialog(Component component, Date defaultStartDate, String description, Topic topic, Context context, Value time, Value energy, Value priority, int scheduleHours, int scheduleMins, int durationHours, int durationMins, Recurrence.Basis basis, Date startDate, Recurrence.Period period, int frequency, int advanceNbr, Integer endNbr, Date endDate) {
        super(WindowManager.getDefault().getMainWindow(), true);
        this.defaultStartDate = defaultStartDate;
        this.basis = basis;
        this.frequency = frequency;
        this.period = period;
        this.advance = advanceNbr;
        this.endNbr = endNbr;
        this.endDate = endDate;
        this.setDefaultCloseOperation(2);
        this.initComponents();
        this.descriptionText.setText(description);
        this.topicCombo.setSelectedItem(topic);
        this.contextsCombo.setSelectedItem(context);
        this.timeCombo.setSelectedItem(time);
        this.energyCombo.setSelectedItem(energy);
        this.priorityCombo.setSelectedItem(priority);
        this.durationHourSpinner.setVal(durationHours);
        this.durationMinSpinner.setVal(durationMins);
        this.scheduleHourSpinner.setVal(scheduleHours);
        this.scheduleMinSpinner.setVal(scheduleMins);
        this.basisStartRadioButton.setSelected(basis == Recurrence.Basis.START_DATE);
        this.basisDoneRadioButton.setSelected(basis == Recurrence.Basis.DONE_DATE);
        this.startDateButton.setDate(startDate);
        this.periodCombo.setSelectedItem(period);
        this.frequencyNbrSpinner.setValue(new Integer(frequency));
        this.advanceSpinner.setValue(this.advance);
        if (this.advance == 0) {
            this.periodActionPerformed(null);
        }
        if (endNbr != null) {
            this.terminateNumberRadioButton.setSelected(true);
            this.terminateNumberSpinner.setValue(endNbr);
            this.terminateDateButton.setDate(null);
        } else if (endDate != null) {
            this.terminateDateRadioButton.setSelected(true);
            this.terminateDateButton.setDate(endDate);
            this.terminateNumberSpinner.setValue(0);
        } else {
            this.terminateNeverRadioButton.setSelected(true);
            this.terminateNumberSpinner.setValue(0);
            this.terminateDateButton.setDate(null);
        }
        this.showHideCriteria();
        this.enableDisableBasisComponents();
        this.enableDisableTerminateComponents();
        this.setLocationRelativeTo(component);
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.cancel = true;
            this.delete = false;
            super.setVisible(true);
        } else {
            super.setVisible(false);
            super.dispose();
        }
    }

    private void initComponents() {
        this.basisButtonGroup = new ButtonGroup();
        this.terminatebuttonGroup = new ButtonGroup();
        this.jPanel1 = new JPanel();
        this.buttonsPanel = new JPanel();
        this.deleteButton = new JButton();
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.fillerLabel = new JLabel();
        this.actionPanel = new JPanel();
        this.descriptionLabel = new JLabel();
        this.descriptionText = new JTextField();
        this.contextLabel = new JLabel();
        this.contextsModel = new ContextsComboBoxModel(false);
        this.contextsCombo = new ContextsComboBox(this.contextsModel);
        this.topicLabel = new JLabel();
        this.topicsModel = new TopicComboBoxModel(false);
        this.topicCombo = new TopicComboBox(this.topicsModel);
        this.scheduleTimeLabel = new JLabel();
        this.scheduleHourSpinner = new HourSpinner();
        this.scheduleMinSpinner = new MinuteSpinner();
        this.durationLabel = new JLabel();
        this.durationHourSpinner = new HourSpinner();
        this.durationMinSpinner = new MinuteSpinner();
        this.jPanel2 = new JPanel();
        this.timeLabel = new JLabel();
        this.timeCombo = new JComboBox();
        this.energyLabel = new JLabel();
        this.energyCombo = new JComboBox();
        this.priorityLabel = new JLabel();
        this.priorityCombo = new JComboBox();
        this.recurrencePanel = new JPanel();
        this.periodCombo = new JComboBox();
        this.frequencyLabel = new JLabel();
        this.frequencyNbrSpinner = new JSpinner();
        this.basisStartRadioButton = new JRadioButton();
        this.basisDoneRadioButton = new JRadioButton();
        this.triggerLabel = new JLabel();
        this.terminateLabel = new JLabel();
        this.terminateNeverRadioButton = new JRadioButton();
        this.terminateNumberRadioButton = new JRadioButton();
        this.terminateNumberSpinner = new JSpinner();
        this.terminateDateRadioButton = new JRadioButton();
        this.terminateDateButton = new DateButton((Dialog)this);
        this.terminateNumberLabel = new JLabel();
        this.startDateButton = new DateButton((Dialog)this);
        this.advanceLabel1 = new JLabel();
        this.advanceSpinner = new JSpinner();
        this.advanceLabel2 = new JLabel();
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add(0, 100, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add(0, 100, Short.MAX_VALUE));
        this.setDefaultCloseOperation(2);
        this.setTitle(Resources.getText("RecurrenceDialog.title"));
        this.buttonsPanel.setLayout(new FlowLayout(2));
        this.buttonsPanel.setPreferredSize(new Dimension(186, 39));
        this.deleteButton.setText(NbBundle.getMessage(RecurrenceDialog.class, (String)"RecurrenceDialog.button.delete"));
        this.deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RecurrenceDialog.this.deleteButtonActionPerformed(evt);
            }
        });
        this.buttonsPanel.add(this.deleteButton);
        this.cancelButton.setText(NbBundle.getMessage(RecurrenceDialog.class, (String)"RecurrenceDialog.button.cancel"));
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RecurrenceDialog.this.cancelActionPerformed(evt);
            }
        });
        this.buttonsPanel.add(this.cancelButton);
        this.okButton.setText(NbBundle.getMessage(RecurrenceDialog.class, (String)"RecurrenceDialog.button.ok"));
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RecurrenceDialog.this.okActionPerformed(evt);
            }
        });
        this.buttonsPanel.add(this.okButton);
        this.fillerLabel.setText("    ");
        this.buttonsPanel.add(this.fillerLabel);
        this.actionPanel.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(RecurrenceDialog.class, (String)"RecurrenceDialog.action.title")));
        this.descriptionLabel.setHorizontalAlignment(11);
        this.descriptionLabel.setText(NbBundle.getMessage(RecurrenceDialog.class, (String)"RecurrenceDialog.description"));
        this.contextLabel.setHorizontalAlignment(11);
        this.contextLabel.setText(NbBundle.getMessage(RecurrenceDialog.class, (String)"RecurrenceDialog.context"));
        this.contextsCombo.setMaximumRowCount(30);
        this.topicLabel.setHorizontalAlignment(11);
        this.topicLabel.setText(NbBundle.getMessage(RecurrenceDialog.class, (String)"RecurrenceDialog.topic"));
        this.topicCombo.setRenderer(new TopicListCellRenderer());
        this.topicCombo.setMaximumRowCount(30);
        this.scheduleTimeLabel.setHorizontalAlignment(11);
        this.scheduleTimeLabel.setText(NbBundle.getMessage(RecurrenceDialog.class, (String)"RecurrenceDialog.time"));
        this.durationLabel.setText(NbBundle.getMessage(RecurrenceDialog.class, (String)"RecurrenceDialog.duration"));
        this.timeLabel.setHorizontalAlignment(11);
        this.timeLabel.setText(NbBundle.getMessage(RecurrenceDialog.class, (String)"RecurrenceDialog.criteria.time"));
        this.timeCombo.setModel(this.getTimeComboBoxModel());
        this.energyLabel.setHorizontalAlignment(11);
        this.energyLabel.setText(NbBundle.getMessage(RecurrenceDialog.class, (String)"RecurrenceDialog.criteria.energy"));
        this.energyCombo.setModel(this.getEnergyComboBoxModel());
        this.priorityLabel.setHorizontalAlignment(11);
        this.priorityLabel.setText(NbBundle.getMessage(RecurrenceDialog.class, (String)"RecurrenceDialog.criteria.priority"));
        this.priorityCombo.setModel(this.getPriorityComboBoxModel());
        GroupLayout jPanel2Layout = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)jPanel2Layout);
        jPanel2Layout.setHorizontalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap().add((Component)this.timeLabel, -2, 94, -2).addPreferredGap(0).add((Component)this.timeCombo, -2, 150, -2).addPreferredGap(0).add((Component)this.energyLabel, -2, 92, -2).addPreferredGap(0).add((Component)this.energyCombo, -2, 150, -2).addPreferredGap(0).add((Component)this.priorityLabel, -2, 92, -2).addPreferredGap(0).add((Component)this.priorityCombo, -2, 150, -2).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.energyLabel).add((Component)this.energyCombo, -2, -1, -2).add((Component)this.priorityLabel).add((Component)this.priorityCombo, -2, -1, -2).add((Component)this.timeCombo, -2, -1, -2).add((Component)this.timeLabel)));
        GroupLayout actionPanelLayout = new GroupLayout((Container)this.actionPanel);
        this.actionPanel.setLayout((LayoutManager)actionPanelLayout);
        actionPanelLayout.setHorizontalGroup((GroupLayout.Group)actionPanelLayout.createParallelGroup(1).add((GroupLayout.Group)actionPanelLayout.createSequentialGroup().add((GroupLayout.Group)actionPanelLayout.createParallelGroup(1).add((GroupLayout.Group)actionPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)actionPanelLayout.createParallelGroup(2).add((Component)this.topicLabel, -2, 91, -2).add((Component)this.descriptionLabel, -2, 91, -2).add((Component)this.contextLabel, -2, 91, -2)).addPreferredGap(0).add((GroupLayout.Group)actionPanelLayout.createParallelGroup(1).add((GroupLayout.Group)actionPanelLayout.createParallelGroup(2, false).add(1, (Component)this.topicCombo, 0, 200, Short.MAX_VALUE).add(1, (GroupLayout.Group)actionPanelLayout.createSequentialGroup().add((Component)this.contextsCombo, 0, 200, Short.MAX_VALUE).add(105, 105, 105))).add((Component)this.descriptionText, -1, 669, Short.MAX_VALUE))).add((Component)this.jPanel2, -2, -1, -2).add((GroupLayout.Group)actionPanelLayout.createSequentialGroup().addContainerGap().add((Component)this.scheduleTimeLabel, -2, 91, -2).addPreferredGap(0).add((Component)this.scheduleHourSpinner, -2, 40, -2).add(0, 0, 0).add((Component)this.scheduleMinSpinner, -2, 40, -2).addPreferredGap(0).add((Component)this.durationLabel).addPreferredGap(0).add((Component)this.durationHourSpinner, -2, 40, -2).add(0, 0, 0).add((Component)this.durationMinSpinner, -2, 40, -2))).addContainerGap()));
        actionPanelLayout.setVerticalGroup((GroupLayout.Group)actionPanelLayout.createParallelGroup(1).add((GroupLayout.Group)actionPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)actionPanelLayout.createParallelGroup(3).add((Component)this.descriptionText, -2, -1, -2).add((Component)this.descriptionLabel)).addPreferredGap(0).add((GroupLayout.Group)actionPanelLayout.createParallelGroup(3).add((Component)this.topicCombo, -2, -1, -2).add((Component)this.topicLabel)).addPreferredGap(0).add((GroupLayout.Group)actionPanelLayout.createParallelGroup(3).add((Component)this.contextsCombo, -2, -1, -2).add((Component)this.contextLabel)).addPreferredGap(0).add((Component)this.jPanel2, -2, -1, -2).addPreferredGap(0).add((GroupLayout.Group)actionPanelLayout.createParallelGroup(3).add((Component)this.scheduleHourSpinner, -2, 22, -2).add((Component)this.scheduleMinSpinner, -2, 22, -2).add((Component)this.scheduleTimeLabel, -2, 22, -2).add((Component)this.durationLabel, -2, 22, -2).add((Component)this.durationHourSpinner, -2, 22, -2).add((Component)this.durationMinSpinner, -2, 22, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.recurrencePanel.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(RecurrenceDialog.class, (String)"RecurrenceDialog.recurrence.title")));
        this.periodCombo.setModel(this.getPeriodComboBoxModel());
        this.periodCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RecurrenceDialog.this.periodActionPerformed(evt);
            }
        });
        this.frequencyLabel.setText(NbBundle.getMessage(RecurrenceDialog.class, (String)"RecurrenceDialog.label.every"));
        this.frequencyNbrSpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                RecurrenceDialog.this.frequencyStateChanged(evt);
            }
        });
        this.basisButtonGroup.add(this.basisStartRadioButton);
        this.basisStartRadioButton.setText(NbBundle.getMessage(RecurrenceDialog.class, (String)"RecurrenceDialog.create.date"));
        this.basisStartRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.basisStartRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.basisStartRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RecurrenceDialog.this.calculateStartDateActionPerformed(evt);
            }
        });
        this.basisButtonGroup.add(this.basisDoneRadioButton);
        this.basisDoneRadioButton.setText(NbBundle.getMessage(RecurrenceDialog.class, (String)"RecurrenceDialog.create.done"));
        this.basisDoneRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.basisDoneRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.basisDoneRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RecurrenceDialog.this.calculateDoneDateActionPerformed(evt);
            }
        });
        this.triggerLabel.setText(NbBundle.getMessage(RecurrenceDialog.class, (String)"RecurrenceDialog.label.create"));
        this.terminateLabel.setText(NbBundle.getMessage(RecurrenceDialog.class, (String)"RecurrenceDialog.label.terminate"));
        this.terminatebuttonGroup.add(this.terminateNeverRadioButton);
        this.terminateNeverRadioButton.setText(NbBundle.getMessage(RecurrenceDialog.class, (String)"RecurrenceDialog.terminate.never"));
        this.terminateNeverRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.terminateNeverRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.terminateNeverRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RecurrenceDialog.this.terminateNeverActionPerformed(evt);
            }
        });
        this.terminatebuttonGroup.add(this.terminateNumberRadioButton);
        this.terminateNumberRadioButton.setText(Resources.getText("RecurrenceDialog.terminate.number"));
        this.terminateNumberRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.terminateNumberRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.terminateNumberRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RecurrenceDialog.this.terminateNumberActionPerformed(evt);
            }
        });
        this.terminateNumberSpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                RecurrenceDialog.this.endNbrStateChanged(evt);
            }
        });
        this.terminatebuttonGroup.add(this.terminateDateRadioButton);
        this.terminateDateRadioButton.setText(NbBundle.getMessage(RecurrenceDialog.class, (String)"RecurrenceDialog.terminate.date"));
        this.terminateDateRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.terminateDateRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.terminateDateRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RecurrenceDialog.this.terminateDateActionPerformed(evt);
            }
        });
        this.terminateDateButton.setPreferredSize(new Dimension(144, Constants.BUTTON_HEIGHT));
        this.terminateDateButton.setNoSelectionText("Select a date");
        this.terminateDateButton.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                RecurrenceDialog.this.endDatePropertyChange(evt);
            }
        });
        this.terminateNumberLabel.setText(NbBundle.getMessage(RecurrenceDialog.class, (String)"RecurrenceDialog.terminate.occurences"));
        this.startDateButton.setPreferredSize(new Dimension(144, Constants.BUTTON_HEIGHT));
        this.startDateButton.setNoSelectionText("Select a date");
        this.advanceLabel1.setText(NbBundle.getMessage(RecurrenceDialog.class, (String)"RecurrenceDialog.advance1"));
        this.advanceSpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                RecurrenceDialog.this.advanceStateChanged(evt);
            }
        });
        this.advanceLabel2.setText(NbBundle.getMessage(RecurrenceDialog.class, (String)"RecurrenceDialog.advance2"));
        GroupLayout recurrencePanelLayout = new GroupLayout((Container)this.recurrencePanel);
        this.recurrencePanel.setLayout((LayoutManager)recurrencePanelLayout);
        recurrencePanelLayout.setHorizontalGroup((GroupLayout.Group)recurrencePanelLayout.createParallelGroup(1).add((GroupLayout.Group)recurrencePanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)recurrencePanelLayout.createParallelGroup(1).add((GroupLayout.Group)recurrencePanelLayout.createSequentialGroup().add((GroupLayout.Group)recurrencePanelLayout.createParallelGroup(1).add((GroupLayout.Group)recurrencePanelLayout.createSequentialGroup().add((Component)this.triggerLabel).add(48, 48, 48).add((Component)this.basisDoneRadioButton).add(67, 67, 67).add((Component)this.basisStartRadioButton).add(6, 6, 6)).add(2, (GroupLayout.Group)recurrencePanelLayout.createSequentialGroup().add((Component)this.terminateLabel).add(23, 23, 23).add((Component)this.terminateNeverRadioButton).add(38, 38, 38).add((Component)this.terminateNumberRadioButton).add(0, 0, 0).add((Component)this.terminateNumberSpinner, -1, 48, Short.MAX_VALUE).add(2, 2, 2).add((Component)this.terminateNumberLabel).add(27, 27, 27).add((Component)this.terminateDateRadioButton).addPreferredGap(0))).add((GroupLayout.Group)recurrencePanelLayout.createParallelGroup(1).add(2, (Component)this.terminateDateButton, -2, 144, -2).add(2, (Component)this.startDateButton, -2, 144, -2)).add(97, 97, 97)).add((GroupLayout.Group)recurrencePanelLayout.createSequentialGroup().add(139, 139, 139).add((Component)this.periodCombo, -2, 120, -2).addPreferredGap(0, 524, -2)).add((GroupLayout.Group)recurrencePanelLayout.createSequentialGroup().add((GroupLayout.Group)recurrencePanelLayout.createParallelGroup(1).add((Component)this.frequencyLabel).add((Component)this.advanceLabel1)).addPreferredGap(0).add((GroupLayout.Group)recurrencePanelLayout.createParallelGroup(1).add((Component)this.frequencyNbrSpinner, -2, 48, -2).add((GroupLayout.Group)recurrencePanelLayout.createSequentialGroup().add((Component)this.advanceSpinner, -2, 48, -2).addPreferredGap(0).add((Component)this.advanceLabel2, -1, 639, Short.MAX_VALUE))))).addContainerGap()));
        recurrencePanelLayout.linkSize(new Component[]{this.startDateButton, this.terminateDateButton}, 1);
        recurrencePanelLayout.linkSize(new Component[]{this.frequencyNbrSpinner, this.terminateNumberSpinner}, 1);
        recurrencePanelLayout.setVerticalGroup((GroupLayout.Group)recurrencePanelLayout.createParallelGroup(1).add((GroupLayout.Group)recurrencePanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)recurrencePanelLayout.createParallelGroup(3).add((Component)this.triggerLabel, -2, 22, -2).add((Component)this.basisDoneRadioButton, -2, 22, -2).add((Component)this.basisStartRadioButton, -2, 22, -2).add((Component)this.startDateButton, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)recurrencePanelLayout.createParallelGroup(3).add((Component)this.frequencyLabel, -2, 22, -2).add((Component)this.frequencyNbrSpinner, -2, 22, -2).add((Component)this.periodCombo, -2, 22, -2)).add(4, 4, 4).add((GroupLayout.Group)recurrencePanelLayout.createParallelGroup(3).add((Component)this.advanceSpinner, -2, 22, -2).add((Component)this.advanceLabel1, -2, 22, -2).add((Component)this.advanceLabel2, -2, 22, -2)).addPreferredGap(0).add((GroupLayout.Group)recurrencePanelLayout.createParallelGroup(3).add((Component)this.terminateLabel, -2, 22, -2).add((Component)this.terminateNeverRadioButton, -2, 22, -2).add((Component)this.terminateNumberRadioButton, -2, 22, -2).add((Component)this.terminateNumberSpinner, -2, 22, -2).add((Component)this.terminateNumberLabel, -2, 22, -2).add((Component)this.terminateDateRadioButton, -2, 22, -2).add((Component)this.terminateDateButton, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.actionPanel, -2, -1, -2).add((Component)this.recurrencePanel, -2, -1, -2).add((Component)this.buttonsPanel, -2, 793, -2));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.actionPanel, -2, -1, -2).addPreferredGap(0).add((Component)this.recurrencePanel, -2, -1, -2).addPreferredGap(0).add((Component)this.buttonsPanel, -2, -1, -2).add(0, 0, 0)));
        this.pack();
    }

    private void deleteButtonActionPerformed(ActionEvent evt) {
        String t = NbBundle.getMessage(this.getClass(), (String)"recurrence.confirm.delete.title");
        String m = NbBundle.getMessage(this.getClass(), (String)"recurrence.confirm.delete.message");
        int r = JOptionPane.showConfirmDialog(this, m, t, 0);
        if (r == 0) {
            this.cancel = false;
            this.delete = true;
            this.setVisible(false);
        }
    }

    private void endDatePropertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("date") && Utils.equal((Object)this.getEndDate(), (Object)this.endDate)) {
            LOG.fine("value changed");
            this.scheduleChange = true;
            this.startDateButton.setDate(this.defaultStartDate);
        }
    }

    private void endNbrStateChanged(ChangeEvent evt) {
        if (this.getEndNbr() != this.endNbr) {
            LOG.fine("value changed");
            this.scheduleChange = true;
            this.startDateButton.setDate(this.defaultStartDate);
        }
    }

    private void advanceStateChanged(ChangeEvent evt) {
        if ((Integer)this.advanceSpinner.getValue() != this.advance) {
            LOG.fine("value changed");
            this.scheduleChange = true;
            this.startDateButton.setDate(this.defaultStartDate);
        }
    }

    private void frequencyStateChanged(ChangeEvent evt) {
        if ((Integer)this.frequencyNbrSpinner.getValue() != this.frequency) {
            LOG.fine("value changed");
            this.scheduleChange = true;
            this.startDateButton.setDate(this.defaultStartDate);
        }
    }

    private void periodActionPerformed(ActionEvent evt) {
        Recurrence.Period period = (Recurrence.Period)this.periodCombo.getSelectedItem();
        if (period != this.period) {
            LOG.fine("value changed");
            this.scheduleChange = true;
            this.startDateButton.setDate(this.defaultStartDate);
        }
        if (this.getBasis() == Recurrence.Basis.DONE_DATE) {
            this.advance = 0;
            this.advanceSpinner.setValue(new Integer(0));
            return;
        }
        this.setDefaultAdvanceNumber(period);
    }

    private void setDefaultAdvanceNumber(Recurrence.Period period) {
        if (period == null) {
            return;
        }
        switch (period) {
            case WEEKDAY: {
                this.advanceSpinner.setValue(RecurrencePrefs.getNbrFutureWeekday());
                return;
            }
            case DAY: {
                this.advanceSpinner.setValue(RecurrencePrefs.getNbrFutureDay());
                return;
            }
            case WEEK: {
                this.advanceSpinner.setValue(RecurrencePrefs.getNbrFutureWeek());
                return;
            }
            case MONTH: {
                this.advanceSpinner.setValue(RecurrencePrefs.getNbrFutureMonth());
                return;
            }
            case YEAR: {
                this.advanceSpinner.setValue(RecurrencePrefs.getNbrFutureYear());
                return;
            }
        }
    }

    private ComboBoxModel getTimeComboBoxModel() {
        Criterion criterion;
        if (this.data != null && (criterion = this.data.getTimeCriterion()) != null) {
            return new CriterionComboBoxModel(criterion);
        }
        return new DefaultComboBoxModel();
    }

    private ComboBoxModel getEnergyComboBoxModel() {
        Criterion criterion;
        if (this.data != null && (criterion = this.data.getEnergyCriterion()) != null) {
            return new CriterionComboBoxModel(criterion);
        }
        return new DefaultComboBoxModel();
    }

    private ComboBoxModel getPriorityComboBoxModel() {
        Criterion criterion;
        if (this.data != null && (criterion = this.data.getPriorityCriterion()) != null) {
            return new CriterionComboBoxModel(criterion);
        }
        return new DefaultComboBoxModel();
    }

    private void calculateDoneDateActionPerformed(ActionEvent evt) {
        if (this.getBasis() != this.basis) {
            LOG.fine("value changed");
            this.scheduleChange = true;
            this.startDateButton.setDate(this.defaultStartDate);
        }
        if (this.getBasis() == Recurrence.Basis.DONE_DATE) {
            this.advance = 0;
            this.advanceSpinner.setValue(new Integer(this.advance));
        }
        this.enableDisableBasisComponents();
    }

    private void calculateStartDateActionPerformed(ActionEvent evt) {
        if (this.getBasis() != this.basis) {
            LOG.fine("value changed");
            this.scheduleChange = true;
            this.startDateButton.setDate(this.defaultStartDate);
        }
        if (this.getBasis() == Recurrence.Basis.START_DATE && (Integer)this.advanceSpinner.getValue() < 1) {
            this.setDefaultAdvanceNumber((Recurrence.Period)this.periodCombo.getSelectedItem());
        }
        this.enableDisableBasisComponents();
    }

    private void showHideCriteria() {
        Data data = (Data)DataLookup.instance().lookup(Data.class);
        this.timeLabel.setVisible(data.getTimeCriterion().use);
        this.timeCombo.setVisible(data.getTimeCriterion().use);
        this.energyLabel.setVisible(data.getEnergyCriterion().use);
        this.energyCombo.setVisible(data.getEnergyCriterion().use);
        this.priorityLabel.setVisible(data.getPriorityCriterion().use);
        this.priorityCombo.setVisible(data.getPriorityCriterion().use);
    }

    private void enableDisableBasisComponents() {
        boolean b = this.basisStartRadioButton.isSelected();
        this.startDateButton.setEnabled(b);
        this.advanceLabel1.setEnabled(b);
        this.advanceLabel2.setEnabled(b);
        this.advanceSpinner.setEnabled(b);
    }

    private void terminateDateActionPerformed(ActionEvent evt) {
        this.enableDisableTerminateComponents();
    }

    private void terminateNumberActionPerformed(ActionEvent evt) {
        this.enableDisableTerminateComponents();
    }

    private void terminateNeverActionPerformed(ActionEvent evt) {
        this.enableDisableTerminateComponents();
    }

    private void enableDisableTerminateComponents() {
        if (this.terminateNeverRadioButton.isSelected()) {
            this.terminateDateButton.setEnabled(false);
            this.terminateNumberSpinner.setEnabled(false);
        } else if (this.terminateNumberRadioButton.isSelected()) {
            this.terminateDateButton.setEnabled(false);
            this.terminateNumberSpinner.setEnabled(true);
        } else if (this.terminateDateRadioButton.isSelected()) {
            this.terminateDateButton.setEnabled(true);
            this.terminateNumberSpinner.setEnabled(false);
        }
    }

    private void cancelActionPerformed(ActionEvent evt) {
        this.cancel = true;
        this.delete = false;
        this.setVisible(false);
    }

    private void okActionPerformed(ActionEvent evt) {
        StringBuffer e = new StringBuffer();
        if (this.basisStartRadioButton.isSelected() && this.getStartDate() == null) {
            e.append(NbBundle.getMessage(RecurrenceDialog.class, (String)"RecurrenceDialog.err.startDate"));
            e.append("\n");
        }
        if (this.getFrequencyNbr() < 1) {
            e.append(NbBundle.getMessage(RecurrenceDialog.class, (String)"RecurrenceDialog.err.frequency"));
            e.append("\n");
        }
        if (this.terminateNumberRadioButton.isSelected() && this.getEndNbr() < 1) {
            e.append(NbBundle.getMessage(RecurrenceDialog.class, (String)"RecurrenceDialog.err.endNbr"));
            e.append("\n");
        }
        if (this.terminateDateRadioButton.isSelected()) {
            if (this.getEndDate() == null) {
                e.append(NbBundle.getMessage(RecurrenceDialog.class, (String)"RecurrenceDialog.err.endDateNull"));
                e.append("\n");
            } else if (this.getStartDate() != null && DateUtils.getStart((Date)this.getStartDate()).after(DateUtils.getStart((Date)this.getEndDate()))) {
                e.append(NbBundle.getMessage(RecurrenceDialog.class, (String)"RecurrenceDialog.err.endDateBeforeStartDate"));
                e.append("\n");
            }
        }
        if (e.toString().length() > 0) {
            String b = NbBundle.getMessage(RecurrenceDialog.class, (String)"RecurrenceDialog.err.blurb");
            String m = b + "      \n\n" + e.toString();
            String t = NbBundle.getMessage(RecurrenceDialog.class, (String)"RecurrenceDialog.err.title");
            JOptionPane.showMessageDialog(null, m, t, 0);
            return;
        }
        this.cancel = false;
        this.setVisible(false);
    }

    public Recurrence.Period getPeriod() {
        return (Recurrence.Period)this.periodCombo.getSelectedItem();
    }

    public int getFrequencyNbr() {
        Object object = this.frequencyNbrSpinner.getValue();
        if (object instanceof Number) {
            return ((Number)object).intValue();
        }
        return 0;
    }

    public Recurrence.Basis getBasis() {
        if (this.basisStartRadioButton.isSelected()) {
            return Recurrence.Basis.START_DATE;
        }
        return Recurrence.Basis.DONE_DATE;
    }

    public Integer getEndNbr() {
        if (!this.terminateNumberRadioButton.isSelected()) {
            return null;
        }
        Object object = this.terminateNumberSpinner.getValue();
        if (object instanceof Number) {
            return ((Number)object).intValue();
        }
        return 0;
    }

    public Date getEndDate() {
        if (!this.terminateDateRadioButton.isSelected()) {
            return null;
        }
        return this.terminateDateButton.getDate();
    }

    public Date getStartDate() {
        Date dateStart = this.startDateButton.getDate();
        if (dateStart == null) {
            return null;
        }
        Calendar calStart = Calendar.getInstance();
        calStart.setTime(dateStart);
        calStart.set(11, 0);
        calStart.set(12, 0);
        calStart.set(13, 0);
        calStart.set(14, 0);
        return calStart.getTime();
    }

    public String getDescription() {
        return this.descriptionText.getText();
    }

    public Topic getTopic() {
        return (Topic)this.topicCombo.getSelectedItem();
    }

    public Context getContext() {
        return (Context)this.contextsCombo.getSelectedItem();
    }

    public Value getTime() {
        return (Value)this.timeCombo.getSelectedItem();
    }

    public Value getEnergy() {
        return (Value)this.energyCombo.getSelectedItem();
    }

    public Value getPriority() {
        return (Value)this.priorityCombo.getSelectedItem();
    }

    public int getDurationHours() {
        return this.durationHourSpinner.getVal();
    }

    public int getDurationMins() {
        return this.durationMinSpinner.getVal();
    }

    public int getScheduleHours() {
        return this.scheduleHourSpinner.getVal();
    }

    public int getScheduleMins() {
        return this.scheduleMinSpinner.getVal();
    }

    public int getAdvance() {
        return (Integer)this.advanceSpinner.getValue();
    }

    private ComboBoxModel getPeriodComboBoxModel() {
        if (this.periodComboBoxModel == null) {
            Object[] model = new Object[]{Recurrence.Period.WEEKDAY, Recurrence.Period.DAY, Recurrence.Period.WEEK, Recurrence.Period.MONTH, Recurrence.Period.YEAR};
            this.periodComboBoxModel = new DefaultComboBoxModel<Object>(model);
        }
        return this.periodComboBoxModel;
    }
}

