/*
 * Decompiled with CFR 0.152.
 */
package tr.view.future;

import java.util.Collections;
import java.util.Comparator;
import java.util.TreeSet;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import tr.model.Data;
import tr.model.DataLookup;
import tr.model.future.Future;
import tr.model.topic.Topic;
import tr.util.Observable;
import tr.util.Observer;
import tr.view.future.TopicNode;

public class TopicChildren
extends Children.Keys
implements Observer {
    public TopicChildren() {
        this.initKeys();
    }

    protected synchronized void initKeys() {
        Data data = (Data)DataLookup.instance().lookup(Data.class);
        if (data == null) {
            this.setKeys(Collections.EMPTY_SET);
        } else {
            TreeSet<Topic> topics = new TreeSet<Topic>(new TopicComparator());
            for (Future future : data.getFutureManager().list()) {
                topics.add(future.getTopic());
            }
            this.setKeys(topics);
        }
    }

    protected void addNotify() {
        Data data = (Data)DataLookup.instance().lookup(Data.class);
        if (data != null) {
            data.getTopicManager().addObserver((Observer)this);
            data.getFutureManager().addObserver((Observer)this);
        }
    }

    protected void removeNotify() {
        Data data = (Data)DataLookup.instance().lookup(Data.class);
        if (data != null) {
            data.getTopicManager().removeObserver((Observer)this);
            data.getFutureManager().removeObserver((Observer)this);
        }
    }

    protected Node[] createNodes(Object key) {
        return new Node[]{new TopicNode((Topic)key)};
    }

    public void update(Observable observable, Object arguement) {
        this.initKeys();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TopicComparator
    implements Comparator<Topic> {
        private TopicComparator() {
        }

        @Override
        public int compare(Topic t1, Topic t2) {
            return t1.toString().compareToIgnoreCase(t2.toString());
        }
    }
}

