/*
 * Decompiled with CFR 0.152.
 */
package tr.view.future;

import java.awt.BorderLayout;
import java.io.Serializable;
import java.util.Collection;
import java.util.logging.Logger;
import org.openide.ErrorManager;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import tr.model.future.Future;
import tr.view.Window;
import tr.view.future.FutureListTopComponent;
import tr.view.future.FuturePanel;
import tr.view.future.FutureTopicsTopComponent;
import tr.view.future.Resources;

public final class FutureTopComponent
extends Window
implements LookupListener {
    private static final Logger LOG = Logger.getLogger("tr.view.future");
    private static final String PREFERRED_ID = "FutureTopComponent";
    private static FutureTopComponent instance;
    private transient FuturePanel panel;
    private transient Lookup.Result result;

    private FutureTopComponent() {
        this.setName(NbBundle.getMessage(FutureTopicsTopComponent.class, (String)"CTL_FutureTopComponent"));
        this.setToolTipText(NbBundle.getMessage(FutureTopicsTopComponent.class, (String)"TTT_FutureTopComponent"));
        this.setIcon(Resources.ICON_FUTURE.getImage());
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    public synchronized void resultChanged(LookupEvent lookupEvent) {
        if (this.panel == null) {
            return;
        }
        Collection collection = this.result.allInstances();
        if (collection.isEmpty()) {
            this.panel.initModel(null);
        } else {
            this.panel.initModel((Future)collection.iterator().next());
        }
    }

    public static synchronized FutureTopComponent getDefault() {
        if (instance == null) {
            instance = new FutureTopComponent();
        }
        return instance;
    }

    protected void componentOpened() {
        super.componentOpened();
        if (this.panel == null) {
            this.removeAll();
            this.panel = new FuturePanel();
            this.add(this.panel, "Center");
        }
        this.panel.initModel(null);
        FutureListTopComponent itc = FutureListTopComponent.findInstance();
        this.result = itc.getLookup().lookup(new Lookup.Template(Future.class));
        this.result.addLookupListener((LookupListener)this);
        this.result.allInstances();
    }

    protected void componentClosed() {
        super.componentClosed();
        this.result.removeLookupListener((LookupListener)this);
        this.result = null;
    }

    protected void componentDeactivated() {
        super.componentDeactivated();
        if (this.panel != null) {
            this.panel.deactivate();
        }
    }

    public static synchronized FutureTopComponent findInstance() {
        TopComponent win = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (win == null) {
            ErrorManager.getDefault().log(16, "Cannot find Future component. It will not be located properly in the window system.");
            return FutureTopComponent.getDefault();
        }
        if (win instanceof FutureTopComponent) {
            return (FutureTopComponent)win;
        }
        ErrorManager.getDefault().log(16, "There seem to be multiple components with the 'FutureTopComponent' ID. That is a potential source of errors and unexpected behavior.");
        return FutureTopComponent.getDefault();
    }

    public int getPersistenceType() {
        return 0;
    }

    public Object writeReplace() {
        return new ResolvableHelper();
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("tr.view.future");
    }

    static final class ResolvableHelper
    implements Serializable {
        private static final long serialVersionUID = 1L;

        ResolvableHelper() {
        }

        public Object readResolve() {
            return FutureTopComponent.getDefault();
        }
    }
}

