/*
 * Decompiled with CFR 0.152.
 */
package tr.view.future;

import java.awt.Image;
import java.io.IOException;
import java.util.logging.Logger;
import javax.swing.Action;
import org.openide.actions.DeleteAction;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;
import tr.model.Data;
import tr.model.DataLookup;
import tr.model.future.Future;
import tr.model.thought.Thought;
import tr.model.topic.TopicChangeCookie;
import tr.util.Observable;
import tr.util.Observer;
import tr.view.ReprocessAction;
import tr.view.ReprocessCookie;
import tr.view.future.Resources;
import tr.view.process.ProcessThoughtsAction;
import tr.view.topic.TopicChangeAction;

public class FutureNode
extends AbstractNode
implements Observer,
ReprocessCookie {
    private static final Logger LOG = Logger.getLogger("tr.view.future");
    private String name;

    public FutureNode(Future future) {
        super(Children.LEAF, Lookups.singleton((Object)future));
        this.name = future.getDescription();
        super.setName(this.name);
        future.addObserver((Observer)this);
    }

    private Future getFuture() {
        return (Future)this.getLookup().lookup(Future.class);
    }

    public Image getIcon(int type) {
        return Resources.ICON_FUTURE.getImage();
    }

    public String getHtmlDisplayName() {
        return this.name;
    }

    public boolean canCut() {
        return false;
    }

    public boolean canCopy() {
        return false;
    }

    public boolean canDestroy() {
        return true;
    }

    public void destroy() throws IOException {
        Future future = this.getFuture();
        if (future == null) {
            return;
        }
        future.removeObserver((Observer)this);
        Data data = (Data)DataLookup.instance().lookup(Data.class);
        if (data == null) {
            return;
        }
        data.getFutureManager().remove((Observable)future);
        this.fireNodeDestroyed();
    }

    public boolean canRename() {
        return false;
    }

    public Action[] getActions(boolean popup) {
        return new Action[]{SystemAction.get(DeleteAction.class), null, SystemAction.get(TopicChangeAction.class), null, SystemAction.get(ReprocessAction.class)};
    }

    public Node.Cookie getCookie(Class clazz) {
        if (clazz == ReprocessCookie.class) {
            return this;
        }
        if (clazz == TopicChangeCookie.class) {
            return this.getFuture();
        }
        return super.getCookie(clazz);
    }

    public void update(Observable observable, Object arguement) {
        LOG.info("Handle future change.");
        String oldName = this.name;
        String newName = this.getFuture().getDescription();
        if (!newName.equals(oldName)) {
            super.setName(newName);
            this.name = newName;
        }
    }

    public void reprocess() {
        Data data = (Data)DataLookup.instance().lookup(Data.class);
        if (data == null) {
            return;
        }
        Future future = this.getFuture();
        if (future == null) {
            return;
        }
        future.removeObserver((Observer)this);
        data.getFutureManager().remove((Observable)future);
        Thought thought = new Thought();
        thought.setDescription(future.getDescription());
        thought.setTopic(future.getTopic());
        thought.setNotes(future.getNotes());
        data.getThoughtManager().insert((Observable)thought, 0);
        try {
            Thread.currentThread();
            Thread.sleep(500L);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        ProcessThoughtsAction pta = (ProcessThoughtsAction)SystemAction.get(ProcessThoughtsAction.class);
        pta.performAction();
    }
}

