/*
 * Decompiled with CFR 0.152.
 */
package tr.view.future;

import java.awt.event.ActionEvent;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import tr.global.InitialAction;
import tr.model.Data;
import tr.model.DataLookup;
import tr.view.WindowUtils;
import tr.view.future.FutureListTopComponent;
import tr.view.future.FutureTopComponent;
import tr.view.future.FutureTopicsTopComponent;
import tr.view.future.Resources;

public class FutureAction
extends AbstractAction
implements InitialAction {
    private static final Logger LOG = Logger.getLogger("tr.view.future");

    public FutureAction() {
        super(NbBundle.getMessage(FutureAction.class, (String)"CTL_FutureAction"));
        this.putValue("SmallIcon", Resources.ICON_FUTURE);
        this.enableDisable();
        Lookup.Result r = DataLookup.instance().lookup(new Lookup.Template(Data.class));
        r.addLookupListener(new LookupListener(){

            public void resultChanged(LookupEvent lookupEvent) {
                FutureAction.this.enableDisable();
            }
        });
    }

    private void enableDisable() {
        Data data = (Data)DataLookup.instance().lookup(Data.class);
        this.setEnabled(data != null);
    }

    public void actionPerformed(ActionEvent evt) {
        Data data = (Data)DataLookup.instance().lookup(Data.class);
        if (data == null) {
            return;
        }
        WindowUtils.closeWindows();
        FutureTopicsTopComponent tcTopicsList = FutureTopicsTopComponent.findInstance();
        FutureListTopComponent tcFutureList = FutureListTopComponent.findInstance();
        FutureTopComponent tcFutureItem = FutureTopComponent.findInstance();
        Mode mode = WindowManager.getDefault().findMode("topics-list");
        if (mode == null) {
            LOG.severe("Mode: topics-list; was not found.");
        } else {
            mode.dockInto((TopComponent)tcTopicsList);
        }
        mode = WindowManager.getDefault().findMode("future-list");
        if (mode == null) {
            LOG.severe("Mode: future-list; was not found.");
        } else {
            mode.dockInto((TopComponent)tcFutureList);
        }
        mode = WindowManager.getDefault().findMode("future");
        if (mode == null) {
            LOG.severe("Mode: future; was not found.");
        } else {
            mode.dockInto((TopComponent)tcFutureItem);
        }
        tcTopicsList.open();
        tcFutureList.open();
        tcFutureItem.open();
        tcTopicsList.requestActive();
    }

    public String getID() {
        return "future";
    }

    public String getName() {
        return (String)this.getValue("Name");
    }
}

