/*
 * Decompiled with CFR 0.152.
 */
package tr.autoversion;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Logger;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import org.openide.modules.ModuleInstall;
import org.openide.util.NbBundle;
import tr.prefs.general.GeneralPrefs;
import tr.util.DateUtils;

public class Installer
extends ModuleInstall {
    private static final Logger log = Logger.getLogger("tr.autoversion");

    public void restored() {
        log.finest("Begin");
        switch (GeneralPrefs.getVersionCheckPeriod()) {
            case 5: {
                log.fine("User preference Check Period is set to NEVER");
                return;
            }
            case 0: {
                log.fine("User preference Check Period is set to STARTUP");
                this.checkVersion();
                return;
            }
        }
        if (this.checkPeriodExpired()) {
            log.fine("Period has expired");
            this.checkVersion();
        } else {
            log.fine("Period has not expired");
        }
        log.finest("End");
    }

    private boolean checkPeriodExpired() {
        log.fine("Checking if period has expired ... ");
        Calendar checkDate = Calendar.getInstance();
        checkDate.setTimeInMillis(GeneralPrefs.getCheckVersionLastTime());
        switch (GeneralPrefs.getVersionCheckPeriod()) {
            case 1: {
                log.fine("User preference Check Period is set to DAY");
                checkDate.add(6, 1);
                break;
            }
            case 2: {
                log.fine("User preference Check Period is set to WEEK");
                checkDate.add(6, 7);
                break;
            }
            case 3: {
                log.fine("User preference Check Period is set to TWO WEEKS");
                checkDate.add(6, 14);
                break;
            }
            case 4: {
                log.fine("User preference Check Period is set to MONTH");
                checkDate.add(2, 1);
                break;
            }
            default: {
                log.severe("User preference Check Period is not recognized.");
                return false;
            }
        }
        Calendar now = Calendar.getInstance();
        return now.after(checkDate);
    }

    private void checkVersion() {
        String latestVersion;
        log.fine("Getting latest version number from web site");
        try {
            URL url = new URL("http://www.thinkingrock.com.au/version.php");
            URLConnection connection = url.openConnection();
            connection.setConnectTimeout(15000);
            InputStream in = connection.getInputStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            latestVersion = br.readLine();
            in.close();
        }
        catch (Exception ex) {
            log.severe(ex.getMessage());
            return;
        }
        if (latestVersion == null) {
            log.severe("Latest version was not obtained from web site");
            return;
        }
        if ("2.0.epsilon".equals(latestVersion)) {
            log.fine("Application version is the latest version");
        } else {
            log.fine("Notifying user of a new version");
            this.notifyUser(latestVersion);
        }
        log.fine("Setting last time checked");
        Date startOfToday = DateUtils.getStart((Date)Calendar.getInstance().getTime());
        GeneralPrefs.setCheckVersionLastTime((long)startOfToday.getTime());
    }

    private void notifyUser(String version) {
        String t = this.getHeading();
        String m = "\n\n" + this.getMessage(version, "http://www.thinkingrock.com.au") + "    \n\n ";
        JCheckBox icb = new JCheckBox(this.getTurnOff());
        Object[] options = new Object[]{m, icb};
        JOptionPane.showOptionDialog(null, options, t, -1, 1, null, null, null);
        if (icb.isSelected()) {
            log.fine("Setting user preference Check Period to NEVER");
            GeneralPrefs.setVersionCheckPeriod((int)5);
        }
    }

    private String getHeading() {
        return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"CTL_Heading");
    }

    private String getMessage(String version, String url) {
        return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"CTL_Message", (Object)version, (Object)url);
    }

    private String getTurnOff() {
        return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"CTL_TurnOff");
    }
}

