/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.multiview;

import java.awt.AWTKeyStroke;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.text.Keymap;
import org.netbeans.core.multiview.MultiViewModel;
import org.netbeans.core.spi.multiview.MultiViewDescription;
import org.netbeans.core.spi.multiview.MultiViewElement;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.CallbackSystemAction;

class TabsComponent
extends JPanel {
    private JComponent EMPTY;
    private static final String TOOLBAR_MARKER = "MultiViewPanel";
    MultiViewModel model;
    private ActionListener listener;
    private MouseListener buttonMouseListener = null;
    private JComponent toolbarPanel;
    private JPanel componentPanel;
    private CardLayout cardLayout;
    private Set alreadyAddedElements;
    private JToolBar bar = AQUA ? new TB() : new JToolBar();
    private static final boolean AQUA = "Aqua".equals(UIManager.getLookAndFeel().getID());
    private boolean toolbarVisible = true;
    private Border buttonBorder = null;
    private boolean isMetal = false;
    private boolean isWindows = false;

    public TabsComponent(boolean bl) {
        Border border = (Border)UIManager.get("Nb.Editor.Toolbar.border");
        this.bar.setBorder(border);
        this.bar.setFloatable(false);
        this.bar.setFocusable(true);
        this.setLayout(new BorderLayout());
        this.add((Component)this.bar, "North");
        this.startToggling();
        this.setToolbarBarVisible(bl);
    }

    public void setModel(MultiViewModel multiViewModel) {
        Cloneable cloneable;
        Serializable serializable;
        if (this.model != null) {
            this.bar.removeAll();
        }
        this.model = multiViewModel;
        this.componentPanel = new JPanel();
        this.cardLayout = new CardLayout();
        this.componentPanel.setLayout(this.cardLayout);
        this.add((Component)this.componentPanel, "Center");
        this.alreadyAddedElements = new HashSet();
        MultiViewDescription[] multiViewDescriptionArray = multiViewModel.getDescriptions();
        MultiViewDescription multiViewDescription = multiViewModel.getActiveDescription();
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.bar.setLayout(gridBagLayout);
        Serializable serializable2 = null;
        int n = -1;
        int n2 = -1;
        for (int i = 0; i < multiViewDescriptionArray.length; ++i) {
            serializable = this.createButton(multiViewDescriptionArray[i]);
            multiViewModel.getButtonGroup().add((AbstractButton)serializable);
            cloneable = new GridBagConstraints();
            cloneable.anchor = 17;
            n = Math.max(((JComponent)serializable).getPreferredSize().height, n);
            this.bar.add((Component)serializable, cloneable);
            n2 = Math.max(((JComponent)serializable).getPreferredSize().width, n2);
            if (multiViewDescriptionArray[i] != multiViewModel.getActiveDescription()) continue;
            serializable2 = serializable;
        }
        Enumeration<AbstractButton> enumeration = multiViewModel.getButtonGroup().getElements();
        while (enumeration.hasMoreElements()) {
            serializable = (JToggleButton)enumeration.nextElement();
            cloneable = ((JComponent)serializable).getBorder().getBorderInsets((Component)serializable);
            ((JComponent)serializable).setPreferredSize(new Dimension(n2 + 10, n));
            ((JComponent)serializable).setMinimumSize(new Dimension(n2 + 10, n));
        }
        if (serializable2 != null) {
            serializable2.setSelected(true);
        }
        this.toolbarPanel = this.getEmptyInnerToolBar();
        serializable = new GridBagConstraints();
        ((GridBagConstraints)serializable).anchor = 13;
        ((GridBagConstraints)serializable).fill = 1;
        ((GridBagConstraints)serializable).gridwidth = 0;
        ((GridBagConstraints)serializable).weightx = 1.0;
        this.bar.add((Component)this.toolbarPanel, serializable);
    }

    void switchToCard(MultiViewElement multiViewElement, String string) {
        if (!this.alreadyAddedElements.contains(multiViewElement)) {
            this.componentPanel.add((Component)multiViewElement.getVisualRepresentation(), string);
            this.alreadyAddedElements.add(multiViewElement);
        }
        this.cardLayout.show(this.componentPanel, string);
    }

    void changeActiveManually(MultiViewDescription multiViewDescription) {
        Enumeration<AbstractButton> enumeration = this.model.getButtonGroup().getElements();
        while (enumeration.hasMoreElements()) {
            TabsButtonModel tabsButtonModel;
            JToggleButton jToggleButton = (JToggleButton)enumeration.nextElement();
            if (!(jToggleButton.getModel() instanceof TabsButtonModel) || !(tabsButtonModel = (TabsButtonModel)jToggleButton.getModel()).getButtonsDescription().equals(multiViewDescription)) continue;
            jToggleButton.setSelected(true);
            MultiViewElement multiViewElement = this.model.getElementForDescription(multiViewDescription);
            multiViewElement.getVisualRepresentation().requestFocus();
            break;
        }
    }

    void changeVisibleManually(MultiViewDescription multiViewDescription) {
        Enumeration<AbstractButton> enumeration = this.model.getButtonGroup().getElements();
        while (enumeration.hasMoreElements()) {
            TabsButtonModel tabsButtonModel;
            JToggleButton jToggleButton = (JToggleButton)enumeration.nextElement();
            if (!(jToggleButton.getModel() instanceof TabsButtonModel) || !(tabsButtonModel = (TabsButtonModel)jToggleButton.getModel()).getButtonsDescription().equals(multiViewDescription)) continue;
            jToggleButton.setSelected(true);
            break;
        }
    }

    private JToggleButton createButton(MultiViewDescription multiViewDescription) {
        Object object;
        JToggleButton jToggleButton = new JToggleButton(multiViewDescription.getDisplayName());
        jToggleButton.setModel(new TabsButtonModel(multiViewDescription));
        jToggleButton.setRolloverEnabled(true);
        Border border = this.getButtonBorder();
        if (border != null) {
            jToggleButton.setBorder(border);
        }
        if (this.buttonMouseListener == null) {
            this.buttonMouseListener = new ButtonMouseListener();
        }
        jToggleButton.addMouseListener(this.buttonMouseListener);
        Font font = jToggleButton.getFont();
        FontMetrics fontMetrics = jToggleButton.getFontMetrics(font);
        int n = fontMetrics.getHeight();
        Keymap keymap = (Keymap)Lookup.getDefault().lookup(Keymap.class);
        AWTKeyStroke aWTKeyStroke = null;
        AWTKeyStroke aWTKeyStroke2 = null;
        if (keymap != null) {
            object = keymap.getBoundActions();
            for (int i = 0; i < ((Action[])object).length; ++i) {
                KeyStroke[] keyStrokeArray;
                if (!(object[i] instanceof CallbackSystemAction)) continue;
                CallbackSystemAction callbackSystemAction = (CallbackSystemAction)object[i];
                if ("NextViewAction".equals(callbackSystemAction.getActionMapKey()) && (keyStrokeArray = keymap.getKeyStrokesForAction(object[i])) != null && keyStrokeArray.length > 0) {
                    aWTKeyStroke = keyStrokeArray[0];
                }
                if (!"PreviousViewAction".equals(callbackSystemAction.getActionMapKey()) || (keyStrokeArray = keymap.getKeyStrokesForAction(object[i])) == null || keyStrokeArray.length <= 0) continue;
                aWTKeyStroke2 = keyStrokeArray[0];
            }
        }
        object = aWTKeyStroke == null ? "" : KeyEvent.getKeyModifiersText(aWTKeyStroke.getModifiers()) + "+" + KeyEvent.getKeyText(aWTKeyStroke.getKeyCode());
        String string = aWTKeyStroke2 == null ? "" : KeyEvent.getKeyModifiersText(aWTKeyStroke2.getModifiers()) + "+" + KeyEvent.getKeyText(aWTKeyStroke2.getKeyCode());
        jToggleButton.setToolTipText(NbBundle.getMessage((Class)TabsComponent.class, (String)"TabButton.tooltip", (Object)multiViewDescription.getDisplayName(), (Object)object, (Object)string));
        jToggleButton.setFocusable(true);
        jToggleButton.setFocusPainted(true);
        return jToggleButton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setInnerToolBar(JComponent jComponent) {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.toolbarPanel != null) {
                this.bar.remove(this.toolbarPanel);
            }
            if (jComponent == null) {
                jComponent = this.getEmptyInnerToolBar();
            }
            jComponent.putClientProperty(TOOLBAR_MARKER, "X");
            if (!AQUA) {
                jComponent.setBorder(null);
            } else {
                jComponent.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
            }
            this.toolbarPanel = jComponent;
            if (this.toolbarPanel != null) {
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.anchor = 13;
                gridBagConstraints.fill = 1;
                gridBagConstraints.weightx = 1.0;
                this.toolbarPanel.setMinimumSize(new Dimension(10, 10));
                gridBagConstraints.gridwidth = 0;
                this.bar.add((Component)this.toolbarPanel, gridBagConstraints);
            }
            this.bar.revalidate();
            this.bar.repaint();
        }
    }

    void setToolbarBarVisible(boolean bl) {
        if (this.toolbarVisible == bl) {
            return;
        }
        this.toolbarVisible = bl;
        this.bar.setVisible(bl);
    }

    JComponent getEmptyInnerToolBar() {
        if (this.EMPTY == null) {
            this.EMPTY = new JPanel();
        }
        return this.EMPTY;
    }

    void requestFocusForSelectedButton() {
        this.bar.setFocusable(true);
        Enumeration<AbstractButton> enumeration = this.model.getButtonGroup().getElements();
        while (enumeration.hasMoreElements()) {
            JToggleButton jToggleButton = (JToggleButton)enumeration.nextElement();
            if (!this.model.getButtonGroup().isSelected(jToggleButton.getModel())) continue;
            jToggleButton.requestFocus();
            return;
        }
        throw new IllegalStateException("How come none of the buttons is selected?");
    }

    void requestFocusForPane() {
        this.bar.setFocusable(false);
        this.componentPanel.requestFocus();
    }

    private Border getButtonBorder() {
        if (this.buttonBorder == null) {
            this.buttonBorder = UIManager.getBorder("nb.tabbutton.border");
        }
        return this.buttonBorder;
    }

    public static boolean isXPTheme() {
        Boolean bl = (Boolean)Toolkit.getDefaultToolkit().getDesktopProperty("win.xpstyle.themeActive");
        return bl == null ? false : bl;
    }

    void startToggling() {
        ActionMap actionMap = this.bar.getActionMap();
        AbstractAction abstractAction = new TogglesGoEastAction();
        actionMap.put("navigateRight", abstractAction);
        InputMap inputMap = this.bar.getInputMap(1);
        abstractAction = new TogglesGoWestAction();
        actionMap.put("navigateLeft", abstractAction);
        abstractAction = new TogglesGoDownAction();
        actionMap.put("TogglesGoDown", abstractAction);
        actionMap.put("navigateUp", abstractAction);
        KeyStroke keyStroke = KeyStroke.getKeyStroke("ESCAPE");
        inputMap.put(keyStroke, "TogglesGoDown");
    }

    class ButtonMouseListener
    extends MouseAdapter {
        ButtonMouseListener() {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            AbstractButton abstractButton = (AbstractButton)mouseEvent.getComponent();
            abstractButton.getModel().setRollover(true);
        }

        public void mouseExited(MouseEvent mouseEvent) {
            AbstractButton abstractButton = (AbstractButton)mouseEvent.getComponent();
            abstractButton.getModel().setRollover(false);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            AbstractButton abstractButton = (AbstractButton)mouseEvent.getComponent();
            MultiViewModel multiViewModel = TabsComponent.this.model;
            if (multiViewModel != null) {
                multiViewModel.getButtonGroup().setSelected(abstractButton.getModel(), true);
                multiViewModel.fireActivateCurrent();
            }
        }
    }

    private static final class TB
    extends JToolBar {
        private boolean updating = false;

        public TB() {
            this.setName("editorToolbar");
        }

        public void setBorder(Border border) {
            if (!this.updating) {
                return;
            }
            super.setBorder(border);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updateUI() {
            this.updating = true;
            try {
                super.updateUI();
            }
            finally {
                this.updating = false;
            }
        }

        public String getUIClassID() {
            return UIManager.get("Nb.Toolbar.ui") == null ? super.getUIClassID() : "Nb.Toolbar.ui";
        }
    }

    static class TabsButtonModel
    extends JToggleButton.ToggleButtonModel {
        private MultiViewDescription desc;

        public TabsButtonModel(MultiViewDescription multiViewDescription) {
            this.desc = multiViewDescription;
        }

        public MultiViewDescription getButtonsDescription() {
            return this.desc;
        }
    }

    private class TogglesGoDownAction
    extends AbstractAction {
        private TogglesGoDownAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            TabsComponent.this.changeActiveManually(TabsComponent.this.model.getActiveDescription());
            TabsComponent.this.model.getActiveElement().getVisualRepresentation().requestFocusInWindow();
        }
    }

    private class TogglesGoEastAction
    extends AbstractAction {
        private TogglesGoEastAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MultiViewDescription[] multiViewDescriptionArray = TabsComponent.this.model.getDescriptions();
            MultiViewDescription multiViewDescription = TabsComponent.this.model.getActiveDescription();
            for (int i = 0; i < multiViewDescriptionArray.length; ++i) {
                if (multiViewDescriptionArray[i] != multiViewDescription) continue;
                int n = i + 1;
                if (n >= multiViewDescriptionArray.length) {
                    n = 0;
                }
                TabsComponent.this.changeVisibleManually(multiViewDescriptionArray[n]);
                TabsComponent.this.requestFocusForSelectedButton();
            }
        }
    }

    private class TogglesGoWestAction
    extends AbstractAction {
        private TogglesGoWestAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MultiViewDescription[] multiViewDescriptionArray = TabsComponent.this.model.getDescriptions();
            MultiViewDescription multiViewDescription = TabsComponent.this.model.getActiveDescription();
            for (int i = 0; i < multiViewDescriptionArray.length; ++i) {
                if (multiViewDescriptionArray[i] != multiViewDescription) continue;
                int n = i - 1;
                if (n < 0) {
                    n = multiViewDescriptionArray.length - 1;
                }
                TabsComponent.this.changeVisibleManually(multiViewDescriptionArray[n]);
                TabsComponent.this.requestFocusForSelectedButton();
            }
        }
    }
}

