/*
 * Decompiled with CFR 0.152.
 */
package org.openide.awt;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.SystemColor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Vector;
import org.openide.awt.SpinButtonListener;

public class SpinButton
extends Canvas {
    static final long serialVersionUID = -3525959415481788776L;
    public static final boolean DEFAULT_ORIENTATION = false;
    public static final int DEFAULT_MINIMUM = 0;
    public static final int DEFAULT_MAXIMUM = 100;
    public static final int DEFAULT_STEP = 1;
    public static final int DEFAULT_REPEAT_DELAY = 300;
    public static final int DEFAULT_REPEAT_RATE = 70;
    private static final boolean SPIN_UP = true;
    private static final boolean SPIN_DOWN = false;
    protected boolean orientation = false;
    protected boolean arrowsOrientation = false;
    protected int minimum = 0;
    protected int maximum = 100;
    protected int step = 1;
    protected int value = 0;
    protected int repeatDelay = 300;
    protected int repeatRate = 70;
    protected RepeatThread rt = null;
    protected boolean running = false;
    protected boolean repeating = true;
    protected boolean runningDir = false;
    protected boolean boundsIgnored = false;
    private PropertyChangeSupport valueSupport = new PropertyChangeSupport(this);
    private Vector spinButtonListeners = new Vector(3, 3);

    public SpinButton() {
        this.setBackground(SystemColor.control);
        this.setForeground(SystemColor.controlText);
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                Dimension dimension = SpinButton.this.getSize();
                boolean bl = true;
                bl = SpinButton.this.orientation ? mouseEvent.getX() > (dimension.width - 1) / 2 : mouseEvent.getY() <= (dimension.height - 1) / 2;
                if ((bl && SpinButton.this.value >= SpinButton.this.maximum || !bl && SpinButton.this.value <= SpinButton.this.minimum) && !SpinButton.this.boundsIgnored) {
                    return;
                }
                SpinButton.this.switchRun(bl);
                SpinButton.this.repaint();
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                boolean bl = SpinButton.this.running;
                SpinButton.this.switchStop();
                if (bl) {
                    SpinButton.this.repaint();
                }
            }
        });
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        this.repaint();
    }

    public void setOrientation(boolean bl) {
        this.orientation = bl;
        this.switchStop();
        this.repaint();
    }

    public void setArrowsOrientation(boolean bl) {
        this.arrowsOrientation = bl;
        this.switchStop();
        this.repaint();
    }

    public boolean getOrientation() {
        return this.orientation;
    }

    public boolean getArrowsOrientation() {
        return this.arrowsOrientation;
    }

    public void setMinimum(int n) {
        this.minimum = n;
        if (this.maximum < this.minimum) {
            this.maximum = this.minimum;
        }
        if (this.value < this.minimum) {
            this.setValue(this.value);
        }
        this.switchStop();
        this.repaint();
    }

    public int getMinimum() {
        return this.minimum;
    }

    public void setMaximum(int n) {
        this.maximum = n;
        if (this.maximum < this.minimum) {
            this.minimum = this.maximum;
        }
        if (this.value > this.maximum) {
            this.setValue(this.value);
        }
        this.switchStop();
        this.repaint();
    }

    public int getMaximum() {
        return this.maximum;
    }

    public void setValue(int n) {
        int n2 = this.value;
        this.value = n;
        if (!this.boundsIgnored) {
            if (this.value < this.minimum) {
                this.value = this.minimum;
            }
            if (this.value > this.maximum) {
                this.value = this.maximum;
            }
        }
        if (this.value != n2) {
            this.valueSupport.firePropertyChange("value", new Integer(n2), new Integer(this.value));
        }
        if (this.getValue() == this.minimum || this.getValue() == this.maximum || n2 == this.minimum || n2 == this.maximum) {
            this.repaint();
        }
    }

    public int getValue() {
        return this.value;
    }

    public void setStep(int n) {
        this.step = n;
        this.switchStop();
        this.repaint();
    }

    public int getStep() {
        return this.step;
    }

    public void setDelay(int n) {
        this.repeatDelay = n;
        this.switchStop();
        this.repaint();
    }

    public int getDelay() {
        return this.repeatDelay;
    }

    public void setRate(int n) {
        this.repeatRate = n;
        this.switchStop();
        this.repaint();
    }

    public int getRate() {
        return this.repeatRate;
    }

    public boolean isBoundsIgnored() {
        return this.boundsIgnored;
    }

    public void setBoundsIgnored(boolean bl) {
        this.boundsIgnored = bl;
    }

    public boolean isRepeating() {
        return this.repeating;
    }

    public void setRepeating(boolean bl) {
        this.repeating = bl;
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        int n = 0;
        int n2 = 0;
        int n3 = dimension.width - 1;
        int n4 = dimension.height - 1;
        graphics.setColor(this.getBackground());
        graphics.fillRect(n, n2, n3, n4);
        if (this.orientation) {
            this.paintBorder(graphics, n, n2, n3 /= 2, n4, this.running && !this.runningDir, false);
            n += n3 + 1;
            n3 = dimension.width - 1 - n;
            this.paintBorder(graphics, n, n2, n3, n4, this.running && this.runningDir, true);
        } else {
            this.paintBorder(graphics, n, n2, n3, n4 /= 2, this.running && this.runningDir, true);
            n2 += n4 + 1;
            n4 = dimension.height - 1 - n2;
            this.paintBorder(graphics, n, n2, n3, n4, this.running && !this.runningDir, false);
        }
    }

    private void paintBorder(Graphics graphics, int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        graphics.setColor(Color.black);
        if (!bl) {
            graphics.drawLine(n, n2 + n4, n + n3, n2 + n4);
            graphics.drawLine(n + n3, n2, n + n3, n2 + n4);
        } else {
            graphics.drawLine(n, n2, n + n3, n2);
            graphics.drawLine(n, n2, n, n2 + n4);
            ++n;
            ++n2;
        }
        graphics.setColor(SystemColor.controlHighlight);
        graphics.draw3DRect(n, n2, --n3, --n4, !bl);
        this.paintArrow(graphics, n, n2, n3, n4, bl2);
    }

    private void paintArrow(Graphics graphics, int n, int n2, int n3, int n4, boolean bl) {
        if (n3 <= 0 || n4 <= 0) {
            return;
        }
        int n5 = n3 / 4;
        int n6 = n4 / 4;
        int[] nArray = new int[3];
        int[] nArray2 = new int[3];
        if (this.arrowsOrientation) {
            if (bl) {
                nArray[0] = n + n5;
                nArray[2] = n + n3 - n5;
            } else {
                nArray[0] = n + n3 - n5;
                nArray[2] = n + n5;
            }
            nArray[1] = nArray[0];
            nArray2[0] = n2 + n6;
            nArray2[1] = n2 + n4 - n6;
            nArray2[2] = n2 + n4 / 2;
        } else {
            if (bl) {
                nArray2[0] = n2 + n4 - n6;
                nArray2[2] = n2 + n6;
            } else {
                nArray2[0] = n2 + n6;
                nArray2[2] = n2 + n4 - n6;
            }
            nArray2[1] = nArray2[0];
            nArray[0] = n + n5;
            nArray[1] = n + n3 - n5;
            nArray[2] = n + n3 / 2;
        }
        if ((bl && this.value >= this.maximum || !bl && this.value <= this.minimum) && !this.boundsIgnored) {
            Color color = this.getForeground();
            Color color2 = this.getBackground();
            graphics.setColor(new Color((color.getRed() + 2 * color2.getRed()) / 3, (color.getGreen() + 2 * color2.getGreen()) / 3, (color.getBlue() + 2 * color2.getBlue()) / 3));
        } else {
            graphics.setColor(this.getForeground());
        }
        graphics.fillPolygon(nArray, nArray2, 3);
    }

    protected synchronized void switchRun(boolean bl) {
        if (this.running) {
            this.rt.finish = true;
        }
        this.rt = new RepeatThread();
        this.rt.start();
        this.runningDir = bl;
        this.running = true;
    }

    public synchronized void switchStop() {
        if (this.rt == null) {
            return;
        }
        this.rt.finish = true;
        this.running = false;
    }

    public Dimension getMinimumSize() {
        return this.countSize();
    }

    public Dimension getPreferredSize() {
        return this.countSize();
    }

    private Dimension countSize() {
        int n;
        int n2 = n = 11;
        if (this.orientation) {
            n += n;
        } else {
            n2 += n2;
        }
        return new Dimension(n, n2);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.valueSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.valueSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public void addSpinButtonListener(SpinButtonListener spinButtonListener) {
        this.spinButtonListeners.addElement(spinButtonListener);
    }

    public void removeSpinButtonListener(SpinButtonListener spinButtonListener) {
        this.spinButtonListeners.removeElement(spinButtonListener);
    }

    public void notifySpinButtonListenersAboutUpMove() {
        int n = this.spinButtonListeners.size();
        for (int i = 0; i < n; ++i) {
            ((SpinButtonListener)this.spinButtonListeners.elementAt(i)).moveUp();
        }
    }

    public void notifySpinButtonListenersAboutDownMove() {
        int n = this.spinButtonListeners.size();
        for (int i = 0; i < n; ++i) {
            ((SpinButtonListener)this.spinButtonListeners.elementAt(i)).moveDown();
        }
    }

    protected void repeatThreadNotify() {
        int n = this.getValue();
        if (this.runningDir) {
            this.setValue(this.getValue() + this.step);
            if (this.value != n) {
                this.notifySpinButtonListenersAboutUpMove();
            }
        } else {
            this.setValue(this.getValue() - this.step);
            if (this.value != n) {
                this.notifySpinButtonListenersAboutDownMove();
            }
        }
        if (this.getValue() == n && !this.boundsIgnored) {
            this.switchStop();
            this.repaint();
        }
    }

    class RepeatThread
    extends Thread {
        boolean finish = false;

        public void run() {
            SpinButton.this.repeatThreadNotify();
            try {
                RepeatThread.sleep(SpinButton.this.repeatDelay);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!SpinButton.this.repeating) {
                return;
            }
            while (!this.finish) {
                SpinButton.this.repeatThreadNotify();
                if (this.finish) break;
                try {
                    RepeatThread.sleep(SpinButton.this.repeatRate);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

