/*
 * Decompiled with CFR 0.152.
 */
package tr.util;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JButton;
import org.openide.windows.WindowManager;
import tr.util.DateChooser;

public class DateButton
extends JButton {
    public static final DateFormat DATE_FORMAT_FIXED;
    public static final DateFormat DATE_FORMAT;
    private final DateChooser dateChooser;
    private Date date;
    private String noSelectionText = "";
    public Component component = null;

    public DateButton() {
        Frame owner = WindowManager.getDefault().getMainWindow();
        this.dateChooser = new DateChooser(owner);
    }

    public DateButton(String title) {
        Frame owner = WindowManager.getDefault().getMainWindow();
        this.dateChooser = new DateChooser(owner, title);
    }

    public DateButton(Frame owner) {
        this.dateChooser = new DateChooser(owner);
    }

    public DateButton(Frame owner, String title) {
        this.dateChooser = new DateChooser(owner, title);
    }

    public DateButton(Dialog owner) {
        this.dateChooser = new DateChooser(owner);
    }

    public DateButton(Dialog owner, String title) {
        this.dateChooser = new DateChooser(owner, title);
    }

    public void setNoSelectionText(String text) {
        this.noSelectionText = text;
        this.setDate(this.date);
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        Date old = this.date;
        this.date = date;
        this.setText(date == null ? this.noSelectionText : DATE_FORMAT.format(date));
        this.firePropertyChange("date", old, date);
    }

    protected void fireActionPerformed(ActionEvent event) {
        Date newDate = null;
        newDate = this.component == null ? this.dateChooser.select(this.date, this) : this.dateChooser.select(this.date, this.component);
        if (!this.dateChooser.cancelled()) {
            this.setDate(newDate);
        }
    }

    static {
        DATE_FORMAT = DATE_FORMAT_FIXED = new SimpleDateFormat("EEE, d MMM yyyy");
    }
}

