/*
 * Decompiled with CFR 0.152.
 */
package tr.runtime;

import tr.runtime.Runtime;

public class Email {
    private Email() {
    }

    public static final void email(String to, String subject, String body) {
        if (Runtime.macosx) {
            to = Email.filterTo(to);
            subject = Email.filterSubject(subject);
            body = Email.filterBody(body);
            Runtime.exec(new String[]{"open", "mailto:" + to + "?subject=" + subject + "&body=" + body});
        } else if (Runtime.linux || Runtime.unix) {
            to = Email.filterToLinux(to);
            subject = Email.filterSubjectLinux(subject);
            body = Email.filterBodyLinux(body);
            String[] args = new String[]{"./xdg-email", "--subject", subject, "--body", body, to};
            Runtime.exec(args);
        } else if (Runtime.win95 || Runtime.win98) {
            to = Email.filterTo(to);
            subject = Email.filterSubject(subject);
            body = Email.filterBody(body);
            Runtime.exec(new String[]{"command.com", "/C", "start", "mailto:" + to + "?subject=" + subject + "\"&\"body=" + body});
        } else if (Runtime.windows) {
            to = Email.filterTo(to);
            subject = Email.filterSubject(subject);
            body = Email.filterBody(body);
            Runtime.exec(new String[]{"cmd.exe", "/C", "start", "mailto:" + to + "?subject=" + subject + "\"&\"body=" + body});
        } else {
            to = Email.filterTo(to);
            subject = Email.filterSubject(subject);
            body = Email.filterBody(body);
            Runtime.exec(new String[]{"email", "mailto:" + to + "?subject=" + subject + "&body=" + body});
        }
    }

    private static String filterTo(String to) {
        to = to.replaceAll("%", "");
        to = to.replaceAll("#", "");
        to = to.replaceAll("\\?", "");
        to = to.replaceAll("\\{", "");
        to = to.replaceAll("\\}", "");
        to = to.replaceAll("\\\\", "");
        to = to.replaceAll("\\|", "");
        to = to.replaceAll("\\^", "");
        to = to.replaceAll(" ", "%20");
        to = to.replaceAll("\t", "%20");
        to = to.replaceAll("\n", "%20");
        to = to.replaceAll("\f", "");
        to = to.replaceAll("\r", "");
        to = to.replaceAll("<", "");
        to = to.replaceAll(">", "");
        to = to.replaceAll("\"", "");
        to = to.replaceAll("&", "");
        to = to.replaceAll("'", "");
        to = to.replaceAll("`", "");
        return to;
    }

    private static String filterSubject(String subject) {
        subject = subject.replaceAll("%", "");
        subject = subject.replaceAll("#", "");
        subject = subject.replaceAll("\\?", "");
        subject = subject.replaceAll("\\{", "");
        subject = subject.replaceAll("\\}", "");
        subject = subject.replaceAll("\\\\", "");
        subject = subject.replaceAll("\\|", "");
        subject = subject.replaceAll("\\^", "");
        subject = subject.replaceAll(" ", "%20");
        subject = subject.replaceAll("\t", "%20");
        subject = subject.replaceAll("\n", "%20");
        subject = subject.replaceAll("\f", "");
        subject = subject.replaceAll("\r", "");
        subject = subject.replaceAll("<", "");
        subject = subject.replaceAll(">", "");
        subject = subject.replaceAll("\"", "");
        subject = subject.replaceAll("&", "");
        subject = subject.replaceAll("'", "");
        subject = subject.replaceAll("`", "");
        return subject;
    }

    private static String filterBody(String body) {
        body = body.replaceAll("%", "");
        body = body.replaceAll("#", "");
        body = body.replaceAll("\\?", "");
        body = body.replaceAll("\\{", "");
        body = body.replaceAll("\\}", "");
        body = body.replaceAll("\\\\", "");
        body = body.replaceAll("\\|", "");
        body = body.replaceAll("\\^", "");
        body = body.replaceAll(" ", "%20");
        body = body.replaceAll("\t", "%09");
        body = body.replaceAll("\n", "%0D");
        body = body.replaceAll("<", "");
        body = body.replaceAll(">", "");
        body = body.replaceAll("\"", "");
        body = body.replaceAll("&", "");
        body = body.replaceAll("'", "");
        body = body.replaceAll("`", "");
        return body;
    }

    private static String filterToLinux(String to) {
        to = to.replaceAll(" ", "");
        to = to.replaceAll("\t", "");
        to = to.replaceAll("\n", "");
        to = to.replaceAll("\f", "");
        to = to.replaceAll("\r", "");
        return to;
    }

    private static String filterSubjectLinux(String subject) {
        subject = subject.replaceAll("\t", " ");
        subject = subject.replaceAll("\n", " ");
        subject = subject.replaceAll("\f", " ");
        subject = subject.replaceAll("\r", " ");
        return subject;
    }

    private static String filterBodyLinux(String body) {
        return body;
    }
}

