/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.plaf.util;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.UIManager;

public final class UIUtils {
    private static HashMap hintsMap = null;
    private static final boolean noAntialias = Boolean.getBoolean("nb.no.antialias");
    private static boolean colorsReady = false;
    private static Boolean openideAvailable = null;
    private static Class utilsClass = null;
    private static Method utilsMethod = null;

    private UIUtils() {
    }

    public static boolean isWindowsLF() {
        if (Boolean.getBoolean("netbeans.winsys.forceclassic")) {
            return false;
        }
        String string = UIManager.getLookAndFeel().getID();
        return string.equals("Windows");
    }

    public static boolean isXPLF() {
        if (!UIUtils.isWindowsLF()) {
            return false;
        }
        Boolean bl = (Boolean)Toolkit.getDefaultToolkit().getDesktopProperty("win.xpstyle.themeActive");
        return bl == null ? false : bl;
    }

    public static final Map getHints() {
        if (hintsMap == null) {
            hintsMap = new HashMap();
            hintsMap.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            hintsMap.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        return hintsMap;
    }

    public static final void configureRenderingHints(Graphics graphics) {
        if (noAntialias) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.addRenderingHints(UIUtils.getHints());
    }

    public static Image loadImage(String string) {
        if (openideAvailable == null) {
            UIUtils.checkOpenide();
        }
        if (Boolean.TRUE.equals(openideAvailable)) {
            return UIUtils.loadWithUtilities(string);
        }
        return UIUtils.loadWithImageIO(string);
    }

    public static Color getMiddle(Color color, Color color2) {
        return new Color((color.getRed() + color2.getRed()) / 2, (color.getGreen() + color2.getGreen()) / 2, (color.getBlue() + color2.getBlue()) / 2);
    }

    private static void checkOpenide() {
        try {
            utilsClass = Class.forName("org.openide.util.Utilities");
            utilsMethod = utilsClass.getDeclaredMethod("loadImage", String.class);
            openideAvailable = Boolean.TRUE;
        }
        catch (Exception exception) {
            openideAvailable = Boolean.FALSE;
        }
    }

    private static Image loadWithUtilities(String string) {
        Image image = null;
        try {
            image = (Image)utilsMethod.invoke(null, string);
        }
        catch (Exception exception) {
            System.err.println("Error loading image " + string);
            exception.printStackTrace();
        }
        return image;
    }

    private static Image loadWithImageIO(String string) {
        BufferedImage bufferedImage = null;
        try {
            URL uRL = UIUtils.class.getResource(string);
            bufferedImage = ImageIO.read(uRL);
        }
        catch (Exception exception) {
            System.err.println("Error loading image using ImageIO " + string);
            exception.printStackTrace();
        }
        return bufferedImage;
    }

    public static GradientPaint getGradientPaint(float f, float f2, Color color, float f3, float f4, Color color2, boolean bl) {
        return new GradientPaint(f, f2, color, f3, f4, color2, bl);
    }

    public static Color adjustColor(Color color, int n, int n2, int n3) {
        int n4 = Math.max(0, Math.min(255, color.getRed() + n));
        int n5 = Math.max(0, Math.min(255, color.getGreen() + n2));
        int n6 = Math.max(0, Math.min(255, color.getBlue() + n3));
        return new Color(n4, n5, n6);
    }

    private static float minMax(float f) {
        return Math.max(0.0f, Math.min(1.0f, f));
    }

    public static boolean isBrighter(Color color, Color color2) {
        int[] nArray = new int[]{color.getRed(), color.getGreen(), color.getBlue()};
        int[] nArray2 = new int[]{color2.getRed(), color2.getGreen(), color2.getBlue()};
        int n = 0;
        for (int i = 0; i < 3; ++i) {
            int n2 = nArray[i] - nArray2[i];
            if (Math.abs(n2) <= Math.abs(n)) continue;
            n = n2;
        }
        return n > 0;
    }
}

