/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.plaf.aqua;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.netbeans.swing.plaf.aqua.ShapeGradientPaint;
import org.netbeans.swing.plaf.util.UIUtils;

public final class DropShadowBorder
implements Border {
    int offset = 7;
    private static final int[] xpoints = new int[5];
    private static final int[] ypoints = new int[5];
    static final Color DEFAULT_SHADOWLIGHT = new Color(255, 255, 255, 0);
    private Color shadowLight = DEFAULT_SHADOWLIGHT;
    private Color shadowDark = null;
    private static final Composite transparency = AlphaComposite.getInstance(3, 0.7f);
    private static final int WIDTH = 17;
    private static final int HEIGHT = 17;
    private static final int ARC = 12;
    private static final int GAP = 6;

    private Color getShadowLight() {
        return DEFAULT_SHADOWLIGHT;
    }

    private Color getShadowDark() {
        Color color = null;
        if (this.shadowDark == null) {
            color = UIManager.getColor("controlDkShadow");
            color = new Color(color.getRed(), color.getGreen(), color.getBlue(), 128);
        } else {
            color = this.shadowDark;
        }
        return color;
    }

    public Insets getBorderInsets(Component component) {
        return new Insets(1, 17, 22, 17);
    }

    public boolean isBorderOpaque() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        UIUtils.configureRenderingHints(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        Composite composite = graphics2D.getComposite();
        Paint paint = graphics2D.getPaint();
        try {
            Insets insets = this.getBorderInsets(component);
            int n5 = n2 + (n4 - (insets.bottom + insets.top)) + 6;
            int n6 = n + insets.left - 6;
            int n7 = n + n3 - insets.right + 6;
            int n8 = n2 + insets.top + 1;
            int n9 = n2 + (n4 - (insets.bottom + insets.top + 12));
            int n10 = n7 - 18;
            int n11 = n + insets.left + 12;
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo(n6, n8 + 27);
            generalPath.lineTo(n6, n9);
            generalPath.quadTo(n6, n5, n11, n5);
            generalPath.lineTo(n10, n5);
            generalPath.quadTo(n7, n5, n7, n9);
            generalPath.lineTo(n7, n8 + 27);
            generalPath.quadTo(n7, n8 + 22, n7 - 6, n8 + 18);
            generalPath.lineTo(n7 - 9, n8 + 5);
            generalPath.quadTo(n7 - 9, n8, n7 - 14, n8);
            generalPath.lineTo(n6 + 11, n8);
            generalPath.quadTo(n6 + 11, n8, n6 + 8, n8 + 3);
            generalPath.lineTo(n6 + 11, n8 + 16);
            generalPath.quadTo(n6, n8 + 21, n6, n8 + 26);
            generalPath.closePath();
            graphics.setColor(Color.WHITE);
            graphics2D.fill(generalPath);
            Area area = new Area(new Rectangle(n, n2, n3, n4));
            area.subtract(new Area(generalPath));
            graphics2D.setPaint(new ShapeGradientPaint(generalPath.getBounds(), this.getShadowDark(), this.getShadowLight()));
            graphics2D.fill(area);
            graphics.setColor(UIManager.getColor("controlShadow"));
            graphics2D.draw(generalPath);
        }
        finally {
            graphics2D.setComposite(composite);
            graphics2D.setPaint(paint);
        }
    }
}

