/*
 * Decompiled with CFR 0.152.
 */
package tr.archive;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Calendar;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.openide.util.NbBundle;
import tr.archive.Resources;
import tr.util.DateButton;

public class ArchiveDialog
extends JDialog {
    private JButton archiveButton;
    private JPanel buttonsPanel;
    private JButton cancelButton;
    private JPanel centerPanel;
    private DateButton dateButton;
    private JLabel dateHintLabel;
    private JLabel dateLabel;
    private JLabel jLabel1;
    private JButton pathButton;
    private JLabel pathHintLabel;
    private JLabel pathLabel;
    private JTextField pathText;
    public boolean archive;

    public ArchiveDialog(Frame parent, boolean modal, Date date, String path) {
        super(parent, modal);
        this.setDefaultCloseOperation(2);
        this.initComponents();
        this.dateButton.setDate(date);
        this.pathText.setText(path);
    }

    private void initComponents() {
        this.buttonsPanel = new JPanel();
        this.cancelButton = new JButton();
        this.archiveButton = new JButton();
        this.jLabel1 = new JLabel();
        this.centerPanel = new JPanel();
        this.dateLabel = new JLabel();
        this.dateButton = new DateButton((Dialog)this);
        this.pathLabel = new JLabel();
        this.pathText = new JTextField();
        this.pathText.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent arg0) {
                ArchiveDialog.this.enableDisableButtons();
            }

            public void insertUpdate(DocumentEvent arg0) {
                ArchiveDialog.this.enableDisableButtons();
            }

            public void removeUpdate(DocumentEvent arg0) {
                ArchiveDialog.this.enableDisableButtons();
            }
        });
        this.pathButton = new JButton();
        this.pathHintLabel = new JLabel();
        this.dateHintLabel = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle(Resources.getText("archive.title"));
        this.buttonsPanel.setLayout(new FlowLayout(2));
        this.cancelButton.setText(Resources.getText("button.cancel"));
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ArchiveDialog.this.cancelActionPerformed(evt);
            }
        });
        this.buttonsPanel.add(this.cancelButton);
        this.archiveButton.setText(Resources.getText("button.archive"));
        this.archiveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ArchiveDialog.this.archiveActionPerformed(evt);
            }
        });
        this.buttonsPanel.add(this.archiveButton);
        this.jLabel1.setText("    ");
        this.buttonsPanel.add(this.jLabel1);
        this.getContentPane().add((Component)this.buttonsPanel, "Last");
        this.centerPanel.setBorder(BorderFactory.createEtchedBorder());
        this.dateLabel.setText(Resources.getText("archive.date"));
        this.dateButton.setNoSelectionText("Select a date");
        this.dateButton.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                ArchiveDialog.this.datePropertyChange(evt);
            }
        });
        this.pathLabel.setText(Resources.getText("archive.folder"));
        this.pathButton.setText(Resources.getText("button.browse"));
        this.pathButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ArchiveDialog.this.browseButtonActionPerformed(evt);
            }
        });
        this.pathHintLabel.setFont(new Font("Lucida Grande", 2, 13));
        this.pathHintLabel.setForeground(UIManager.getDefaults().getColor("controlDkShadow"));
        this.pathHintLabel.setText(NbBundle.getMessage(ArchiveDialog.class, (String)"archive.folder.hint"));
        this.dateHintLabel.setFont(new Font("Lucida Grande", 2, 13));
        this.dateHintLabel.setForeground(UIManager.getDefaults().getColor("controlDkShadow"));
        this.dateHintLabel.setText(NbBundle.getMessage(ArchiveDialog.class, (String)"archive.date.hint"));
        GroupLayout centerPanelLayout = new GroupLayout((Container)this.centerPanel);
        this.centerPanel.setLayout((LayoutManager)centerPanelLayout);
        centerPanelLayout.setHorizontalGroup((GroupLayout.Group)centerPanelLayout.createParallelGroup(1).add((GroupLayout.Group)centerPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)centerPanelLayout.createParallelGroup(1).add((GroupLayout.Group)centerPanelLayout.createSequentialGroup().add((GroupLayout.Group)centerPanelLayout.createParallelGroup(2, false).add(1, (Component)this.pathLabel, -1, -1, Short.MAX_VALUE).add(1, (Component)this.dateLabel, -1, 99, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)centerPanelLayout.createParallelGroup(1).add((Component)this.dateButton, -2, 150, -2).add(2, (GroupLayout.Group)centerPanelLayout.createSequentialGroup().add((Component)this.pathText, -1, 394, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.pathButton))).addContainerGap()).add((GroupLayout.Group)centerPanelLayout.createSequentialGroup().add((Component)this.pathHintLabel, -1, -1, Short.MAX_VALUE).add(210, 210, 210)).add((Component)this.dateHintLabel, -1, 604, Short.MAX_VALUE))));
        centerPanelLayout.setVerticalGroup((GroupLayout.Group)centerPanelLayout.createParallelGroup(1).add((GroupLayout.Group)centerPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)centerPanelLayout.createParallelGroup(3).add((Component)this.dateLabel).add((Component)this.dateButton, -2, -1, -2)).add(0, 0, 0).add((Component)this.dateHintLabel).addPreferredGap(0).add((GroupLayout.Group)centerPanelLayout.createParallelGroup(3).add((Component)this.pathLabel).add((Component)this.pathText, -2, -1, -2).add((Component)this.pathButton)).add(0, 0, 0).add((Component)this.pathHintLabel).addContainerGap(29, Short.MAX_VALUE)));
        this.getContentPane().add((Component)this.centerPanel, "Center");
        this.pack();
    }

    private void datePropertyChange(PropertyChangeEvent evt) {
        this.enableDisableButtons();
    }

    private void enableDisableButtons() {
        this.archiveButton.setEnabled(this.isValidArchiveDate(this.getArchiveDate()) && this.isValidArchivePath(this.getArchivePath()));
    }

    private void cancelActionPerformed(ActionEvent evt) {
        this.archive = false;
        this.setVisible(false);
    }

    private void archiveActionPerformed(ActionEvent evt) {
        this.archive = true;
        this.setVisible(false);
    }

    private void browseButtonActionPerformed(ActionEvent evt) {
        JFileChooser fc = new JFileChooser();
        fc.setFileSelectionMode(1);
        fc.setSelectedFile(new File(this.pathText.getText()));
        int returnVal = fc.showOpenDialog(null);
        if (returnVal == 0) {
            try {
                this.pathText.setText(fc.getSelectedFile().getCanonicalPath());
            }
            catch (Exception ex) {
                this.pathText.setText("");
            }
        }
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.archive = false;
            super.setVisible(true);
        } else {
            super.setVisible(false);
            super.dispose();
        }
    }

    public boolean isValidArchiveDate(Date date) {
        if (date == null) {
            return false;
        }
        return date.before(Calendar.getInstance().getTime());
    }

    public Date getArchiveDate() {
        return this.dateButton.getDate();
    }

    public boolean isValidArchivePath(String path) {
        if (path == null || path.trim().equals("")) {
            return true;
        }
        try {
            File file = new File(path);
            return file.isDirectory() && file.canWrite();
        }
        catch (SecurityException ex) {
            return false;
        }
    }

    public String getArchivePath() {
        return this.pathText.getText().trim();
    }
}

