/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.openide.ErrorManager;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataObject;
import org.openide.loaders.MultiDataObject;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.WeakSet;
import org.openide.windows.CloneableOpenSupport;
import org.openide.windows.CloneableTopComponent;

public abstract class OpenSupport
extends CloneableOpenSupport {
    protected MultiDataObject.Entry entry;
    static /* synthetic */ Class class$org$openide$windows$CloneableOpenSupport;
    static /* synthetic */ Class class$org$openide$cookies$OpenCookie;
    static /* synthetic */ Class class$org$openide$cookies$EditorCookie;

    public OpenSupport(MultiDataObject.Entry entry) {
        this(entry, new Env(entry.getDataObject()));
    }

    protected OpenSupport(MultiDataObject.Entry entry, Env env) {
        super((CloneableOpenSupport.Env)env);
        this.entry = entry;
    }

    protected String messageOpening() {
        MultiDataObject multiDataObject = this.entry.getDataObject();
        return NbBundle.getMessage((Class)OpenSupport.class, (String)"CTL_ObjectOpen", (Object)multiDataObject.getName(), (Object)multiDataObject.getPrimaryFile().toString());
    }

    protected String messageOpened() {
        return NbBundle.getMessage((Class)OpenSupport.class, (String)"CTL_ObjectOpened");
    }

    final CloneableTopComponent.Ref allEditors() {
        return this.allEditors;
    }

    public static class Env
    implements CloneableOpenSupport.Env,
    Serializable,
    PropertyChangeListener,
    VetoableChangeListener {
        static final long serialVersionUID = -1934890789745432531L;
        private DataObject obj;
        private transient PropertyChangeSupport propSupp;
        private transient VetoableChangeSupport vetoSupp;
        private static final Map fsListenerMap = new WeakHashMap(30);
        private static final Object LOCK_SUPPORT = new Object();

        public Env(DataObject dataObject) {
            this.obj = dataObject;
            this.init();
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            this.init();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void init() {
            FileSystemNameListener fileSystemNameListener;
            FileSystem fileSystem;
            this.obj.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.obj));
            try {
                fileSystem = this.obj.getPrimaryFile().getFileSystem();
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                IllegalStateException illegalStateException = new IllegalStateException("FileSystem is invalid for " + this.obj.getPrimaryFile() + "!");
                ErrorManager.getDefault().annotate((Throwable)illegalStateException, (Throwable)fileStateInvalidException);
                throw illegalStateException;
            }
            boolean bl = false;
            Map map = fsListenerMap;
            synchronized (map) {
                Reference reference = (Reference)fsListenerMap.get(fileSystem);
                FileSystemNameListener fileSystemNameListener2 = fileSystemNameListener = reference == null ? null : (FileSystemNameListener)reference.get();
                if (fileSystemNameListener == null) {
                    fileSystemNameListener = new FileSystemNameListener();
                    fsListenerMap.put(fileSystem, new WeakReference<FileSystemNameListener>(fileSystemNameListener));
                    bl = true;
                }
            }
            if (bl) {
                fileSystem.addPropertyChangeListener((PropertyChangeListener)fileSystemNameListener);
                fileSystem.addVetoableChangeListener((VetoableChangeListener)fileSystemNameListener);
            }
            fileSystemNameListener.add(this);
        }

        protected final DataObject getDataObject() {
            return this.obj;
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.prop().addPropertyChangeListener(propertyChangeListener);
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.prop().removePropertyChangeListener(propertyChangeListener);
        }

        public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
            this.veto().addVetoableChangeListener(vetoableChangeListener);
        }

        public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
            this.veto().removeVetoableChangeListener(vetoableChangeListener);
        }

        public boolean isValid() {
            return this.getDataObject().isValid();
        }

        public boolean isModified() {
            return this.getDataObject().isModified();
        }

        public void markModified() throws IOException {
            this.getDataObject().setModified(true);
        }

        public void unmarkModified() {
            this.getDataObject().setModified(false);
        }

        public CloneableOpenSupport findCloneableOpenSupport() {
            Node.Cookie cookie = this.getDataObject().getCookie(class$org$openide$windows$CloneableOpenSupport == null ? (class$org$openide$windows$CloneableOpenSupport = OpenSupport.class$("org.openide.windows.CloneableOpenSupport")) : class$org$openide$windows$CloneableOpenSupport);
            if (cookie instanceof CloneableOpenSupport) {
                return (CloneableOpenSupport)cookie;
            }
            cookie = this.getDataObject().getCookie(class$org$openide$cookies$OpenCookie == null ? (class$org$openide$cookies$OpenCookie = OpenSupport.class$("org.openide.cookies.OpenCookie")) : class$org$openide$cookies$OpenCookie);
            if (cookie instanceof CloneableOpenSupport) {
                return (CloneableOpenSupport)cookie;
            }
            cookie = this.getDataObject().getCookie(class$org$openide$cookies$EditorCookie == null ? (class$org$openide$cookies$EditorCookie = OpenSupport.class$("org.openide.cookies.EditorCookie")) : class$org$openide$cookies$EditorCookie);
            if (cookie instanceof CloneableOpenSupport) {
                return (CloneableOpenSupport)cookie;
            }
            return null;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("modified".equals(propertyChangeEvent.getPropertyName())) {
                if (this.getDataObject().isModified()) {
                    this.getDataObject().addVetoableChangeListener(this);
                } else {
                    this.getDataObject().removeVetoableChangeListener(this);
                }
            }
            this.firePropertyChange(propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
        }

        public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
            this.fireVetoableChange(propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
        }

        protected void firePropertyChange(String string, Object object, Object object2) {
            this.prop().firePropertyChange(string, object, object2);
        }

        protected void fireVetoableChange(String string, Object object, Object object2) throws PropertyVetoException {
            this.veto().fireVetoableChange(string, object, object2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private PropertyChangeSupport prop() {
            Object object = LOCK_SUPPORT;
            synchronized (object) {
                if (this.propSupp == null) {
                    this.propSupp = new PropertyChangeSupport(this);
                }
                return this.propSupp;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private VetoableChangeSupport veto() {
            Object object = LOCK_SUPPORT;
            synchronized (object) {
                if (this.vetoSupp == null) {
                    this.vetoSupp = new VetoableChangeSupport(this);
                }
                return this.vetoSupp;
            }
        }
    }

    private static final class FileSystemNameListener
    implements PropertyChangeListener,
    VetoableChangeListener {
        private final Set environments = new WeakSet(30);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(Env env) {
            Set set = this.environments;
            synchronized (set) {
                this.environments.add(env);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("systemName".equals(propertyChangeEvent.getPropertyName())) {
                HashSet hashSet;
                Object object = this.environments;
                synchronized (object) {
                    hashSet = new HashSet(this.environments);
                }
                object = hashSet.iterator();
                while (object.hasNext()) {
                    Env env = (Env)object.next();
                    env.firePropertyChange("valid", Boolean.TRUE, Boolean.FALSE);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
            if ("systemName".equals(propertyChangeEvent.getPropertyName())) {
                HashSet hashSet;
                Object object = this.environments;
                synchronized (object) {
                    hashSet = new HashSet(this.environments);
                }
                object = hashSet.iterator();
                while (object.hasNext()) {
                    Env env = (Env)object.next();
                    env.fireVetoableChange("valid", Boolean.TRUE, Boolean.FALSE);
                }
            }
        }
    }

    private static final class Listener
    extends CloneableTopComponent.Ref {
        static final long serialVersionUID = -1934890789745432531L;
        private MultiDataObject.Entry entry;

        Listener() {
        }

        public Object readResolve() {
            MultiDataObject multiDataObject = this.entry.getDataObject();
            OpenSupport openSupport = (OpenSupport)((DataObject)multiDataObject).getCookie(class$org$openide$loaders$OpenSupport == null ? (class$org$openide$loaders$OpenSupport = OpenSupport.class$("org.openide.loaders.OpenSupport")) : class$org$openide$loaders$OpenSupport);
            if (openSupport == null) {
                return this;
            }
            return openSupport.allEditors();
        }
    }
}

