/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.beans.PropertyVetoException;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataLoader;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.DataObjectPool;
import org.openide.loaders.MultiDataObject;

public abstract class MultiFileLoader
extends DataLoader {
    static final long serialVersionUID = 1521919955690157343L;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected MultiFileLoader(Class clazz) {
        super(clazz);
    }

    protected MultiFileLoader(String string) {
        super(string);
    }

    protected final DataObject handleFindDataObject(FileObject fileObject, DataLoader.RecognizedFiles recognizedFiles) throws IOException {
        MultiDataObject multiDataObject;
        FileObject fileObject2 = this.findPrimaryFileImpl(fileObject);
        if (fileObject2 == null) {
            return null;
        }
        if (ERR_WILL_LOG) {
            ERR.log(1, ((Object)((Object)this)).getClass().getName() + " is accepting: " + fileObject);
        }
        try {
            multiDataObject = this.createMultiObject(fileObject2);
            if (ERR_WILL_LOG) {
                ERR.log(1, ((Object)((Object)this)).getClass().getName() + " created object for: " + fileObject + " obj: " + multiDataObject);
            }
        }
        catch (DataObjectExistsException dataObjectExistsException) {
            DataObject dataObject = dataObjectExistsException.getDataObject();
            if (ERR_WILL_LOG) {
                ERR.log(1, ((Object)((Object)this)).getClass().getName() + " object already exists for: " + fileObject + " obj: " + dataObject);
            }
            if (dataObject.getLoader() != this) {
                if (ERR_WILL_LOG) {
                    ERR.log(1, ((Object)((Object)this)).getClass().getName() + " loader is wrong: " + ((Object)((Object)dataObject.getLoader())).getClass().getName());
                }
                dataObject = this.checkCollision(dataObject, fileObject);
            }
            if (!(dataObject instanceof MultiDataObject)) {
                if (ERR_WILL_LOG) {
                    ERR.log(1, ((Object)((Object)this)).getClass().getName() + " object is not MultiDataObject: " + dataObject);
                }
                throw dataObjectExistsException;
            }
            multiDataObject = (MultiDataObject)dataObject;
        }
        if (multiDataObject.getLoader() != this) {
            if (ERR_WILL_LOG) {
                ERR.log(1, ((Object)((Object)this)).getClass().getName() + " wrong loader: " + ((Object)((Object)multiDataObject.getLoader())).getClass().getName());
            }
            return multiDataObject;
        }
        if (ERR_WILL_LOG) {
            ERR.log(1, ((Object)((Object)this)).getClass().getName() + " marking secondary entries");
        }
        multiDataObject.markSecondaryEntriesRecognized(recognizedFiles);
        if (ERR_WILL_LOG) {
            ERR.log(1, ((Object)((Object)this)).getClass().getName() + " register entry: " + fileObject);
        }
        MultiDataObject.Entry entry = multiDataObject.registerEntry(fileObject);
        if (ERR_WILL_LOG) {
            ERR.log(1, ((Object)((Object)this)).getClass().getName() + " success: " + entry);
        }
        return multiDataObject;
    }

    protected abstract FileObject findPrimaryFile(FileObject var1);

    protected abstract MultiDataObject createMultiObject(FileObject var1) throws DataObjectExistsException, IOException;

    protected abstract MultiDataObject.Entry createPrimaryEntry(MultiDataObject var1, FileObject var2);

    protected abstract MultiDataObject.Entry createSecondaryEntry(MultiDataObject var1, FileObject var2);

    DataObject checkCollision(DataObject dataObject, FileObject fileObject) {
        FileObject fileObject2 = dataObject.getPrimaryFile();
        DataObjectPool.getPOOL().revalidate(new HashSet<FileObject>(Collections.singleton(fileObject2)));
        DataObject dataObject2 = DataObjectPool.getPOOL().find(fileObject2);
        return dataObject2;
    }

    void checkConsistency(MultiDataObject multiDataObject) {
        FileObject fileObject = multiDataObject.getPrimaryFile();
        if (fileObject.equals(this.findPrimaryFileImpl(fileObject))) {
            return;
        }
        try {
            multiDataObject.setValid(false);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    void checkFiles(MultiDataObject multiDataObject) {
        FileObject fileObject = multiDataObject.getPrimaryFile();
        if (!$assertionsDisabled && fileObject == null) {
            throw new AssertionError((Object)("Object " + multiDataObject + " cannot have null primary file"));
        }
        FileObject fileObject2 = fileObject.getParent();
        if (!$assertionsDisabled && fileObject2 == null) {
            throw new AssertionError((Object)("Object " + multiDataObject + " cannot have null parent file"));
        }
        FileObject[] fileObjectArray = fileObject2.getChildren();
        for (int i = 0; i < fileObjectArray.length; ++i) {
            FileObject fileObject3 = this.findPrimaryFileImpl(fileObjectArray[i]);
            if (fileObject3 != fileObject) continue;
            try {
                DataObject.find(fileObjectArray[i]);
                continue;
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
        }
    }

    MultiDataObject.Entry createSecondaryEntryImpl(MultiDataObject multiDataObject, FileObject fileObject) {
        return this.createSecondaryEntry(multiDataObject, fileObject);
    }

    FileObject findPrimaryFileImpl(FileObject fileObject) {
        return this.findPrimaryFile(fileObject);
    }

    static {
        $assertionsDisabled = !MultiFileLoader.class.desiredAssertionStatus();
    }
}

