/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.openide.ErrorManager;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.FolderList;
import org.openide.loaders.FolderListListener;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;
import org.openide.util.WeakListeners;

public abstract class FolderInstance
extends Task
implements InstanceCookie {
    private static final RequestProcessor PROCESSOR = new RequestProcessor("Folder Instance Processor");
    private static final ThreadLocal CURRENT = new ThreadLocal();
    private static final ThreadLocal LAST_CURRENT = new ThreadLocal();
    protected DataFolder folder;
    private DataObject.Container container;
    private HashMap map = new HashMap(17);
    private Task[] waitFor;
    private Object object = CURRENT;
    private Listener listener;
    private ErrorManager err;
    private Task recognizingTask;
    private Task creationTask;
    static /* synthetic */ Class class$org$openide$util$TaskListener;

    public FolderInstance(DataFolder dataFolder) {
        this((DataObject.Container)dataFolder);
    }

    public FolderInstance(DataObject.Container container) {
        this(container, null);
    }

    private FolderInstance(DataObject.Container container, String string) {
        if (container instanceof DataFolder) {
            this.folder = (DataFolder)container;
            if (string == null) {
                string = this.folder.getPrimaryFile().getPath().replace('/', '.');
            }
            container = FolderList.find(this.folder.getPrimaryFile(), true);
        }
        this.listener = new Listener();
        string = string == null ? "org.openide.loaders.FolderInstance" : "org.openide.loaders.FolderInstance." + string;
        this.err = ErrorManager.getDefault().getInstance(string);
        this.container = container;
        container.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.listener, (Object)container));
        if (this.err.isLoggable(1)) {
            this.err.log("new " + (Object)((Object)this));
        }
    }

    public String instanceName() {
        try {
            return this.instanceClass().getName();
        }
        catch (IOException iOException) {
            return "java.lang.Object";
        }
        catch (ClassNotFoundException classNotFoundException) {
            return "java.lang.Object";
        }
    }

    public Class instanceClass() throws IOException, ClassNotFoundException {
        Object object = this.object;
        if (object != null) {
            if (object instanceof IOException) {
                throw (IOException)object;
            }
            if (object instanceof ClassNotFoundException) {
                throw (ClassNotFoundException)object;
            }
            return object.getClass();
        }
        return Object.class;
    }

    public Object instanceCreate() throws IOException, ClassNotFoundException {
        Object object = CURRENT.get();
        if (object == null || LAST_CURRENT.get() != this) {
            this.err.log("do into waitFinished");
            this.waitFinished();
            object = this.object;
        }
        if (this.err.isLoggable(1)) {
            this.err.log("instanceCreate: " + object);
        }
        if (object instanceof IOException) {
            throw (IOException)object;
        }
        if (object instanceof ClassNotFoundException) {
            throw (ClassNotFoundException)object;
        }
        if (object == CURRENT) {
            throw new IOException("Cyclic reference. Somebody is trying to get value from FolderInstance (" + ((Object)((Object)this)).getClass().getName() + ") from the same thread that is processing the instance");
        }
        return object;
    }

    public final void instanceFinished() {
        this.waitFinished();
    }

    public void waitFinished() {
        Task task;
        boolean bl = this.err.isLoggable(1);
        do {
            this.err.log("waitProcessingFinished on container");
            FolderInstance.waitProcessingFinished(this.container);
            task = this.checkRecognizingStarted();
            if (bl) {
                this.err.log("checkRecognizingStarted: " + task);
            }
            task.waitFinished();
            Task task2 = this.creationTask;
            if (bl) {
                this.err.log("creationTask: " + this.creationTask);
            }
            if (task2 != null) {
                task2.waitFinished();
            }
            Task[] taskArray = this.waitFor;
            if (bl) {
                this.err.log("toWait: " + taskArray);
            }
            if (taskArray == null) continue;
            for (int i = 0; i < taskArray.length; ++i) {
                if (bl) {
                    this.err.log("  wait[" + i + "]: " + taskArray[i]);
                }
                taskArray[i].waitFinished();
            }
        } while (task != this.checkRecognizingStarted());
        this.err.log("breaking the wait loop");
    }

    public void run() {
        this.recreate();
        this.instanceFinished();
    }

    protected InstanceCookie acceptDataObject(DataObject dataObject) {
        DataObject.Container container;
        int n = -1;
        Object object = (InstanceCookie)dataObject.getCookie(InstanceCookie.class);
        try {
            object = object == null ? null : this.acceptCookie((InstanceCookie)object);
            n = 1;
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(1, (Throwable)iOException);
            object = null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            ErrorManager.getDefault().notify(1, (Throwable)classNotFoundException);
            object = null;
        }
        if (object == null && (container = (DataFolder)dataObject.getCookie(DataFolder.class)) != null) {
            HoldInstance holdInstance = (HoldInstance)this.map.get(((DataObject)((Object)container)).getPrimaryFile());
            if (holdInstance != null && holdInstance.cookie != null) {
                object = holdInstance;
                n = 2;
            } else {
                object = this.acceptFolder((DataFolder)container);
                n = 3;
            }
        }
        if (object == null && (container = (DataObject.Container)dataObject.getCookie(DataObject.Container.class)) != null) {
            object = this.acceptContainer(container);
            n = 4;
        }
        if (this.err.isLoggable(1)) {
            this.err.log(1, "acceptDataObject: " + dataObject + " cookie: " + object + " acceptType: " + n);
        }
        return object;
    }

    protected InstanceCookie acceptCookie(InstanceCookie instanceCookie) throws IOException, ClassNotFoundException {
        return instanceCookie;
    }

    protected InstanceCookie acceptFolder(DataFolder dataFolder) {
        return this.acceptContainer(dataFolder);
    }

    protected InstanceCookie acceptContainer(DataObject.Container container) {
        return null;
    }

    protected abstract Object createInstance(InstanceCookie[] var1) throws IOException, ClassNotFoundException;

    protected Object instanceForCookie(DataObject dataObject, InstanceCookie instanceCookie) throws IOException, ClassNotFoundException {
        return instanceCookie.instanceCreate();
    }

    public synchronized void recreate() {
        this.err.log("recreate");
        this.recognizingTask = FolderInstance.computeChildrenList(this.container, this.listener);
        if (this.err.isLoggable(1)) {
            this.err.log("  recognizing task is now " + this.recognizingTask);
        }
        this.notifyRunning();
    }

    final void checkRecreate() {
        if (this.isFinished()) {
            this.recreate();
        }
    }

    private final synchronized Task checkRecognizingStarted() {
        if (this.recognizingTask == null) {
            this.recreate();
        }
        return this.recognizingTask;
    }

    private static void waitProcessingFinished(DataObject.Container container) {
        if (container instanceof FolderList) {
            ((FolderList)container).waitProcessingFinished();
        }
    }

    private static Task computeChildrenList(final DataObject.Container container, final FolderListListener folderListListener) {
        if (container instanceof FolderList) {
            FolderList folderList = (FolderList)container;
            return folderList.computeChildrenList(folderListListener);
        }
        return PROCESSOR.post(new Runnable(){

            public void run() {
                DataObject[] dataObjectArray = container.getChildren();
                ArrayList arrayList = new ArrayList(dataObjectArray.length);
                for (int i = 0; i < dataObjectArray.length; ++i) {
                    folderListListener.process(dataObjectArray[i], arrayList);
                }
                folderListListener.finished(arrayList);
            }
        });
    }

    final void processObjects(final Collection collection) {
        this.creationTask = this.postCreationTask(new Runnable(){

            public void run() {
                FolderInstance.this.defaultProcessObjects(collection);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final void defaultProcessObjects(Collection collection) {
        Object object;
        Object object2;
        HashSet hashSet;
        this.err.log("defaultProcessObjects");
        ArrayList<HoldInstance> arrayList = new ArrayList<HoldInstance>();
        Object object3 = CURRENT;
        synchronized (object3) {
            hashSet = new HashSet(this.map.keySet());
        }
        object3 = collection.iterator();
        while (object3.hasNext()) {
            HoldInstance holdInstance;
            Object object4;
            object2 = (DataObject)object3.next();
            if (!object2.isValid()) continue;
            object = this.acceptDataObject((DataObject)object2);
            if (object != null) {
                object4 = object2.getPrimaryFile();
                boolean bl = true;
                holdInstance = null;
                if (hashSet.remove(object4) && (holdInstance = (HoldInstance)this.map.get(object4)) != null && (holdInstance.cookie == null || !holdInstance.cookie.equals(object))) {
                    holdInstance = null;
                    bl = false;
                }
                if (holdInstance == null) {
                    HoldInstance holdInstance2 = object instanceof HoldInstance ? (HoldInstance)object : new HoldInstance((DataObject)object2, (InstanceCookie)object);
                    ThreadLocal threadLocal = CURRENT;
                    synchronized (threadLocal) {
                        this.map.put(object4, holdInstance2);
                    }
                    if (bl) {
                        object2.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.listener, (Object)object2));
                    }
                    arrayList.add(holdInstance2);
                    continue;
                }
                arrayList.add(holdInstance);
                continue;
            }
            object4 = CURRENT;
            synchronized (object4) {
                FileObject fileObject = object2.getPrimaryFile();
                hashSet.remove(fileObject);
                holdInstance = (HoldInstance)this.map.get(fileObject);
                if (holdInstance != null && holdInstance.cookie == null) {
                    continue;
                }
                holdInstance = new HoldInstance((DataObject)object2, null);
                this.map.put(fileObject, holdInstance);
            }
            object2.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.listener, (Object)object2));
        }
        object2 = CURRENT;
        synchronized (object2) {
            this.map.keySet().removeAll(hashSet);
        }
        object2 = new HoldInstance[arrayList.size()];
        arrayList.toArray((T[])object2);
        this.updateWaitFor((HoldInstance[])object2);
        object = null;
        object = this.createInstance((InstanceCookie[])object2);
        Object var16_19 = null;
        if (this.err.isLoggable(1)) {
            this.err.log("notifying finished");
            for (int i = 0; i < ((HoldInstance[])object2).length; ++i) {
                this.err.log("  #" + i + ": " + object2[i]);
            }
        }
        this.object = object;
        Object t = CURRENT.get();
        CURRENT.set(object);
        Object t2 = LAST_CURRENT.get();
        LAST_CURRENT.set(this);
        try {
            this.notifyFinished();
        }
        finally {
            CURRENT.set(t);
            LAST_CURRENT.set(t2);
        }
        {
            catch (IOException iOException) {
                object = iOException;
                Object var16_20 = null;
                if (this.err.isLoggable(1)) {
                    this.err.log("notifying finished");
                    for (int i = 0; i < ((HoldInstance[])object2).length; ++i) {
                        this.err.log("  #" + i + ": " + object2[i]);
                    }
                }
                this.object = object;
                Object t3 = CURRENT.get();
                CURRENT.set(object);
                Object t4 = LAST_CURRENT.get();
                LAST_CURRENT.set(this);
                try {
                    this.notifyFinished();
                }
                finally {
                    CURRENT.set(t3);
                    LAST_CURRENT.set(t4);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                object = classNotFoundException;
                Object var16_21 = null;
                if (this.err.isLoggable(1)) {
                    this.err.log("notifying finished");
                    for (int i = 0; i < ((HoldInstance[])object2).length; ++i) {
                        this.err.log("  #" + i + ": " + object2[i]);
                    }
                }
                this.object = object;
                Object t5 = CURRENT.get();
                CURRENT.set(object);
                Object t6 = LAST_CURRENT.get();
                LAST_CURRENT.set(this);
                try {
                    this.notifyFinished();
                }
                finally {
                    CURRENT.set(t5);
                    LAST_CURRENT.set(t6);
                }
            }
        }
        catch (Throwable throwable) {
            Object var16_22 = null;
            if (this.err.isLoggable(1)) {
                this.err.log("notifying finished");
                for (int i = 0; i < ((HoldInstance[])object2).length; ++i) {
                    this.err.log("  #" + i + ": " + object2[i]);
                }
            }
            this.object = object;
            Object t7 = CURRENT.get();
            CURRENT.set(object);
            Object t8 = LAST_CURRENT.get();
            LAST_CURRENT.set(this);
            try {
                this.notifyFinished();
            }
            finally {
                CURRENT.set(t7);
                LAST_CURRENT.set(t8);
            }
            throw throwable;
        }
    }

    private void updateWaitFor(HoldInstance[] holdInstanceArray) {
        ArrayList<Task> arrayList = new ArrayList<Task>(holdInstanceArray.length);
        for (int i = 0; i < holdInstanceArray.length; ++i) {
            Task task = holdInstanceArray[i].getTask();
            if (task == null) continue;
            arrayList.add(task);
        }
        this.waitFor = arrayList.toArray(new Task[arrayList.size()]);
    }

    protected Task postCreationTask(Runnable runnable) {
        return PROCESSOR.post(runnable);
    }

    final ErrorManager err() {
        return this.err;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getName() + "@" + Integer.toHexString(System.identityHashCode((Object)this)) + "(" + this.container + ")";
    }

    private class HoldInstance
    implements InstanceCookie.Of,
    TaskListener {
        private final DataObject source;
        protected final InstanceCookie cookie;

        public HoldInstance(DataObject dataObject, InstanceCookie instanceCookie) {
            this.cookie = instanceCookie;
            this.source = dataObject;
            if (instanceCookie instanceof Task) {
                Task task = (Task)instanceCookie;
                task.addTaskListener((TaskListener)WeakListeners.create((Class)(class$org$openide$util$TaskListener == null ? (class$org$openide$util$TaskListener = FolderInstance.class$("org.openide.util.TaskListener")) : class$org$openide$util$TaskListener), (EventListener)((Object)this), (Object)task));
            }
        }

        public String instanceName() {
            return this.cookie.instanceName();
        }

        public boolean instanceOf(Class clazz) {
            if (this.cookie instanceof InstanceCookie.Of) {
                InstanceCookie.Of of = (InstanceCookie.Of)this.cookie;
                return of.instanceOf(clazz);
            }
            try {
                Class clazz2 = this.cookie.instanceClass();
                return clazz.isAssignableFrom(clazz2);
            }
            catch (IOException iOException) {
                return false;
            }
            catch (ClassNotFoundException classNotFoundException) {
                return false;
            }
        }

        public Class instanceClass() throws IOException, ClassNotFoundException {
            return this.cookie.instanceClass();
        }

        public Object instanceCreate() throws IOException, ClassNotFoundException {
            return FolderInstance.this.instanceForCookie(this.source, this.cookie);
        }

        public void taskFinished(Task task) {
            FolderInstance.this.checkRecreate();
        }

        public Task getTask() {
            if (this.cookie instanceof Task) {
                return (Task)this.cookie;
            }
            return null;
        }
    }

    private class Listener
    implements PropertyChangeListener,
    FolderListListener {
        Listener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Object object = propertyChangeEvent.getSource();
            if (object == FolderInstance.this.container) {
                if ("children".equals(propertyChangeEvent.getPropertyName())) {
                    FolderInstance.this.err.log("PROP_CHILDREN");
                    FolderInstance.this.recreate();
                }
                return;
            }
            if ("name".equals(propertyChangeEvent.getPropertyName()) && object instanceof DataObject) {
                FolderInstance.this.err.log("PROP_NAME");
                FolderInstance.this.recreate();
            }
            if ("cookie".equals(propertyChangeEvent.getPropertyName()) && object instanceof DataObject) {
                HoldInstance holdInstance;
                DataObject dataObject = (DataObject)object;
                FolderInstance.this.err.log("PROP_COOKIE: " + dataObject);
                InstanceCookie instanceCookie = FolderInstance.this.acceptDataObject(dataObject);
                FileObject fileObject = dataObject.getPrimaryFile();
                ThreadLocal threadLocal = CURRENT;
                synchronized (threadLocal) {
                    holdInstance = (HoldInstance)FolderInstance.this.map.get(fileObject);
                }
                if (holdInstance != null) {
                    FolderInstance.this.err.log("previous instance: " + holdInstance + " new instance " + instanceCookie);
                    if (instanceCookie == null || instanceCookie != holdInstance && !instanceCookie.equals(holdInstance.cookie)) {
                        holdInstance = new HoldInstance(dataObject, instanceCookie);
                        threadLocal = CURRENT;
                        synchronized (threadLocal) {
                            FolderInstance.this.map.put(fileObject, holdInstance);
                        }
                        FolderInstance.this.recreate();
                    }
                }
            }
        }

        public void finished(List list) {
            FolderInstance.this.processObjects(list);
        }

        public void process(DataObject dataObject, List list) {
            list.add(dataObject);
        }
    }
}

