/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.beans.PropertyVetoException;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.ErrorManager;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataLoader;
import org.openide.loaders.DataLoaderPool;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.FolderList;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.loaders.OperationEvent;
import org.openide.loaders.ShadowChangeAdapter;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.WeakSet;

final class DataObjectPool
implements ChangeListener {
    private static final ThreadLocal FIND = new ThreadLocal();
    private static final Validator VALIDATOR = new Validator();
    private static final List TOKEN = Collections.unmodifiableList(new ArrayList());
    private HashMap map = new HashMap(512);
    private WeakSet knownFileSystems = new WeakSet();
    private static final ErrorManager err = ErrorManager.getDefault().getInstance("org.openide.loaders.DataObject.find");
    private static final boolean errLog = err.isLoggable(1);
    private static DataObjectPool POOL;
    private static Object lockPOOL;
    private volatile long inWaitNotified = -1L;
    private Thread atomic;
    private RequestProcessor priviledged;
    private FileObject blocked;
    private HashSet toNotify = new HashSet();
    private static final Integer ONE;
    private final Map registrationCounts = new WeakHashMap();
    private static final DataLoaderPool lp;
    private static final ErrorManager LISTENER;
    private static final boolean WILL_LOG_LISTENER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static DataObjectPool getPOOL() {
        Object object = lockPOOL;
        synchronized (object) {
            if (POOL != null) {
                return POOL;
            }
            POOL = new DataObjectPool();
        }
        lp.addChangeListener(POOL);
        return POOL;
    }

    private static Collection enterAllowContructor() {
        Collection collection = (Collection)FIND.get();
        FIND.set(TOKEN);
        return collection;
    }

    private static void exitAllowConstructor(Collection collection) {
        List list = (List)FIND.get();
        FIND.set(collection);
        if (list != TOKEN) {
            DataObjectPool.getPOOL().notifyCreationAll(list);
        }
    }

    static final boolean isConstructorAllowed() {
        return FIND.get() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DataObject handleFindDataObject(DataLoader dataLoader, FileObject fileObject, DataLoader.RecognizedFiles recognizedFiles) throws IOException {
        DataObject dataObject;
        Collection collection = DataObjectPool.enterAllowContructor();
        try {
            DataObjectPool.getPOOL().enterRecognition(fileObject);
            dataObject = dataLoader.handleFindDataObject(fileObject, recognizedFiles);
        }
        finally {
            DataObjectPool.exitAllowConstructor(collection);
        }
        return dataObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MultiDataObject createMultiObject(MultiFileLoader multiFileLoader, FileObject fileObject) throws IOException {
        MultiDataObject multiDataObject;
        Collection collection = DataObjectPool.enterAllowContructor();
        try {
            multiDataObject = multiFileLoader.createMultiObject(fileObject);
        }
        finally {
            DataObjectPool.exitAllowConstructor(collection);
        }
        return multiDataObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MultiDataObject createMultiObject(DataLoaderPool.FolderLoader folderLoader, FileObject fileObject, DataFolder dataFolder) throws IOException {
        MultiDataObject multiDataObject;
        Collection collection = DataObjectPool.enterAllowContructor();
        try {
            multiDataObject = folderLoader.createMultiObject(fileObject, dataFolder);
        }
        finally {
            DataObjectPool.exitAllowConstructor(collection);
        }
        return multiDataObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runAtomicActionSimple(FileObject fileObject, FileSystem.AtomicAction atomicAction) throws IOException {
        Collection collection = DataObjectPool.enterAllowContructor();
        try {
            fileObject.getFileSystem().runAtomicAction(atomicAction);
        }
        finally {
            DataObjectPool.exitAllowConstructor(collection);
        }
    }

    public void runAtomicAction(FileObject fileObject, FileSystem.AtomicAction atomicAction) throws IOException {
        class WrapAtomicAction
        implements FileSystem.AtomicAction {
            private final /* synthetic */ FileObject val$target;
            private final /* synthetic */ FileSystem.AtomicAction val$action;

            WrapAtomicAction(FileObject fileObject, FileSystem.AtomicAction atomicAction) {
                this.val$target = fileObject;
                this.val$action = atomicAction;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() throws IOException {
                FileObject fileObject;
                Thread thread;
                Object object = DataObjectPool.this;
                synchronized (object) {
                    DataObjectPool.this.enterRecognition(null);
                    thread = DataObjectPool.this.atomic;
                    fileObject = DataObjectPool.this.blocked;
                    DataObjectPool.this.atomic = Thread.currentThread();
                    DataObjectPool.this.blocked = this.val$target;
                }
                object = DataObjectPool.enterAllowContructor();
                try {
                    this.val$action.run();
                }
                finally {
                    DataObjectPool dataObjectPool = DataObjectPool.this;
                    synchronized (dataObjectPool) {
                        DataObjectPool.this.atomic = thread;
                        DataObjectPool.this.blocked = fileObject;
                        DataObjectPool.this.notifyAll();
                    }
                    DataObjectPool.exitAllowConstructor((Collection)object);
                }
            }
        }
        fileObject.getFileSystem().runAtomicAction((FileSystem.AtomicAction)new WrapAtomicAction(fileObject, atomicAction));
    }

    public synchronized void enterPriviledgedProcessor(RequestProcessor requestProcessor) {
        if (this.atomic == Thread.currentThread()) {
            if (this.priviledged != null) {
                throw new IllegalStateException("Previous priviledged is not null: " + this.priviledged + " now: " + requestProcessor);
            }
            this.priviledged = requestProcessor;
        }
        this.notifyAll();
    }

    public synchronized void exitPriviledgedProcessor(RequestProcessor requestProcessor) {
        if (this.atomic == Thread.currentThread()) {
            if (this.priviledged != requestProcessor) {
                throw new IllegalStateException("Trying to unregister wrong priviledged. Prev: " + this.priviledged + " now: " + requestProcessor);
            }
            this.priviledged = null;
        }
        this.notifyAll();
    }

    private synchronized void enterRecognition(FileObject fileObject) {
        while (!(this.atomic == null || this.atomic == Thread.currentThread() || this.priviledged != null && this.priviledged.isRequestProcessorThread() || fileObject != null && this.blocked != null && !this.blocked.equals(fileObject.getParent()))) {
            if (errLog) {
                err.log(1, "Enter recognition block: " + Thread.currentThread());
                err.log(1, "            waiting for: " + fileObject);
                err.log(1, "        blocking thread: " + this.atomic);
                err.log(1, "             blocked on: " + this.blocked);
            }
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private DataObjectPool() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataObject find(FileObject fileObject) {
        DataObjectPool dataObjectPool = this;
        synchronized (dataObjectPool) {
            List list;
            Item item = (Item)this.map.get(fileObject);
            if (item == null) {
                return null;
            }
            if (this.toNotify.contains(item) && ((list = (List)FIND.get()) == null || !list.contains(item))) {
                return null;
            }
            return item.getDataObjectOrNull();
        }
    }

    void countRegistration(FileObject fileObject) {
        Integer n = (Integer)this.registrationCounts.get(fileObject);
        Integer n2 = n == null ? ONE : new Integer(n + 1);
        this.registrationCounts.put(fileObject, n2);
    }

    int registrationCount(FileObject fileObject) {
        Integer n = (Integer)this.registrationCounts.get(fileObject);
        if (n == null) {
            return 0;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshAllFolders() {
        HashSet hashSet;
        Object object = this;
        synchronized (object) {
            hashSet = new HashSet(this.map.keySet());
        }
        object = hashSet.iterator();
        while (object.hasNext()) {
            DataObject dataObject;
            FileObject fileObject = (FileObject)object.next();
            if (!fileObject.isFolder() || !((dataObject = this.find(fileObject)) instanceof DataFolder)) continue;
            DataFolder dataFolder = (DataFolder)dataObject;
            FileObject fileObject2 = dataFolder.getPrimaryFile();
            DataObjectPool dataObjectPool = this;
            synchronized (dataObjectPool) {
                if (this.toNotify.isEmpty() || !this.toNotify.contains((Item)this.map.get(fileObject2))) {
                    FolderList.changedDataSystem(fileObject2);
                }
            }
        }
    }

    public Set revalidate(Set set) {
        return VALIDATOR.revalidate(set);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set revalidate() {
        Set set;
        DataObjectPool dataObjectPool = this;
        synchronized (dataObjectPool) {
            set = DataObjectPool.createSetOfAllFiles(this.map.values());
        }
        return this.revalidate(set);
    }

    public void notifyCreation(DataObject dataObject) {
        this.notifyCreation(dataObject.item);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyCreation(Item item) {
        Object object = this;
        synchronized (object) {
            if (errLog) {
                err.log(1, "Notify created: " + item + " by " + Thread.currentThread());
            }
            if (this.toNotify.isEmpty()) {
                if (errLog) {
                    err.log(1, "  but toNotify is empty");
                }
                return;
            }
            if (!this.toNotify.remove(item)) {
                if (errLog) {
                    err.log(1, "  the item is not there: " + this.toNotify);
                }
                return;
            }
            this.notifyAll();
        }
        object = item.getDataObjectOrNull();
        if (object != null) {
            lp.fireOperationEvent(new OperationEvent((DataObject)object), 7);
        }
    }

    private void notifyCreationAll(List list) {
        if (list.isEmpty()) {
            return;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Item item = (Item)iterator.next();
            this.notifyCreation(item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void waitNotified(DataObject dataObject) {
        while (true) {
            DataObjectPool dataObjectPool = this;
            synchronized (dataObjectPool) {
                try {
                    this.enterRecognition(dataObject.getPrimaryFile().getParent());
                    if (this.toNotify.isEmpty()) {
                        return;
                    }
                    List list = (List)FIND.get();
                    if (list != null && list.contains(dataObject.item)) {
                        return;
                    }
                    if (!this.toNotify.contains(dataObject.item)) {
                        return;
                    }
                    if (errLog) {
                        err.log(1, "waitTillNotified: " + Thread.currentThread());
                        err.log(1, "      waitingFor: " + dataObject.getPrimaryFile().getPath());
                    }
                    if (FolderList.isFolderRecognizerThread()) {
                        this.inWaitNotified = System.currentTimeMillis();
                    }
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                }
                finally {
                    if (FolderList.isFolderRecognizerThread()) {
                        this.inWaitNotified = -1L;
                    }
                }
            }
        }
    }

    final long timeInWaitNotified() {
        long l = this.inWaitNotified;
        if (l == -1L) {
            return -1L;
        }
        l = System.currentTimeMillis() - l;
        if (l < 0L) {
            l = 0L;
        }
        return l;
    }

    private void notifyAdd(Item item) {
        this.toNotify.add(item);
        ArrayList<Item> arrayList = (ArrayList<Item>)FIND.get();
        if (arrayList == TOKEN) {
            arrayList = new ArrayList<Item>();
            FIND.set(arrayList);
        }
        arrayList.add(item);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Item register(FileObject fileObject, DataLoader dataLoader) throws DataObjectExistsException {
        Object object;
        Object object2;
        if (FIND.get() == null) {
            throw new IllegalStateException("DataObject constructor can be called only thru DataObject.find - use that method");
        }
        try {
            object2 = fileObject.getFileSystem();
            object = this.knownFileSystems;
            synchronized (object) {
                if (!this.knownFileSystems.contains(object2)) {
                    object2.addFileChangeListener((FileChangeListener)new FSListener());
                    this.knownFileSystems.add(object2);
                }
            }
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            // empty catch block
        }
        DataObjectPool dataObjectPool = this;
        synchronized (dataObjectPool) {
            object2 = (Item)this.map.get(fileObject);
            if (object2 == null) {
                object2 = new Item(fileObject);
                this.map.put(fileObject, object2);
                this.countRegistration(fileObject);
                this.notifyAdd((Item)object2);
                VALIDATOR.notifyRegistered(fileObject);
                return object2;
            }
            object = ((Item)object2).getDataObjectOrNull();
            if (object == null) {
                object2 = new Item(fileObject);
                this.map.put(fileObject, object2);
                this.countRegistration(fileObject);
                this.notifyAdd((Item)object2);
                return object2;
            }
            if (!VALIDATOR.reregister((DataObject)object, dataLoader)) {
                throw new DataObjectExistsException((DataObject)object);
            }
        }
        try {
            ((DataObject)object).setValid(false);
            dataObjectPool = this;
            synchronized (dataObjectPool) {
                Item item = (Item)this.map.get(fileObject);
                if (item == null) {
                    object2 = new Item(fileObject);
                    this.map.put(fileObject, object2);
                    this.countRegistration(fileObject);
                    this.notifyAdd((Item)object2);
                    return object2;
                }
            }
        }
        catch (PropertyVetoException propertyVetoException) {
            VALIDATOR.refusingObjects.add(object);
        }
        throw new DataObjectExistsException((DataObject)object);
    }

    private synchronized void deregister(Item item, boolean bl) {
        DataFolder dataFolder;
        Item item2;
        FileObject fileObject = item.primaryFile;
        Item item3 = (Item)this.map.remove(fileObject);
        if (item3 != null && item3 != item) {
            this.map.put(fileObject, item3);
            this.countRegistration(fileObject);
            if (this.toNotify.remove(item)) {
                this.notifyAll();
            }
            return;
        }
        if (bl && (fileObject = fileObject.getParent()) != null && (item2 = (Item)this.map.get(fileObject)) != null && (dataFolder = (DataFolder)item2.getDataObjectOrNull()) != null) {
            VALIDATOR.refreshFolderOf(dataFolder);
        }
    }

    private synchronized void changePrimaryFile(Item item, FileObject fileObject) {
        this.map.remove(item.primaryFile);
        item.primaryFile = fileObject;
        this.map.put(fileObject, item);
        this.countRegistration(fileObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stateChanged(ChangeEvent changeEvent) {
        Set<Object> set;
        DataObjectPool dataObjectPool = this;
        synchronized (dataObjectPool) {
            set = new HashSet(this.map.values());
        }
        set = DataObjectPool.createSetOfAllFiles(set);
        this.revalidate(set);
    }

    private static Set createSetOfAllFiles(Collection collection) {
        HashSet hashSet = new HashSet(collection.size() * 7);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Item item = (Item)iterator.next();
            DataObject dataObject = item.getDataObjectOrNull();
            if (dataObject == null) continue;
            DataObjectPool.getPOOL().waitNotified(dataObject);
            hashSet.addAll(dataObject.files());
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Iterator getActiveDataObjects() {
        DataObjectPool dataObjectPool = this;
        synchronized (dataObjectPool) {
            ArrayList arrayList = new ArrayList(this.map.values());
            return arrayList.iterator();
        }
    }

    static {
        lockPOOL = new Object();
        ONE = new Integer(1);
        lp = DataLoaderPool.getDefault();
        LISTENER = ErrorManager.getDefault().getInstance("org.openide.loaders.DataObjectPool.Listener");
        WILL_LOG_LISTENER = LISTENER.isLoggable(1);
    }

    private final class FSListener
    extends FileChangeAdapter {
        FSListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Iterator getTargets(FileEvent fileEvent) {
            FileObject fileObject = fileEvent.getFile();
            LinkedList<Item> linkedList = new LinkedList<Item>();
            DataObjectPool dataObjectPool = DataObjectPool.this;
            synchronized (dataObjectPool) {
                Item item = (Item)DataObjectPool.this.map.get(fileObject);
                if (item != null) {
                    linkedList.add(item);
                } else {
                    FileObject fileObject2 = fileObject.getParent();
                    if (fileObject2 != null) {
                        FileObject[] fileObjectArray = fileObject2.getChildren();
                        for (int i = 0; i < fileObjectArray.length; ++i) {
                            item = (Item)DataObjectPool.this.map.get(fileObjectArray[i]);
                            if (item == null) continue;
                            linkedList.add(item);
                        }
                    }
                }
            }
            return linkedList.iterator();
        }

        public void fileChanged(FileEvent fileEvent) {
            if (WILL_LOG_LISTENER) {
                LISTENER.log("fileChanged: " + fileEvent);
            }
            Iterator iterator = this.getTargets(fileEvent);
            while (iterator.hasNext()) {
                DataObject dataObject = ((Item)iterator.next()).getDataObjectOrNull();
                if (WILL_LOG_LISTENER) {
                    LISTENER.log("  to: " + dataObject);
                }
                if (dataObject == null) continue;
                dataObject.notifyFileChanged(fileEvent);
            }
        }

        public void fileRenamed(FileRenameEvent fileRenameEvent) {
            if (WILL_LOG_LISTENER) {
                LISTENER.log("fileRenamed: " + fileRenameEvent);
            }
            Iterator iterator = this.getTargets((FileEvent)fileRenameEvent);
            while (iterator.hasNext()) {
                DataObject dataObject = ((Item)iterator.next()).getDataObjectOrNull();
                if (WILL_LOG_LISTENER) {
                    LISTENER.log("  to: " + dataObject);
                }
                if (dataObject == null) continue;
                dataObject.notifyFileRenamed(fileRenameEvent);
            }
        }

        public void fileDeleted(FileEvent fileEvent) {
            if (WILL_LOG_LISTENER) {
                LISTENER.log("fileDeleted: " + fileEvent);
            }
            Iterator iterator = this.getTargets(fileEvent);
            while (iterator.hasNext()) {
                DataObject dataObject = ((Item)iterator.next()).getDataObjectOrNull();
                if (WILL_LOG_LISTENER) {
                    LISTENER.log("  to: " + dataObject);
                }
                if (dataObject == null) continue;
                dataObject.notifyFileDeleted(fileEvent);
            }
        }

        public void fileDataCreated(FileEvent fileEvent) {
            if (WILL_LOG_LISTENER) {
                LISTENER.log("fileDataCreated: " + fileEvent);
            }
            Iterator iterator = this.getTargets(fileEvent);
            while (iterator.hasNext()) {
                DataObject dataObject = ((Item)iterator.next()).getDataObjectOrNull();
                if (WILL_LOG_LISTENER) {
                    LISTENER.log("  to: " + dataObject);
                }
                if (dataObject == null) continue;
                dataObject.notifyFileDataCreated(fileEvent);
            }
            ShadowChangeAdapter.checkBrokenDataShadows((EventObject)fileEvent);
        }

        public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
            if (WILL_LOG_LISTENER) {
                LISTENER.log("fileAttributeChanged: " + fileAttributeEvent);
            }
            Iterator iterator = this.getTargets((FileEvent)fileAttributeEvent);
            while (iterator.hasNext()) {
                DataObject dataObject = ((Item)iterator.next()).getDataObjectOrNull();
                if (WILL_LOG_LISTENER) {
                    LISTENER.log("  to: " + dataObject);
                }
                if (dataObject == null) continue;
                dataObject.notifyAttributeChanged(fileAttributeEvent);
            }
        }

        public void fileFolderCreated(FileEvent fileEvent) {
            if (WILL_LOG_LISTENER) {
                LISTENER.log("fileFolderCreated: " + fileEvent);
            }
            ShadowChangeAdapter.checkBrokenDataShadows((EventObject)fileEvent);
        }
    }

    static final class Item {
        private static final Reference REFERENCE_NOT_SET = new WeakReference<Object>(null);
        private Reference obj = REFERENCE_NOT_SET;
        FileObject primaryFile;

        public Item(FileObject fileObject) {
            this.primaryFile = fileObject;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setDataObject(DataObject dataObject) {
            this.obj = new ItemReference(dataObject, this);
            if (dataObject != null && !dataObject.getPrimaryFile().isValid()) {
                this.deregister(false);
            }
            DataObjectPool dataObjectPool = DataObjectPool.getPOOL();
            synchronized (dataObjectPool) {
                DataObjectPool.getPOOL().notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        DataObject getDataObjectOrNull() {
            DataObjectPool dataObjectPool = DataObjectPool.getPOOL();
            synchronized (dataObjectPool) {
                while (this.obj == REFERENCE_NOT_SET) {
                    try {
                        DataObjectPool.getPOOL().wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            return this.obj == null ? null : (DataObject)this.obj.get();
        }

        public DataObject getDataObject() {
            DataObject dataObject = this.getDataObjectOrNull();
            if (dataObject == null) {
                throw new IllegalStateException();
            }
            return dataObject;
        }

        public void deregister(boolean bl) {
            DataObjectPool.getPOOL().deregister(this, bl);
        }

        public void changePrimaryFile(FileObject fileObject) {
            DataObjectPool.getPOOL().changePrimaryFile(this, fileObject);
        }

        public boolean isValid() {
            if (DataObjectPool.getPOOL().map.get(this.primaryFile) == this) {
                return this.primaryFile.isValid();
            }
            return false;
        }

        public String toString() {
            DataObject dataObject = (DataObject)this.obj.get();
            if (dataObject == null) {
                return "nothing[" + this.primaryFile + "]";
            }
            return dataObject.toString();
        }
    }

    static final class ItemReference
    extends WeakReference
    implements Runnable {
        private Item item;

        ItemReference(DataObject dataObject, Item item) {
            super(dataObject, Utilities.activeReferenceQueue());
            this.item = item;
        }

        public void run() {
            this.item.deregister(false);
            this.item = null;
        }
    }

    private static final class Validator
    implements DataLoader.RecognizedFiles {
        private static final ErrorManager err = ErrorManager.getDefault().getInstance("org.openide.loaders.DataObject.Validator");
        private static final boolean errLog = err.isLoggable(1);
        private Set files;
        private Thread current;
        private int waiters;
        private int reenterCount;
        private HashSet recognizedFiles;
        private HashSet refusingObjects;
        private HashSet createdFiles;

        Validator() {
        }

        private synchronized Set enter(Set set) {
            boolean bl = err.isLoggable(1);
            if (bl) {
                err.log("enter: " + set + " on thread: " + Thread.currentThread());
            }
            if (this.current == Thread.currentThread()) {
                ++this.reenterCount;
                if (bl) {
                    err.log("current thread, rentered: " + this.reenterCount);
                }
            } else {
                ++this.waiters;
                if (bl) {
                    err.log("Waiting as waiter: " + this.waiters);
                }
                while (this.current != null) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                this.current = Thread.currentThread();
                --this.waiters;
                if (bl) {
                    err.log("Wait finished, waiters: " + this.waiters + " new current: " + this.current);
                }
            }
            if (this.files == null) {
                if (bl) {
                    err.log("New files: " + set);
                }
                this.files = set;
            } else {
                this.files.addAll(set);
                if (bl) {
                    err.log("Added files: " + set);
                    err.log("So they are: " + this.files);
                }
            }
            return this.files;
        }

        private synchronized void exit() {
            boolean bl = err.isLoggable(1);
            if (this.reenterCount == 0) {
                this.current = null;
                if (this.waiters == 0) {
                    this.files = null;
                }
                this.notify();
                if (bl) {
                    err.log("Exit and notify from " + Thread.currentThread());
                }
            } else {
                --this.reenterCount;
                if (bl) {
                    err.log("Exit reentrant: " + this.reenterCount);
                }
            }
        }

        private synchronized boolean goOn() {
            return this.waiters == 0;
        }

        public void refreshFolderOf(DataFolder dataFolder) {
            if (this.createdFiles == null) {
                FolderList.changedDataSystem(dataFolder.getPrimaryFile());
            }
        }

        public void markRecognized(FileObject fileObject) {
            this.recognizedFiles.add(fileObject);
        }

        public void notifyRegistered(FileObject fileObject) {
            if (this.createdFiles != null) {
                this.createdFiles.add(fileObject);
            }
        }

        public boolean reregister(DataObject dataObject, DataLoader dataLoader) {
            if (this.recognizedFiles == null) {
                return false;
            }
            if (dataObject.getLoader() == dataLoader) {
                return false;
            }
            if (this.createdFiles.contains(dataObject.getPrimaryFile())) {
                return false;
            }
            return !this.refusingObjects.contains(dataObject);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Set revalidate(Set set) {
            if (set.size() == 1 && this.current == Thread.currentThread() && this.files != null && this.files.contains(set.iterator().next())) {
                return new HashSet();
            }
            LinkedList<DataObject> linkedList = new LinkedList<DataObject>();
            boolean bl = err.isLoggable(1);
            try {
                HashSet hashSet;
                set = this.enter(set);
                this.recognizedFiles = new HashSet();
                this.refusingObjects = new HashSet();
                this.createdFiles = new HashSet();
                DataLoaderPool dataLoaderPool = lp;
                Iterator iterator = set.iterator();
                while (iterator.hasNext() && this.goOn()) {
                    try {
                        hashSet = (FileObject)iterator.next();
                        if (bl) {
                            err.log("Iterate: " + hashSet);
                        }
                        if (this.recognizedFiles.contains(hashSet)) continue;
                        boolean bl2 = false;
                        DataObject dataObject = DataObjectPool.getPOOL().find((FileObject)hashSet);
                        if (bl) {
                            err.log("Original: " + dataObject);
                        }
                        if (dataObject == null) continue;
                        DataObject dataObject2 = dataLoaderPool.findDataObject((FileObject)hashSet, this);
                        linkedList.add(dataObject2);
                        bl2 = dataObject2 != dataObject;
                        if (!bl2) continue;
                        if (bl) {
                            err.log("Invalidate: " + dataObject2);
                        }
                        iterator.remove();
                        try {
                            dataObject.setValid(false);
                        }
                        catch (PropertyVetoException propertyVetoException) {
                            this.refusingObjects.add(dataObject);
                            if (!bl) continue;
                            err.log("  Refusing: " + dataObject);
                        }
                    }
                    catch (DataObjectExistsException dataObjectExistsException) {
                    }
                    catch (IOException iOException) {
                        ErrorManager.getDefault().notify(1, (Throwable)iOException);
                    }
                    catch (ConcurrentModificationException concurrentModificationException) {
                        iterator = set.iterator();
                        if (!bl) continue;
                        err.notify(1, (Throwable)concurrentModificationException);
                        err.log("New iterator over: " + set);
                    }
                }
                hashSet = this.refusingObjects;
                return hashSet;
            }
            finally {
                this.recognizedFiles = null;
                this.refusingObjects = null;
                this.createdFiles = null;
                this.exit();
                if (bl) {
                    err.log("will do refreshAllFolders: " + set.size());
                }
                DataObjectPool.getPOOL().refreshAllFolders();
                if (bl) {
                    err.log("refreshAllFolders done");
                }
            }
        }
    }
}

