/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.awt.Image;
import java.awt.datatransfer.Transferable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.Action;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileStatusEvent;
import org.openide.filesystems.FileStatusListener;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectPool;
import org.openide.loaders.DefaultDataObject;
import org.openide.loaders.LoaderTransfer;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.ExTransferable;

public class DataNode
extends AbstractNode {
    static final long serialVersionUID = -7882925922830244768L;
    private DataObject obj;
    private PropL propL;
    private static boolean showFileExtensions = true;
    private static Class defaultLookup;
    private static RequestProcessor.Task refreshNamesIconsTask;
    private static Set refreshNameNodes;
    private static Set refreshIconNodes;
    private static boolean refreshNamesIconsRunning;
    private static final Object refreshNameIconLock;
    static /* synthetic */ Class array$Ljava$lang$String;
    static /* synthetic */ Class class$java$util$Date;

    public DataNode(DataObject dataObject, Children children) {
        this(dataObject, children, null);
    }

    public DataNode(DataObject dataObject, Children children, Lookup lookup) {
        super(children, lookup);
        this.obj = dataObject;
        this.propL = new PropL();
        dataObject.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.propL, (Object)dataObject));
        super.setName(dataObject.getName());
        this.updateDisplayName();
    }

    private void updateDisplayName() {
        String string;
        FileObject fileObject = this.obj.getPrimaryFile();
        if (fileObject.isRoot()) {
            FileObject fileObject2;
            File file = FileUtil.toFile((FileObject)fileObject);
            if (file == null && (fileObject2 = FileUtil.getArchiveFile((FileObject)fileObject)) != null) {
                file = FileUtil.toFile((FileObject)fileObject2);
            }
            if (file != null) {
                string = file.getAbsolutePath();
            } else {
                try {
                    string = fileObject.getURL().toExternalForm();
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    string = "???";
                }
            }
        } else {
            string = showFileExtensions || this.obj instanceof DataFolder || this.obj instanceof DefaultDataObject ? fileObject.getNameExt() : fileObject.getName();
        }
        if (this.displayFormat != null) {
            this.setDisplayName(this.displayFormat.format(new Object[]{string}));
        } else {
            this.setDisplayName(string);
        }
    }

    public DataObject getDataObject() {
        return this.obj;
    }

    public void setName(String string, boolean bl) {
        try {
            if (bl) {
                this.obj.rename(string);
            }
            super.setName(string);
            this.updateDisplayName();
        }
        catch (IOException iOException) {
            String string2 = null;
            string2 = iOException.getLocalizedMessage() == null || iOException.getLocalizedMessage().equals(iOException.getMessage()) ? NbBundle.getMessage((Class)DataNode.class, (String)"MSG_renameError", (Object)this.getName(), (Object)string) : iOException.getLocalizedMessage();
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
            ErrorManager.getDefault().annotate((Throwable)illegalArgumentException, 256, null, string2, (Throwable)iOException, null);
            throw illegalArgumentException;
        }
    }

    public void setName(String string) {
        this.setName(string, true);
    }

    public String getDisplayName() {
        String string = super.getDisplayName();
        try {
            string = this.obj.getPrimaryFile().getFileSystem().getStatus().annotateName(string, (Set)new LazyFilesSet());
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            // empty catch block
        }
        return string;
    }

    public String getHtmlDisplayName() {
        try {
            FileSystem.Status status = this.obj.getPrimaryFile().getFileSystem().getStatus();
            if (status instanceof FileSystem.HtmlStatus) {
                FileSystem.HtmlStatus htmlStatus = (FileSystem.HtmlStatus)status;
                String string = htmlStatus.annotateNameHtml(super.getDisplayName(), (Set)new LazyFilesSet());
                if (!super.getDisplayName().equals(string)) {
                    return string;
                }
            }
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            // empty catch block
        }
        return super.getHtmlDisplayName();
    }

    public Image getIcon(int n) {
        Image image = super.getIcon(n);
        try {
            image = this.obj.getPrimaryFile().getFileSystem().getStatus().annotateIcon(image, n, (Set)new LazyFilesSet());
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            // empty catch block
        }
        return image;
    }

    public Image getOpenedIcon(int n) {
        Image image = super.getOpenedIcon(n);
        try {
            image = this.obj.getPrimaryFile().getFileSystem().getStatus().annotateIcon(image, n, (Set)new LazyFilesSet());
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            // empty catch block
        }
        return image;
    }

    public HelpCtx getHelpCtx() {
        return this.obj.getHelpCtx();
    }

    public boolean canRename() {
        return this.obj.isRenameAllowed();
    }

    public boolean canDestroy() {
        return this.obj.isDeleteAllowed();
    }

    public void destroy() throws IOException {
        if (this.obj.isDeleteAllowed()) {
            this.obj.delete();
        }
        super.destroy();
    }

    public boolean canCopy() {
        return this.obj.isCopyAllowed();
    }

    public boolean canCut() {
        return this.obj.isMoveAllowed();
    }

    protected SystemAction[] createActions() {
        return null;
    }

    public Action[] getActions(boolean bl) {
        if (this.systemActions == null) {
            this.systemActions = this.createActions();
        }
        if (this.systemActions != null) {
            return this.systemActions;
        }
        return this.obj.getLoader().getSwingActions();
    }

    public SystemAction[] getActions() {
        if (this.systemActions == null) {
            this.systemActions = this.createActions();
        }
        if (this.systemActions != null) {
            return this.systemActions;
        }
        return this.obj.getLoader().getActions();
    }

    public Action getPreferredAction() {
        if (this.obj.isTemplate()) {
            return null;
        }
        Action action = super.getPreferredAction();
        if (action != null) {
            return action;
        }
        Action[] actionArray = this.getActions(false);
        if (actionArray != null && actionArray.length > 0) {
            return actionArray[0];
        }
        return null;
    }

    public Node.Cookie getCookie(Class clazz) {
        if (this.ownLookup()) {
            return super.getCookie(clazz);
        }
        Node.Cookie cookie = this.obj.getCookie(clazz);
        if (cookie != null) {
            return cookie;
        }
        return super.getCookie(clazz);
    }

    protected Sheet createSheet() {
        Sheet sheet = Sheet.createDefault();
        Sheet.Set set = sheet.get("properties");
        Node.Property property = DataNode.createNameProperty(this.obj);
        set.put(property);
        FileObject fileObject = this.getDataObject().getPrimaryFile();
        if (DataNode.couldBeTemplate(fileObject) && fileObject.canWrite()) {
            try {
                property = new PropertySupport.Reflection((Object)this.obj, Boolean.TYPE, "isTemplate", "setTemplate");
                property.setName("template");
                property.setDisplayName(DataObject.getString("PROP_template"));
                property.setShortDescription(DataObject.getString("HINT_template"));
                set.put(property);
            }
            catch (Exception exception) {
                throw new InternalError();
            }
        }
        if (fileObject.isData()) {
            set.put((Node.Property)new AllFilesProperty());
            set.put((Node.Property)new SizeProperty());
            set.put((Node.Property)new LastModifiedProperty());
        }
        return sheet;
    }

    private static boolean couldBeTemplate(FileObject fileObject) {
        FileSystem fileSystem;
        try {
            fileSystem = fileObject.getFileSystem();
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            return false;
        }
        return fileSystem.isDefault() && fileObject.getPath().startsWith("Templates/");
    }

    public Transferable clipboardCopy() throws IOException {
        ExTransferable exTransferable = ExTransferable.create((Transferable)super.clipboardCopy());
        exTransferable.put(LoaderTransfer.transferable(this.getDataObject(), 1));
        return exTransferable;
    }

    public Transferable clipboardCut() throws IOException {
        ExTransferable exTransferable = ExTransferable.create((Transferable)super.clipboardCut());
        exTransferable.put(LoaderTransfer.transferable(this.getDataObject(), 4));
        return exTransferable;
    }

    static Node.Property createNameProperty(final DataObject dataObject) {
        PropertySupport.ReadWrite readWrite = new PropertySupport.ReadWrite("name", String.class, DataObject.getString("PROP_name"), DataObject.getString("HINT_name")){

            public Object getValue() {
                return dataObject.getName();
            }

            public void setValue(Object object) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
                if (!this.canWrite()) {
                    throw new IllegalAccessException();
                }
                if (!(object instanceof String)) {
                    throw new IllegalArgumentException();
                }
                try {
                    dataObject.rename((String)object);
                }
                catch (IOException iOException) {
                    String string = null;
                    string = iOException.getLocalizedMessage() == null || iOException.getLocalizedMessage().equals(iOException.getMessage()) ? NbBundle.getMessage((Class)(class$org$openide$loaders$DataNode == null ? (class$org$openide$loaders$DataNode = DataNode.class$("org.openide.loaders.DataNode")) : class$org$openide$loaders$DataNode), (String)"MSG_renameError", (Object)dataObject.getName(), (Object)object) : iOException.getLocalizedMessage();
                    ErrorManager.getDefault().annotate((Throwable)iOException, 256, null, string, null, null);
                    throw new InvocationTargetException(iOException);
                }
            }

            public boolean canWrite() {
                return dataObject.isRenameAllowed();
            }

            public Object getValue(String string) {
                if ("suppressCustomEditor".equals(string)) {
                    return Boolean.TRUE;
                }
                return super.getValue(string);
            }
        };
        return readWrite;
    }

    void fireChange(final PropertyChangeEvent propertyChangeEvent) {
        Mutex.EVENT.writeAccess(new Runnable(){

            public void run() {
                if ("children".equals(propertyChangeEvent.getPropertyName())) {
                    return;
                }
                if ("primaryFile".equals(propertyChangeEvent.getPropertyName())) {
                    DataNode.this.propL.updateStatusListener();
                    DataNode.this.setName(DataNode.this.obj.getName(), false);
                    return;
                }
                if ("name".equals(propertyChangeEvent.getPropertyName())) {
                    DataNode.super.setName(DataNode.this.obj.getName());
                    DataNode.this.updateDisplayName();
                    return;
                }
                if ("cookie".equals(propertyChangeEvent.getPropertyName())) {
                    DataNode.this.fireCookieChange();
                }
                if ("valid".equals(propertyChangeEvent.getPropertyName())) {
                    Object object = propertyChangeEvent.getNewValue();
                    if (object instanceof Boolean && !((Boolean)object).booleanValue()) {
                        DataNode.this.fireNodeDestroyed();
                    }
                    return;
                }
                List<String> list = Arrays.asList("name", "files", "template");
                if (list.contains(propertyChangeEvent.getPropertyName())) {
                    DataNode.this.firePropertyChange(propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
                }
            }
        });
    }

    public Node.Handle getHandle() {
        return new ObjectHandle(this.obj, this.obj.isValid() ? this != this.obj.getNodeDelegate() : true);
    }

    final void fireChangeAccess(boolean bl, boolean bl2) {
        if (bl2) {
            this.fireDisplayNameChange(null, null);
        }
        if (bl) {
            this.fireIconChange();
        }
    }

    public static boolean getShowFileExtensions() {
        return showFileExtensions;
    }

    public static void setShowFileExtensions(boolean bl) {
        boolean bl2 = showFileExtensions != bl;
        showFileExtensions = bl;
        if (bl2) {
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    Iterator iterator = DataObjectPool.getPOOL().getActiveDataObjects();
                    while (iterator.hasNext()) {
                        DataObject dataObject = ((DataObjectPool.Item)iterator.next()).getDataObjectOrNull();
                        if (dataObject == null || !(dataObject.getNodeDelegate() instanceof DataNode)) continue;
                        ((DataNode)dataObject.getNodeDelegate()).updateDisplayName();
                    }
                }
            }, 300, 1);
        }
    }

    private boolean ownLookup() {
        if (defaultLookup == null) {
            try {
                defaultLookup = Class.forName("org.openide.nodes.NodeLookup", false, Node.class.getClassLoader());
            }
            catch (ClassNotFoundException classNotFoundException) {
                ErrorManager.getDefault().notify((Throwable)classNotFoundException);
                return false;
            }
        }
        return !defaultLookup.isInstance(this.getLookup());
    }

    static {
        refreshNamesIconsTask = null;
        refreshNameNodes = null;
        refreshIconNodes = null;
        refreshNamesIconsRunning = false;
        refreshNameIconLock = "DataNode.refreshNameIconLock";
    }

    private final class AllFilesProperty
    extends PropertySupport.ReadOnly {
        public AllFilesProperty() {
            super("files", array$Ljava$lang$String == null ? (array$Ljava$lang$String = DataNode.class$("[Ljava.lang.String;")) : array$Ljava$lang$String, DataObject.getString("PROP_files"), DataObject.getString("HINT_files"));
        }

        public Object getValue() {
            Set set = DataNode.this.obj.files();
            final String string = this.name(DataNode.this.obj.getPrimaryFile());
            TreeSet<String> treeSet = new TreeSet<String>(new Comparator(){

                public int compare(Object object, Object object2) {
                    String string3 = (String)object;
                    String string2 = (String)object2;
                    if (string3.equals(string)) {
                        return -1;
                    }
                    if (string2.equals(string)) {
                        return 1;
                    }
                    return string3.compareTo(string2);
                }
            });
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                treeSet.add(this.name((FileObject)iterator.next()));
            }
            return treeSet.toArray(new String[0]);
        }

        private String name(FileObject fileObject) {
            return FileUtil.getFileDisplayName((FileObject)fileObject);
        }
    }

    private final class LastModifiedProperty
    extends PropertySupport.ReadOnly {
        public LastModifiedProperty() {
            super("lastModified", class$java$util$Date == null ? (class$java$util$Date = DataNode.class$("java.util.Date")) : class$java$util$Date, DataObject.getString("PROP_lastModified"), DataObject.getString("HINT_lastModified"));
        }

        public Object getValue() {
            return DataNode.this.getDataObject().getPrimaryFile().lastModified();
        }
    }

    private class LazyFilesSet
    implements Set {
        private Set obj_files;

        private LazyFilesSet() {
        }

        private synchronized void lazyInitialization() {
            this.obj_files = DataNode.this.obj.files();
        }

        public boolean add(Object object) {
            this.lazyInitialization();
            return this.obj_files.add(object);
        }

        public boolean addAll(Collection collection) {
            this.lazyInitialization();
            return this.obj_files.addAll(collection);
        }

        public void clear() {
            this.lazyInitialization();
            this.obj_files.clear();
        }

        public boolean contains(Object object) {
            this.lazyInitialization();
            return this.obj_files.contains(object);
        }

        public boolean containsAll(Collection collection) {
            this.lazyInitialization();
            return this.obj_files.containsAll(collection);
        }

        public boolean isEmpty() {
            this.lazyInitialization();
            return this.obj_files.isEmpty();
        }

        public Iterator iterator() {
            return new FilesIterator();
        }

        public boolean remove(Object object) {
            this.lazyInitialization();
            return this.obj_files.remove(object);
        }

        public boolean removeAll(Collection collection) {
            this.lazyInitialization();
            return this.obj_files.removeAll(collection);
        }

        public boolean retainAll(Collection collection) {
            this.lazyInitialization();
            return this.obj_files.retainAll(collection);
        }

        public int size() {
            this.lazyInitialization();
            return this.obj_files.size();
        }

        public Object[] toArray() {
            this.lazyInitialization();
            return this.obj_files.toArray();
        }

        public Object[] toArray(Object[] objectArray) {
            this.lazyInitialization();
            return this.obj_files.toArray(objectArray);
        }

        public boolean equals(Object object) {
            this.lazyInitialization();
            return ((Object)this.obj_files).equals(object);
        }

        public String toString() {
            this.lazyInitialization();
            return this.obj_files.toString();
        }

        public int hashCode() {
            this.lazyInitialization();
            return ((Object)this.obj_files).hashCode();
        }

        private final class FilesIterator
        implements Iterator {
            private boolean first = true;
            private Iterator itDelegate = null;

            FilesIterator() {
            }

            public boolean hasNext() {
                return this.first ? true : this.getIteratorDelegate().hasNext();
            }

            public Object next() {
                if (this.first) {
                    this.first = false;
                    return DataNode.this.obj.getPrimaryFile();
                }
                return this.getIteratorDelegate().next();
            }

            public void remove() {
                this.getIteratorDelegate().remove();
            }

            private Iterator getIteratorDelegate() {
                if (this.itDelegate == null) {
                    LazyFilesSet.this.lazyInitialization();
                    this.itDelegate = LazyFilesSet.this.obj_files.iterator();
                    this.itDelegate.next();
                }
                return this.itDelegate;
            }
        }
    }

    private static class ObjectHandle
    implements Node.Handle {
        private FileObject obj;
        private boolean clone;
        static final long serialVersionUID = 6616060729084681518L;

        public ObjectHandle(DataObject dataObject, boolean bl) {
            this.obj = dataObject.getPrimaryFile();
            this.clone = bl;
        }

        public Node getNode() throws IOException {
            if (this.obj == null) {
                throw new IOException("File could not be restored");
            }
            Node node = DataObject.find(this.obj).getNodeDelegate();
            return this.clone ? node.cloneNode() : node;
        }
    }

    private class PropL
    implements PropertyChangeListener,
    FileStatusListener,
    Runnable {
        private FileStatusListener weakL;
        private FileSystem previous;

        public PropL() {
            this.updateStatusListener();
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            DataNode.this.fireChange(propertyChangeEvent);
        }

        private void updateStatusListener() {
            if (this.previous != null) {
                this.previous.removeFileStatusListener(this.weakL);
            }
            try {
                this.previous = DataNode.this.obj.getPrimaryFile().getFileSystem();
                if (this.weakL == null) {
                    this.weakL = FileUtil.weakFileStatusListener((FileStatusListener)this, null);
                }
                this.previous.addFileStatusListener(this.weakL);
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                this.previous = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void annotationChanged(FileStatusEvent fileStatusEvent) {
            Object object;
            boolean bl = false;
            Iterator iterator = DataNode.this.obj.files().iterator();
            while (iterator.hasNext()) {
                object = (FileObject)iterator.next();
                if (!fileStatusEvent.hasChanged(object)) continue;
                bl = true;
                break;
            }
            if (bl) {
                object = refreshNameIconLock;
                synchronized (object) {
                    boolean bl2 = false;
                    if (fileStatusEvent.isNameChange()) {
                        if (refreshNameNodes == null) {
                            refreshNameNodes = new HashSet();
                        }
                        bl2 |= refreshNameNodes.add(DataNode.this);
                    }
                    if (fileStatusEvent.isIconChange()) {
                        if (refreshIconNodes == null) {
                            refreshIconNodes = new HashSet();
                        }
                        bl2 |= refreshIconNodes.add(DataNode.this);
                    }
                    if (bl2 && !refreshNamesIconsRunning) {
                        refreshNamesIconsRunning = true;
                        if (refreshNamesIconsTask == null) {
                            refreshNamesIconsTask = RequestProcessor.getDefault().post((Runnable)this);
                        } else {
                            refreshNamesIconsTask.schedule(0);
                        }
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            int n;
            DataNode[] dataNodeArray;
            DataNode[] dataNodeArray2;
            Object object = refreshNameIconLock;
            synchronized (object) {
                if (refreshNameNodes != null) {
                    dataNodeArray2 = refreshNameNodes.toArray(new DataNode[refreshNameNodes.size()]);
                    refreshNameNodes.clear();
                } else {
                    dataNodeArray2 = new DataNode[]{};
                }
                if (refreshIconNodes != null) {
                    dataNodeArray = refreshIconNodes.toArray(new DataNode[refreshIconNodes.size()]);
                    refreshIconNodes.clear();
                } else {
                    dataNodeArray = new DataNode[]{};
                }
                refreshNamesIconsRunning = false;
            }
            for (n = 0; n < dataNodeArray2.length; ++n) {
                dataNodeArray2[n].fireChangeAccess(false, true);
            }
            for (n = 0; n < dataNodeArray.length; ++n) {
                dataNodeArray[n].fireChangeAccess(true, false);
            }
        }
    }

    private final class SizeProperty
    extends PropertySupport.ReadOnly {
        public SizeProperty() {
            super("size", Long.TYPE, DataObject.getString("PROP_size"), DataObject.getString("HINT_size"));
        }

        public Object getValue() {
            return new Long(DataNode.this.getDataObject().getPrimaryFile().getSize());
        }
    }
}

