/*
 * Decompiled with CFR 0.152.
 */
package org.openide.awt;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import org.openide.awt.Actions;
import org.openide.awt.DynamicMenuContent;
import org.openide.util.Utilities;
import org.openide.util.actions.Presenter;

class DynaMenuModel {
    private static final Icon BLANK_ICON = new ImageIcon(Utilities.loadImage((String)"org/openide/loaders/empty.gif"));
    private List menuItems;
    private HashMap actionToMenuMap = new HashMap();
    private boolean isWithIcons = false;

    public void loadSubmenu(List list, JMenu jMenu) {
        Actions.MenuItem menuItem;
        Object object;
        boolean bl = false;
        Object var4_4 = null;
        Iterator iterator = list.iterator();
        this.menuItems = new ArrayList(list.size());
        this.actionToMenuMap.clear();
        while (iterator.hasNext()) {
            Object object2;
            object = iterator.next();
            if (object instanceof Presenter.Menu) {
                object = ((Presenter.Menu)object).getMenuPresenter();
            }
            if (object instanceof DynamicMenuContent) {
                if (bl) {
                    this.menuItems.add(null);
                    bl = false;
                }
                object2 = (DynamicMenuContent)object;
                menuItem = this.convertArray(object2.getMenuPresenters());
                this.actionToMenuMap.put(object2, menuItem);
                Iterator<JComponent> iterator2 = Arrays.asList(menuItem).iterator();
                while (iterator2.hasNext()) {
                    JComponent jComponent = iterator2.next();
                    this.menuItems.add(jComponent);
                    this.isWithIcons = this.checkIcon(jComponent, this.isWithIcons);
                }
                continue;
            }
            if (object instanceof JMenuItem) {
                if (bl) {
                    this.menuItems.add(null);
                    bl = false;
                }
                this.isWithIcons = this.checkIcon(object, this.isWithIcons);
                this.menuItems.add((JMenuItem)object);
                continue;
            }
            if (object instanceof JSeparator) {
                bl = this.menuItems.size() > 0;
                continue;
            }
            if (!(object instanceof Action)) continue;
            if (bl) {
                this.menuItems.add(null);
                bl = false;
            }
            object2 = (Action)object;
            menuItem = new Actions.MenuItem((Action)object2, true);
            this.isWithIcons = this.checkIcon(menuItem, this.isWithIcons);
            this.actionToMenuMap.put(menuItem, new JComponent[]{menuItem});
            this.menuItems.add(menuItem);
        }
        if (this.isWithIcons) {
            this.menuItems = this.alignVertically(this.menuItems);
        }
        object = null;
        boolean bl2 = false;
        menuItem = this.menuItems.iterator();
        while (menuItem.hasNext()) {
            object = (JComponent)menuItem.next();
            if (object == null) {
                object = new JSeparator();
            }
            jMenu.add((Component)object);
            boolean bl3 = object instanceof JSeparator;
            if (bl3 && bl2) {
                ((JComponent)object).setVisible(false);
            }
            if (object instanceof InvisibleMenuItem) continue;
            bl2 = bl3;
        }
    }

    private boolean checkIcon(Object object, boolean bl) {
        if (bl) {
            return bl;
        }
        return object instanceof JMenuItem && ((JMenuItem)object).getIcon() != null && !BLANK_ICON.equals(((JMenuItem)object).getIcon());
    }

    public void checkSubmenu(JMenu jMenu) {
        DynamicMenuContent dynamicMenuContent;
        Iterator iterator = this.actionToMenuMap.entrySet().iterator();
        boolean bl = this.isWithIcons;
        boolean bl2 = false;
        while (iterator.hasNext()) {
            int n;
            int n2;
            Map.Entry entry = iterator.next();
            dynamicMenuContent = (DynamicMenuContent)entry.getKey();
            JComponent[] jComponentArray = (JComponent[])entry.getValue();
            boolean bl3 = false;
            Component[] componentArray = jMenu.getPopupMenu().getComponents();
            int n3 = n2 = jComponentArray.length > 0 ? this.findFirstItemIndex(jComponentArray[0], componentArray) : -1;
            JComponent[] jComponentArray2 = this.convertArray(dynamicMenuContent.synchMenuPresenters(this.unconvertArray(jComponentArray)));
            if (this.compareEqualArrays(jComponentArray, jComponentArray2)) continue;
            if (n2 < 0) {
                n2 = 0;
            } else {
                for (n = 0; n < jComponentArray.length; ++n) {
                    if (jComponentArray[n] == null) continue;
                    jMenu.getPopupMenu().remove(jComponentArray[n]);
                    this.menuItems.remove(jComponentArray[n]);
                }
            }
            for (n = 0; n < jComponentArray2.length; ++n) {
                JComponent jComponent = jComponentArray2[n];
                jMenu.getPopupMenu().add((Component)jComponent, n + n2);
                bl2 = true;
                this.menuItems.add(jComponent);
                boolean bl4 = this.checkIcon(jComponent, false);
                if (!bl4 && this.isWithIcons) {
                    this.alignVertically(Collections.singletonList(jComponent));
                }
                if (!bl4 || this.isWithIcons) continue;
                this.isWithIcons = true;
            }
            entry.setValue(jComponentArray2);
        }
        boolean bl5 = false;
        dynamicMenuContent = jMenu.getPopupMenu().getComponents();
        for (int i = 0; !(i >= ((DynamicMenuContent)dynamicMenuContent).length || dynamicMenuContent[i] != null && (bl5 = this.checkIcon(dynamicMenuContent[i], bl5))); ++i) {
        }
        DynaMenuModel.checkSeparators((Component[])dynamicMenuContent, jMenu.getPopupMenu());
        if (!bl5 && this.isWithIcons) {
            this.isWithIcons = false;
        }
        if (bl != this.isWithIcons) {
            this.menuItems = this.alignVertically(this.menuItems);
        }
        if (bl2 && Utilities.isWindows()) {
            jMenu.getPopupMenu().revalidate();
        }
    }

    static void checkSeparators(Component[] componentArray, JPopupMenu jPopupMenu) {
        boolean bl = false;
        for (int i = 0; i < componentArray.length; ++i) {
            boolean bl2;
            Component component = componentArray[i];
            if (component == null) continue;
            boolean bl3 = component instanceof JSeparator;
            if (bl3 && (bl2 = component.isVisible()) != !bl) {
                jPopupMenu.remove(i);
                JSeparator jSeparator = new JSeparator();
                jSeparator.setVisible(!bl);
                jPopupMenu.add((Component)jSeparator, i);
            }
            if (component instanceof InvisibleMenuItem) continue;
            bl = bl3;
        }
    }

    private JComponent[] convertArray(JComponent[] jComponentArray) {
        if (jComponentArray == null || jComponentArray.length == 0) {
            return new JComponent[]{new InvisibleMenuItem()};
        }
        JComponent[] jComponentArray2 = new JComponent[jComponentArray.length];
        for (int i = 0; i < jComponentArray.length; ++i) {
            jComponentArray2[i] = jComponentArray[i] == null ? new JSeparator() : jComponentArray[i];
        }
        return jComponentArray2;
    }

    private JComponent[] unconvertArray(JComponent[] jComponentArray) {
        if (jComponentArray.length == 1 && jComponentArray[0] instanceof InvisibleMenuItem) {
            return new JComponent[0];
        }
        return jComponentArray;
    }

    private int findFirstItemIndex(JComponent jComponent, Component[] componentArray) {
        for (int i = 0; i < componentArray.length; ++i) {
            if (jComponent != componentArray[i]) continue;
            return i;
        }
        return -1;
    }

    private boolean compareEqualArrays(JComponent[] jComponentArray, JComponent[] jComponentArray2) {
        if (jComponentArray.length != jComponentArray2.length) {
            return false;
        }
        for (int i = 0; i < jComponentArray.length; ++i) {
            if (jComponentArray[i] == jComponentArray2[i]) continue;
            return false;
        }
        return true;
    }

    private List alignVertically(List list) {
        ArrayList arrayList = new ArrayList(list.size());
        JMenuItem jMenuItem = null;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof JMenuItem) {
                jMenuItem = (JMenuItem)e;
                if (this.isWithIcons && jMenuItem != null && jMenuItem.getIcon() == null) {
                    jMenuItem.setIcon(BLANK_ICON);
                } else if (!this.isWithIcons && jMenuItem != null) {
                    jMenuItem.setIcon(null);
                }
            }
            arrayList.add(e);
        }
        return arrayList;
    }

    static final class InvisibleMenuItem
    extends JMenuItem {
        InvisibleMenuItem() {
        }

        public boolean isVisible() {
            return false;
        }
    }
}

