/*
 * Decompiled with CFR 0.152.
 */
package tr.view.information;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.net.URL;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jdesktop.layout.GroupLayout;
import org.openide.util.NbBundle;
import tr.model.information.Information;
import tr.runtime.Open;
import tr.swing.editorpane.HyperEditorPane;

public class InformationPanel
extends JPanel {
    private static final Logger LOG = Logger.getLogger("tr.view.information");
    private Information information;
    private boolean updating;
    private DocumentListener docListenerDescription;
    private DocumentListener docListenerNotes;
    private HyperlinkListener hyperlinkListener;
    private JLabel descriptionLabel;
    private JTextField descriptionText;
    private HyperEditorPane notesEditorPane;
    private JLabel notesLabel;

    public InformationPanel() {
        this.initComponents();
        this.initModel(null);
    }

    public void addNotify() {
        super.addNotify();
        this.addListeners();
    }

    public void removeNotify() {
        this.removeListeners();
        super.removeNotify();
    }

    private void addListeners() {
        this.docListenerDescription = new DocumentListener(){

            public void changedUpdate(DocumentEvent arg0) {
                InformationPanel.this.changedDescription();
            }

            public void insertUpdate(DocumentEvent arg0) {
                InformationPanel.this.changedDescription();
            }

            public void removeUpdate(DocumentEvent arg0) {
                InformationPanel.this.changedDescription();
            }
        };
        this.descriptionText.getDocument().addDocumentListener(this.docListenerDescription);
        this.docListenerNotes = new DocumentListener(){

            public void changedUpdate(DocumentEvent arg0) {
                InformationPanel.this.changedNotes();
            }

            public void insertUpdate(DocumentEvent arg0) {
                InformationPanel.this.changedNotes();
            }

            public void removeUpdate(DocumentEvent arg0) {
                InformationPanel.this.changedNotes();
            }
        };
        this.notesEditorPane.addDocumentListener(this.docListenerNotes);
        this.hyperlinkListener = new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent evt) {
                InformationPanel.this.hyperlink(evt);
            }
        };
        this.notesEditorPane.addHyperlinkListener(this.hyperlinkListener);
    }

    private void removeListeners() {
        this.descriptionText.getDocument().removeDocumentListener(this.docListenerDescription);
        this.notesEditorPane.removeDocumentListener(this.docListenerNotes);
        this.notesEditorPane.removeHyperlinkListener(this.hyperlinkListener);
        this.docListenerDescription = null;
        this.docListenerNotes = null;
        this.hyperlinkListener = null;
    }

    private void hyperlink(HyperlinkEvent evt) {
        URL url = evt.getURL();
        if (url == null) {
            return;
        }
        if (evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            Open.open((URL)url);
        }
    }

    private void changedDescription() {
        if (this.information == null) {
            return;
        }
        this.information.setDescription(this.descriptionText.getText());
    }

    private void changedNotes() {
        if (this.information == null) {
            return;
        }
        this.information.setNotes(this.notesEditorPane.getText());
    }

    private void initComponents() {
        this.descriptionLabel = new JLabel();
        this.descriptionText = new JTextField();
        this.notesLabel = new JLabel();
        this.notesEditorPane = new HyperEditorPane();
        this.descriptionLabel.setText(NbBundle.getMessage(InformationPanel.class, (String)"InformationPanel.descriptionLabel"));
        this.notesLabel.setText(NbBundle.getMessage(InformationPanel.class, (String)"InformationPanel.notesLabel"));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.descriptionLabel).add((Component)this.notesLabel)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.notesEditorPane, -1, 90, Short.MAX_VALUE).add((Component)this.descriptionText, -1, 90, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.descriptionLabel).add((Component)this.descriptionText, -2, -1, -2)).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(4, 4, 4).add((Component)this.notesEditorPane, -1, 49, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().add(36, 36, 36).add((Component)this.notesLabel))).addContainerGap()));
    }

    public void initModel(Information information) {
        this.information = information;
        this.initView();
    }

    private void initView() {
        this.updating = true;
        if (this.information == null) {
            this.descriptionText.setText("");
            this.notesEditorPane.setText("");
            this.setEnabled(false);
        } else {
            this.descriptionText.setText(this.information.getDescription());
            this.notesEditorPane.setText(this.information.getNotes());
            this.setEnabled(true);
        }
        this.updating = false;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.descriptionLabel.setEnabled(enabled);
        this.descriptionText.setEnabled(enabled);
        this.notesLabel.setEnabled(enabled);
        this.notesEditorPane.setEnabled(enabled);
        this.notesEditorPane.setEditable(false);
    }
}

