/*
 * Decompiled with CFR 0.152.
 */
package tr.view.information;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.logging.Logger;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Utilities;
import tr.model.Data;
import tr.model.DataLookup;
import tr.model.information.Information;
import tr.model.topic.Topic;
import tr.model.util.Manager;
import tr.util.Observable;
import tr.util.Observer;
import tr.view.information.InformationNode;

public class InformationChildren
extends Children.Keys
implements LookupListener,
Observer {
    private static final Logger LOG = Logger.getLogger("tr.view.information");
    private Data data = (Data)DataLookup.instance().lookup(Data.class);
    private Topic topic;
    private Lookup.Result rslt;

    protected void addNotify() {
        this.data.getInformationManager().addObserver((Observer)this);
        this.rslt = Utilities.actionsGlobalContext().lookup(new Lookup.Template(Topic.class));
        this.rslt.addLookupListener((LookupListener)this);
        this.rslt.allInstances();
        this.resultChanged(null);
    }

    protected void removeNotify() {
        this.data.getInformationManager().removeObserver((Observer)this);
        this.rslt.removeLookupListener((LookupListener)this);
        this.rslt = null;
    }

    protected Node[] createNodes(Object key) {
        return new Node[]{new InformationNode((Information)key)};
    }

    public void resultChanged(LookupEvent e) {
        LOG.fine("Topic lookup changed.");
        if (this.topic != null) {
            this.topic.removeObserver((Observer)this);
        }
        if (this.rslt == null) {
            return;
        }
        Collection c = this.rslt.allInstances();
        if (c == null || c.isEmpty()) {
            LOG.fine("No topic lookup result");
            return;
        }
        this.topic = (Topic)c.toArray()[0];
        this.topic.addObserver((Observer)this);
        this.initKeys();
    }

    private synchronized void initKeys() {
        if (this.data == null || this.topic == null) {
            this.setKeys(Collections.EMPTY_SET);
        } else {
            Manager manager = this.data.getInformationManager();
            ArrayList<Information> items = new ArrayList<Information>();
            for (Information item : manager.list()) {
                if (!item.getTopic().equals((Object)this.topic)) continue;
                items.add(item);
            }
            Collections.sort(items);
            this.setKeys(items);
        }
    }

    public void update(Observable observable, Object arguement) {
        LOG.fine("Observed information manager change.");
        this.initKeys();
    }
}

