/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.modules.openide.filesystems.DefaultURLMapperProxy;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileURL;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.JarFileSystem;
import org.openide.filesystems.MultiFileObject;
import org.openide.filesystems.Repository;
import org.openide.filesystems.XMLFileSystem;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;

public abstract class URLMapper {
    public static final int INTERNAL = 0;
    public static final int EXTERNAL = 1;
    public static final int NETWORK = 2;
    private static Lookup.Result result;
    private static final List CACHE_JUST_COMPUTING;
    private static final ThreadLocal threadCache;
    private static URLMapper defMapper;
    private static List cache;

    public static URL findURL(FileObject fileObject, int n) {
        Iterator iterator = URLMapper.getInstances().iterator();
        while (iterator.hasNext()) {
            URLMapper uRLMapper = (URLMapper)iterator.next();
            URL uRL = uRLMapper.getURL(fileObject, n);
            if (uRL == null) continue;
            return uRL;
        }
        if (n == 0) {
            try {
                return FileURL.encodeFileObject(fileObject);
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                // empty catch block
            }
        }
        return null;
    }

    public abstract URL getURL(FileObject var1, int var2);

    public static FileObject[] findFileObjects(URL uRL) {
        LinkedHashSet<FileObject> linkedHashSet = new LinkedHashSet<FileObject>();
        Iterator iterator = URLMapper.getInstances().iterator();
        while (iterator.hasNext()) {
            URLMapper uRLMapper = (URLMapper)iterator.next();
            FileObject[] fileObjectArray = uRLMapper.getFileObjects(uRL);
            if (fileObjectArray == null) continue;
            linkedHashSet.addAll(Arrays.asList(fileObjectArray));
        }
        return linkedHashSet.toArray(new FileObject[linkedHashSet.size()]);
    }

    public static FileObject findFileObject(URL uRL) {
        if (uRL == null) {
            throw new NullPointerException("Cannot pass null URL to URLMapper.findFileObject");
        }
        FileObject[] fileObjectArray = null;
        Iterator iterator = URLMapper.getInstances().iterator();
        while (iterator.hasNext() && (fileObjectArray == null || fileObjectArray.length == 0)) {
            URLMapper uRLMapper = (URLMapper)iterator.next();
            fileObjectArray = uRLMapper.getFileObjects(uRL);
        }
        return fileObjectArray != null && fileObjectArray.length > 0 ? fileObjectArray[0] : null;
    }

    public abstract FileObject[] getFileObjects(URL var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List getInstances() {
        Object object;
        Object object2;
        Serializable serializable = URLMapper.class;
        synchronized (serializable) {
            if (cache != null && (cache != CACHE_JUST_COMPUTING || threadCache.get() == CACHE_JUST_COMPUTING)) {
                return cache;
            }
            cache = CACHE_JUST_COMPUTING;
            threadCache.set(CACHE_JUST_COMPUTING);
        }
        serializable = null;
        try {
            serializable = new ArrayList(result.allInstances());
            object2 = null;
            object = ((ArrayList)serializable).iterator();
            while (object.hasNext()) {
                URLMapper uRLMapper = (URLMapper)object.next();
                if (!(uRLMapper instanceof DefaultURLMapperProxy)) continue;
                object2 = uRLMapper;
                object.remove();
                break;
            }
            if (object2 != null) {
                ((ArrayList)serializable).add(object2);
            }
            object2 = serializable;
            object = URLMapper.class;
        }
        catch (Throwable throwable) {
            Class clazz = URLMapper.class;
            synchronized (clazz) {
                if (cache == CACHE_JUST_COMPUTING) {
                    cache = serializable;
                }
                threadCache.set(null);
            }
            throw throwable;
        }
        synchronized (object) {
            if (cache == CACHE_JUST_COMPUTING) {
                cache = serializable;
            }
            threadCache.set(null);
        }
        return object2;
    }

    static {
        CACHE_JUST_COMPUTING = new ArrayList();
        threadCache = new ThreadLocal();
        DefaultURLMapperProxy.setDefault(new DefaultURLMapper());
        result = Lookup.getDefault().lookup(new Lookup.Template(URLMapper.class));
        result.addLookupListener(new LookupListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void resultChanged(LookupEvent lookupEvent) {
                Class clazz = class$org$openide$filesystems$URLMapper == null ? (class$org$openide$filesystems$URLMapper = URLMapper.class$("org.openide.filesystems.URLMapper")) : class$org$openide$filesystems$URLMapper;
                synchronized (clazz) {
                    cache = null;
                }
            }
        });
    }

    private static class DefaultURLMapper
    extends URLMapper {
        static final /* synthetic */ boolean $assertionsDisabled;

        DefaultURLMapper() {
        }

        public FileObject[] getFileObjects(URL uRL) {
            FileObject[] fileObjectArray;
            File file;
            String string = uRL.getProtocol();
            if (string.equals("nbfs")) {
                FileObject[] fileObjectArray2;
                FileObject fileObject = FileURL.decodeURL(uRL);
                if (fileObject == null) {
                    fileObjectArray2 = null;
                } else {
                    FileObject[] fileObjectArray3 = new FileObject[1];
                    fileObjectArray2 = fileObjectArray3;
                    fileObjectArray3[0] = fileObject;
                }
                return fileObjectArray2;
            }
            if (string.equals("jar")) {
                return DefaultURLMapper.getFileObjectsForJarProtocol(uRL);
            }
            if (string.equals("file") && (file = DefaultURLMapper.toFile(uRL)) != null && (fileObjectArray = this.findFileObjectsInRepository(file)) != null && fileObjectArray.length > 0) {
                return fileObjectArray;
            }
            return null;
        }

        private FileObject[] findFileObjectsInRepository(File file) {
            FileObject[] fileObjectArray;
            if (!file.equals(FileUtil.normalizeFile(file))) {
                throw new IllegalArgumentException("Parameter file was not normalized. Was " + file + " instead of " + FileUtil.normalizeFile(file));
            }
            Enumeration enumeration = Repository.getDefault().getFileSystems();
            LinkedList<FileObject> linkedList = new LinkedList<FileObject>();
            String string = file.getAbsolutePath();
            while (enumeration.hasMoreElements()) {
                File file2;
                Object object;
                fileObjectArray = (FileObject[])enumeration.nextElement();
                String string2 = null;
                FileObject fileObject = fileObjectArray.getRoot();
                File file3 = DefaultURLMapper.findFileInRepository(fileObject);
                if (file3 == null) {
                    object = fileObject.getAttribute("FileSystem.rootPath");
                    if (object == null || !(object instanceof String)) continue;
                    string2 = (String)object;
                }
                if (string2 == null) {
                    string2 = file3.getAbsolutePath();
                }
                if (string.indexOf(string2) != 0) continue;
                object = string.substring(string2.length()).replace(File.separatorChar, '/');
                FileObject fileObject2 = fileObjectArray.findResource((String)object);
                File file4 = file2 = fileObject2 != null ? DefaultURLMapper.findFileInRepository(fileObject2) : null;
                if (fileObject2 == null || file2 == null || !file.equals(file2)) continue;
                if (fileObject2.getClass().toString().indexOf("org.netbeans.modules.masterfs.MasterFileObject") != -1) {
                    linkedList.addFirst(fileObject2);
                    continue;
                }
                linkedList.addLast(fileObject2);
            }
            fileObjectArray = new FileObject[linkedList.size()];
            linkedList.toArray(fileObjectArray);
            return fileObjectArray;
        }

        public URL getURL(FileObject fileObject, int n) {
            if (fileObject == null) {
                return null;
            }
            if (n == 2) {
                return null;
            }
            if (fileObject instanceof MultiFileObject && n == 0) {
                return null;
            }
            File file = DefaultURLMapper.findFileInRepository(fileObject);
            if (file != null) {
                try {
                    return DefaultURLMapper.toURL(file, fileObject);
                }
                catch (MalformedURLException malformedURLException) {
                    if (!$assertionsDisabled) {
                        throw new AssertionError((Object)malformedURLException);
                    }
                    return null;
                }
            }
            URL uRL = null;
            FileSystem fileSystem = null;
            try {
                fileSystem = fileObject.getFileSystem();
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                return null;
            }
            if (fileSystem instanceof JarFileSystem) {
                JarFileSystem jarFileSystem = (JarFileSystem)fileSystem;
                File file2 = jarFileSystem.getJarFile();
                if (file2 == null) {
                    return null;
                }
                try {
                    uRL = new URL("jar:" + file2.toURI() + "!/" + fileObject.getPath() + (fileObject.isFolder() && !fileObject.isRoot() ? "/" : ""));
                }
                catch (MalformedURLException malformedURLException) {
                    malformedURLException.printStackTrace();
                    return null;
                }
            } else if (fileSystem instanceof XMLFileSystem) {
                URL uRL2 = null;
                try {
                    uRL2 = ((XMLFileSystem)fileSystem).getURL(fileObject.getPath());
                    if (uRL2 == null) {
                        return null;
                    }
                    if (n == 0) {
                        return uRL2;
                    }
                    boolean bl = uRL2.getProtocol().startsWith("nbres");
                    if (n == 1 && !bl) {
                        return uRL2;
                    }
                    return null;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    return null;
                }
            }
            return uRL;
        }

        private static URL toURL(File file, FileObject fileObject) throws MalformedURLException {
            String string;
            String string2;
            URL uRL = null;
            if (fileObject.isFolder() && !fileObject.isValid() && !(string2 = file.toURI().toURL().toExternalForm()).endsWith(string = "/")) {
                uRL = new URL(string2 + string);
            }
            return uRL == null ? file.toURI().toURL() : uRL;
        }

        private static File findFileInRepository(FileObject fileObject) {
            File file = (File)fileObject.getAttribute("java.io.File");
            return file != null ? FileUtil.normalizeFile(file) : null;
        }

        private static FileObject[] getFileObjectsForJarProtocol(URL uRL) {
            FileObject[] fileObjectArray;
            JarFileSystem jarFileSystem;
            FileObject fileObject = null;
            JarURLParser jarURLParser = new JarURLParser(uRL);
            File file = jarURLParser.getJarFile();
            String string = jarURLParser.getEntryName();
            if (file != null && (jarFileSystem = DefaultURLMapper.findJarFileSystem(file)) != null) {
                if (string == null) {
                    string = "";
                }
                fileObject = jarFileSystem.findResource(string);
            }
            if (fileObject == null) {
                fileObjectArray = null;
            } else {
                FileObject[] fileObjectArray2 = new FileObject[1];
                fileObjectArray = fileObjectArray2;
                fileObjectArray2[0] = fileObject;
            }
            return fileObjectArray;
        }

        private static JarFileSystem findJarFileSystem(File file) {
            JarFileSystem jarFileSystem = null;
            Enumeration enumeration = Repository.getDefault().getFileSystems();
            while (enumeration.hasMoreElements()) {
                File file2;
                FileSystem fileSystem = (FileSystem)enumeration.nextElement();
                if (!(fileSystem instanceof JarFileSystem) || !(file2 = ((JarFileSystem)fileSystem).getJarFile()).equals(file)) continue;
                jarFileSystem = (JarFileSystem)fileSystem;
                break;
            }
            return jarFileSystem;
        }

        private static File toFile(URL uRL) {
            if (uRL == null) {
                throw new NullPointerException();
            }
            try {
                URI uRI = new URI(uRL.toExternalForm());
                return FileUtil.normalizeFile(new File(uRI));
            }
            catch (URISyntaxException uRISyntaxException) {
                return null;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return null;
            }
        }

        static {
            $assertionsDisabled = !(class$org$openide$filesystems$URLMapper == null ? (class$org$openide$filesystems$URLMapper = URLMapper.class$("org.openide.filesystems.URLMapper")) : class$org$openide$filesystems$URLMapper).desiredAssertionStatus();
        }

        private static class JarURLParser {
            private File jarFile;
            private String entryName;

            JarURLParser(URL uRL) {
                this.parse(uRL);
            }

            void parse(URL uRL) {
                String string = uRL.getFile();
                int n = string.indexOf(33);
                if (n != -1) {
                    try {
                        this.jarFile = DefaultURLMapper.toFile(new URL(string.substring(0, n++)));
                        this.entryName = null;
                    }
                    catch (MalformedURLException malformedURLException) {
                        return;
                    }
                    if (++n != string.length()) {
                        this.entryName = string.substring(n, string.length());
                    }
                }
            }

            File getJarFile() {
                return this.jarFile;
            }

            String getEntryName() {
                return this.entryName;
            }
        }
    }
}

