/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.openide.filesystems.AbstractFileSystem;
import org.openide.filesystems.AbstractFolder;
import org.openide.filesystems.ExternalUtil;
import org.openide.filesystems.FileAlreadyLockedException;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.util.WeakSet;

final class StreamPool {
    private static final boolean ANNOTATE_UNCLOSED_STREAMS = Boolean.getBoolean("org.openide.filesystems.annotateUnclosedStreams");
    private static Map fo2StreamPool = new WeakHashMap();
    private static Map fs2StreamPool = new WeakHashMap();
    private Set iStreams;
    private Set oStreams;

    private StreamPool() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputStream createInputStream(final AbstractFolder abstractFolder) throws FileNotFoundException {
        InputStream inputStream = null;
        Serializable serializable = StreamPool.class;
        synchronized (serializable) {
            try {
                StreamPool.get(abstractFolder).waitForOutputStreamsClosed(2000);
                inputStream = new NotifyInputStream(abstractFolder);
                StreamPool.get(abstractFolder).iStream().add(inputStream);
                StreamPool.get(abstractFolder.getFileSystem()).iStream().add(inputStream);
            }
            catch (InterruptedException interruptedException) {
                ExternalUtil.exception(interruptedException);
            }
        }
        if (inputStream != null && inputStream instanceof NotifyInputStream) {
            serializable = (AbstractFileSystem)abstractFolder.getFileSystem();
            ((NotifyInputStream)inputStream).setOriginal(((AbstractFileSystem)serializable).info.inputStream(abstractFolder.getPath()));
        } else {
            inputStream = new InputStream(){

                public int read() throws IOException {
                    FileAlreadyLockedException fileAlreadyLockedException = new FileAlreadyLockedException(abstractFolder.getPath());
                    StreamPool.get(abstractFolder).annotate(fileAlreadyLockedException);
                    throw fileAlreadyLockedException;
                }
            };
        }
        return inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OutputStream createOutputStream(final AbstractFolder abstractFolder, boolean bl) throws IOException {
        OutputStream outputStream = null;
        Serializable serializable = StreamPool.class;
        synchronized (serializable) {
            try {
                StreamPool.get(abstractFolder).waitForInputStreamsClosed(2000);
                StreamPool.get(abstractFolder).waitForOutputStreamsClosed(2000);
                outputStream = new NotifyOutputStream(abstractFolder, bl);
                StreamPool.get(abstractFolder).oStream().add(outputStream);
                StreamPool.get(abstractFolder.getFileSystem()).oStream().add(outputStream);
            }
            catch (InterruptedException interruptedException) {
                ExternalUtil.exception(interruptedException);
            }
        }
        if (outputStream != null && outputStream instanceof NotifyOutputStream) {
            serializable = (AbstractFileSystem)abstractFolder.getFileSystem();
            ((NotifyOutputStream)outputStream).setOriginal(((AbstractFileSystem)serializable).info.outputStream(abstractFolder.getPath()));
        } else {
            outputStream = new OutputStream(){

                public void write(int n) throws IOException {
                    FileAlreadyLockedException fileAlreadyLockedException = new FileAlreadyLockedException(abstractFolder.getPath());
                    StreamPool.get(abstractFolder).annotate(fileAlreadyLockedException);
                    throw fileAlreadyLockedException;
                }
            };
        }
        return outputStream;
    }

    public static synchronized StreamPool find(FileObject fileObject) {
        return (StreamPool)fo2StreamPool.get(fileObject);
    }

    public static synchronized StreamPool find(FileSystem fileSystem) {
        return (StreamPool)fs2StreamPool.get(fileSystem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void annotate(Exception exception) {
        if (!ANNOTATE_UNCLOSED_STREAMS) {
            return;
        }
        Class clazz = StreamPool.class;
        synchronized (clazz) {
            Exception exception2;
            Closeable closeable;
            Iterator iterator;
            if (this.iStreams != null) {
                iterator = this.iStreams.iterator();
                while (iterator.hasNext()) {
                    closeable = (NotifyInputStream)iterator.next();
                    exception2 = ((NotifyInputStream)closeable).getException();
                    if (exception2 == null) continue;
                    ExternalUtil.annotate((Throwable)exception, exception2);
                }
            }
            if (this.oStreams != null) {
                iterator = this.oStreams.iterator();
                while (iterator.hasNext()) {
                    closeable = (NotifyOutputStream)iterator.next();
                    exception2 = ((NotifyOutputStream)closeable).getException();
                    if (exception2 == null) continue;
                    ExternalUtil.annotate((Throwable)exception, exception2);
                }
            }
        }
    }

    public boolean isInputStreamOpen() {
        return this.iStreams != null && !this.iStreams.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForInputStreamsClosed(int n) throws InterruptedException {
        Class clazz = StreamPool.class;
        synchronized (clazz) {
            if (this.isInputStreamOpen()) {
                StreamPool.class.wait(n);
                if (this.isInputStreamOpen()) {
                    throw new InterruptedException();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForOutputStreamsClosed(int n) throws InterruptedException {
        Class clazz = StreamPool.class;
        synchronized (clazz) {
            if (this.isOutputStreamOpen()) {
                StreamPool.class.wait(n);
                if (this.isOutputStreamOpen()) {
                    throw new InterruptedException();
                }
            }
        }
    }

    public boolean isOutputStreamOpen() {
        return this.oStreams != null && !this.oStreams.isEmpty();
    }

    private static StreamPool get(FileObject fileObject) {
        StreamPool streamPool = (StreamPool)fo2StreamPool.get(fileObject);
        if (streamPool == null) {
            streamPool = new StreamPool();
            fo2StreamPool.put(fileObject, streamPool);
        }
        return streamPool;
    }

    private static StreamPool get(FileSystem fileSystem) {
        StreamPool streamPool = (StreamPool)fs2StreamPool.get(fileSystem);
        if (streamPool == null) {
            streamPool = new StreamPool();
            fs2StreamPool.put(fileSystem, streamPool);
        }
        return streamPool;
    }

    private Set iStream() {
        if (this.iStreams == null) {
            this.iStreams = new WeakSet();
        }
        return this.iStreams;
    }

    private Set oStream() {
        if (this.oStreams == null) {
            this.oStreams = new WeakSet();
        }
        return this.oStreams;
    }

    private static void closeOutputStream(AbstractFolder abstractFolder, OutputStream outputStream, boolean bl) {
        StreamPool streamPool = StreamPool.find(abstractFolder);
        StreamPool streamPool2 = StreamPool.find(abstractFolder.getFileSystem());
        Set set = streamPool != null ? streamPool.oStreams : null;
        Set set2 = streamPool2 != null ? streamPool2.oStreams : null;
        StreamPool.removeStreams(set2, set, outputStream);
        StreamPool.removeStreamPools(streamPool2, streamPool, abstractFolder);
        abstractFolder.outputStreamClosed(bl);
    }

    private static void closeInputStream(AbstractFolder abstractFolder, InputStream inputStream) {
        StreamPool streamPool = StreamPool.find(abstractFolder);
        StreamPool streamPool2 = StreamPool.find(abstractFolder.getFileSystem());
        Set set = streamPool != null ? streamPool.iStreams : null;
        Set set2 = streamPool2 != null ? streamPool2.iStreams : null;
        StreamPool.removeStreams(set2, set, inputStream);
        StreamPool.removeStreamPools(streamPool2, streamPool, abstractFolder);
    }

    private static synchronized void removeStreams(Set set, Set set2, Object object) {
        if (set2 != null) {
            set2.remove(object);
        }
        if (set != null) {
            set.remove(object);
        }
    }

    private static synchronized void removeStreamPools(StreamPool streamPool, StreamPool streamPool2, AbstractFolder abstractFolder) {
        boolean bl;
        boolean bl2 = streamPool2 == null || streamPool2.iStreams == null || streamPool2.iStreams.isEmpty();
        boolean bl3 = bl = streamPool2 == null || streamPool2.oStreams == null || streamPool2.oStreams.isEmpty();
        if (bl2 && bl) {
            fo2StreamPool.remove(abstractFolder);
        }
        bl2 = streamPool == null || streamPool.iStreams == null || streamPool.iStreams.isEmpty();
        boolean bl4 = bl = streamPool == null || streamPool.oStreams == null || streamPool.oStreams.isEmpty();
        if (bl2 && bl) {
            fs2StreamPool.remove(abstractFolder.getFileSystem());
        }
    }

    private static final class NotifyInputStream
    extends FilterInputStream {
        private static final InputStream emptyIs = new ByteArrayInputStream(new byte[0]);
        private Exception ex;
        AbstractFolder fo;
        private boolean closed = false;

        public NotifyInputStream(AbstractFolder abstractFolder) {
            super(emptyIs);
            this.fo = abstractFolder;
            if (ANNOTATE_UNCLOSED_STREAMS) {
                this.ex = new Exception();
            }
        }

        private void setOriginal(InputStream inputStream) {
            this.in = inputStream;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            if (!this.closed) {
                this.closed = true;
                this.ex = null;
                super.close();
                StreamPool.closeInputStream(this.fo, this);
                Class clazz = class$org$openide$filesystems$StreamPool == null ? (class$org$openide$filesystems$StreamPool = StreamPool.class$("org.openide.filesystems.StreamPool")) : class$org$openide$filesystems$StreamPool;
                synchronized (clazz) {
                    if (!StreamPool.get(this.fo).isInputStreamOpen()) {
                        (class$org$openide$filesystems$StreamPool == null ? (class$org$openide$filesystems$StreamPool = StreamPool.class$("org.openide.filesystems.StreamPool")) : class$org$openide$filesystems$StreamPool).notifyAll();
                    }
                }
            }
        }

        public Exception getException() {
            return this.ex;
        }
    }

    private static final class NotifyOutputStream
    extends FilterOutputStream {
        private static final OutputStream emptyOs = new ByteArrayOutputStream();
        private Exception ex;
        private boolean closed = false;
        AbstractFolder fo;
        private boolean fireFileChanged;

        public NotifyOutputStream(AbstractFolder abstractFolder, boolean bl) {
            super(emptyOs);
            this.fo = abstractFolder;
            if (ANNOTATE_UNCLOSED_STREAMS) {
                this.ex = new Exception();
            }
            this.fireFileChanged = bl;
        }

        private void setOriginal(OutputStream outputStream) {
            this.out = outputStream;
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            this.out.write(byArray, n, n2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            if (!this.closed) {
                this.closed = true;
                this.ex = null;
                this.out.flush();
                super.close();
                StreamPool.closeOutputStream(this.fo, this, this.fireFileChanged);
                Class clazz = class$org$openide$filesystems$StreamPool == null ? (class$org$openide$filesystems$StreamPool = StreamPool.class$("org.openide.filesystems.StreamPool")) : class$org$openide$filesystems$StreamPool;
                synchronized (clazz) {
                    (class$org$openide$filesystems$StreamPool == null ? (class$org$openide$filesystems$StreamPool = StreamPool.class$("org.openide.filesystems.StreamPool")) : class$org$openide$filesystems$StreamPool).notifyAll();
                }
            }
        }

        public Exception getException() {
            return this.ex;
        }
    }
}

