/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.io.IOException;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.openide.filesystems.EnvironmentNotSupportedException;
import org.openide.filesystems.FSException;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.MultiFileObject;
import org.openide.util.Enumerations;
import org.openide.util.actions.SystemAction;

public class MultiFileSystem
extends FileSystem {
    static final long serialVersionUID = -767493828111559560L;
    static final String MASK = "_hidden";
    private static final int WRITE_SYSTEM_INDEX = 0;
    private FileSystem[] systems;
    private boolean propagateMasks = false;
    private transient MultiFileObject root;

    protected MultiFileSystem() {
        this(new FileSystem[1]);
    }

    public MultiFileSystem(FileSystem[] fileSystemArray) {
        this.systems = (FileSystem[])fileSystemArray.clone();
    }

    public void refresh(boolean bl) {
        Enumeration enumeration = this.getMultiRoot().existingSubFiles(true);
        while (enumeration.hasMoreElements()) {
            FileObject fileObject = (FileObject)enumeration.nextElement();
            fileObject.refresh(bl);
        }
    }

    protected final void setDelegates(FileSystem[] fileSystemArray) {
        Object object;
        FileSystem[] fileSystemArray2 = this.systems;
        this.systems = fileSystemArray;
        this.getMultiRoot().updateAllAfterSetDelegates(fileSystemArray2);
        List<FileSystem> list = Arrays.asList(fileSystemArray2);
        List<FileSystem> list2 = Arrays.asList(this.systems);
        HashSet<FileSystem> hashSet = new HashSet<FileSystem>(list);
        hashSet.removeAll(list2);
        Object object2 = hashSet.iterator();
        while (object2.hasNext()) {
            object = object2.next();
            if (object == null) continue;
            ((FileSystem)object).removeNotify();
        }
        object2 = new HashSet<FileSystem>(list2);
        ((AbstractSet)object2).removeAll(list);
        object = ((HashSet)object2).iterator();
        while (object.hasNext()) {
            FileSystem fileSystem = (FileSystem)object.next();
            if (fileSystem == null) continue;
            fileSystem.addNotify();
        }
    }

    protected final FileSystem[] getDelegates() {
        return this.systems;
    }

    public final boolean getPropagateMasks() {
        return this.propagateMasks;
    }

    protected final void setPropagateMasks(boolean bl) {
        this.propagateMasks = bl;
    }

    public boolean isReadOnly() {
        return this.systems[0] == null || this.systems[0].isReadOnly();
    }

    public String getDisplayName() {
        return MultiFileSystem.getString("CTL_MultiFileSystem");
    }

    public FileObject getRoot() {
        return this.getMultiRoot();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MultiFileObject getMultiRoot() {
        Class clazz = MultiFileSystem.class;
        synchronized (clazz) {
            if (this.root == null) {
                this.root = new MultiFileObject(this);
            }
            return this.root;
        }
    }

    public SystemAction[] getActions() {
        ArrayList<SystemAction> arrayList = new ArrayList<SystemAction>(101);
        HashSet<SystemAction> hashSet = new HashSet<SystemAction>(101);
        FileSystem[] fileSystemArray = this.getDelegates();
        for (int i = 0; i < fileSystemArray.length; ++i) {
            if (fileSystemArray[i] == null) continue;
            SystemAction[] systemActionArray = fileSystemArray[i].getActions();
            for (int j = 0; j < systemActionArray.length; ++j) {
                if (!hashSet.add(systemActionArray[j])) continue;
                arrayList.add(systemActionArray[j]);
            }
        }
        return arrayList.toArray(new SystemAction[arrayList.size()]);
    }

    public SystemAction[] getActions(Set set) {
        ArrayList<SystemAction> arrayList = new ArrayList<SystemAction>(101);
        HashSet<SystemAction> hashSet = new HashSet<SystemAction>(101);
        FileSystem[] fileSystemArray = this.getDelegates();
        for (int i = 0; i < fileSystemArray.length; ++i) {
            if (fileSystemArray[i] == null) continue;
            SystemAction[] systemActionArray = fileSystemArray[i].getActions(set);
            for (int j = 0; j < systemActionArray.length; ++j) {
                if (!hashSet.add(systemActionArray[j])) continue;
                arrayList.add(systemActionArray[j]);
            }
        }
        return arrayList.toArray(new SystemAction[arrayList.size()]);
    }

    public FileObject find(String string, String string2, String string3) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        Enumeration<Object> enumeration = string2 == null || string3 == null ? stringTokenizer : Enumerations.concat((Enumeration)stringTokenizer, (Enumeration)Enumerations.singleton((Object)(string2 + '.' + string3)));
        return this.getMultiRoot().find(enumeration);
    }

    public FileObject findResource(String string) {
        if (string.length() == 0) {
            return this.getMultiRoot();
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        return this.getMultiRoot().find(stringTokenizer);
    }

    protected final FileSystem findSystem(FileObject fileObject) throws IllegalArgumentException {
        try {
            if (fileObject instanceof MultiFileObject) {
                MultiFileObject multiFileObject = (MultiFileObject)fileObject;
                return multiFileObject.getLeaderFileSystem();
            }
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            return this;
        }
        throw new IllegalArgumentException(fileObject.getPath());
    }

    protected final void hideResource(String string, boolean bl) throws IOException {
        if (bl) {
            this.maskFile(this.createWritableOn(string), string);
        } else {
            this.unmaskFile(this.createWritableOn(string), string);
        }
    }

    protected static Enumeration hiddenFiles(FileObject fileObject, boolean bl) {
        Enumeration enumeration = fileObject.getChildren(bl);
        class OnlyHidden
        implements Enumerations.Processor {
            OnlyHidden() {
            }

            public Object process(Object object, Collection collection) {
                String string = ((FileObject)object).getPath();
                if (string.endsWith(MultiFileSystem.MASK)) {
                    return string.substring(0, string.length() - MultiFileSystem.MASK.length());
                }
                return null;
            }
        }
        return Enumerations.filter((Enumeration)enumeration, (Enumerations.Processor)new OnlyHidden());
    }

    protected FileObject findResourceOn(FileSystem fileSystem, String string) {
        return fileSystem.findResource(string);
    }

    protected FileSystem createWritableOn(String string) throws IOException {
        if (this.systems[0] == null || this.systems[0].isReadOnly()) {
            FSException.io("EXC_FSisRO", this.getDisplayName());
        }
        return this.systems[0];
    }

    protected FileSystem createWritableOnForRename(String string, String string2) throws IOException {
        return this.createWritableOn(string2);
    }

    protected Set createLocksOn(String string) throws IOException {
        FileSystem fileSystem = this.createWritableOn(string);
        return Collections.singleton(fileSystem);
    }

    protected void notifyMigration(FileObject fileObject) {
    }

    protected void markUnimportant(FileObject fileObject) {
    }

    public void prepareEnvironment(FileSystem.Environment environment) throws EnvironmentNotSupportedException {
        FileSystem[] fileSystemArray = this.getDelegates();
        for (int i = 0; i < fileSystemArray.length; ++i) {
            if (fileSystemArray[i] == null) continue;
            try {
                fileSystemArray[i].prepareEnvironment(environment);
                continue;
            }
            catch (EnvironmentNotSupportedException environmentNotSupportedException) {
                // empty catch block
            }
        }
    }

    public void addNotify() {
        super.addNotify();
        for (int i = 0; i < this.systems.length; ++i) {
            if (this.systems[i] == null) continue;
            this.systems[i].addNotify();
        }
    }

    public void removeNotify() {
        super.removeNotify();
        for (int i = 0; i < this.systems.length; ++i) {
            if (this.systems[i] == null) continue;
            this.systems[i].removeNotify();
        }
    }

    private static String[] split(String string, String[] stringArray) {
        if (stringArray == null) {
            stringArray = new String[3];
        }
        int n = string.lastIndexOf(47);
        int n2 = string.lastIndexOf(46);
        stringArray[0] = n == -1 ? "" : string.substring(0, n);
        ++n;
        if (n2 == -1) {
            stringArray[1] = string.substring(n);
            stringArray[2] = "";
        } else {
            stringArray[1] = string.substring(n, n2);
            stringArray[2] = string.substring(n2 + 1);
        }
        return stringArray;
    }

    Enumeration delegates(String string) {
        Enumeration enumeration = Enumerations.array((Object[])this.systems);
        class Resources
        implements Enumerations.Processor {
            private final /* synthetic */ String val$name;

            Resources(String string) {
                this.val$name = string;
            }

            public Object process(Object object, Collection collection) {
                FileSystem fileSystem = (FileSystem)object;
                if (fileSystem == null) {
                    return null;
                }
                return MultiFileSystem.this.findResourceOn(fileSystem, this.val$name);
            }
        }
        return Enumerations.filter((Enumeration)enumeration, (Enumerations.Processor)new Resources(string));
    }

    void maskFile(FileSystem fileSystem, String string) throws IOException {
        FileObject fileObject = this.findResourceOn(fileSystem, fileSystem.getRoot().getPath());
        FileUtil.createData(fileObject, string + MASK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unmaskFile(FileSystem fileSystem, String string) throws IOException {
        FileObject fileObject = this.findResourceOn(fileSystem, string + MASK);
        if (fileObject != null) {
            FileLock fileLock = fileObject.lock();
            try {
                fileObject.delete(fileLock);
            }
            finally {
                fileLock.releaseLock();
            }
        }
    }

    void unmaskFileOnAll(FileSystem fileSystem, String string) throws IOException {
        FileSystem[] fileSystemArray = this.getDelegates();
        for (int i = 0; i < fileSystemArray.length; ++i) {
            if (fileSystemArray[i] == null || fileSystemArray[i].isReadOnly()) continue;
            this.unmaskFile(fileSystemArray[i], string);
            if (fileSystemArray[i] != fileSystem) continue;
            return;
        }
    }

    static boolean isMaskFile(FileObject fileObject) {
        return fileObject.getExt().endsWith(MASK);
    }
}

