/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.beans.PropertyVetoException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.Reference;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.openide.ErrorManager;
import org.openide.filesystems.AbstractFileSystem;
import org.openide.filesystems.FileObject;
import org.openide.util.Enumerations;

final class MemoryFileSystem
extends AbstractFileSystem
implements AbstractFileSystem.Info,
AbstractFileSystem.Change,
AbstractFileSystem.List,
AbstractFileSystem.Attr {
    private static final ErrorManager ERR = ErrorManager.getDefault().getInstance(MemoryFileSystem.class.getName());
    private static final boolean LOGGABLE = ERR.isLoggable(1);
    private Date created = new Date();
    private Map entries = this.initEntry();

    public MemoryFileSystem() {
        this.attr = this;
        this.list = this;
        this.change = this;
        this.info = this;
        try {
            this.setSystemName("MemoryFileSystem" + String.valueOf(System.identityHashCode(this)));
        }
        catch (PropertyVetoException propertyVetoException) {
            propertyVetoException.printStackTrace();
        }
    }

    public MemoryFileSystem(String[] stringArray) {
        this();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i]);
            this.getOrCreateEntry((String)stringArray[i]).data = (byte[])(stringArray[i].endsWith("/") ? null : new byte[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Entry getOrCreateEntry(String string) {
        if (string.length() > 0 && string.charAt(0) == '/') {
            string = string.substring(1);
        }
        boolean bl = this.isValidEntry(string);
        Map map = this.entries;
        synchronized (map) {
            Entry entry = (Entry)this.entries.get(string);
            if (entry == null || !bl) {
                entry = new Entry(string);
                this.entries.put(string, entry);
            }
            return entry;
        }
    }

    private boolean isValidEntry(String string) {
        return this.isValidEntry(string, null);
    }

    private boolean isValidEntry(String string, Boolean bl) {
        Reference reference;
        boolean bl2 = false;
        if (string.length() > 0 && string.charAt(0) == '/') {
            string = string.substring(1);
        }
        Entry entry = (Entry)this.entries.get(string);
        FileObject fileObject = null;
        if (entry != null && (reference = this.findReference(string)) != null) {
            fileObject = (FileObject)reference.get();
            boolean bl3 = bl2 = fileObject != null ? fileObject.isValid() : true;
        }
        if (LOGGABLE && bl != null && bl2 != bl) {
            MemoryFileSystem.logMessage("entry: " + entry + " isValidReference.fo: " + (fileObject == null ? "null" : (fileObject.isValid() ? "valid" : "invalid")));
        }
        return bl2;
    }

    public String getDisplayName() {
        return "MemoryFileSystem";
    }

    public boolean isReadOnly() {
        return false;
    }

    public Enumeration attributes(String string) {
        return this.isValidEntry(string) ? Collections.enumeration(this.getOrCreateEntry((String)string).attrs.keySet()) : Enumerations.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] children(String string) {
        if (string.length() > 0 && string.charAt(0) == '/') {
            string = string.substring(1);
        }
        if (string.length() > 0 && !string.endsWith("/")) {
            string = string + "/";
        }
        HashSet<String> hashSet = new HashSet<String>();
        Map map = this.entries;
        synchronized (map) {
            Iterator iterator = this.entries.keySet().iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                if (!string2.startsWith(string) && string.trim().length() != 0) continue;
                int n = string2.indexOf(47, string.length());
                String string3 = null;
                string3 = n > 0 ? string2.substring(string.length(), n) : string2.substring(string.length());
                if (string3.trim().length() <= 0) continue;
                hashSet.add(string3);
            }
            return hashSet.toArray(new String[0]);
        }
    }

    public void createData(String string) throws IOException {
        if (this.isValidEntry(string, Boolean.FALSE)) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("File already exists: ").append(string);
            throw new IOException(stringBuffer.toString());
        }
        this.getOrCreateEntry((String)string).data = new byte[0];
    }

    public void createFolder(String string) throws IOException {
        if (this.isValidEntry(string, Boolean.FALSE)) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Folder already exists: ").append(string);
            throw new IOException(stringBuffer.toString());
        }
        this.getOrCreateEntry((String)string).data = null;
    }

    public void delete(String string) throws IOException {
        if (this.entries.remove(string) == null) {
            throw new IOException("No file to delete: " + string);
        }
    }

    public void deleteAttributes(String string) {
    }

    public boolean folder(String string) {
        return this.getOrCreateEntry((String)string).data == null;
    }

    public InputStream inputStream(String string) throws FileNotFoundException {
        byte[] byArray = this.getOrCreateEntry((String)string).data;
        if (byArray == null) {
            byArray = new byte[]{};
        }
        return new ByteArrayInputStream(byArray);
    }

    public Date lastModified(String string) {
        Date date = this.getOrCreateEntry((String)string).last;
        return date == null ? this.created : date;
    }

    public void lock(String string) throws IOException {
    }

    public void markUnimportant(String string) {
    }

    public String mimeType(String string) {
        return (String)this.getOrCreateEntry((String)string).attrs.get("mimeType");
    }

    public OutputStream outputStream(String string) throws IOException {
        class Out
        extends ByteArrayOutputStream {
            private final /* synthetic */ String val$name;

            Out(String string) {
                this.val$name = string;
            }

            public void close() throws IOException {
                super.close();
                ((MemoryFileSystem)MemoryFileSystem.this).getOrCreateEntry((String)this.val$name).data = this.toByteArray();
                ((MemoryFileSystem)MemoryFileSystem.this).getOrCreateEntry((String)this.val$name).last = new Date();
            }
        }
        return new Out(string);
    }

    public Object readAttribute(String string, String string2) {
        return this.isValidEntry(string) ? this.getOrCreateEntry((String)string).attrs.get(string2) : null;
    }

    public boolean readOnly(String string) {
        return false;
    }

    public void rename(String string, String string2) throws IOException {
        if (!this.isValidEntry(string)) {
            throw new IOException("The file to rename does not exist.");
        }
        if (this.isValidEntry(string2)) {
            throw new IOException("Cannot rename to existing file");
        }
        if (string2.length() > 0 && string2.charAt(0) == '/') {
            string2 = string2.substring(1);
        }
        Entry entry = this.getOrCreateEntry(string);
        this.entries.remove(string);
        this.entries.put(string2, entry);
    }

    public void renameAttributes(String string, String string2) {
    }

    public long size(String string) {
        byte[] byArray = this.getOrCreateEntry((String)string).data;
        return byArray == null ? 0L : (long)byArray.length;
    }

    public void unlock(String string) {
    }

    public void writeAttribute(String string, String string2, Object object) throws IOException {
        this.getOrCreateEntry((String)string).attrs.put(string2, object);
    }

    private Map initEntry() {
        return Collections.synchronizedMap(!LOGGABLE ? new Hashtable() : new Hashtable(){

            public Object get(Object object) {
                Object v = super.get(object);
                MemoryFileSystem.logMessage("called: GET key: " + object + " result: " + v);
                return v;
            }

            public Object put(Object object, Object object2) {
                Object object3 = super.put(object, object2);
                MemoryFileSystem.logMessage("called: PUT key: " + object + " value: " + object2 + " result: " + object3);
                return object3;
            }

            public Object remove(Object object) {
                Object v = super.remove(object);
                MemoryFileSystem.logMessage("called: REMOVE key: " + object + " result: " + v);
                return v;
            }
        });
    }

    private static void logMessage(String string) {
        if (LOGGABLE) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(" -> ").append(string);
            ERR.log(1, stringBuffer.toString());
        }
    }

    static final class Entry {
        public HashMap attrs = new HashMap();
        public byte[] data;
        public Date last;
        private final String entryName;

        Entry(String string) {
            this.entryName = string;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(" [").append(this.entryName);
            stringBuffer.append(" -> ").append(super.toString());
            stringBuffer.append("] ");
            return stringBuffer.toString();
        }
    }
}

