/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.queries;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.spi.queries.VisibilityQueryImplementation;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;

public final class VisibilityQuery {
    private static final VisibilityQuery INSTANCE = new VisibilityQuery();
    private static final Lookup.Template TEMPLATE = new Lookup.Template(VisibilityQueryImplementation.class);
    private final ResultListener resultListener = new ResultListener();
    private final VqiChangedListener vqiListener = new VqiChangedListener();
    private final List listeners = Collections.synchronizedList(new ArrayList());
    private Lookup.Result vqiResult = null;
    private Set cachedVqiInstances = null;

    public static final VisibilityQuery getDefault() {
        return INSTANCE;
    }

    private VisibilityQuery() {
    }

    public boolean isVisible(FileObject fileObject) {
        boolean bl = true;
        Set set = this.getVqiInstances();
        Iterator iterator = set.iterator();
        while (bl && iterator.hasNext()) {
            VisibilityQueryImplementation visibilityQueryImplementation = (VisibilityQueryImplementation)iterator.next();
            bl = visibilityQueryImplementation.isVisible(fileObject);
        }
        return bl;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChange() {
        ChangeListener[] changeListenerArray;
        Object object = this.listeners;
        synchronized (object) {
            if (this.listeners.isEmpty()) {
                return;
            }
            changeListenerArray = this.listeners.toArray(new ChangeListener[this.listeners.size()]);
        }
        object = new ChangeEvent(this);
        for (int i = 0; i < changeListenerArray.length; ++i) {
            changeListenerArray[i].stateChanged((ChangeEvent)object);
        }
    }

    private synchronized Set getVqiInstances() {
        if (this.cachedVqiInstances == null) {
            this.vqiResult = Lookup.getDefault().lookup(TEMPLATE);
            this.vqiResult.addLookupListener((LookupListener)this.resultListener);
            this.setupChangeListeners(this.cachedVqiInstances, new LinkedHashSet(this.vqiResult.allInstances()));
        }
        return this.cachedVqiInstances;
    }

    private synchronized void setupChangeListeners(Set set, Set set2) {
        VisibilityQueryImplementation visibilityQueryImplementation;
        Iterator iterator;
        HashSet hashSet;
        if (set != null) {
            hashSet = new HashSet(set);
            hashSet.removeAll(set2);
            iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                visibilityQueryImplementation = (VisibilityQueryImplementation)iterator.next();
                visibilityQueryImplementation.removeChangeListener(this.vqiListener);
            }
        }
        hashSet = new HashSet(set2);
        if (set != null) {
            hashSet.removeAll(set);
        }
        iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            visibilityQueryImplementation = (VisibilityQueryImplementation)iterator.next();
            visibilityQueryImplementation.addChangeListener(this.vqiListener);
        }
        this.cachedVqiInstances = set2;
    }

    private class ResultListener
    implements LookupListener {
        private ResultListener() {
        }

        public void resultChanged(LookupEvent lookupEvent) {
            VisibilityQuery.this.setupChangeListeners(VisibilityQuery.this.cachedVqiInstances, new LinkedHashSet(VisibilityQuery.this.vqiResult.allInstances()));
            VisibilityQuery.this.fireChange();
        }
    }

    private class VqiChangedListener
    implements ChangeListener {
        private VqiChangedListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            VisibilityQuery.this.fireChange();
        }
    }
}

