/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.updater;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.URL;
import java.util.Locale;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import org.netbeans.updater.Localization;
import org.netbeans.updater.ModuleUpdater;

public class UpdaterFrame
extends JPanel {
    int xxx = 0xFFFFFF;
    public static final int OS_WIN = 1;
    public static final int OS_SOLARIS = 8;
    public static final int OS_LINUX = 16;
    public static final int OS_OS2 = 1024;
    public static final int OS_OTHER = 65536;
    private static final String SPLASH_PATH = "org/netbeans/updater/resources/updatersplash";
    private static final String UNDERLINE = "_";
    private static UpdaterFrame panel;
    private static boolean bigBounds;
    private static ModuleUpdater mu;
    private static boolean fromIDE;
    private static Window splashWindow;
    private static boolean noSplash;
    private JLabel jLabel3;
    private JTextArea jTextArea1;
    private JProgressBar progressBar;
    private JLabel textLabel;

    public UpdaterFrame() {
        this.initComponents();
        if (UpdaterFrame.addBorder()) {
            this.setBorder(new LineBorder(UpdaterFrame.stringToColor("UpdaterFrame.LineBorder.Color", new Color(0, 0, 0))));
        }
        this.loadSplash();
    }

    static final void center(Window c) {
        c.pack();
        GraphicsConfiguration gconf = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        Rectangle bounds = gconf.getBounds();
        Dimension dialogSize = c.getSize();
        c.setLocation(bounds.x + (bounds.width - dialogSize.width) / 2, bounds.y + (bounds.height - dialogSize.height) / 2);
    }

    static String getMainWindowTitle() {
        return Localization.getBrandedString("UpdaterFrame.Form.title");
    }

    private void initComponents() {
        this.jLabel3 = new JLabel();
        this.jTextArea1 = new JTextArea();
        this.textLabel = new JLabel();
        this.progressBar = new JProgressBar();
        this.setLayout(new GridBagLayout());
        this.setBackground(UpdaterFrame.stringToColor("UpdaterFrame.Background", new Color(6, 4, 100)));
        this.setBorder(new EmptyBorder(new Insets(0, 0, 0, 0)));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        this.add((Component)this.jLabel3, gridBagConstraints);
        this.jTextArea1.setBackground(UpdaterFrame.stringToColor("UpdaterFrame.TextBackground", new Color(213, 204, 187)));
        this.jTextArea1.setEditable(false);
        this.jTextArea1.setForeground(UpdaterFrame.stringToColor("UpdaterFrame.TextForeground", Color.white));
        this.jTextArea1.setText(Localization.getBrandedString("UpdaterFrame.jTextArea1.text"));
        this.jTextArea1.setDisabledTextColor(UpdaterFrame.stringToColor("UpdaterFrame.DisabledTextColor", Color.white));
        this.jTextArea1.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(8, 14, 0, 14);
        this.add((Component)this.jTextArea1, gridBagConstraints);
        this.textLabel.setFont(new Font("Dialog", 1, 11));
        this.textLabel.setForeground(UpdaterFrame.stringToColor("UpdaterFrame.TextForeground", Color.white));
        this.textLabel.setText(Localization.getBrandedString("UpdaterFrame.textLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 14, 8, 14);
        this.add((Component)this.textLabel, gridBagConstraints);
        this.progressBar.setPreferredSize(UpdaterFrame.stringToDimension("UpdaterFrame.ProgressBar.PreferredSize", new Dimension(300, 20)));
        this.progressBar.setRequestFocusEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 14, 10, 14);
        this.add((Component)this.progressBar, gridBagConstraints);
    }

    protected void paintComponent(Graphics g) {
        if (UpdaterFrame.isGradient()) {
            Color outerColor = UpdaterFrame.stringToColor("UpdaterFrame.outerColor", new Color(230, 242, 234));
            Color centerColor = UpdaterFrame.stringToColor("UpdaterFrame.centerColor", Color.WHITE);
            int w = this.getWidth();
            int h = this.getHeight();
            Graphics2D g2d = (Graphics2D)g;
            g2d.setPaint(new GradientPaint(0.0f, 0.0f, outerColor, w / 2, 0.0f, centerColor, true));
            g2d.fillRect(0, 0, w, h);
        } else {
            super.paintComponent(g);
        }
    }

    private static void showSplash() {
        splashWindow = UpdaterFrame.getOperatingSystem() == 1 || UpdaterFrame.getOperatingSystem() == 8 || UpdaterFrame.getOperatingSystem() == 1024 || UpdaterFrame.getOperatingSystem() == 16 ? new SplashWindow() : new SplashFrame();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                splashWindow.setVisible(true);
                splashWindow.toFront();
            }
        });
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            UpdaterFrame.cli(args);
        }
        panel = new UpdaterFrame();
        if (!noSplash) {
            UpdaterFrame.showSplash();
        }
        mu = new ModuleUpdater();
        mu.start();
    }

    public static void runFromIDE(File[] files, PropertyChangeListener listener, String brandingToken) {
        fromIDE = true;
        Localization.setBranding(brandingToken);
        panel = new UpdaterFrame();
        panel.addPropertyChangeListener(listener);
        if (!noSplash) {
            UpdaterFrame.showSplash();
        }
        mu = new ModuleUpdater();
        mu.setInstallOnly(files);
        mu.start();
    }

    void unpackingFinished() {
        this.runningFinished();
    }

    void runningFinished() {
        if (fromIDE) {
            this.firePropertyChange("FINISHED", null, null);
            if (splashWindow != null) {
                splashWindow.dispose();
            }
        } else {
            System.exit(0);
        }
    }

    boolean isFromIde() {
        return fromIDE;
    }

    static void setLabel(final String text) {
        if (noSplash) {
            return;
        }
        final JLabel label = UpdaterFrame.panel.textLabel;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                label.setText(text);
            }
        });
    }

    static void setProgressRange(final long min, final long max) {
        if (noSplash) {
            return;
        }
        bigBounds = max > 65535L;
        final JProgressBar progressBar = UpdaterFrame.panel.progressBar;
        final boolean bb = bigBounds;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                progressBar.setMinimum(bb ? (int)(min / 1024L) : (int)min);
                progressBar.setMaximum(bb ? (int)(max / 1024L) : (int)max);
            }
        });
    }

    static void setProgressValue(final long value) {
        if (noSplash) {
            return;
        }
        final JProgressBar progressBar = UpdaterFrame.panel.progressBar;
        final boolean bb = bigBounds;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                progressBar.setValue(bb ? (int)(value / 1024L) : (int)value);
            }
        });
    }

    public static final int getOperatingSystem() {
        int operatingSystem = -1;
        String osName = System.getProperty("os.name");
        operatingSystem = osName != null && osName.startsWith("Windows") ? 1 : ("Solaris".equals(osName) ? 8 : (osName.startsWith("SunOS") ? 8 : ("Linux".equals(osName) ? 16 : ("OS/2".equals(osName) ? 1024 : 65536))));
        return operatingSystem;
    }

    static boolean isFromIDE() {
        return fromIDE;
    }

    static UpdaterFrame getUpdaterFrame() {
        return panel;
    }

    private static Color stringToColor(String key, Color defcolor) {
        try {
            String str = Localization.getBrandedString(key + "_R");
            int re = Integer.parseInt(str);
            str = Localization.getBrandedString(key + "_G");
            int gr = Integer.parseInt(str);
            str = Localization.getBrandedString(key + "_B");
            int bl = Integer.parseInt(str);
            return new Color(re, gr, bl);
        }
        catch (Exception e) {
            return defcolor;
        }
    }

    private static Dimension stringToDimension(String key, Dimension defaultSize) {
        try {
            String str = Localization.getBrandedString(key + "_X");
            int x = Integer.parseInt(str);
            str = Localization.getBrandedString(key + "_Y");
            int y = Integer.parseInt(str);
            return new Dimension(x, y);
        }
        catch (Exception e) {
            return defaultSize;
        }
    }

    private static boolean addBorder() {
        return "true".equals(Localization.getBrandedString("UpdaterFrame.hasBorder"));
    }

    private static boolean isGradient() {
        return "true".equals(Localization.getBrandedString("UpdaterFrame.isGradient"));
    }

    private void loadSplash() {
        URL lookup = Localization.getBrandedResource(SPLASH_PATH, ".gif");
        if (lookup != null) {
            this.jLabel3.setIcon(new ImageIcon(lookup));
        }
    }

    private static boolean isOption(String value, String optionName) {
        if (value == null) {
            return false;
        }
        if (value.startsWith("--")) {
            return value.substring(2).equals(optionName);
        }
        if (value.startsWith("-")) {
            return value.substring(1).equals(optionName);
        }
        return false;
    }

    private static int cli(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (args[i] == null) continue;
            if (UpdaterFrame.isOption(args[i], "nosplash")) {
                noSplash = true;
                continue;
            }
            if (UpdaterFrame.isOption(args[i], "locale")) {
                String language;
                args[i] = null;
                String localeParam = args[++i];
                String country = "";
                String variant = "";
                int index1 = localeParam.indexOf(":");
                if (index1 == -1) {
                    language = localeParam;
                } else {
                    language = localeParam.substring(0, index1);
                    int index2 = localeParam.indexOf(":", index1 + 1);
                    if (index2 != -1) {
                        country = localeParam.substring(index1 + 1, index2);
                        variant = localeParam.substring(index2 + 1);
                    } else {
                        country = localeParam.substring(index1 + 1);
                    }
                }
                Locale.setDefault(new Locale(language, country, variant));
                continue;
            }
            if (!UpdaterFrame.isOption(args[i], "branding")) continue;
            args[i] = null;
            if (++i == args.length) {
                System.err.println("Option --branding requires one argument.");
                return 2;
            }
            String branding = args[i];
            if (branding.equals("-")) {
                branding = null;
            }
            try {
                Localization.setBranding(branding);
                continue;
            }
            catch (IllegalArgumentException iae) {
                iae.printStackTrace();
                return 1;
            }
        }
        return 0;
    }

    static {
        bigBounds = false;
        mu = null;
        fromIDE = false;
        noSplash = false;
    }

    static class SplashFrame
    extends JFrame {
        public SplashFrame() {
            super(UpdaterFrame.getMainWindowTitle());
            this.setDefaultCloseOperation(0);
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.getContentPane().add(panel);
            UpdaterFrame.center(this);
        }

        public Dimension getPreferredSize() {
            return UpdaterFrame.stringToDimension("UpdaterFrame.Splash.PreferredSize", new Dimension(400, 280));
        }
    }

    static class SplashWindow
    extends Window {
        public SplashWindow() {
            super(new Frame());
            this.setLayout(new BorderLayout());
            this.add((Component)panel, "Center");
            UpdaterFrame.center(this);
        }

        public Dimension getPreferredSize() {
            return UpdaterFrame.stringToDimension("UpdaterFrame.Splash.PreferredSize", new Dimension(400, 280));
        }
    }
}

