/*
 * Decompiled with CFR 0.152.
 */
package tr.extract.reports.projectoutline;

import java.io.File;
import java.net.URL;
import java.util.List;
import java.util.Vector;
import tr.extract.Extract;
import tr.extract.Param;
import tr.extract.ParamBoolean;
import tr.extract.ParamFont;
import tr.extract.ParamProject;
import tr.extract.ParamsDialog;
import tr.model.Data;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportImplCurrent
extends Extract {
    public String getID() {
        return "project-outline-current";
    }

    public String getName() {
        return this.getString("CTL_ReportActionCurrent");
    }

    public List<Param> getParams() {
        Vector<Param> params = new Vector<Param>(4);
        params.add((Param)new ParamProject("project-key", this.getString("param-project"), this.getString("param-project-current"), false));
        params.add((Param)new ParamBoolean("include-done", this.getString("param-include-done")));
        params.add((Param)new ParamBoolean("striked-done", this.getString("param-striked-done")));
        params.add((Param)new ParamBoolean("colour", this.getString("param-use-colour")));
        params.add((Param)new ParamFont("font", this.getString("param-font")));
        return params;
    }

    public void process(Data data) throws Exception {
        List<Param> params = this.getParams();
        String title = this.getDialogTitleReport(this.getName());
        ParamsDialog dlg = new ParamsDialog(title, this.getID(), params);
        if (dlg.showDialog() == 2) {
            return;
        }
        File xmlfile = this.getTmpFile("data.xml");
        this.extractData(data, xmlfile);
        URL xslfoURL = ((Object)((Object)this)).getClass().getResource("project-outline-current.fo.xml");
        File outfile = this.getOutFile(this.getID() + "-" + this.getTimeStamp() + ".pdf");
        this.transformXSLFO(xmlfile, xslfoURL, params, outfile);
        this.openFile(outfile);
    }
}

