/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.options.ui.ListModel;
import org.netbeans.modules.options.ui.TabbedPanel;

public class TabbedListPanel
extends TabbedPanel {
    public TabbedListPanel(ListModel listModel, int n) {
        super(listModel, n, true);
        this.addActionListener(new Listener());
    }

    public JList getSelectedList() {
        JComponent jComponent = this.getSelectedComponent();
        if (jComponent == null) {
            return null;
        }
        if (jComponent instanceof JList) {
            return (JList)jComponent;
        }
        return (JList)((JScrollPane)jComponent).getViewport().getView();
    }

    public int getSelectedListIndex() {
        JList jList = this.getSelectedList();
        if (jList == null) {
            return -1;
        }
        return jList.getSelectedIndex();
    }

    public void refreshPanels() {
        super.refreshPanels();
    }

    public void setSelectedListIndex(int n) {
        JList jList = this.getSelectedList();
        if (jList == null) {
            return;
        }
        jList.setSelectedIndex(n);
    }

    public Object getSelectedListItem() {
        JList jList = this.getSelectedList();
        if (jList == null) {
            return null;
        }
        return jList.getSelectedValue();
    }

    private class Listener
    implements ActionListener,
    ListSelectionListener {
        private JList currentList;

        Listener() {
            this.currentList = TabbedListPanel.this.getSelectedList();
            if (this.currentList != null) {
                this.currentList.addListSelectionListener(this);
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JList jList = TabbedListPanel.this.getSelectedList();
            if (jList == this.currentList) {
                return;
            }
            if (this.currentList != null) {
                this.currentList.removeListSelectionListener(this);
            }
            this.currentList = jList;
            if (this.currentList != null) {
                this.currentList.addListSelectionListener(this);
            }
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            TabbedListPanel.this.fireActionPerformed(new ActionEvent(TabbedListPanel.this, 0, "selectedIndex"));
        }
    }
}

