/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.advanced;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import org.netbeans.modules.options.ui.TabbedPanelModel;
import org.netbeans.spi.options.AdvancedOption;
import org.netbeans.spi.options.OptionsPanelController;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.FolderLookup;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.lookup.ProxyLookup;

public final class Model
extends TabbedPanelModel {
    private Map categoryToOption = new HashMap();
    private Map categoryToPanel = new HashMap();
    private Map categoryToController = new HashMap();
    private Lookup masterLookup;
    private boolean initialized = false;

    public List getCategories() {
        this.init();
        ArrayList arrayList = new ArrayList(this.categoryToOption.keySet());
        Collections.sort(arrayList);
        return arrayList;
    }

    public JComponent getPanel(String string) {
        this.init();
        JComponent jComponent = (JComponent)this.categoryToPanel.get(string);
        if (jComponent != null) {
            return jComponent;
        }
        AdvancedOption advancedOption = (AdvancedOption)this.categoryToOption.get(string);
        OptionsPanelController optionsPanelController = advancedOption.create();
        this.categoryToController.put(string, optionsPanelController);
        jComponent = optionsPanelController.getComponent(this.masterLookup);
        this.categoryToPanel.put(string, jComponent);
        Border border = jComponent.getBorder();
        border = border != null ? new CompoundBorder(new EmptyBorder(6, 16, 6, 6), border) : new EmptyBorder(6, 16, 6, 6);
        jComponent.setBorder(border);
        jComponent.setBackground(Color.white);
        jComponent.setMaximumSize(jComponent.getPreferredSize());
        return jComponent;
    }

    void update() {
        Iterator iterator = this.categoryToController.values().iterator();
        while (iterator.hasNext()) {
            ((OptionsPanelController)iterator.next()).update();
        }
    }

    void applyChanges() {
        Iterator iterator = this.categoryToController.values().iterator();
        while (iterator.hasNext()) {
            ((OptionsPanelController)iterator.next()).applyChanges();
        }
    }

    void cancel() {
        Iterator iterator = this.categoryToController.values().iterator();
        while (iterator.hasNext()) {
            ((OptionsPanelController)iterator.next()).cancel();
        }
    }

    boolean isValid() {
        Iterator iterator = this.categoryToController.values().iterator();
        while (iterator.hasNext()) {
            if (((OptionsPanelController)iterator.next()).isValid()) continue;
            return false;
        }
        return true;
    }

    boolean isChanged() {
        Iterator iterator = this.categoryToController.values().iterator();
        while (iterator.hasNext()) {
            if (!((OptionsPanelController)iterator.next()).isChanged()) continue;
            return true;
        }
        return false;
    }

    Lookup getLookup() {
        ArrayList<Lookup> arrayList = new ArrayList<Lookup>();
        Iterator iterator = this.categoryToController.values().iterator();
        while (iterator.hasNext()) {
            arrayList.add(((OptionsPanelController)iterator.next()).getLookup());
        }
        return new ProxyLookup(arrayList.toArray(new Lookup[arrayList.size()]));
    }

    HelpCtx getHelpCtx(JComponent jComponent) {
        Iterator iterator = this.categoryToPanel.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (jComponent != this.categoryToPanel.get(string)) continue;
            OptionsPanelController optionsPanelController = (OptionsPanelController)this.categoryToController.get(string);
            return optionsPanelController.getHelpCtx();
        }
        return new HelpCtx("netbeans.optionsDialog.advanced");
    }

    private void init() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        FileObject fileObject = Repository.getDefault().getDefaultFileSystem().findResource("OptionsDialog/Advanced");
        if (fileObject == null) {
            return;
        }
        Lookup lookup = new FolderLookup((DataObject.Container)DataFolder.findFolder((FileObject)fileObject)).getLookup();
        Iterator iterator = lookup.lookup(new Lookup.Template(AdvancedOption.class)).allInstances().iterator();
        while (iterator.hasNext()) {
            AdvancedOption advancedOption = (AdvancedOption)iterator.next();
            this.categoryToOption.put(advancedOption.getDisplayName(), advancedOption);
        }
    }

    void setLoookup(Lookup lookup) {
        this.masterLookup = lookup;
    }
}

