/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.catalog;

import java.awt.Component;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.netbeans.Module;
import org.netbeans.modules.autoupdate.catalog.ModuleBean;
import org.netbeans.modules.autoupdate.catalog.ModuleNode;
import org.netbeans.modules.autoupdate.catalog.ModuleNodeActions;
import org.netbeans.modules.autoupdate.catalog.ModuleSelectionPanel;
import org.netbeans.modules.autoupdate.catalog.ModuleUninstallPanel;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

class ModuleNodeUtils {
    static final /* synthetic */ boolean $assertionsDisabled;

    private ModuleNodeUtils() {
    }

    private static Set getCategoryModules(Node node) {
        if (!$assertionsDisabled && node.isLeaf()) {
            throw new AssertionError((Object)("Parent " + node + " cannot be leaf."));
        }
        HashSet<Node> hashSet = new HashSet<Node>();
        Node[] nodeArray = node.getChildren().getNodes(true);
        for (int i = 0; i < nodeArray.length; ++i) {
            if (!(nodeArray[i] instanceof ModuleNode.Item)) continue;
            hashSet.add(nodeArray[i]);
        }
        return hashSet;
    }

    static Set getAllSelectedModuleItems(Node[] nodeArray) {
        HashSet<Node> hashSet = new HashSet<Node>();
        for (int i = 0; i < nodeArray.length; ++i) {
            if (nodeArray[i] instanceof ModuleNode.Item) {
                hashSet.add(nodeArray[i]);
                continue;
            }
            if (nodeArray[i].isLeaf()) continue;
            hashSet.addAll(ModuleNodeUtils.getCategoryModules(nodeArray[i]));
        }
        return hashSet;
    }

    static Set getAllSelectedModuleBeans(Node[] nodeArray) {
        HashSet<ModuleBean> hashSet = new HashSet<ModuleBean>();
        for (int i = 0; i < nodeArray.length; ++i) {
            if (nodeArray[i] instanceof ModuleNode.Item) {
                hashSet.add(((ModuleNode.Item)nodeArray[i]).getItem());
                continue;
            }
            if (nodeArray[i].isLeaf()) continue;
            hashSet.addAll(ModuleNodeUtils.getAllSelectedModuleBeans(nodeArray[i].getChildren().getNodes(true)));
        }
        return hashSet;
    }

    static Boolean isEnableCandidate(Node[] nodeArray) {
        Iterator iterator = ModuleNodeUtils.getAllSelectedModuleBeans(nodeArray).iterator();
        Boolean bl = null;
        while (iterator.hasNext()) {
            ModuleBean moduleBean = (ModuleBean)iterator.next();
            if (bl == null) {
                bl = moduleBean.isEnabled() ? Boolean.FALSE : Boolean.TRUE;
                continue;
            }
            if (bl.booleanValue() != moduleBean.isEnabled()) continue;
            return null;
        }
        return bl;
    }

    static boolean isEnableAllowed(Module module) {
        if (!module.isValid()) {
            return false;
        }
        return module.getProblems().isEmpty() && !module.isAutoload() && !module.isEager() && module.getJarFile() != null;
    }

    static String getUninstallActionName(Node[] nodeArray, String string) {
        String string2;
        if (nodeArray == null || nodeArray.length == 0) {
            return string;
        }
        if (nodeArray.length == 1 && !(nodeArray[0] instanceof ModuleNode.Item)) {
            string2 = NbBundle.getMessage((Class)ModuleNodeActions.class, (String)"CTL_ModuleNodeActions_UninstallAction", (Object)nodeArray[0].getDisplayName());
        } else {
            Set set = ModuleNodeUtils.getAllSelectedModuleItems(nodeArray);
            string2 = NbBundle.getMessage((Class)ModuleNodeActions.class, (String)"CTL_ModuleNodeActions_UninstallAction", (Object)(set.size() > 1 ? NbBundle.getMessage((Class)ModuleNodeActions.class, (String)"CTL_ModuleNodeActions_UninstallAction_many") : ((ModuleNode.Item)set.iterator().next()).getDisplayName()));
        }
        return string2;
    }

    static boolean canUninstall(Node[] nodeArray) {
        if (nodeArray == null || nodeArray.length == 0) {
            return false;
        }
        Set set = ModuleNodeUtils.getAllSelectedModuleItems(nodeArray);
        boolean bl = !set.isEmpty();
        Iterator iterator = set.iterator();
        String string = null;
        while (bl && iterator.hasNext()) {
            Object e = iterator.next();
            if (!$assertionsDisabled && !(e instanceof ModuleNode.Item)) {
                throw new AssertionError((Object)("Object " + e + " is instanceof ModuleNode.Item"));
            }
            Module module = ((ModuleNode.Item)e).getItem().getModule();
            bl = bl && ((Node)e).canDestroy();
            string = module.getDisplayName();
        }
        return bl;
    }

    static void doUninstall(final Node[] nodeArray) {
        if (ModuleNodeUtils.confirmUninstall(nodeArray)) {
            ModuleSelectionPanel.getGUI(false).setWaitingState(true, true);
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    ModuleNodeUtils.uninstallNodes(nodeArray);
                }
            });
        }
    }

    static boolean confirmUninstall(Node[] nodeArray) {
        if (!$assertionsDisabled && nodeArray == null) {
            throw new AssertionError((Object)"Any ModuleNode must be selected");
        }
        Set set = ModuleNodeUtils.getAllSelectedModuleItems(nodeArray);
        if (!$assertionsDisabled && set.isEmpty()) {
            throw new AssertionError((Object)"Any module must be selected");
        }
        String string = null;
        if (nodeArray.length == 1 && !(nodeArray[0] instanceof ModuleNode.Item)) {
            string = nodeArray[0].getDisplayName();
        }
        Iterator iterator = set.iterator();
        HashSet<Module> hashSet = new HashSet<Module>(set.size());
        while (iterator.hasNext()) {
            hashSet.add(((ModuleNode.Item)iterator.next()).getItem().getModule());
        }
        ModuleUninstallPanel moduleUninstallPanel = new ModuleUninstallPanel(hashSet, string);
        ((Component)moduleUninstallPanel).getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)ModuleSelectionPanel.class, (String)"ACD_ModuleUninstallPanel_form"));
        NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)moduleUninstallPanel, NbBundle.getMessage((Class)ModuleSelectionPanel.class, (String)"CTL_ModuleUninstallPanel_UninstallConfirmation"), 0);
        return NotifyDescriptor.YES_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation));
    }

    private static void uninstallNodes(Node[] nodeArray) {
        if (!$assertionsDisabled && nodeArray == null) {
            throw new AssertionError((Object)"uninstallNodes cannot be called on null nodes.");
        }
        for (int i = 0; i < nodeArray.length; ++i) {
            if (nodeArray[i].isLeaf()) {
                if (!$assertionsDisabled && !(nodeArray[i] instanceof ModuleNode.Item)) {
                    throw new AssertionError((Object)("Node " + nodeArray[i] + " instanceof ModuleNode.Item"));
                }
                ((ModuleNode.Item)nodeArray[i]).uninstall();
                continue;
            }
            ModuleNodeUtils.uninstallNodes(nodeArray[i].getChildren().getNodes(true));
        }
    }

    static {
        $assertionsDisabled = !ModuleNodeUtils.class.desiredAssertionStatus();
    }
}

