/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate;

import java.beans.PropertyEditorSupport;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.Random;
import org.netbeans.modules.autoupdate.AutoupdateType;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.options.SystemOption;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class Settings
extends SystemOption {
    private static final String PROP_ASK_BEFORE = "askBefore";
    private static final String PROP_NEGATIVE_RESULTS = "negativeResults";
    private static final String PROP_PERIOD = "period";
    private static final String PROP_LAST_CHECK = "lastCheck";
    private static final String PROP_IDE_IDENTITY = "ideIdentity";
    private static final String PROP_ACCEPTED_NOTIFICATIONS = "acceptedNotifications";
    public static final int EVERY_STARTUP = 0;
    public static final int EVERY_DAY = 1;
    public static final int EVERY_WEEK = 2;
    public static final int EVERY_2WEEKS = 3;
    public static final int EVERY_MONTH = 4;
    public static final int EVERY_NEVER = 5;
    public static final String NODE_DEFAULT_ACTION = "nodeDefaultAction";
    static final long serialVersionUID = 362844553936969452L;
    private static final Random RANDOM;
    private static final ErrorManager err;
    private String tempIdeIdentity = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected void initialize() {
        super.initialize();
        this.setNegativeResults(false);
        this.setPeriod(2);
        this.setLastCheck(null);
        this.setAskBefore(false);
    }

    static Settings getShared() {
        return (Settings)Settings.findObject((Class)Settings.class, (boolean)true);
    }

    public String displayName() {
        return Settings.getBundle("CTL_Settings_Name");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(Settings.class);
    }

    public int getPeriod() {
        return (Integer)this.getProperty(PROP_PERIOD);
    }

    public void setPeriod(int n) {
        this.putProperty(PROP_PERIOD, new Integer(n), true);
    }

    protected AutoupdateType defaultAutoupdateType() {
        return AutoupdateType.getDefault();
    }

    public void setIdeIdentity(String string) {
        this.putProperty(PROP_IDE_IDENTITY, string, true);
    }

    public String getIdeIdentity() {
        if (this.tempIdeIdentity instanceof String) {
            return this.tempIdeIdentity;
        }
        Object object = this.getProperty(PROP_IDE_IDENTITY);
        String string = null;
        string = object == null ? Settings.modifyIdeIdentityIfNeeded(Integer.toString(Settings.generateNewId())) : Settings.modifyIdeIdentityIfNeeded((String)object);
        this.tempIdeIdentity = string;
        if (!string.equals(object)) {
            err.log("Put new value of PROP_IDE_IDENTITY to " + string);
            this.putProperty(PROP_IDE_IDENTITY, string, true);
        }
        return this.tempIdeIdentity;
    }

    public void setAcceptedNotifications(Map map) {
        this.putProperty(PROP_ACCEPTED_NOTIFICATIONS, map, true);
    }

    public Map getAcceptedNotifications() {
        return (Map)this.getProperty(PROP_ACCEPTED_NOTIFICATIONS);
    }

    public boolean isAskBefore() {
        return (Boolean)this.getProperty(PROP_ASK_BEFORE);
    }

    public void setAskBefore(boolean bl) {
        this.putProperty(PROP_ASK_BEFORE, bl ? Boolean.TRUE : Boolean.FALSE, true);
    }

    public boolean isNegativeResults() {
        return (Boolean)this.getProperty(PROP_NEGATIVE_RESULTS);
    }

    public void setNegativeResults(boolean bl) {
        this.putProperty(PROP_NEGATIVE_RESULTS, bl ? Boolean.TRUE : Boolean.FALSE, true);
    }

    public Date getLastCheck() {
        return (Date)this.getProperty(PROP_LAST_CHECK);
    }

    public void setLastCheck(Date date) {
        this.putProperty(PROP_LAST_CHECK, date, true);
    }

    public void fireNodeDefaultAction() {
        this.firePropertyChange(NODE_DEFAULT_ACTION, null, null);
    }

    private static String getBundle(String string) {
        return NbBundle.getMessage((Class)Settings.class, (String)string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String modifyIdeIdentityIfNeeded(String string) {
        String string2;
        String string3;
        String string4;
        block10: {
            String[] stringArray = string.split("\\d");
            string4 = null;
            string3 = null;
            if (stringArray.length == 0) {
                string4 = string;
                string3 = "";
            } else {
                if (!$assertionsDisabled && stringArray.length != 1) {
                    throw new AssertionError((Object)"ideIdentityArr cannot be greater then 1!");
                }
                string3 = stringArray[0];
                string4 = string.substring(string3.length());
            }
            err.log("Old IDE Identity Prefix: " + string3);
            err.log("Old IDE Identity ID: " + string4);
            string2 = "";
            try {
                FileObject fileObject = Repository.getDefault().getDefaultFileSystem().findResource("/productid");
                if (fileObject == null) break block10;
                InputStream inputStream = fileObject.getInputStream();
                try {
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                    string2 = bufferedReader.readLine().trim();
                }
                finally {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (!string2.equals(string3)) {
            err.log("New IDE Identity Prefix: " + string2);
        } else {
            err.log("No new prefix.");
        }
        return string2 + string4;
    }

    private static int generateNewId() {
        int n = RANDOM.nextInt();
        if (n < 0) {
            n = -(n + 1);
        }
        return n;
    }

    static {
        $assertionsDisabled = !Settings.class.desiredAssertionStatus();
        RANDOM = new Random();
        err = ErrorManager.getDefault().getInstance("org.netbeans.modules.autoupdate.Settings");
    }

    public static class LastCheckPropertyEditor
    extends PropertyEditorSupport {
        private static final SimpleDateFormat sdf = new SimpleDateFormat();

        public String getAsText() {
            Date date = (Date)this.getValue();
            return date == null ? "" : sdf.format(date);
        }

        public void setAsText(String string) {
            try {
                Date date = sdf.parse(string);
                this.setValue(date);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
    }

    public static class PeriodPropertyEditor
    extends PropertyEditorSupport {
        private static final String[] tags = new String[]{Settings.access$000("CTL_PeriodEditor_Startup"), Settings.access$000("CTL_PeriodEditor_Day"), Settings.access$000("CTL_PeriodEditor_Week"), Settings.access$000("CTL_PeriodEditor_2Weeks"), Settings.access$000("CTL_PeriodEditor_Month"), Settings.access$000("CTL_PeriodEditor_Never")};
        private static final int[] values = new int[]{0, 1, 2, 3, 4, 5};

        public String[] getTags() {
            return tags;
        }

        public String getAsText() {
            long l = ((Integer)this.getValue()).intValue();
            for (int i = 0; i < values.length; ++i) {
                if ((long)values[i] != l) continue;
                return tags[i];
            }
            return Settings.getBundle("CTL_PeriodEditor_Unsupported");
        }

        public void setAsText(String string) {
            for (int i = 0; i < tags.length; ++i) {
                if (tags[i] != string) continue;
                this.setValue(new Integer(values[i]));
                return;
            }
            this.setValue(new Integer(0));
        }
    }
}

